/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Dimension;
import java.awt.Graphics;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractPolarAxis;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarAxes;

public class PolarType1
extends AbstractPolarAxis
implements PolarAxes,
Dimensioned {
    public PolarType1(PlottingPanel panel, String rLabel, String phiLabel, double phiOffset) {
        super(panel);
        this.defaultLeftGutter = 25;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 25;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        if (panel == null) {
            return;
        }
        panel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        panel.setAxes(this);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createPolar(rLabel, phiLabel, phiOffset));
        panel.setClipAtGutter(false);
    }

    public PolarType1(PlottingPanel panel) {
        this(panel, "r=", " phi=", 0.0);
    }

    @Override
    public Dimension getInterior(DrawingPanel panel) {
        double max = Math.abs(panel.getPreferredXMax());
        max = Math.max(max, Math.abs(panel.getPreferredXMin()));
        max = Math.max(max, Math.abs(panel.getPreferredYMax()));
        max = Math.max(max, Math.abs(panel.getPreferredYMin()));
        panel.setPreferredMinMax(-max, max, -max, max, false);
        return null;
    }

    @Override
    public void setXLabel(String s, String font_name) {
    }

    @Override
    public void setYLabel(String s, String font_name) {
    }

    @Override
    public String getXLabel() {
        return "";
    }

    @Override
    public String getYLabel() {
        return "";
    }

    public void setXLog(boolean isLog) {
    }

    public void setYLog(boolean isLog) {
    }

    @Override
    public void setShowMajorXGrid(boolean showGrid) {
    }

    @Override
    public void setShowMinorXGrid(boolean showGrid) {
    }

    @Override
    public void setShowMajorYGrid(boolean showGrid) {
    }

    @Override
    public void setShowMinorYGrid(boolean showGrid) {
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        double rmax = Math.abs(panel.getPreferredXMax());
        double dr = this.drawRings(rmax, panel, g);
        this.drawSpokes(rmax, panel, g);
        this.drawRAxis(dr, rmax, panel, g);
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.setColor(panel.getForeground());
        this.titleLine.draw(panel, g);
    }
}

