/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractPolarAxis;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarAxes;

public class PolarType2
extends AbstractPolarAxis
implements PolarAxes {
    public PolarType2(PlottingPanel panel, String rLabel, String phiLabel, double phiOffset) {
        super(panel);
        this.defaultLeftGutter = 25;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 25;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        if (panel == null) {
            return;
        }
        panel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        panel.setAxes(this);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createPolar(rLabel, phiLabel, phiOffset));
    }

    public PolarType2(PlottingPanel panel) {
        this(panel, "r=", " phi=", 0.0);
    }

    @Override
    public void setXLabel(String s, String font_name) {
    }

    @Override
    public void setYLabel(String s, String font_name) {
    }

    @Override
    public String getXLabel() {
        return "";
    }

    @Override
    public String getYLabel() {
        return "";
    }

    public void setXLog(boolean isLog) {
    }

    public void setYLog(boolean isLog) {
    }

    @Override
    public void setShowMajorXGrid(boolean showGrid) {
    }

    @Override
    public void setShowMinorXGrid(boolean showGrid) {
    }

    @Override
    public void setShowMajorYGrid(boolean showGrid) {
    }

    @Override
    public void setShowMinorYGrid(boolean showGrid) {
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        int gw = panel.getLeftGutter() + panel.getRightGutter();
        int gh = panel.getTopGutter() + panel.getLeftGutter();
        if (this.interiorColor != null) {
            g.setColor(this.interiorColor);
            g.fillRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
            g.setColor(this.gridcolor);
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.setColor(panel.getForeground());
        this.titleLine.draw(panel, g2);
        g2.clipRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
        double rmax = Math.abs(panel.getXMax()) + Math.abs(panel.getYMax());
        rmax = Math.max(rmax, Math.abs(panel.getXMax()) + Math.abs(panel.getYMin()));
        rmax = Math.max(rmax, Math.abs(panel.getXMin()) + Math.abs(panel.getYMax()));
        rmax = Math.max(rmax, Math.abs(panel.getXMin()) + Math.abs(panel.getYMin()));
        double dr = this.drawRings(rmax, panel, g2);
        this.drawSpokes(rmax, panel, g2);
        this.drawRAxis(dr, rmax, panel, g2);
        g2.dispose();
    }
}

