/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.axes.XYAxis;

public class XAxis
extends XYAxis {
    public XAxis() {
        this("X Axis");
    }

    public XAxis(String title) {
        this.setTitle(title);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics g) {
        int pixLoc = drawingPanel.yToPix(this.location);
        if (pixLoc < 1) {
            this.location = drawingPanel.getYMin();
        }
        if (pixLoc > drawingPanel.getHeight() - 1) {
            this.location = drawingPanel.getYMax();
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        switch (this.locationType) {
            case 0: 
            case 2: {
                this.drawInsideDisplay(drawingPanel, g);
                break;
            }
            case 1: {
                this.drawInsideGutter(drawingPanel, g);
                break;
            }
            default: {
                this.drawInsideDisplay(drawingPanel, g);
            }
        }
        g2.dispose();
    }

    private void drawInsideDisplay(DrawingPanel drawingPanel, Graphics g) {
        Color foreground = drawingPanel.getForeground();
        int bottomGutter = drawingPanel.getBottomGutter();
        int rightGutter = drawingPanel.getRightGutter();
        int leftGutter = drawingPanel.getLeftGutter();
        int topGutter = drawingPanel.getTopGutter();
        FontMetrics fm = g.getFontMetrics();
        int sw = 0;
        g.setColor(foreground);
        if (this.locationType == 0) {
            this.location = (drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0;
        }
        int xo = leftGutter;
        int yo = drawingPanel.yToPix(this.location);
        int w = drawingPanel.getWidth() - leftGutter - rightGutter;
        g.drawLine(xo, yo, xo + w, yo);
        this.calculateLabels(drawingPanel.getXMin(), drawingPanel.getXMax(), 1 + w / 35);
        String[] temp_strings = this.label_string;
        double[] temp_values = this.label_value;
        if (temp_strings.length != temp_values.length) {
            return;
        }
        int i = 0;
        int n = temp_strings.length;
        while (i < n) {
            int xpix;
            if (this.axisType == 0) {
                xpix = drawingPanel.xToPix(temp_values[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(xpix, topGutter + 1, xpix, drawingPanel.getHeight() - bottomGutter - 1);
                    g.setColor(foreground);
                }
                g.drawLine(xpix, yo - 5, xpix, yo + 5);
                sw = fm.stringWidth(temp_strings[i]);
                g.drawString(temp_strings[i], xpix - sw / 2, yo + 18);
            } else {
                xpix = drawingPanel.xToPix(Math.pow(10.0, temp_values[i] * this.decade_multiplier));
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(xpix, topGutter + 1, xpix, drawingPanel.getHeight() - bottomGutter - 1);
                    g.setColor(foreground);
                }
                g.drawLine(xpix, yo - 5, xpix, yo + 5);
                sw = fm.stringWidth(this.logBase);
                this.drawMultiplier(xpix - sw / 2, yo + 18, (int)temp_values[i], (Graphics2D)g);
            }
            ++i;
        }
        int ypix = drawingPanel.getHeight() - Math.max(bottomGutter / 2, 6);
        Graphics2D g2 = (Graphics2D)g;
        Font oldFont = g2.getFont();
        if (this.axisType == 0 && this.label_exponent != 0) {
            g2.setColor(Color.red);
            g2.drawString("x10", drawingPanel.getWidth() - 36, ypix);
            g2.setFont(g2.getFont().deriveFont(0, 9.0f));
            g2.drawString("" + this.label_exponent, drawingPanel.getWidth() - 16, ypix - 6);
        }
        g2.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
            this.axisLabel.setY(drawingPanel.getYMin() - 20.0 / drawingPanel.getYPixPerUnit());
            this.axisLabel.setColor(foreground);
            this.axisLabel.draw(drawingPanel, g2);
        }
        g2.setFont(oldFont);
    }

    private void drawInsideGutter(DrawingPanel drawingPanel, Graphics g) {
        Color foreground = drawingPanel.getForeground();
        int bottomGutter = drawingPanel.getBottomGutter();
        int rightGutter = drawingPanel.getRightGutter();
        int leftGutter = drawingPanel.getLeftGutter();
        int topGutter = drawingPanel.getTopGutter();
        FontMetrics fm = g.getFontMetrics();
        int sw = 0;
        g.setColor(foreground);
        int xo = leftGutter;
        int yo = drawingPanel.getHeight() - bottomGutter - 1;
        int w = drawingPanel.getWidth() - leftGutter - rightGutter;
        this.calculateLabels(drawingPanel.getXMin(), drawingPanel.getXMax(), 1 + w / 35);
        String[] temp_strings = this.label_string;
        double[] temp_values = this.label_value;
        if (temp_strings.length != temp_values.length) {
            return;
        }
        int i = 0;
        int n = temp_strings.length;
        while (i < n) {
            int xpix;
            if (this.axisType == 0) {
                xpix = drawingPanel.xToPix(temp_values[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(xpix, topGutter + 1, xpix, yo);
                    g.setColor(foreground);
                }
                g.drawLine(xpix, yo, xpix, yo + 5);
                sw = fm.stringWidth(temp_strings[i]);
                g.drawString(temp_strings[i], xpix - sw / 2, yo + 18);
            } else {
                xpix = drawingPanel.xToPix(Math.pow(10.0, temp_values[i] * this.decade_multiplier));
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(xpix, topGutter + 1, xpix, yo);
                    g.setColor(foreground);
                }
                g.drawLine(xpix, yo, xpix, yo + 5);
                sw = fm.stringWidth(this.logBase);
                this.drawMultiplier(xpix - sw / 2, yo + 18, (int)temp_values[i], (Graphics2D)g);
            }
            ++i;
        }
        g.drawLine(xo, yo, xo + w, yo);
        int ypix = drawingPanel.getHeight() - Math.max(bottomGutter / 2 - 15, 6);
        Graphics2D g2 = (Graphics2D)g;
        if (this.axisType == 0 && this.label_exponent != 0) {
            g2.setColor(Color.red);
            g2.drawString("x10", drawingPanel.getWidth() - 36, ypix);
            g2.setFont(g2.getFont().deriveFont(0, 9.0f));
            g2.drawString("" + this.label_exponent, drawingPanel.getWidth() - 16, ypix - 6);
        }
        g2.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setX(drawingPanel.pixToX((drawingPanel.getWidth() + leftGutter - rightGutter) / 2));
            FontMetrics labelFontMetrics = drawingPanel.getFontMetrics(this.labelFont);
            this.axisLabel.setY(drawingPanel.pixToY(drawingPanel.getHeight() - Math.max(bottomGutter - 2 * labelFontMetrics.getHeight() - 4, 10)));
            this.axisLabel.setColor(foreground);
            this.axisLabel.draw(drawingPanel, g2);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.enabled) {
            return null;
        }
        if (Math.abs(panel.yToPix(this.location) - ypix) < 2) {
            return this;
        }
        return null;
    }

    @Override
    public void setXY(double x, double y) {
        this.location = y;
    }

    @Override
    public void setY(double y) {
        this.location = y;
    }
}

