/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.numerics.Util;

public abstract class XYAxis
implements Interactive {
    public static final int DRAW_IN_DISPLAY = 0;
    public static final int DRAW_IN_GUTTER = 1;
    public static final int DRAW_AT_LOCATION = 2;
    public static final int LINEAR = 0;
    protected double x = 0.0;
    protected double y = 0.0;
    boolean enabled = false;
    public static final int LOG10 = 1;
    int locationType = 0;
    int axisType = 0;
    String logBase = "10";
    DecimalFormat labelFormat = Util.newDecimalFormat("0.0");
    DecimalFormat integerFormat = Util.newDecimalFormat("000");
    double label_step = -14.0;
    double label_start = 2.0;
    DrawableTextLine axisLabel = new DrawableTextLine("x", 0.0, 0.0);
    Font labelFont = new Font("Dialog", 0, 12);
    int label_exponent = 0;
    String[] label_string = new String[0];
    double[] label_value = new double[0];
    double decade_multiplier = 1.0;
    int label_count = 0;
    double location = 0.0;
    Font titleFont = new Font("Dialog", 0, 12);
    boolean showMajorGrid = false;
    Color majorGridColor = new Color(0, 0, 0, 32);

    public XYAxis() {
        this.axisLabel.setJustification(0);
        this.axisLabel.setFont(this.labelFont);
    }

    @Override
    public abstract void draw(DrawingPanel var1, Graphics var2);

    public void setLabelFormat(DecimalFormat format) {
        if (format != null) {
            this.labelFormat = format;
        }
    }

    public void setLabelFormat(String formatString) {
        this.labelFormat = Util.newDecimalFormat(formatString);
    }

    public void setLocationType(int _locationType) {
        this.locationType = _locationType;
    }

    public void setLocation(double _location) {
        this.location = _location;
    }

    public void setAxisType(int type) {
        this.axisType = type;
    }

    public void setTitle(String title, String font_name) {
        this.axisLabel.setText(title);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.axisLabel.setFont(Font.decode(font_name));
    }

    public void setTitle(String title) {
        this.axisLabel.setText(title);
    }

    public void setTitleFont(String name) {
        if (name != null && !name.equals("")) {
            this.titleFont = Font.decode(name);
        }
    }

    public void setShowMajorGrid(boolean show) {
        this.showMajorGrid = show;
    }

    protected void drawMultiplier(int xpix, int ypix, int exponent, Graphics2D g2) {
        Font oldFont = g2.getFont();
        g2.drawString("10", xpix, ypix);
        g2.setFont(g2.getFont().deriveFont(0, 9.0f));
        g2.drawString("" + exponent, xpix + 16, ypix - 6);
        g2.setFont(oldFont);
    }

    public void calculateLabels(double minimum, double maximum, int numTicks) {
        numTicks = Math.min(19, numTicks);
        double min = minimum;
        double max = maximum;
        if (maximum < minimum) {
            min = maximum;
            max = minimum;
        } else {
            max = maximum;
            min = minimum;
        }
        switch (this.axisType) {
            case 0: {
                this.calculateLinearLabels(min, max, numTicks);
                break;
            }
            case 1: {
                this.calculateLogLabels(min, max, numTicks);
                break;
            }
            default: {
                this.calculateLinearLabels(min, max, numTicks);
            }
        }
    }

    private void calculateLogLabels(double minimum, double maximum, int numTicks) {
        this.label_exponent = 0;
        this.decade_multiplier = 1.0;
        int label_step = 1;
        int label_start = (int)Math.ceil(minimum);
        if ((double)label_start - minimum > 0.998) {
            --label_start;
        }
        int val = label_start;
        this.label_count = 1;
        do {
            ++this.label_count;
        } while ((double)(val += label_step) <= maximum - (double)label_step);
        this.label_string = new String[this.label_count];
        this.label_value = new double[this.label_count];
        int i = 0;
        while (i < this.label_count) {
            val = label_start + i * label_step;
            this.label_string[i] = this.integerFormat.format(val);
            this.label_value[i] = val;
            ++i;
        }
    }

    private void calculateLinearLabels(double minimum, double maximum, int numTicks) {
        int j;
        if (Math.abs(minimum) == 0.0 && Math.abs(maximum) == 0.0) {
            maximum = minimum + 1.0E-6;
        }
        this.label_exponent = Math.abs(minimum) > Math.abs(maximum) ? (int)Math.floor(XYAxis.log10(Math.abs(minimum)) / 2.0) * 2 : (int)Math.floor(XYAxis.log10(Math.abs(maximum)) / 2.0) * 2;
        this.label_step = maximum - minimum > (double)(10 * numTicks) * Double.MIN_VALUE ? this.RoundUp((maximum - minimum) / (double)numTicks) : 1.0;
        this.label_start = Math.floor(minimum / this.label_step) * this.label_step;
        while (this.label_step > 0.0 && this.label_start < minimum) {
            this.label_start += this.label_step;
        }
        double val = this.label_start;
        this.label_count = 1;
        while (val <= maximum - this.label_step) {
            val += this.label_step;
            ++this.label_count;
        }
        this.label_string = new String[this.label_count];
        this.label_value = new double[this.label_count];
        int i = 0;
        while (i < this.label_count) {
            val = this.label_start + (double)i * this.label_step;
            if (this.label_exponent < 0) {
                j = this.label_exponent;
                while (j < 0) {
                    val *= 10.0;
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.label_exponent) {
                    val /= 10.0;
                    ++j;
                }
            }
            this.label_string[i] = this.labelFormat.format(val);
            this.label_value[i] = val;
            ++i;
        }
        this.decade_multiplier = 1.0;
        if (this.label_exponent < 0) {
            j = this.label_exponent;
            while (j < 0) {
                this.decade_multiplier /= 10.0;
                ++j;
            }
        } else {
            j = 0;
            while (j < this.label_exponent) {
                this.decade_multiplier *= 10.0;
                ++j;
            }
        }
    }

    private double RoundUp(double val) {
        int i;
        int exponent = (int)Math.floor(XYAxis.log10(val));
        if (exponent < 0) {
            i = exponent;
            while (i < 0) {
                val *= 10.0;
                ++i;
            }
        } else {
            i = 0;
            while (i < exponent) {
                val /= 10.0;
                ++i;
            }
        }
        val = val > 5.0 ? 10.0 : (val > 2.0 ? 5.0 : (val > 1.0 ? 2.0 : 1.0));
        if (exponent < 0) {
            i = exponent;
            while (i < 0) {
                val /= 10.0;
                ++i;
            }
        } else {
            i = 0;
            while (i < exponent) {
                val *= 10.0;
                ++i;
            }
        }
        return val;
    }

    @Override
    public double getXMin() {
        return 0.0;
    }

    @Override
    public double getXMax() {
        return 0.0;
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        return 0.0;
    }

    @Override
    public boolean isMeasured() {
        return false;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int _xpix, int _ypix) {
        return null;
    }

    @Override
    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public static double log10(double x) throws ArithmeticException {
        if (x <= 0.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(x) / 2.302585092994046;
    }
}

