/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.axes.XYAxis;

public class YAxis
extends XYAxis {
    AffineTransform rot90 = AffineTransform.getRotateInstance(-1.5707963267948966);

    public YAxis() {
        this("Y Axis");
    }

    public YAxis(String title) {
        this.setTitle(title);
        this.axisLabel.setTheta(1.5707963267948966);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics g) {
        int pixLoc = drawingPanel.xToPix(this.location);
        if (pixLoc < 1) {
            this.location = drawingPanel.getXMin();
        }
        if (pixLoc > drawingPanel.getWidth() - 1) {
            this.location = drawingPanel.getXMax();
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        switch (this.locationType) {
            case 0: 
            case 2: {
                this.drawInsideDisplay(drawingPanel, g);
                break;
            }
            case 1: {
                this.drawInsideGutter(drawingPanel, g);
                break;
            }
            default: {
                this.drawInsideDisplay(drawingPanel, g);
            }
        }
        g2.dispose();
    }

    private void drawInsideDisplay(DrawingPanel drawingPanel, Graphics g) {
        Color foreground = drawingPanel.getForeground();
        int bottomGutter = drawingPanel.getBottomGutter();
        int rightGutter = drawingPanel.getRightGutter();
        int leftGutter = drawingPanel.getLeftGutter();
        int topGutter = drawingPanel.getTopGutter();
        FontMetrics fm = g.getFontMetrics();
        int sw = 0;
        g.setColor(foreground);
        if (this.locationType == 0) {
            this.location = (drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0;
        }
        int xo = drawingPanel.xToPix(this.location);
        int yo = drawingPanel.getHeight() - bottomGutter;
        int h = drawingPanel.getHeight() - bottomGutter - topGutter;
        this.calculateLabels(drawingPanel.getYMin(), drawingPanel.getYMax(), 1 + h / 35);
        String[] temp_strings = this.label_string;
        double[] temp_values = this.label_value;
        if (temp_strings.length != temp_values.length) {
            return;
        }
        int i = 0;
        int n = temp_values.length;
        while (i < n) {
            int ypix;
            if (this.axisType == 0) {
                ypix = drawingPanel.yToPix(temp_values[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(leftGutter, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                    g.setColor(foreground);
                }
                g.drawLine(xo - 5, ypix, xo + 5, ypix);
                sw = fm.stringWidth(temp_strings[i]);
                g.drawString(temp_strings[i], xo - sw - 7, ypix + 5);
            } else {
                ypix = drawingPanel.yToPix(Math.pow(10.0, temp_values[i] * this.decade_multiplier));
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(leftGutter, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                    g.setColor(foreground);
                }
                g.drawLine(xo - 5, ypix, xo + 5, ypix);
                sw = fm.stringWidth(this.logBase);
                this.drawMultiplier(xo - sw - 7, ypix + 5, (int)temp_values[i], (Graphics2D)g);
            }
            ++i;
        }
        g.drawLine(xo, yo, xo, yo - h);
        Graphics2D g2 = (Graphics2D)g;
        if (this.axisType == 0 && this.label_exponent != 0) {
            g2.setColor(Color.red);
            g2.drawString("x10", 5, 18);
            g2.setFont(g2.getFont().deriveFont(0, 9.0f));
            g2.drawString("" + this.label_exponent, 25, 12);
        }
        g2.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setY((drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0);
            this.axisLabel.setX(drawingPanel.pixToX(Math.max(leftGutter / 2 - 10, 18)));
            this.axisLabel.setColor(foreground);
            this.axisLabel.draw(drawingPanel, g2);
        }
    }

    private void drawInsideGutter(DrawingPanel drawingPanel, Graphics g) {
        Color foreground = drawingPanel.getForeground();
        int bottomGutter = drawingPanel.getBottomGutter();
        int rightGutter = drawingPanel.getRightGutter();
        int leftGutter = drawingPanel.getLeftGutter();
        int topGutter = drawingPanel.getTopGutter();
        FontMetrics fm = g.getFontMetrics();
        int sw = 0;
        g.setColor(foreground);
        int xo = leftGutter;
        int yo = drawingPanel.getHeight() - bottomGutter - 1;
        int h = drawingPanel.getHeight() - bottomGutter - topGutter;
        g.drawLine(xo, yo, xo, yo - h);
        this.calculateLabels(drawingPanel.getYMin(), drawingPanel.getYMax(), 1 + h / 35);
        String[] temp_strings = this.label_string;
        double[] temp_values = this.label_value;
        if (temp_strings.length != temp_values.length) {
            return;
        }
        int i = 0;
        int n = temp_values.length;
        while (i < n) {
            int ypix;
            if (this.axisType == 0) {
                ypix = drawingPanel.yToPix(temp_values[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(xo, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                    g.setColor(foreground);
                }
                g.drawLine(xo - 5, ypix, xo, ypix);
                sw = fm.stringWidth(temp_strings[i]);
                g.drawString(temp_strings[i], xo - sw - 7, ypix + 5);
            } else {
                ypix = drawingPanel.yToPix(Math.pow(10.0, temp_values[i] * this.decade_multiplier));
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(xo, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                    g.setColor(foreground);
                }
                g.drawLine(xo - 5, ypix, xo, ypix);
                sw = fm.stringWidth(this.logBase);
                this.drawMultiplier(xo - sw - 14, ypix + 5, (int)temp_values[i], (Graphics2D)g);
            }
            ++i;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.axisType == 0 && this.label_exponent != 0) {
            g2.setColor(Color.red);
            g2.drawString("x10", 5, 18);
            g2.setFont(g2.getFont().deriveFont(0, 9.0f));
            g2.drawString("" + this.label_exponent, 25, 12);
        }
        g2.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setY((drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0);
            this.axisLabel.setX(drawingPanel.pixToX(Math.max(leftGutter / 2 - 10, 18)));
            this.axisLabel.setColor(foreground);
            this.axisLabel.draw(drawingPanel, g2);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.enabled) {
            return null;
        }
        if (Math.abs(panel.xToPix(this.location) - xpix) < 2) {
            return this;
        }
        return null;
    }

    @Override
    public void setXY(double x, double y) {
        this.location = x;
    }

    @Override
    public void setX(double x) {
        this.location = x;
    }
}

