/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.NumberField;

public class ScaleInspector
extends JDialog {
    protected DrawingPanel drawingPanel;
    protected JPanel dataPanel;
    protected JLabel xMinLabel;
    protected JLabel xMaxLabel;
    protected JLabel yMinLabel;
    protected JLabel yMaxLabel;
    protected NumberField xMinField;
    protected NumberField xMaxField;
    protected NumberField yMinField;
    protected NumberField yMaxField;
    protected JCheckBox xMinCheckBox;
    protected JCheckBox xMaxCheckBox;
    protected JCheckBox yMinCheckBox;
    protected JCheckBox yMaxCheckBox;
    protected JButton okButton;

    public ScaleInspector(DrawingPanel panel) {
        super(JOptionPane.getFrameForComponent(panel), JOptionPane.getFrameForComponent(panel) != null);
        this.drawingPanel = panel;
        this.setTitle(DialogsRes.SCALE_SCALE);
        this.setResizable(false);
        this.createGUI();
        this.pack();
    }

    private void createGUI() {
        JPanel inspectorPanel = new JPanel(new BorderLayout());
        this.setContentPane(inspectorPanel);
        JPanel controlPanel = new JPanel(new BorderLayout());
        inspectorPanel.add((Component)controlPanel, "South");
        final AbstractAction setXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double xMin = ScaleInspector.this.xMinCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.xMinField.getValue();
                double xMax = ScaleInspector.this.xMaxCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.xMaxField.getValue();
                ScaleInspector.this.drawingPanel.setPreferredMinMaxX(xMin, xMax);
                ScaleInspector.this.drawingPanel.paintImmediately(ScaleInspector.this.drawingPanel.getBounds());
                ScaleInspector.this.updateDisplay();
            }
        };
        final AbstractAction setYAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double yMin = ScaleInspector.this.yMinCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.yMinField.getValue();
                double yMax = ScaleInspector.this.yMaxCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.yMaxField.getValue();
                ScaleInspector.this.drawingPanel.setPreferredMinMaxY(yMin, yMax);
                ScaleInspector.this.drawingPanel.paintImmediately(ScaleInspector.this.drawingPanel.getBounds());
                ScaleInspector.this.updateDisplay();
            }
        };
        this.xMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.xMinField = new DecimalField(4, 2);
        this.xMinField.setMaximumSize(this.xMinField.getPreferredSize());
        this.xMinField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                setXAction.actionPerformed(null);
                ScaleInspector.this.xMinField.requestFocusInWindow();
            }
        });
        this.xMinField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                setXAction.actionPerformed(null);
            }
        });
        this.xMinCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.xMinCheckBox.addActionListener(setXAction);
        this.xMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.xMaxField = new DecimalField(4, 2);
        this.xMaxField.setMaximumSize(this.xMaxField.getPreferredSize());
        this.xMaxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                setXAction.actionPerformed(null);
                ScaleInspector.this.xMaxField.requestFocusInWindow();
            }
        });
        this.xMaxField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                setXAction.actionPerformed(null);
            }
        });
        this.xMaxCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.xMaxCheckBox.addActionListener(setXAction);
        this.yMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.yMinField = new DecimalField(4, 2);
        this.yMinField.setMaximumSize(this.yMinField.getPreferredSize());
        this.yMinField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                setYAction.actionPerformed(null);
                ScaleInspector.this.yMinField.requestFocusInWindow();
            }
        });
        this.yMinField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                setYAction.actionPerformed(null);
            }
        });
        this.yMinCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.yMinCheckBox.addActionListener(setYAction);
        this.yMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.yMaxField = new DecimalField(4, 2);
        this.yMaxField.setMaximumSize(this.yMaxField.getPreferredSize());
        this.yMaxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                setYAction.actionPerformed(null);
                ScaleInspector.this.yMaxField.requestFocusInWindow();
            }
        });
        this.yMaxField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                setYAction.actionPerformed(null);
            }
        });
        this.yMaxCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.yMaxCheckBox.addActionListener(setYAction);
        JPanel xPanel = new JPanel(new GridLayout(2, 1));
        String title = DialogsRes.SCALE_HORIZONTAL;
        xPanel.setBorder(BorderFactory.createTitledBorder(title));
        JPanel yPanel = new JPanel(new GridLayout(2, 1));
        title = DialogsRes.SCALE_VERTICAL;
        yPanel.setBorder(BorderFactory.createTitledBorder(title));
        this.dataPanel = new JPanel(new GridLayout(2, 1));
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        controlPanel.add((Component)this.dataPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMaxLabel);
        box.add(this.xMaxField);
        box.add(this.xMaxCheckBox);
        xPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMinLabel);
        box.add(this.xMinField);
        box.add(this.xMinCheckBox);
        xPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMaxLabel);
        box.add(this.yMaxField);
        box.add(this.yMaxCheckBox);
        yPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMinLabel);
        box.add(this.yMinField);
        box.add(this.yMinCheckBox);
        yPanel.add(box);
        this.dataPanel.add(yPanel);
        this.dataPanel.add(xPanel);
        this.xMinLabel.setAlignmentX(1.0f);
        this.xMaxLabel.setAlignmentX(1.0f);
        this.yMinLabel.setAlignmentX(1.0f);
        this.yMaxLabel.setAlignmentX(1.0f);
        this.xMinField.setAlignmentX(1.0f);
        this.xMaxField.setAlignmentX(1.0f);
        this.yMinField.setAlignmentX(1.0f);
        this.yMaxField.setAlignmentX(1.0f);
        this.xMinCheckBox.setAlignmentX(1.0f);
        this.xMaxCheckBox.setAlignmentX(1.0f);
        this.yMinCheckBox.setAlignmentX(1.0f);
        this.yMaxCheckBox.setAlignmentX(1.0f);
        this.okButton = new JButton(DialogsRes.SCALE_OK);
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScaleInspector.this.setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel();
        controlPanel.add((Component)buttonbar, "South");
        buttonbar.add(this.okButton);
    }

    public void updateDisplay() {
        this.xMinCheckBox.setSelected(this.drawingPanel.isAutoscaleXMin());
        this.xMinField.setEnabled(!this.xMinCheckBox.isSelected());
        this.xMinField.setValue(this.drawingPanel.getXMin());
        this.xMaxCheckBox.setSelected(this.drawingPanel.isAutoscaleXMax());
        this.xMaxField.setEnabled(!this.xMaxCheckBox.isSelected());
        this.xMaxField.setValue(this.drawingPanel.getXMax());
        this.yMinCheckBox.setSelected(this.drawingPanel.isAutoscaleYMin());
        this.yMinField.setEnabled(!this.yMinCheckBox.isSelected());
        this.yMinField.setValue(this.drawingPanel.getYMin());
        this.yMaxCheckBox.setSelected(this.drawingPanel.isAutoscaleYMax());
        this.yMaxField.setEnabled(!this.yMaxCheckBox.isSelected());
        this.yMaxField.setValue(this.drawingPanel.getYMax());
    }
}

