/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.SnapshotTool;

public class ImageFrame
extends OSPFrame {
    protected BufferedImage image;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu saveImageMenu;
    protected JMenuItem copyItem;
    protected JMenuItem printItem;
    protected JMenuItem exitItem;
    protected JMenuItem epsItem;
    protected JMenuItem gifItem;
    protected JMenuItem jpgItem;
    protected JMenuItem pngItem;
    protected DrawingPanel drawingPanel = new DrawingPanel();
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected String chooserTitle;

    public ImageFrame(MeasuredImage measuredImage) {
        this.setContentPane(this.drawingPanel);
        this.drawingPanel.addDrawable(measuredImage);
        this.drawingPanel.setPreferredMinMax(measuredImage.getXMin(), measuredImage.getXMax(), measuredImage.getYMin(), measuredImage.getYMax());
        this.image = measuredImage.getImage();
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        this.drawingPanel.setPreferredSize(new Dimension(w + 1, h + 1));
        this.createMenuBar();
        this.pack();
        this.chooserTitle = DisplayRes.getString("GUIUtils.Title.SaveImage");
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = new JMenu(DisplayRes.getString("DrawingFrame.File_menu_item"));
        this.printItem = new JMenuItem(DisplayRes.getString("ImageFrame.Print_menu_item"));
        this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_SHORTCUT_KEY_MASK));
        if (!OSPRuntime.isJS) {
            this.printItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintUtils.printComponent(ImageFrame.this.drawingPanel);
                }
            });
        }
        this.saveImageMenu = new JMenu(DisplayRes.getString("ImageFrame.SaveAs_menu_item"));
        this.epsItem = new JMenuItem(DisplayRes.getString("DrawingFrame.EPS_menu_item"));
        this.gifItem = new JMenuItem(DisplayRes.getString("DrawingFrame.GIF_menu_item"));
        this.jpgItem = new JMenuItem(DisplayRes.getString("DrawingFrame.JPEG_menu_item"));
        this.pngItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PNG_menu_item"));
        this.saveImageMenu.add(this.epsItem);
        this.saveImageMenu.add(this.gifItem);
        this.saveImageMenu.add(this.jpgItem);
        this.saveImageMenu.add(this.pngItem);
        this.epsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String description = DisplayRes.getString("ImageFrame.EPS_filter_description");
                String[] extensions = new String[]{"eps", "EPS"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "eps", ImageFrame.this.chooserTitle, description, extensions);
            }
        });
        this.gifItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String description = DisplayRes.getString("ImageFrame.GIF_filter_description");
                String[] extensions = new String[]{"gif", "GIF"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "gif", ImageFrame.this.chooserTitle, description, extensions);
            }
        });
        this.jpgItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String description = DisplayRes.getString("ImageFrame.JPEG_filter_description");
                String[] extensions = new String[]{"jpg", "jpeg", "JPG", "JPEG"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "jpeg", ImageFrame.this.chooserTitle, description, extensions);
            }
        });
        this.pngItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String description = DisplayRes.getString("ImageFrame.PNG_filter_description");
                String[] extensions = new String[]{"png", "PNG"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "png", ImageFrame.this.chooserTitle, description, extensions);
            }
        });
        if (!OSPRuntime.isApplet) {
            if (!OSPRuntime.isJS) {
                this.fileMenu.add(this.saveImageMenu);
            }
            this.fileMenu.addSeparator();
            if (!OSPRuntime.isJS) {
                this.fileMenu.add(this.printItem);
            }
        }
        menuBar.add(this.fileMenu);
        this.editMenu = new JMenu(DisplayRes.getString("DrawingFrame.Edit_menu_title"));
        menuBar.add(this.editMenu);
        this.copyItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Copy_menu_item"));
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, MENU_SHORTCUT_KEY_MASK));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferedImage bi = new BufferedImage(ImageFrame.this.drawingPanel.getWidth(), ImageFrame.this.drawingPanel.getHeight(), 5);
                Graphics g = bi.getGraphics();
                ImageFrame.this.drawingPanel.paint(g);
                g.dispose();
                SnapshotTool.getTool().copyImage(bi);
            }
        });
        this.editMenu.add(this.copyItem);
        this.setJMenuBar(menuBar);
        this.loadDisplayMenu();
        JMenu helpMenu = new JMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        menuBar.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem(DisplayRes.getString("DrawingFrame.AboutOSP_menu_item"));
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, MENU_SHORTCUT_KEY_MASK));
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPRuntime.showAboutDialog(ImageFrame.this);
            }
        });
        helpMenu.add(aboutItem);
    }

    @Override
    protected JMenu loadDisplayMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu displayMenu = new JMenu(DisplayRes.getString("DrawingFrame.Display_menu_title"));
        menuBar.add(displayMenu);
        JMenu fontMenu = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        displayMenu.add(fontMenu);
        JMenuItem sizeUpItem = new JMenuItem(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
        sizeUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSizer.levelUp();
            }
        });
        fontMenu.add(sizeUpItem);
        final JMenuItem sizeDownItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
        sizeDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSizer.levelDown();
            }
        });
        fontMenu.add(sizeDownItem);
        fontMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                sizeDownItem.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        return displayMenu;
    }

    public static OSPFrame newFrame(MeasuredImage mi) {
        return new ImageFrame(mi);
    }
}

