/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class BarrelPincushionFilter
extends Filter {
    protected static double minAlpha = -1.5;
    protected static double maxAlpha = 0.5;
    protected static double minScale = 0.5;
    protected static double maxScale = 2.0;
    private double[] xOut;
    private double[] yOut;
    private double[] xIn;
    private double[] yIn;
    private double pixelsToCorner;
    private boolean isValidTransform = false;
    private boolean updatingDisplay = false;
    private boolean dimensionsChanged = false;
    private int interpolation = 1;
    private double alpha = 0.0;
    private double scaleFactor = 1.0;
    private Inspector inspector;

    public BarrelPincushionFilter() {
        this.refresh();
        this.hasInspector = true;
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.ableButton.setText(this.isEnabled() ? MediaRes.getString("Filter.Button.Disable") : MediaRes.getString("Filter.Button.Enable"));
        this.inspector.refreshGUI();
    }

    public void setAlpha(double a) {
        this.alpha = Math.max(minAlpha, Math.min(maxAlpha, a));
        this.isValidTransform = false;
        this.firePropertyChange("image", null, null);
    }

    public void setScale(double scale) {
        this.scaleFactor = scale;
        this.isValidTransform = false;
        this.firePropertyChange("image", null, null);
    }

    @Override
    protected void initializeSubclass() {
        this.pixelsToCorner = Math.sqrt(this.w * this.w + this.h * this.h) / 2.0;
        this.isValidTransform = false;
    }

    @Override
    protected void initializeSource(BufferedImage image) {
        int prevW = this.w;
        int prevH = this.h;
        super.initializeSource(image);
        this.dimensionsChanged = this.w != prevW || this.h != prevH;
    }

    @Override
    protected void setOutputPixels() {
        int i;
        this.getPixelsIn();
        this.getPixelsOut();
        if (this.dimensionsChanged) {
            this.xOut = new double[this.w * this.h];
            this.yOut = new double[this.w * this.h];
            i = 0;
            while (i < this.w) {
                int j = 0;
                while (j < this.h) {
                    this.xOut[j * this.w + i] = i;
                    this.yOut[j * this.w + i] = j;
                    ++j;
                }
                ++i;
            }
        }
        if (!this.isValidTransform || this.xIn == null || this.dimensionsChanged) {
            this.xIn = new double[this.w * this.h];
            this.yIn = new double[this.w * this.h];
            this.transform(this.xOut, this.yOut, this.xIn, this.yIn);
        }
        i = 0;
        while (i < this.nPixelsIn) {
            this.pixelsOut[i] = this.getColor(this.xIn[i], this.yIn[i], this.w, this.h, this.pixelsIn);
            ++i;
        }
        this.dimensionsChanged = false;
    }

    private void transform(double[] xSource, double[] ySource, double[] xTrans, double[] yTrans) {
        double xCenter = (double)this.w / 2.0;
        double yCenter = (double)this.h / 2.0;
        double str = this.getStretchFactor(0.9 * xCenter);
        this.scaleFactor = 1.0 / str;
        int n = xSource.length;
        int i = 0;
        while (i < n) {
            double dx = xSource[i] - xCenter;
            double dy = ySource[i] - yCenter;
            double r = Math.sqrt(dx * dx + dy * dy);
            double stretch = this.getStretchFactor(r);
            double extra = 1.0E-6;
            xTrans[i] = xCenter + stretch * dx + extra;
            yTrans[i] = yCenter + stretch * dy + extra;
            ++i;
        }
        this.isValidTransform = true;
    }

    private double getStretchFactor(double rOut) {
        if (rOut == 0.0) {
            return 1.0;
        }
        double rn = rOut / this.pixelsToCorner;
        int n = 0;
        double rnPrev = rn;
        double rnNext = this.transform(rn, rnPrev);
        while (n < 1 && Math.abs(rnPrev - rnNext) > 0.1 / this.pixelsToCorner) {
            ++n;
            rnPrev = rnNext;
            rnNext = this.transform(rn, rnPrev);
        }
        double rIn = rnNext * this.pixelsToCorner;
        double ratio = rIn / rOut;
        return ratio;
    }

    private double transform(double rOrig, double rPrev) {
        return rOrig / (1.0 - this.alpha * rPrev * rPrev);
    }

    float getRadialX(float x, float y, float cx, float cy, float k) {
        float xscale = 1.0f;
        float xshift = 1.0f;
        float yscale = 1.0f;
        float yshift = 1.0f;
        x = x * xscale + xshift;
        y = y * yscale + yshift;
        float res = x + (x - cx) * k * ((x - cx) * (x - cx) + (y - cy) * (y - cy));
        return res;
    }

    float getRadialY(float x, float y, float cx, float cy, float k) {
        float xscale = 1.0f;
        float xshift = 1.0f;
        float yscale = 1.0f;
        float yshift = 1.0f;
        x = x * xscale + xshift;
        y = y * yscale + yshift;
        float res = y + (y - cy) * k * ((x - cx) * (x - cx) + (y - cy) * (y - cy));
        return res;
    }

    private static Point2D getSourcePoint(Point2D p, double halfW, double halfH, double a, double zoom) {
        if (a == 0.0) {
            a = 1.0E-5;
        }
        double correctionR = Math.sqrt(halfW * halfW + halfH * halfH) / a;
        double newX = p.getX() - halfW;
        double newY = p.getY() - halfH;
        double d = Math.sqrt(newX * newX + newY * newY);
        double r = d / correctionR;
        double theta = 1.0;
        if (r > 0.0) {
            theta = Math.atan(r) / r;
        } else if (r < 0.0) {
            theta = r / Math.atan(r);
        }
        System.out.println("pig theta " + theta + "     r " + r);
        double x = halfW + theta * newX * zoom;
        double y = halfH + theta * newY * zoom;
        return new Point2D.Double(x, y);
    }

    private static Point2D getTransformedPoint(Point2D p, double w, double h, double a, boolean inverse) {
        double aX = 0.0;
        double aY = 0.0;
        double thetaW = Math.PI;
        double thetaH = thetaW * h / w;
        double angX = thetaW * p.getX() / w;
        double caX = 2.0 * a * (h / 2.0 - p.getY()) / h;
        double angY = thetaH * p.getY() / h;
        double caY = 2.0 * a * (w / 2.0 - p.getX()) / w;
        if (inverse) {
            double iAng = -1.5707963267948966;
            aX = caX * Math.sin(iAng);
            aY = caY * Math.sin(iAng);
        }
        double pX = p.getX() + aY + caY * Math.sin(angY);
        double pY = p.getY() + aX + caX * Math.sin(angX);
        return new Point2D.Double(pX, pY);
    }

    private int getColor(double x, double y, int w, int h, int[] pixelValues) {
        double v;
        double dx = x - (double)(w / 2);
        double dy = y - (double)(h / 2);
        x = (double)(w / 2) + dx * this.scaleFactor;
        y = (double)(h / 2) + dy * this.scaleFactor;
        int col = (int)Math.floor(x);
        int row = (int)Math.floor(y);
        if (col < 0 || col >= w || row < 0 || row >= h) {
            return 0;
        }
        if (col + 1 == w || row + 1 == h) {
            return pixelValues[row * w + col];
        }
        double u = col == 0 ? x : x % (double)col;
        double d = v = row == 0 ? y : y % (double)row;
        if (this.interpolation == 2) {
            int[] values = new int[]{pixelValues[row * w + col], pixelValues[row * w + col + 1], pixelValues[(row + 1) * w + col], pixelValues[(row + 1) * w + col + 1]};
            int[] rgb = new int[4];
            int j = 0;
            while (j < 4) {
                rgb[j] = values[j] >> 16 & 0xFF;
                ++j;
            }
            int r = this.bilinearInterpolation(u, v, rgb);
            int j2 = 0;
            while (j2 < 4) {
                rgb[j2] = values[j2] >> 8 & 0xFF;
                ++j2;
            }
            int g = this.bilinearInterpolation(u, v, rgb);
            int j3 = 0;
            while (j3 < 4) {
                rgb[j3] = values[j3] & 0xFF;
                ++j3;
            }
            int b = this.bilinearInterpolation(u, v, rgb);
            return r << 16 | g << 8 | b;
        }
        return u < 0.5 ? (v < 0.5 ? pixelValues[row * w + col] : pixelValues[(row + 1) * w + col]) : (v < 0.5 ? pixelValues[row * w + col + 1] : pixelValues[(row + 1) * w + col + 1]);
    }

    private int bilinearInterpolation(double x, double y, int[] values) {
        return (int)((1.0 - y) * ((1.0 - x) * (double)values[0] + x * (double)values[2]) + y * ((1.0 - x) * (double)values[1] + x * (double)values[3]));
    }

    public boolean superIsEnabled() {
        return super.isEnabled();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        JButton helpButton;
        JPanel contentPane;
        JSlider alphaSlider;
        JSlider scaleSlider;
        JLabel alphaLabel;
        JLabel scaleLabel;
        NumberField alphaField;
        NumberField scaleField;

        public Inspector() {
            super(BarrelPincushionFilter.this, "RadialDistortionFilter.Inspector.Title");
        }

        @Override
        void createGUI() {
            this.helpButton = new JButton();
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            Border space = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            space = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            int aMax = (int)(300.0 * maxAlpha);
            int aMin = (int)(300.0 * minAlpha);
            int a = (int)(300.0 * BarrelPincushionFilter.this.alpha);
            this.alphaSlider = new JSlider(aMin, aMax, a);
            this.alphaSlider.setBorder(space);
            this.alphaSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = Inspector.this.alphaSlider.getValue();
                    BarrelPincushionFilter.this.setAlpha((double)i / 300.0);
                    BarrelPincushionFilter.this.setAlpha((double)i / 100.0);
                    Inspector.this.updateDisplay();
                }
            });
            space = BorderFactory.createEmptyBorder(2, 4, 2, 2);
            this.alphaLabel = new JLabel();
            this.alphaLabel.setBorder(space);
            this.scaleLabel = new JLabel();
            this.scaleLabel.setBorder(space);
            this.alphaField = new NumberField(4);
            this.alphaField.setMaxValue(maxAlpha);
            this.alphaField.setMinValue(minAlpha);
            this.alphaField.setFixedPattern("0.000");
            this.alphaField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BarrelPincushionFilter.this.alpha = Inspector.this.alphaField.getValue();
                    Inspector.this.updateDisplay();
                    Inspector.this.alphaField.selectAll();
                }
            });
            this.alphaField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Inspector.this.alphaField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    BarrelPincushionFilter.this.alpha = Inspector.this.alphaField.getValue();
                    Inspector.this.updateDisplay();
                }
            });
            int sMax = (int)(100.0 * maxScale);
            int sMin = (int)(100.0 * minScale);
            int s = (int)(100.0 * BarrelPincushionFilter.this.scaleFactor);
            this.scaleSlider = new JSlider(sMin, sMax, s);
            this.scaleSlider.setBorder(space);
            this.scaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = Inspector.this.scaleSlider.getValue();
                    BarrelPincushionFilter.this.setScale((double)i / 100.0);
                    Inspector.this.updateDisplay();
                }
            });
            this.scaleField = new NumberField(4);
            this.scaleField.setMaxValue(maxScale);
            this.scaleField.setMinValue(minScale);
            this.scaleField.setFixedPattern("0.00");
            this.scaleField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BarrelPincushionFilter.this.scaleFactor = Inspector.this.scaleField.getValue();
                    Inspector.this.updateDisplay();
                    Inspector.this.scaleField.selectAll();
                }
            });
            this.scaleField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Inspector.this.scaleField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    BarrelPincushionFilter.this.scaleFactor = Inspector.this.scaleField.getValue();
                    Inspector.this.updateDisplay();
                }
            });
            this.contentPane = new JPanel(new BorderLayout());
            this.setContentPane(this.contentPane);
            JPanel buttonbar = new JPanel(new FlowLayout());
            this.contentPane.add((Component)buttonbar, "South");
            buttonbar.add(this.helpButton);
            buttonbar.add(BarrelPincushionFilter.this.ableButton);
            buttonbar.add(BarrelPincushionFilter.this.closeButton);
            space = BorderFactory.createEmptyBorder(2, 2, 2, 4);
            Box vbox = Box.createVerticalBox();
            vbox.setBorder(space);
            this.contentPane.add((Component)vbox, "Center");
            Box box = Box.createHorizontalBox();
            box.setBorder(space);
            box.add(this.alphaLabel);
            box.add(this.alphaField);
            box.add(this.alphaSlider);
            vbox.add(box);
            box = Box.createHorizontalBox();
            box.setBorder(space);
            box.add(this.scaleLabel);
            box.add(this.scaleField);
            box.add(this.scaleSlider);
            vbox.add(box);
        }

        void refreshGUI() {
            this.setTitle(MediaRes.getString("RadialDistortionFilter.Inspector.Title"));
            this.setTitle("Barrel/Pincushion Correction");
            this.alphaLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.Diameter")) + ":");
            this.alphaLabel.setText("alpha:");
            this.scaleLabel.setText("scale:");
            this.helpButton.setText(MediaRes.getString("PerspectiveFilter.Button.Help"));
            boolean enabled = BarrelPincushionFilter.this.isEnabled();
            this.alphaLabel.setEnabled(enabled);
            this.alphaField.setEnabled(enabled);
            this.alphaSlider.setEnabled(enabled);
            this.scaleLabel.setEnabled(enabled);
            this.scaleField.setEnabled(enabled);
            this.scaleSlider.setEnabled(enabled);
            this.repaint();
        }

        void initialize() {
            this.updateDisplay();
        }

        void updateDisplay() {
            if (BarrelPincushionFilter.this.updatingDisplay) {
                return;
            }
            BarrelPincushionFilter.this.updatingDisplay = true;
            this.alphaField.setValue(BarrelPincushionFilter.this.alpha);
            this.alphaSlider.setValue((int)(BarrelPincushionFilter.this.alpha * 300.0));
            BarrelPincushionFilter.this.updatingDisplay = false;
        }

        @Override
        public void setVisible(boolean vis) {
            super.setVisible(vis);
            this.refreshGUI();
            if (BarrelPincushionFilter.this.vidPanel != null) {
                if (vis) {
                    this.firePropertyChange("filter_visible", null, null);
                    BarrelPincushionFilter.this.addPropertyChangeListener("filter_visible", BarrelPincushionFilter.this.vidPanel);
                } else {
                    this.firePropertyChange("filter_visible", null, null);
                    BarrelPincushionFilter.this.removePropertyChangeListener("filter_visible", BarrelPincushionFilter.this.vidPanel);
                }
            }
            this.firePropertyChange("image", null, null);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            BarrelPincushionFilter filter = (BarrelPincushionFilter)obj;
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new BarrelPincushionFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            BarrelPincushionFilter filter = (BarrelPincushionFilter)obj;
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

