/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ResourceLoader;

public class BaselineFilter
extends Filter {
    private BufferedImage baseline;
    private BufferedImage baselineCopy;
    private BufferedImage thumbnail;
    private int[] baselinePixels;
    private Inspector inspector;
    private String imagePath;
    private JButton loadButton;
    private JButton captureButton;
    private JButton saveButton;
    private JLabel imageLabel;
    private JPanel contentPane;
    private Border imageBorder;
    private Border emptyBorder;
    private JPanel nullBaselinePanel;

    public BaselineFilter() {
        this.hasInspector = true;
    }

    public void capture() {
        if (this.vidPanel == null || this.vidPanel.getVideo() == null) {
            return;
        }
        this.setBaselineImage(this.vidPanel.getVideo().getImage());
        this.imagePath = null;
    }

    public void save() {
        if (this.baseline == null) {
            return;
        }
        VideoIO.getChooserFilesAsync("save image", f -> {
            if (f != null && f[0] != null && f[0].getParent() != null) {
                File file;
                String path = f[0].getPath();
                if (!VideoIO.jpgFileFilter.accept(f[0])) {
                    path = String.valueOf(XML.stripExtension(path)) + ".png";
                }
                if ((file = VideoIO.writeImageFile(this.baselineCopy, path)) != null) {
                    this.imagePath = file.getPath();
                }
            }
            return null;
        });
    }

    public void load(String path) {
        BufferedImage image = ResourceLoader.getBufferedImage(path);
        if (image != null) {
            String prevPath = this.imagePath;
            this.imagePath = path;
            if (!this.setBaselineImage(image)) {
                this.imagePath = prevPath;
            }
        } else {
            JOptionPane.showMessageDialog(this.vidPanel, "\"" + path + "\" " + MediaRes.getString("Filter.Baseline.Dialog.NotImage.Message"), MediaRes.getString("Filter.Baseline.Dialog.NotImage.Title"), 1);
        }
    }

    public void load() {
        VideoIO.getChooserFilesAsync("open image", f -> {
            if (f != null && f[0] != null && VideoIO.imageFileFilter.accept(f[0])) {
                String path = f[0].getPath();
                this.load(path);
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setBaselineImage(BufferedImage image) {
        block6: {
            if (image != null) {
                int wi = image.getWidth();
                int ht = image.getHeight();
                if (wi >= this.w && ht >= this.h) {
                    this.baselineCopy = new BufferedImage(wi, ht, image.getType());
                    Graphics2D g2 = this.baselineCopy.createGraphics();
                    g2.drawImage((Image)image, 0, 0, null);
                    g2.dispose();
                    this.baseline = image;
                    this.getRaster(this.baseline).getDataElements(0, 0, this.w, this.h, this.baselinePixels);
                    break block6;
                } else {
                    JOptionPane.showMessageDialog(this.vidPanel.getTopLevelAncestor(), String.valueOf(MediaRes.getString("Filter.Baseline.Dialog.SmallImage.Message1")) + " (" + wi + "x" + ht + ") " + MediaRes.getString("Filter.Baseline.Dialog.SmallImage.Message2a") + "\n" + MediaRes.getString("Filter.Baseline.Dialog.SmallImage.Message2b") + " (" + this.w + "x" + this.h + ").", MediaRes.getString("Filter.Baseline.Dialog.SmallImage.Title"), 1);
                    return false;
                }
            }
            this.baseline = null;
            this.baselineCopy = null;
            this.imagePath = null;
        }
        if (this.inspector != null) {
            this.thumbnail = this.getThumbnailImage();
            this.imageLabel.setIcon(this.thumbnail == null ? null : new ImageIcon(this.thumbnail));
            String none = "(" + MediaRes.getString("Filter.Baseline.Message.NoImage") + ")";
            this.imageLabel.setText(this.thumbnail == null ? none : null);
            this.imageLabel.setBorder(this.thumbnail == null ? this.emptyBorder : this.imageBorder);
            if (this.thumbnail == null) {
                this.contentPane.remove(this.nullBaselinePanel);
                this.contentPane.add((Component)this.imageLabel, "North");
            } else {
                this.nullBaselinePanel.add(this.imageLabel);
                this.contentPane.add((Component)this.nullBaselinePanel, "North");
            }
            this.saveButton.setEnabled(this.baseline != null);
            this.inspector.pack();
            this.firePropertyChange("baseline", null, null);
        }
        return true;
    }

    public BufferedImage getBaselineImage() {
        return this.baselineCopy;
    }

    private BufferedImage getThumbnailImage() {
        int h;
        int w;
        int imageH;
        if (this.baseline == null) {
            return null;
        }
        int imageW = this.baseline.getWidth();
        if (imageW > (imageH = this.baseline.getHeight())) {
            w = Math.min(9 * this.contentPane.getWidth() / 10, imageW);
            h = Math.min(w * imageH / imageW, imageH);
        } else {
            h = Math.min(9 * this.contentPane.getWidth() / 10, imageH);
            w = Math.min(h * imageW / imageH, imageW);
        }
        if (this.thumbnail == null || this.thumbnail.getWidth() != w || this.thumbnail.getHeight() != h) {
            this.thumbnail = new BufferedImage(w, h, this.baseline.getType());
        }
        Graphics2D g2 = this.thumbnail.createGraphics();
        g2.drawImage(this.baseline, 0, 0, w, h, 0, 0, this.baseline.getWidth(), this.baseline.getHeight(), null);
        g2.dispose();
        return this.thumbnail;
    }

    public void resizeThumbnail() {
        if (this.thumbnail == null) {
            this.contentPane.remove(this.imageLabel);
        } else {
            this.contentPane.remove(this.nullBaselinePanel);
        }
        this.inspector.pack();
        this.setBaselineImage(this.baselineCopy);
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void clear() {
        this.setBaselineImage(null);
        this.imagePath = null;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.loadButton.setText(MediaRes.getString("Filter.Baseline.Button.Load"));
        this.captureButton.setText(MediaRes.getString("Filter.Baseline.Button.Capture"));
        this.saveButton.setText(MediaRes.getString("Dialog.Button.Save"));
        this.loadButton.setEnabled(this.isEnabled());
        this.captureButton.setEnabled(this.isEnabled());
        this.saveButton.setEnabled(this.baseline != null);
        this.inspector.setTitle(MediaRes.getString("Filter.Baseline.Title"));
        this.inspector.pack();
    }

    @Override
    protected void initializeSubclass() {
        this.baselinePixels = new int[this.nPixelsIn];
        if (!this.setBaselineImage(this.baselineCopy)) {
            this.setBaselineImage(null);
        }
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        if (this.baseline != null) {
            int i = 0;
            while (i < this.nPixelsIn) {
                int pixel = this.pixelsIn[i];
                int base = this.baselinePixels[i];
                int r = pixel >> 16 & 0xFF;
                r -= base >> 16 & 0xFF;
                r = Math.max(r, 0);
                int g = pixel >> 8 & 0xFF;
                g -= base >> 8 & 0xFF;
                g = Math.max(g, 0);
                int b = pixel & 0xFF;
                b -= base & 0xFF;
                b = Math.max(b, 0);
                this.pixelsOut[i] = r << 16 | g << 8 | b;
                ++i;
            }
        } else {
            System.arraycopy(this.pixelsIn, 0, this.pixelsOut, 0, this.nPixelsIn);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super(BaselineFilter.this, "Filter.Baseline.Title");
        }

        @Override
        void createGUI() {
            BaselineFilter.this.loadButton = new JButton();
            BaselineFilter.this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaselineFilter.this.load();
                }
            });
            BaselineFilter.this.captureButton = new JButton();
            BaselineFilter.this.captureButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaselineFilter.this.capture();
                    BaselineFilter.this.refresh();
                }
            });
            BaselineFilter.this.saveButton = new JButton();
            BaselineFilter.this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaselineFilter.this.save();
                }
            });
            BaselineFilter.this.imageLabel = new JLabel();
            BaselineFilter.this.imageLabel.setHorizontalAlignment(0);
            Border line = BorderFactory.createLineBorder(Color.black);
            BaselineFilter.this.emptyBorder = BorderFactory.createEmptyBorder(4, 4, 0, 4);
            BaselineFilter.this.imageBorder = BorderFactory.createCompoundBorder(BaselineFilter.this.emptyBorder, line);
            BaselineFilter.this.nullBaselinePanel = new JPanel();
            BaselineFilter.this.contentPane = new JPanel(new BorderLayout());
            this.setContentPane(BaselineFilter.this.contentPane);
            JPanel buttonbar = new JPanel(new FlowLayout());
            BaselineFilter.this.contentPane.add((Component)buttonbar, "South");
            buttonbar.add(BaselineFilter.this.ableButton);
            buttonbar.add(BaselineFilter.this.loadButton);
            buttonbar.add(BaselineFilter.this.captureButton);
            buttonbar.add(BaselineFilter.this.saveButton);
            buttonbar.add(BaselineFilter.this.clearButton);
            buttonbar.add(BaselineFilter.this.closeButton);
        }

        void initialize() {
            SwingUtilities.invokeLater(() -> BaselineFilter.this.setBaselineImage(BaselineFilter.this.baselineCopy));
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            int n;
            BaselineFilter filter = (BaselineFilter)obj;
            if (filter.baseline != null && filter.imagePath == null && (n = JOptionPane.showConfirmDialog(null, MediaRes.getString("Filter.Baseline.Dialog.SaveImage.Text"), MediaRes.getString("Filter.Baseline.Dialog.SaveImage.Title"), 0)) == 0) {
                filter.save();
            }
            if (filter.imagePath != null) {
                control.setValue("imagepath", filter.imagePath);
            }
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new BaselineFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            BaselineFilter filter = (BaselineFilter)obj;
            if (control.getPropertyNamesRaw().contains("imagepath")) {
                filter.load(control.getString("imagepath"));
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

