/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class BrightnessFilter
extends Filter {
    private int defaultBrightness = 0;
    private double defaultContrast = 50.0;
    private int brightness = this.defaultBrightness;
    private int previousBrightness;
    private double contrast = this.defaultContrast;
    private double previousContrast;
    private double slope;
    private double offset1;
    private double offset2;
    private Inspector inspector;
    private JLabel brightnessLabel;
    private IntegerField brightnessField;
    private JSlider brightnessSlider;
    private JLabel contrastLabel;
    private NumberField contrastField;
    private JSlider contrastSlider;

    public BrightnessFilter() {
        this.setBrightness(this.defaultBrightness);
        this.setContrast(this.defaultContrast);
        this.hasInspector = true;
    }

    public void setContrast(double contrast) {
        if (this.previousState == null) {
            this.previousState = new XMLControlElement(this).toXML();
            this.previousBrightness = this.brightness;
            this.previousContrast = contrast;
        }
        this.changed = this.changed || this.contrast != contrast;
        Double prev = this.contrast;
        this.contrast = contrast;
        this.updateFactors();
        this.firePropertyChange("contrast", prev, contrast);
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setBrightness(int brightness) {
        if (this.previousState == null) {
            this.previousState = new XMLControlElement(this).toXML();
            this.previousBrightness = this.brightness;
            this.previousContrast = this.contrast;
        }
        this.changed = this.changed || this.brightness != brightness;
        Integer prev = this.brightness;
        this.brightness = brightness;
        this.updateFactors();
        this.firePropertyChange("brightness", prev, brightness);
    }

    public int getBrightness() {
        return this.brightness;
    }

    @Override
    public boolean isChanged() {
        if (!this.changed) {
            return false;
        }
        return this.previousBrightness != this.brightness || this.previousContrast != this.contrast;
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void clear() {
        this.setBrightness(this.defaultBrightness);
        this.setContrast(this.defaultContrast);
        if (this.inspector != null) {
            this.inspector.updateDisplay();
        }
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.brightnessLabel.setText(MediaRes.getString("Filter.Brightness.Label.Brightness"));
        this.brightnessSlider.setToolTipText(MediaRes.getString("Filter.Brightness.ToolTip.Brightness"));
        this.contrastLabel.setText(MediaRes.getString("Filter.Brightness.Label.Contrast"));
        this.contrastSlider.setToolTipText(MediaRes.getString("Filter.Brightness.ToolTip.Contrast"));
        boolean enabled = this.isEnabled();
        this.brightnessLabel.setEnabled(enabled);
        this.brightnessSlider.setEnabled(enabled);
        this.brightnessField.setEnabled(enabled);
        this.contrastLabel.setEnabled(enabled);
        this.contrastSlider.setEnabled(enabled);
        this.contrastField.setEnabled(enabled);
        this.clearButton.setText(MediaRes.getString("Dialog.Button.Reset"));
        this.inspector.setTitle(MediaRes.getString("Filter.Brightness.Title"));
        this.inspector.updateDisplay();
        this.inspector.pack();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.inspector = null;
    }

    @Override
    protected void initializeSubclass() {
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int i = 0;
        while (i < this.nPixelsIn) {
            int pixel = this.pixelsIn[i];
            int r = pixel >> 16 & 0xFF;
            r = Math.max((int)(this.slope * ((double)r + this.offset1) + this.offset2), 0);
            r = Math.min(r, 255);
            int g = pixel >> 8 & 0xFF;
            g = Math.max((int)(this.slope * ((double)g + this.offset1) + this.offset2), 0);
            g = Math.min(g, 255);
            int b = pixel & 0xFF;
            b = Math.max((int)(this.slope * ((double)b + this.offset1) + this.offset2), 0);
            b = Math.min(b, 255);
            this.pixelsOut[i] = r << 16 | g << 8 | b;
            ++i;
        }
    }

    private void updateFactors() {
        double theta = Math.PI * this.contrast / 200.0;
        double sin = Math.sin(theta);
        this.offset1 = sin * sin * (double)this.brightness - 127.0;
        double cos = Math.cos(theta);
        this.offset2 = 127.0 + cos * cos * (double)this.brightness;
        this.slope = sin / cos;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        protected Inspector() {
            super(BrightnessFilter.this, "Filter.Brightness.Title");
        }

        @Override
        void createGUI() {
            this.setTitle(MediaRes.getString("Filter.Brightness.Title"));
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (BrightnessFilter.this.isChanged() && ((Inspector)Inspector.this).BrightnessFilter.this.previousState != null) {
                        ((Inspector)Inspector.this).BrightnessFilter.this.changed = false;
                        Inspector.this.firePropertyChange("filterChanged", ((Inspector)Inspector.this).BrightnessFilter.this.previousState, BrightnessFilter.this);
                        ((Inspector)Inspector.this).BrightnessFilter.this.previousState = null;
                    }
                }
            });
            BrightnessFilter.this.brightnessLabel = new JLabel();
            BrightnessFilter.this.brightnessLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            BrightnessFilter.this.brightnessField = new IntegerField(3);
            BrightnessFilter.this.brightnessField.setMaxValue(128.0);
            BrightnessFilter.this.brightnessField.setMinValue(-128.0);
            BrightnessFilter.this.brightnessField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrightnessFilter.this.setBrightness(BrightnessFilter.this.brightnessField.getIntValue());
                    Inspector.this.updateDisplay();
                    BrightnessFilter.this.brightnessField.selectAll();
                }
            });
            BrightnessFilter.this.brightnessField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    BrightnessFilter.this.brightnessField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    BrightnessFilter.this.setBrightness(BrightnessFilter.this.brightnessField.getIntValue());
                    Inspector.this.updateDisplay();
                }
            });
            BrightnessFilter.this.brightnessSlider = new JSlider(0, 0, 0);
            BrightnessFilter.this.brightnessSlider.setMaximum(128);
            BrightnessFilter.this.brightnessSlider.setMinimum(-128);
            BrightnessFilter.this.brightnessSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            BrightnessFilter.this.brightnessSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = BrightnessFilter.this.brightnessSlider.getValue();
                    if (i != BrightnessFilter.this.getBrightness()) {
                        BrightnessFilter.this.setBrightness(i);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            BrightnessFilter.this.contrastLabel = new JLabel();
            BrightnessFilter.this.contrastField = new DecimalField(4, 1);
            BrightnessFilter.this.contrastField.setMaxValue(100.0);
            BrightnessFilter.this.contrastField.setMinValue(0.0);
            BrightnessFilter.this.contrastField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrightnessFilter.this.setContrast(BrightnessFilter.this.contrastField.getValue());
                    Inspector.this.updateDisplay();
                    BrightnessFilter.this.contrastField.selectAll();
                }
            });
            BrightnessFilter.this.contrastField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    BrightnessFilter.this.contrastField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    BrightnessFilter.this.setContrast(BrightnessFilter.this.contrastField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            BrightnessFilter.this.contrastSlider = new JSlider(0, 0, 0);
            BrightnessFilter.this.contrastSlider.setMaximum(100);
            BrightnessFilter.this.contrastSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            BrightnessFilter.this.contrastSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = BrightnessFilter.this.contrastSlider.getValue();
                    if (i != (int)BrightnessFilter.this.getContrast()) {
                        BrightnessFilter.this.setContrast(i);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            JLabel[] labels = new JLabel[]{BrightnessFilter.this.brightnessLabel, BrightnessFilter.this.contrastLabel};
            JTextField[] fields = new JTextField[]{BrightnessFilter.this.brightnessField, BrightnessFilter.this.contrastField};
            JSlider[] sliders = new JSlider[]{BrightnessFilter.this.brightnessSlider, BrightnessFilter.this.contrastSlider};
            GridBagLayout gridbag = new GridBagLayout();
            JPanel panel = new JPanel(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 13;
            int i = 0;
            while (i < labels.length) {
                c.gridy = i;
                c.fill = 0;
                c.weightx = 0.0;
                c.gridx = 0;
                c.insets = new Insets(5, 5, 0, 2);
                gridbag.setConstraints(labels[i], c);
                panel.add(labels[i]);
                c.fill = 2;
                c.gridx = 1;
                c.insets = new Insets(5, 0, 0, 0);
                gridbag.setConstraints(fields[i], c);
                panel.add(fields[i]);
                c.gridx = 2;
                c.insets = new Insets(5, 0, 0, 0);
                c.weightx = 1.0;
                gridbag.setConstraints(sliders[i], c);
                panel.add(sliders[i]);
                ++i;
            }
            JPanel buttonbar = new JPanel();
            buttonbar.add(BrightnessFilter.this.ableButton);
            buttonbar.add(BrightnessFilter.this.clearButton);
            buttonbar.add(BrightnessFilter.this.closeButton);
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.add((Component)panel, "North");
            this.setContentPane(contentPane);
            contentPane.add((Component)buttonbar, "South");
        }

        void initialize() {
            this.updateDisplay();
        }

        void updateDisplay() {
            BrightnessFilter.this.brightnessField.setIntValue(BrightnessFilter.this.getBrightness());
            BrightnessFilter.this.contrastField.setValue(BrightnessFilter.this.getContrast());
            BrightnessFilter.this.brightnessSlider.setValue(BrightnessFilter.this.getBrightness());
            BrightnessFilter.this.contrastSlider.setValue((int)BrightnessFilter.this.getContrast());
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            BrightnessFilter filter = (BrightnessFilter)obj;
            control.setValue("brightness", filter.getBrightness());
            control.setValue("contrast", filter.getContrast());
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new BrightnessFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            BrightnessFilter filter = (BrightnessFilter)obj;
            if (control.getPropertyNamesRaw().contains("brightness")) {
                filter.setBrightness(control.getInt("brightness"));
            }
            if (control.getPropertyNamesRaw().contains("contrast")) {
                filter.setContrast(control.getDouble("contrast"));
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            filter.previousState = null;
            filter.changed = false;
            if (filter.inspector != null) {
                filter.inspector.updateDisplay();
            }
            return obj;
        }
    }
}

