/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.StepperClipControl;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoClipControl;

public abstract class ClipControl
extends OSPRuntime.Supported
implements PropertyChangeListener {
    protected int stepNumber = 0;
    protected int videoFrameNumber = 0;
    protected final VideoClip clip;
    protected Video video;
    protected double rate = 1.0;
    protected boolean looping = false;
    protected double timeStretch = 1.0;
    protected DataTrack timeSource;
    protected double savedFrameDuration;
    public boolean videoVisible = true;
    public int loadedStepNumber = -1;
    public static final String PROPERTY_CLIPCONTROL_LOOPING = "looping";
    public static final String PROPERTY_CLIPCONTROL_PLAYING = "playing";
    public static final String PROPERTY_CLIPCONTROL_RATE = "rate";
    public static final String PROPERTY_CLIPCONTROL_STEPNUMBER = "stepnumber";
    public static final String PROPERTY_CLIPCONTROL_FRAMEDURATION = "frameduration";

    public static ClipControl getControl(VideoClip clip) {
        Video video2 = clip.getVideo();
        return clip.isPlayAllSteps() || video2 == null || video2 instanceof ImageVideo ? new StepperClipControl(clip) : new VideoClipControl(clip);
    }

    protected ClipControl(VideoClip videoClip) {
        this.clip = videoClip;
        this.video = this.clip.getVideo();
        if (this.video != null) {
            this.video.addPropertyChangeListener(this);
        }
    }

    public VideoClip getVideoClip() {
        return this.clip;
    }

    public void play() {
    }

    public void stop() {
    }

    public void step() {
    }

    public void back() {
    }

    public void setFrameNumber(int n) {
        if (this.clip.includesFrame(n)) {
            this.stepNumber = this.clip.frameToStep(n);
            this.videoFrameNumber = n;
        }
    }

    public void setStepNumber(int n) {
        this.stepNumber = n;
        this.videoFrameNumber = n = Math.max(0, this.clip.stepToFrame(n));
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setRate(double newRate) {
        this.rate = newRate;
    }

    public double getRate() {
        return this.rate;
    }

    public double getMeasuredRate() {
        return this.rate;
    }

    public void setLooping(boolean loops) {
        this.looping = loops;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public int getFrameNumber() {
        return Math.max(0, this.videoFrameNumber);
    }

    public DataTrack getTimeSource() {
        return this.timeSource;
    }

    public void setTimeSource(DataTrack source) {
        DataTrack prev = this.timeSource;
        this.timeSource = source;
        if (prev == null && this.timeSource != null) {
            this.clip.savedStartTime = this.clip.isDefaultStartTime ? Double.NaN : this.clip.getStartTime();
            this.clip.startTimeIsSaved = true;
            this.savedFrameDuration = this.getMeanFrameDuration();
        } else if (prev != null && this.timeSource == null) {
            this.clip.setStartTime(this.clip.savedStartTime);
            this.clip.startTimeIsSaved = false;
            this.setFrameDuration(this.savedFrameDuration);
        }
        if (this.timeSource != null && this.timeSource.isTimeDataAvailable()) {
            this.clip.setStartTime(this.timeSource.getVideoStartTime() * 1000.0);
            this.setFrameDuration(this.timeSource.getFrameDuration() * 1000.0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "startframe": {
                this.stepNumber = this.clip.frameToStep(this.getFrameNumber());
                break;
            }
            case "framenumber": {
                int n = (Integer)e.getNewValue();
                if (n == this.videoFrameNumber) break;
                this.setFrameNumber(n);
                this.firePropertyChange(PROPERTY_CLIPCONTROL_STEPNUMBER, null, this.stepNumber);
            }
        }
    }

    public abstract boolean isPlaying();

    public abstract double getTime();

    public abstract double getStepTime(int var1);

    public abstract void setFrameDuration(double var1);

    public abstract double getMeanFrameDuration();

    @Override
    public void dispose() {
        if (this.clip != null) {
            this.clip.dispose();
        }
        super.dispose();
    }

    public static boolean isTimeSource(DataTrack track) {
        if (track.getVideoPanel() == null) {
            return false;
        }
        return track == track.getVideoPanel().getPlayer().getClipControl().getTimeSource();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ClipControl clipControl = (ClipControl)obj;
            control.setValue(ClipControl.PROPERTY_CLIPCONTROL_RATE, clipControl.getRate());
            control.setValue("delta_t", clipControl.getTimeSource() != null ? clipControl.savedFrameDuration : clipControl.getMeanFrameDuration());
            if (clipControl.isLooping()) {
                control.setValue(ClipControl.PROPERTY_CLIPCONTROL_LOOPING, true);
            }
            control.setValue("frame", clipControl.getFrameNumber());
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            double dt;
            ClipControl clipControl = (ClipControl)obj;
            double rate = control.getDouble(ClipControl.PROPERTY_CLIPCONTROL_RATE);
            if (rate != Double.NaN) {
                clipControl.setRate(rate);
            }
            if ((dt = control.getDouble("delta_t")) != Double.NaN) {
                clipControl.setFrameDuration(dt);
            }
            clipControl.setLooping(control.getBoolean(ClipControl.PROPERTY_CLIPCONTROL_LOOPING));
            if (control.getPropertyNamesRaw().contains("frame")) {
                int n = control.getInt("frame");
                VideoClip vclip = clipControl.getVideoClip();
                n = vclip.frameToStep(n - vclip.frameShift);
                clipControl.setStepNumber(n);
                clipControl.loadedStepNumber = n;
            }
            return obj;
        }
    }
}

