/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.GhostFilter;

public class DarkGhostFilter
extends GhostFilter {
    public DarkGhostFilter() {
        this.prefix = "Filter.DarkGhost";
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int i = 0;
        while (i < this.nPixelsIn) {
            int ghost = (int)(255.0 - (1.0 - this.fade) * (double)(255 - this.values[i]));
            int pixel = this.pixelsIn[i];
            int v = ((pixel >> 16 & 0xFF) + (pixel >> 8 & 0xFF) + (pixel & 0xFF)) / 3;
            if (ghost < v) {
                this.pixelsOut[i] = ghost << 16 | ghost << 8 | ghost;
                this.values[i] = ghost;
            } else {
                this.pixelsOut[i] = pixel;
                this.values[i] = v;
            }
            ++i;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    extends GhostFilter.Loader {
        Loader() {
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DarkGhostFilter();
        }
    }
}

