/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import org.opensourcephysics.media.core.NumberField;

public class DecimalField
extends NumberField {
    protected String defaultPattern;

    public DecimalField(int columns, int places) {
        super(columns, 4, true);
        this.setDecimalPlaces(places);
    }

    public void setDecimalPlaces(int places) {
        places = Math.min(places, 5);
        places = Math.max(places, 1);
        char d = '.';
        String pattern = "0" + d;
        int i = 0;
        while (i < places) {
            pattern = String.valueOf(pattern) + "0";
            ++i;
        }
        this.defaultPattern = pattern;
        if (this.nf.userPattern.equals("")) {
            this.applyPattern(pattern);
        }
    }

    @Override
    public void setSigFigs(int sigfigs) {
    }

    @Override
    public void setExpectedRange(double lower, double upper) {
    }

    @Override
    public void setFixedPattern(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if ((pattern = pattern.trim()).equals(this.nf.userPattern)) {
            return;
        }
        this.nf.userPattern = pattern;
        if (this.nf.userPattern.equals("")) {
            this.applyPattern(this.defaultPattern);
        } else {
            this.applyPattern(this.nf.userPattern);
        }
        this.setValue(this.prevValue);
    }
}

