/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;

public class DeinterlaceFilter
extends Filter {
    private boolean isOdd;
    private Inspector inspector;
    private JRadioButton odd;
    private JRadioButton even;

    public DeinterlaceFilter() {
        this.hasInspector = true;
    }

    public void setOdd(boolean odd) {
        boolean prev = this.isOdd;
        this.isOdd = odd;
        this.firePropertyChange("odd", prev, odd);
    }

    public boolean isOdd() {
        return this.isOdd;
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.odd.setText(MediaRes.getString("Filter.Deinterlace.Button.Odd"));
        this.even.setText(MediaRes.getString("Filter.Deinterlace.Button.Even"));
        boolean enabled = this.isEnabled();
        this.odd.setEnabled(enabled);
        this.even.setEnabled(enabled);
        this.inspector.setTitle(MediaRes.getString("Filter.Deinterlace.Title"));
        this.inspector.pack();
    }

    @Override
    protected void initializeSubclass() {
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int off = this.isOdd ? this.w : 0;
        int p = 0;
        int i = 0;
        int n = this.h - 1;
        while (i < n) {
            int j = 0;
            while (j < this.w) {
                int n2 = this.pixelsIn[p + off];
                this.pixelsOut[p + this.w] = n2;
                this.pixelsOut[p] = n2;
                ++j;
                ++p;
            }
            i += 2;
            p += this.w;
        }
        if (this.h % 2 != 0) {
            int j = 0;
            while (j < this.w) {
                this.pixelsOut[p] = this.pixelsIn[p];
                ++j;
                ++p;
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        ButtonGroup group;

        public Inspector() {
            super(DeinterlaceFilter.this, "Filter.Deinterlace.Title");
        }

        @Override
        void createGUI() {
            DeinterlaceFilter.this.odd = new JRadioButton();
            DeinterlaceFilter.this.even = new JRadioButton();
            this.group = new ButtonGroup();
            this.group.add(DeinterlaceFilter.this.odd);
            this.group.add(DeinterlaceFilter.this.even);
            ActionListener select = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeinterlaceFilter.this.setOdd(Inspector.this.group.isSelected(DeinterlaceFilter.this.odd.getModel()));
                }
            };
            DeinterlaceFilter.this.even.addActionListener(select);
            DeinterlaceFilter.this.odd.addActionListener(select);
            JPanel panel = new JPanel(new FlowLayout());
            panel.add(DeinterlaceFilter.this.odd);
            panel.add(DeinterlaceFilter.this.even);
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(DeinterlaceFilter.this.ableButton);
            buttonbar.add(DeinterlaceFilter.this.closeButton);
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            contentPane.add((Component)panel, "Center");
            contentPane.add((Component)buttonbar, "South");
        }

        void initialize() {
            this.updateDisplay();
        }

        void updateDisplay() {
            if (DeinterlaceFilter.this.isOdd) {
                this.group.setSelected(DeinterlaceFilter.this.odd.getModel(), true);
            } else {
                this.group.setSelected(DeinterlaceFilter.this.even.getModel(), true);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DeinterlaceFilter filter = (DeinterlaceFilter)obj;
            if (filter.isOdd()) {
                control.setValue("field", "odd");
            } else {
                control.setValue("field", "even");
            }
            if (filter.getFrame() != null && filter.inspector != null && filter.inspector.isVisible()) {
                int x = ((DeinterlaceFilter)filter).inspector.getLocation().x - filter.frame.getLocation().x;
                int y = ((DeinterlaceFilter)filter).inspector.getLocation().y - filter.frame.getLocation().y;
                control.setValue("inspector_x", x);
                control.setValue("inspector_y", y);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DeinterlaceFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DeinterlaceFilter filter = (DeinterlaceFilter)obj;
            if (control.getPropertyNamesRaw().contains("field")) {
                if (control.getString("field").equals("odd")) {
                    filter.setOdd(true);
                } else {
                    filter.setOdd(false);
                }
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

