/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public abstract class Filter
extends OSPRuntime.Supported {
    protected boolean haveGUI;
    protected static final int ROTATE_NONE = -1;
    protected static final int ROTATE_CCW_90 = 0;
    protected static final int ROTATE_CW_90 = 1;
    protected static final int ROTATE_180 = 2;
    public static final String PROPERTY_FILTER_VISIBLE = "filter_visible";
    public static final String PROPERTY_FILTER_COLOR = "filter_color";
    public static final String PROPERTY_FILTER_TAB = "tab";
    public static final String PROPERTY_FILTER_IMAGE = "image";
    public static final String PROPERTY_FILTER_FILTER = "filter";
    public static final String PROPERTY_FILTER_BRIGHTNESS = "brightness";
    public static final String PROPERTY_FILTER_MEAN = "mean";
    public static final String PROPERTY_FILTER_RESET = "reset";
    public static final String PROPERTY_FILTER_ENABLED = "enabled";
    protected int rotationType = -1;
    protected boolean autoScale720x480 = false;
    protected int[] pixelsIn;
    protected int[] pixelsOut;
    protected double widthFactor = 1.0;
    protected double heightFactor = 1.0;
    public boolean inspectorVisible;
    public int inspectorX = Integer.MIN_VALUE;
    public int inspectorY;
    protected BufferedImage source;
    protected BufferedImage input;
    protected BufferedImage output;
    protected int w;
    protected int h;
    private boolean enabled = true;
    private String name = this.getClass().getSimpleName();
    protected boolean changed = false;
    protected String previousState;
    protected VideoPanel vidPanel;
    protected Action enabledAction;
    protected boolean hasInspector;
    protected FilterStack stack;
    protected boolean doCreateOutput = true;
    protected int nPixelsIn;
    protected JFrame frame;
    protected JCheckBoxMenuItem enabledItem;
    protected JMenuItem deleteItem;
    protected JMenuItem propertiesItem;
    protected JMenuItem copyItem;
    protected JButton closeButton;
    protected JButton ableButton;
    protected JButton clearButton;
    protected InspectorDlg inspectorDlg;

    protected Filter() {
        int i = this.name.indexOf("Filter");
        if (i > 0 && i < this.name.length() - 1) {
            this.name = this.name.substring(0, i);
        }
    }

    public JDialog getInspector() {
        if (this.inspectorDlg == null) {
            this.inspectorDlg = this.newInspector();
            if (this.inspectorDlg == null) {
                return null;
            }
        }
        if (this.inspectorDlg.isModal() && this.vidPanel != null) {
            this.frame = this.getFrame();
            this.inspectorDlg.setVisible(false);
            this.inspectorDlg.dispose();
            this.inspectorDlg = this.newInspector();
        }
        return this.inspectorDlg;
    }

    protected abstract InspectorDlg newInspector();

    protected abstract InspectorDlg initInspector();

    public void clear() {
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setVideoPanel(VideoPanel panel) {
        this.vidPanel = panel;
    }

    public JFrame getFrame() {
        Frame test;
        if (this.vidPanel == null) {
            return null;
        }
        if (this.frame == null && (test = JOptionPane.getFrameForComponent(this.vidPanel)) != null && test instanceof JFrame) {
            this.frame = (JFrame)test;
        }
        return this.frame;
    }

    public void refresh() {
        if (!this.haveGUI) {
            return;
        }
        this.enabledItem.setText(MediaRes.getString("Filter.MenuItem.Enabled"));
        this.propertiesItem.setText(MediaRes.getString("Filter.MenuItem.Properties"));
        this.closeButton.setText(MediaRes.getString("Filter.Button.Close"));
        this.ableButton.setText(this.isEnabled() ? MediaRes.getString("Filter.Button.Disable") : MediaRes.getString("Filter.Button.Enable"));
        this.clearButton.setText(MediaRes.getString("Filter.Button.Clear"));
        this.clearButton.setEnabled(this.isEnabled());
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.firePropertyChange(PROPERTY_FILTER_ENABLED, null, enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void copy() {
        OSPRuntime.copy(new XMLControlElement(this).toXML(), null);
    }

    @Override
    public void dispose() {
        if (this.stack != null) {
            this.removePropertyChangeListener(this.stack);
        }
        this.stack = null;
        JDialog inspector = this.getInspector();
        if (inspector != null) {
            inspector.setVisible(false);
            inspector.dispose();
        }
        this.setVideoPanel(null);
        if (this.source != null) {
            this.source.flush();
        }
        if (this.input != null) {
            this.input.flush();
        }
        if (this.output != null) {
            this.output.flush();
        }
        this.pixelsOut = null;
        this.pixelsIn = null;
        super.dispose();
    }

    public JMenu getMenu(Video video2) {
        JMenu menu = new JMenu(MediaRes.getString("VideoFilter." + this.name));
        this.enabledAction = new AbstractAction(MediaRes.getString("Filter.MenuItem.Enabled")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter.this.setEnabled(Filter.this.enabledItem.isSelected());
                Filter.this.refresh();
            }
        };
        this.enabledItem = new JCheckBoxMenuItem(this.enabledAction);
        this.enabledItem.setSelected(this.isEnabled());
        this.propertiesItem = new JMenuItem(MediaRes.getString("Filter.MenuItem.Properties"));
        this.propertiesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog inspector = Filter.this.getInspector();
                if (inspector != null) {
                    inspector.setVisible(true);
                }
            }
        });
        this.copyItem = new JMenuItem(MediaRes.getString("Filter.MenuItem.Copy"));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter.this.copy();
            }
        });
        if (this.hasInspector) {
            menu.add(this.propertiesItem);
            menu.addSeparator();
        }
        menu.add(this.enabledItem);
        menu.addSeparator();
        menu.add(this.copyItem);
        if (video2 != null) {
            menu.addSeparator();
            this.deleteItem = new JMenuItem(MediaRes.getString("Filter.MenuItem.Delete"));
            final FilterStack filterStack = video2.getFilterStack();
            this.deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    filterStack.removeFilter(Filter.this);
                }
            });
            menu.add(this.deleteItem);
        }
        this.refresh();
        return menu;
    }

    private void createButtons() {
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog inspector = Filter.this.getInspector();
                if (inspector != null) {
                    if (Filter.this.isChanged() && Filter.this.previousState != null) {
                        Filter.this.changed = false;
                        Filter.this.firePropertyChange("filterChanged", Filter.this.previousState, Filter.this);
                        Filter.this.previousState = null;
                    }
                    inspector.setVisible(false);
                }
            }
        });
        this.ableButton = new JButton();
        this.ableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter.this.enabledItem.setSelected(!Filter.this.enabledItem.isSelected());
                Filter.this.enabledAction.actionPerformed(null);
            }
        });
        this.clearButton = new JButton();
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter.this.clear();
            }
        });
    }

    protected Raster getRaster(BufferedImage image) {
        return image.getRaster();
    }

    protected void getPixels(BufferedImage image, int[] pixels) {
        image.getRaster().getDataElements(0, 0, this.w, this.h, pixels);
    }

    public void getPixelsIn() {
        this.pixelsIn = ((DataBufferInt)this.input.getRaster().getDataBuffer()).getData();
    }

    public void getPixelsOut() {
        this.pixelsOut = ((DataBufferInt)this.output.getRaster().getDataBuffer()).getData();
    }

    protected void initializeSource(BufferedImage image) {
        this.source = image;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.nPixelsIn = this.w * this.h;
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            Graphics2D gIn = this.input.createGraphics();
            gIn.drawImage((Image)this.source, 0, 0, null);
            gIn.dispose();
        }
        if (this.doCreateOutput) {
            if (this.autoScale720x480 && this.w == 720 && this.h == 480 && this.widthFactor == 1.0 && this.heightFactor == 1.0) {
                this.widthFactor = 0.889;
            }
            int wOut = (int)((double)this.w * this.widthFactor);
            int hOut = (int)((double)this.h * this.heightFactor);
            if (this.rotationType == 1 || this.rotationType == 0) {
                int w0 = wOut;
                wOut = hOut;
                hOut = w0;
            }
            this.output = new BufferedImage(wOut, hOut, 1);
        }
    }

    protected BufferedImage getFilteredImage(BufferedImage sourceImage) {
        if (!this.isEnabled()) {
            return sourceImage;
        }
        if (sourceImage != this.source) {
            this.initializeSource(sourceImage);
            this.initializeSubclass();
        }
        this.setOutputPixels();
        return this.output;
    }

    protected abstract void initializeSubclass();

    protected abstract void setOutputPixels();

    public void addLocation(XMLControl control) {
        if (this.getFrame() != null && this.inspectorDlg != null && this.inspectorDlg.isVisible()) {
            int x = this.inspectorDlg.getLocation().x - this.frame.getLocation().x;
            int y = this.inspectorDlg.getLocation().y - this.frame.getLocation().y;
            control.setValue("inspector_x", x);
            control.setValue("inspector_y", y);
        }
    }

    protected abstract class InspectorDlg
    extends JDialog {
        protected InspectorDlg(String title) {
            super((Frame)Filter.this.getFrame(), !(Filter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString(title));
        }

        abstract void createGUI();

        @Override
        public void setVisible(boolean b) {
            if (b && !Filter.this.haveGUI) {
                Filter.this.haveGUI = true;
                this.setResizable(false);
                Filter.this.createButtons();
                this.createGUI();
                Filter.this.getMenu(null);
                Filter.this.initInspector();
                Filter.this.refresh();
                FontSizer.setFonts(this, FontSizer.getLevel());
                this.pack();
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = Math.max(0, (dim.width - this.getWidth()) / 2);
                int y = Math.max(0, (dim.height - this.getHeight()) / 2);
                this.setLocation(x, y);
            }
            super.setVisible(b);
        }
    }
}

