/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensourcephysics.media.core.Filter;

public class FilterStack
extends Filter
implements PropertyChangeListener {
    private ArrayList<Filter> filters = new ArrayList();
    private Filter postFilter;
    private int indexRemoved = -1;

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        filter.stack = this;
        filter.addPropertyChangeListenerSafely(this);
        this.notifyUpdate(null, filter);
    }

    public void addFilters(Collection<Filter> stack) {
        if (stack != null) {
            for (Filter f : stack) {
                this.addFilter(f);
            }
        }
    }

    public void addFilters(FilterStack stack) {
        if (stack != null) {
            for (Filter f : stack.filters) {
                this.addFilter(f);
            }
        }
    }

    private void notifyUpdate(Filter oldFilter, Filter newFilter) {
        this.firePropertyChange("image", null, null);
        this.firePropertyChange("filter", oldFilter, newFilter);
    }

    public void insertFilter(Filter filter, int index) {
        index = Math.min(index, this.filters.size());
        index = Math.max(index, 0);
        this.filters.add(index, filter);
        filter.stack = this;
        filter.addPropertyChangeListener(this);
        this.notifyUpdate(null, filter);
    }

    public int lastIndexRemoved() {
        return this.indexRemoved;
    }

    public void setPostFilter(Filter filter) {
        if (this.postFilter != null) {
            this.postFilter.removePropertyChangeListener(this);
        }
        this.postFilter = filter;
        if (filter != null) {
            filter.addPropertyChangeListener(this);
            this.notifyUpdate(null, filter);
        }
    }

    public Filter getPostFilter() {
        return this.postFilter;
    }

    public Filter getFilter(Class<?> filterClass) {
        for (Filter filter : this.filters) {
            if (filter.getClass() != filterClass) continue;
            return filter;
        }
        return null;
    }

    public void removeFilter(Filter filter) {
        this.indexRemoved = this.filters.indexOf(filter);
        if (this.indexRemoved > -1) {
            this.filters.remove(filter);
            filter.dispose();
            this.notifyUpdate(filter, null);
        }
        System.gc();
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }

    @Override
    public void clear() {
        for (Filter filter : this.filters) {
            filter.dispose();
        }
        this.filters.clear();
        this.notifyUpdate(null, null);
        System.gc();
    }

    public boolean isEmpty() {
        return this.filters.isEmpty() && this.postFilter == null;
    }

    public ArrayList<Filter> getFilters() {
        return new ArrayList<Filter>(this.filters);
    }

    @Override
    public BufferedImage getFilteredImage(BufferedImage sourceImage) {
        if (!this.isEnabled()) {
            return sourceImage;
        }
        boolean mustWork = this.postFilter != null && this.postFilter.isEnabled();
        int i = 0;
        int n = this.filters.size();
        while (!mustWork && i < n) {
            mustWork = this.filters.get(i).isEnabled();
            ++i;
        }
        if (!mustWork) {
            return sourceImage;
        }
        i = 0;
        n = this.filters.size();
        while (i <= n) {
            Filter filter;
            Filter filter2 = filter = i == n ? this.postFilter : this.filters.get(i);
            if (filter != null && filter.isEnabled()) {
                sourceImage = filter.getFilteredImage(sourceImage);
            }
            ++i;
        }
        return sourceImage;
    }

    @Override
    protected void setOutputPixels() {
    }

    @Override
    public Filter.InspectorDlg newInspector() {
        return null;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        return null;
    }

    public void setInspectorsVisible(boolean vis) {
        ArrayList<Filter> filters = this.getFilters();
        for (Filter filter : filters) {
            Filter.InspectorDlg inspector = (Filter.InspectorDlg)filter.getInspector();
            if (inspector == null) continue;
            if (!vis) {
                filter.inspectorVisible = inspector.isVisible();
                inspector.setVisible(false);
                continue;
            }
            if (inspector.isModal()) continue;
            inspector.setVisible(filter.inspectorVisible);
        }
    }

    @Override
    public void refresh() {
        Iterator<Filter> it = this.getFilters().iterator();
        while (it.hasNext()) {
            it.next().refresh();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "filterChanged": {
                this.firePropertyChange("filterChanged", e.getOldValue(), e.getNewValue());
                break;
            }
            default: {
                this.firePropertyChange("image", null, null);
            }
        }
    }

    @Override
    protected void initializeSubclass() {
    }
}

