/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class GhostFilter
extends Filter {
    protected double fade;
    protected double defaultFade = 0.05;
    protected Inspector inspector;
    protected JLabel fadeLabel;
    protected NumberField fadeField;
    protected JSlider fadeSlider;
    protected int[] values;
    String prefix = "Filter.Ghost";

    public GhostFilter() {
        this.setFade(this.defaultFade);
        this.hasInspector = true;
    }

    public void setFade(double fade) {
        Double prev = this.fade;
        this.fade = Math.min(Math.abs(fade), 1.0);
        this.firePropertyChange("fade", prev, fade);
    }

    public double getFade() {
        return this.fade;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        this.source = null;
        super.setEnabled(enabled);
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void clear() {
        this.source = null;
        this.firePropertyChange("image", null, null);
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.fadeLabel.setText(MediaRes.getString(String.valueOf(this.prefix) + ".Label.Fade"));
        this.fadeSlider.setToolTipText(MediaRes.getString(String.valueOf(this.prefix) + ".ToolTip.Fade"));
        boolean enabled = this.isEnabled();
        this.fadeLabel.setEnabled(enabled);
        this.fadeSlider.setEnabled(enabled);
        this.fadeField.setEnabled(enabled);
        this.inspector.setTitle(MediaRes.getString(String.valueOf(this.prefix) + ".Title"));
        this.inspector.pack();
    }

    @Override
    protected void initializeSubclass() {
        this.getPixelsIn();
        this.values = new int[this.nPixelsIn];
        int i = 0;
        while (i < this.nPixelsIn) {
            int pixel = this.pixelsIn[i];
            this.values[i] = ((pixel >> 16 & 0xFF) + (pixel >> 8 & 0xFF) + (pixel & 0xFF)) / 3;
            ++i;
        }
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int i = 0;
        while (i < this.nPixelsIn) {
            int ghost = (int)((1.0 - this.fade) * (double)this.values[i]);
            int pixel = this.pixelsIn[i];
            int v = ((pixel >> 16 & 0xFF) + (pixel >> 8 & 0xFF) + (pixel & 0xFF)) / 3;
            if (ghost > v) {
                this.pixelsOut[i] = ghost << 16 | ghost << 8 | ghost;
                this.values[i] = ghost;
            } else {
                this.pixelsOut[i] = pixel;
                this.values[i] = v;
            }
            ++i;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super(String.valueOf(GhostFilter.this.prefix) + ".Title");
        }

        @Override
        void createGUI() {
            GhostFilter.this.fadeLabel = new JLabel();
            GhostFilter.this.fadeLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            GhostFilter.this.fadeField = new DecimalField(4, 2);
            GhostFilter.this.fadeField.setMaxValue(0.5);
            GhostFilter.this.fadeField.setMinValue(0.0);
            GhostFilter.this.fadeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GhostFilter.this.setFade(((Inspector)Inspector.this).GhostFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                    ((Inspector)Inspector.this).GhostFilter.this.fadeField.selectAll();
                }
            });
            GhostFilter.this.fadeField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((Inspector)Inspector.this).GhostFilter.this.fadeField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    GhostFilter.this.setFade(((Inspector)Inspector.this).GhostFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            GhostFilter.this.fadeSlider = new JSlider(0, 0, 0);
            GhostFilter.this.fadeSlider.setMaximum(50);
            GhostFilter.this.fadeSlider.setMinimum(0);
            GhostFilter.this.fadeSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            GhostFilter.this.fadeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = ((Inspector)Inspector.this).GhostFilter.this.fadeSlider.getValue();
                    if (i != (int)(GhostFilter.this.getFade() * 100.0)) {
                        GhostFilter.this.setFade((double)i / 100.0);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            GridBagLayout gridbag = new GridBagLayout();
            JPanel panel = new JPanel(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 13;
            c.fill = 0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.insets = new Insets(5, 5, 0, 2);
            gridbag.setConstraints(GhostFilter.this.fadeLabel, c);
            panel.add(GhostFilter.this.fadeLabel);
            c.fill = 2;
            c.gridx = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(GhostFilter.this.fadeField, c);
            panel.add(GhostFilter.this.fadeField);
            c.gridx = 2;
            c.insets = new Insets(5, 0, 0, 0);
            c.weightx = 1.0;
            gridbag.setConstraints(GhostFilter.this.fadeSlider, c);
            panel.add(GhostFilter.this.fadeSlider);
            JPanel buttonbar = new JPanel();
            buttonbar.add(GhostFilter.this.ableButton);
            buttonbar.add(GhostFilter.this.clearButton);
            buttonbar.add(GhostFilter.this.closeButton);
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.add((Component)panel, "North");
            this.setContentPane(contentPane);
            contentPane.add((Component)buttonbar, "South");
        }

        void initialize() {
            this.updateDisplay();
            GhostFilter.this.refresh();
        }

        void updateDisplay() {
            GhostFilter.this.fadeField.setValue(GhostFilter.this.getFade());
            GhostFilter.this.fadeSlider.setValue((int)(100.0 * GhostFilter.this.getFade()));
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            GhostFilter filter = (GhostFilter)obj;
            control.setValue("fade", filter.getFade());
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new GhostFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            GhostFilter filter = (GhostFilter)obj;
            if (control.getPropertyNamesRaw().contains("fade")) {
                filter.setFade(control.getDouble("fade"));
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

