/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class GrayScaleFilter
extends Filter {
    private static final double WT_R_VID = 0.3;
    private static final double WT_G_VID = 0.59;
    private static final double WT_B_VID = 0.11;
    private static final double WT_FLAT = 0.3333333333333333;
    private double redWt;
    private double greenWt;
    private double blueWt;
    private Inspector inspector;
    private JRadioButton vidButton;
    private JRadioButton flatButton;
    private JRadioButton customButton;
    private ButtonGroup buttons;
    private JLabel[] colorLabels = new JLabel[3];
    private NumberField[] colorFields = new NumberField[3];
    private JComponent typePanel;
    private JComponent rgbPanel;
    private double rgbWt;

    public GrayScaleFilter() {
        this.setWeights(0.3, 0.59, 0.11);
        this.hasInspector = true;
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    public void setWeights(double r, double g, double b) {
        this.redWt = r;
        this.greenWt = g;
        this.blueWt = b;
        this.rgbWt = this.redWt + this.greenWt + this.blueWt;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.typePanel.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("Filter.GrayScale.Label.Type")));
        this.rgbPanel.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("Filter.GrayScale.Label.Weight")));
        this.vidButton.setText(MediaRes.getString("Filter.GrayScale.Button.Video"));
        this.flatButton.setText(MediaRes.getString("Filter.GrayScale.Button.Flat"));
        this.customButton.setText(MediaRes.getString("Filter.GrayScale.Button.Custom"));
        this.colorLabels[0].setText(MediaRes.getString("Filter.GrayScale.Label.Red"));
        this.colorLabels[1].setText(MediaRes.getString("Filter.GrayScale.Label.Green"));
        this.colorLabels[2].setText(MediaRes.getString("Filter.GrayScale.Label.Blue"));
        this.vidButton.setEnabled(this.isEnabled());
        this.flatButton.setEnabled(this.isEnabled());
        this.customButton.setEnabled(this.isEnabled());
        int i = 0;
        while (i < 3) {
            this.colorFields[i].setEditable(this.buttons.isSelected(this.customButton.getModel()));
            this.colorFields[i].setEnabled(this.isEnabled());
            this.colorLabels[i].setEnabled(this.isEnabled());
            ++i;
        }
        this.inspector.setTitle(MediaRes.getString("Filter.GrayScale.Title"));
        this.inspector.pack();
    }

    @Override
    protected void initializeSubclass() {
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int i = 0;
        while (i < this.nPixelsIn) {
            int pixel = this.pixelsIn[i];
            int v = this.getGray(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF);
            this.pixelsOut[i] = v << 16 | v << 8 | v;
            ++i;
        }
    }

    private int getGray(int r, int g, int b) {
        double gray = (this.redWt * (double)r + this.greenWt * (double)g + this.blueWt * (double)b) / this.rgbWt;
        return (int)gray;
    }

    private void setWeights(double[] weights) {
        this.redWt = weights[0];
        this.greenWt = weights[1];
        this.blueWt = weights[2];
        this.rgbWt = this.redWt + this.greenWt + this.blueWt;
    }

    private double[] getWeights() {
        return new double[]{this.redWt, this.greenWt, this.blueWt};
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super("Filter.GrayScale.Title");
        }

        @Override
        void createGUI() {
            int i = 0;
            while (i < 3) {
                ((GrayScaleFilter)GrayScaleFilter.this).colorLabels[i] = new JLabel();
                ((GrayScaleFilter)GrayScaleFilter.this).colorFields[i] = new DecimalField(3, 2);
                GrayScaleFilter.this.colorFields[i].setMaxValue(1.0);
                GrayScaleFilter.this.colorFields[i].setMinValue(0.0);
                GrayScaleFilter.this.colorFields[i].addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Inspector.this.readFields((NumberField)e.getSource());
                    }
                });
                GrayScaleFilter.this.colorFields[i].addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        ((NumberField)e.getSource()).selectAll();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        Inspector.this.readFields((NumberField)e.getSource());
                    }
                });
                ++i;
            }
            GridBagLayout gridbag = new GridBagLayout();
            GrayScaleFilter.this.rgbPanel = new JPanel(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 13;
            int i2 = 0;
            while (i2 < 3) {
                c.gridy = i2;
                c.fill = 0;
                c.weightx = 0.0;
                c.gridx = 0;
                c.insets = new Insets(3, 20, 0, 3);
                gridbag.setConstraints(GrayScaleFilter.this.colorLabels[i2], c);
                GrayScaleFilter.this.rgbPanel.add(GrayScaleFilter.this.colorLabels[i2]);
                c.fill = 2;
                c.gridx = 1;
                c.insets = new Insets(3, 0, 0, 5);
                gridbag.setConstraints(GrayScaleFilter.this.colorFields[i2], c);
                GrayScaleFilter.this.rgbPanel.add(GrayScaleFilter.this.colorFields[i2]);
                ++i2;
            }
            GrayScaleFilter.this.vidButton = new JRadioButton();
            GrayScaleFilter.this.flatButton = new JRadioButton();
            GrayScaleFilter.this.customButton = new JRadioButton();
            GrayScaleFilter.this.buttons = new ButtonGroup();
            GrayScaleFilter.this.buttons.add(GrayScaleFilter.this.vidButton);
            GrayScaleFilter.this.buttons.add(GrayScaleFilter.this.flatButton);
            GrayScaleFilter.this.buttons.add(GrayScaleFilter.this.customButton);
            ActionListener select = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GrayScaleFilter.this.buttons.isSelected(GrayScaleFilter.this.vidButton.getModel())) {
                        GrayScaleFilter.this.setWeights(0.3, 0.59, 0.11);
                    } else if (GrayScaleFilter.this.buttons.isSelected(GrayScaleFilter.this.flatButton.getModel())) {
                        GrayScaleFilter.this.setWeights(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
                    }
                    GrayScaleFilter.this.refresh();
                    Inspector.this.updateDisplay();
                    GrayScaleFilter.this.firePropertyChange("weight", null, null);
                }
            };
            GrayScaleFilter.this.vidButton.addActionListener(select);
            GrayScaleFilter.this.flatButton.addActionListener(select);
            GrayScaleFilter.this.customButton.addActionListener(select);
            GrayScaleFilter.this.typePanel = Box.createVerticalBox();
            GrayScaleFilter.this.typePanel.add(GrayScaleFilter.this.vidButton);
            GrayScaleFilter.this.typePanel.add(GrayScaleFilter.this.flatButton);
            GrayScaleFilter.this.typePanel.add(GrayScaleFilter.this.customButton);
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            contentPane.add((Component)GrayScaleFilter.this.typePanel, "West");
            contentPane.add((Component)GrayScaleFilter.this.rgbPanel, "East");
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(GrayScaleFilter.this.ableButton);
            buttonbar.add(GrayScaleFilter.this.closeButton);
            contentPane.add((Component)buttonbar, "South");
        }

        void readFields(NumberField source) {
            double[] rgb = new double[3];
            int i = 0;
            while (i < 3) {
                rgb[i] = GrayScaleFilter.this.colorFields[i].getValue();
                ++i;
            }
            GrayScaleFilter.this.setWeights(rgb);
            this.updateDisplay();
            GrayScaleFilter.this.firePropertyChange("weight", null, null);
            source.selectAll();
        }

        void initialize() {
            if (GrayScaleFilter.this.redWt == 0.3 && GrayScaleFilter.this.greenWt == 0.59 && GrayScaleFilter.this.blueWt == 0.11) {
                GrayScaleFilter.this.vidButton.setSelected(true);
            } else if (GrayScaleFilter.this.redWt == 0.3333333333333333 && GrayScaleFilter.this.greenWt == 0.3333333333333333 && GrayScaleFilter.this.blueWt == 0.3333333333333333) {
                GrayScaleFilter.this.flatButton.setSelected(true);
            } else {
                GrayScaleFilter.this.customButton.setSelected(true);
            }
            GrayScaleFilter.this.refresh();
            this.updateDisplay();
        }

        void updateDisplay() {
            GrayScaleFilter.this.colorFields[0].setValue(GrayScaleFilter.this.redWt);
            GrayScaleFilter.this.colorFields[1].setValue(GrayScaleFilter.this.greenWt);
            GrayScaleFilter.this.colorFields[2].setValue(GrayScaleFilter.this.blueWt);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            GrayScaleFilter filter = (GrayScaleFilter)obj;
            control.setValue("weights", filter.getWeights());
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new GrayScaleFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            GrayScaleFilter filter = (GrayScaleFilter)obj;
            if (control.getPropertyNamesRaw().contains("weights")) {
                filter.setWeights((double[])control.getObject("weights"));
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

