/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javajs.async.AsyncDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ImageVideo
extends VideoAdapter {
    protected Component observer = new JPanel();
    protected Image[] images = new Image[0];
    protected BufferedImage rgbImage;
    protected String[] paths = new String[0];
    protected boolean readOnly;
    protected double deltaT = 100.0;
    protected Dimension rgbSize = new Dimension();

    public ImageVideo(String imageName, String basePath, boolean sequence) throws IOException {
        this.readOnly = true;
        if (basePath == null) {
            basePath = XML.getDirectoryPath(imageName);
        }
        if (basePath != null) {
            this.baseDir = basePath;
            this.setProperty("absolutePath", imageName.startsWith(basePath) ? imageName : String.valueOf(basePath) + "/" + imageName);
        }
        this.append(imageName, sequence);
    }

    public ImageVideo(String imageName) throws IOException {
        this.readOnly = true;
        this.insert(imageName, 0);
    }

    public ImageVideo(Image clipBoardImage) {
        this.readOnly = false;
        if (clipBoardImage != null) {
            this.insert(new Image[]{clipBoardImage}, 0, null);
        }
    }

    public ImageVideo(ImageVideo video2) {
        this.readOnly = false;
        Image[] images = video2.images;
        if (images == null) {
            return;
        }
        if (images.length > 0 && images[0] != null) {
            this.insert(images, 0, null);
        }
        this.rawImage = images[0];
        this.filterStack.addFilters(video2.filterStack);
    }

    @Override
    public void play() {
        this.playing = true;
    }

    @Override
    public void stop() {
        this.playing = false;
    }

    @Override
    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        this.rawImage = this.getImageAtFrame(this.getFrameNumber(), this.rawImage);
        this.updateBufferedImage();
        this.invalidateVideoAndFilter();
        this.notifyFrame(n, false);
    }

    public void setFrameDuration(double millis) {
        this.deltaT = millis;
    }

    @Override
    public double getEndTime() {
        return this.getFrameCountDurationMS();
    }

    @Override
    public void setEndTime(double millis) {
    }

    @Override
    public double getFrameCountDurationMS() {
        return (double)this.length() * this.deltaT;
    }

    @Override
    public double getFrameTime(int n) {
        return (double)n * this.deltaT;
    }

    public Image[] getImages() {
        return this.images;
    }

    public void append(String imageName) throws IOException {
        this.insert(imageName, this.length());
    }

    public void append(String imageName, boolean sequence) throws IOException {
        this.insert(imageName, this.length(), sequence);
    }

    public void insert(String imageName, final int index) throws IOException {
        this.loadImages(imageName, false, new Function<Object[], Void>(){

            @Override
            public Void apply(Object[] array) {
                Image[] images;
                if (array != null && ((images = (Image[])array[0]) == null || images.length > 0)) {
                    String[] paths = (String[])array[1];
                    ImageVideo.this.insert(images, index, paths);
                }
                return null;
            }
        });
    }

    public void insert(String imageName, int index, boolean sequence) throws IOException {
        Object[] images_paths = this.loadImages(imageName, sequence, null);
        Image[] images = (Image[])images_paths[0];
        if (images == null || images.length > 0) {
            String[] paths = (String[])images_paths[1];
            this.insert(images, index, paths);
            if (paths.length > 1) {
                this.size = this.getMaximumSize();
            }
        }
    }

    public void insert(Image image, int index) {
        if (image == null) {
            return;
        }
        this.insert(new Image[]{image}, index, null);
    }

    public String remove(int index) {
        if (this.readOnly) {
            return null;
        }
        int len = this.images.length;
        if (len == 1 || len <= index) {
            return null;
        }
        String removed = this.paths[index];
        Image[] newArray = new Image[len - 1];
        System.arraycopy(this.images, 0, newArray, 0, index);
        System.arraycopy(this.images, index + 1, newArray, index, len - 1 - index);
        this.images = newArray;
        String[] newPaths = new String[len - 1];
        System.arraycopy(this.paths, 0, newPaths, 0, index);
        System.arraycopy(this.paths, index + 1, newPaths, index, len - 1 - index);
        this.paths = newPaths;
        this.rawImage = index < len - 1 ? this.getImageAtFrame(index, this.rawImage) : this.getImageAtFrame(index - 1, this.rawImage);
        this.setFrameCount(this.images.length);
        this.endFrameNumber = this.frameCount - 1;
        this.size = this.getMaximumSize();
        return removed;
    }

    private Dimension getMaximumSize() {
        int w = this.images[0].getWidth(this.observer);
        int h = this.images[0].getHeight(this.observer);
        int i = 1;
        while (i < this.paths.length) {
            Image img = this.getImageAtFrame(i, null);
            if (img != null) {
                w = Math.max(w, img.getWidth(this.observer));
                h = Math.max(h, img.getHeight(this.observer));
            }
            ++i;
        }
        return new Dimension(w, h);
    }

    public Dimension getRGBSize() {
        return this.rgbSize;
    }

    public boolean isFileBased() {
        return this.getValidPaths().length == this.paths.length;
    }

    public boolean isEditable() {
        return !this.readOnly;
    }

    public void setEditable(boolean edit) throws IOException {
        if (edit && this.isEditable()) {
            return;
        }
        if (!edit && !this.isEditable()) {
            return;
        }
        if (!edit) {
            this.saveInvalidImages();
        }
        this.readOnly = !edit;
        String[] thePaths = this.paths;
        this.paths = new String[0];
        this.images = new Image[0];
        System.gc();
        int i = 0;
        while (i < thePaths.length) {
            if (thePaths[i] != null && thePaths[i].trim().length() > 0) {
                this.append(thePaths[i], false);
            }
            ++i;
        }
        if (this.frameCount < thePaths.length) {
            this.setEndFrameNumber(this.endFrameNumber + 1);
        }
    }

    public boolean saveInvalidImages() {
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<Image> imageList = new ArrayList<Image>();
        int i = 0;
        while (i < this.paths.length) {
            if (this.paths[i].equals("")) {
                pathList.add(this.paths[i]);
                imageList.add(this.images[i]);
            }
            ++i;
        }
        if (pathList.isEmpty()) {
            return true;
        }
        int approved = JOptionPane.showConfirmDialog(null, String.valueOf(MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Message1")) + XML.NEW_LINE + MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Message2"), MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Title"), 0, 2);
        if (approved == 0) {
            File file;
            block10: {
                ImageVideoRecorder recorder = new ImageVideoRecorder();
                recorder.setExpectedFrameCount(imageList.size());
                file = recorder.selectFile();
                if (file != null) break block10;
                return false;
            }
            try {
                String filePath = file.getAbsolutePath();
                BufferedImage[] imagesToSave = imageList.toArray(new BufferedImage[0]);
                String[] pathArray = ImageVideoRecorder.saveImages(filePath, imagesToSave);
                int j = 0;
                int i2 = 0;
                while (i2 < this.paths.length) {
                    if (this.paths[i2].equals("")) {
                        String relativePath = XML.getPathRelativeTo(pathArray[j++], this.baseDir);
                        this.paths[i2] = XML.forwardSlash(relativePath);
                    }
                    ++i2;
                }
                if (this.getProperty("name") == null) {
                    this.setProperty("name", XML.getName(filePath));
                    this.setProperty("path", filePath);
                    this.setProperty("absolutePath", filePath);
                }
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private Image getImageAtFrame(int frameNumber, Image defaultImage) {
        if (this.readOnly && frameNumber < this.paths.length) {
            Image image;
            if (frameNumber < this.images.length && this.images[frameNumber] != null) {
                return this.images[frameNumber];
            }
            if (!this.paths[frameNumber].equals("") && (image = ResourceLoader.getVideoImage(this.getAbsolutePath(this.paths[frameNumber]))) != null) {
                return image;
            }
        } else if (frameNumber < this.images.length && this.images[frameNumber] != null) {
            return this.images[frameNumber];
        }
        return defaultImage;
    }

    private int length() {
        if (this.readOnly) {
            return this.paths.length;
        }
        return this.images.length;
    }

    private Object[] loadImages(String imagePath, boolean sequence, final Function<Object[], Void> whenDone) throws IOException {
        String[] zipPaths = VideoIO.getZippedImagePaths(imagePath);
        if (zipPaths != null && zipPaths[0].equals(imagePath)) {
            return this.loadImages(zipPaths, sequence, whenDone);
        }
        final String path0 = imagePath;
        Resource res = ResourceLoader.getResource(this.getAbsolutePath(imagePath));
        if (res == null) {
            throw new IOException("Image " + imagePath + " not found");
        }
        Image image = res.getImage();
        if (image == null) {
            throw new IOException("\"" + imagePath + "\" is not an image");
        }
        if (this.getProperty("name") == null) {
            this.setProperty("name", XML.getName(imagePath));
            this.setProperty("path", imagePath);
            this.setProperty("absolutePath", res.getAbsolutePath());
        }
        if (whenDone == null && !sequence) {
            Image[] imageArray;
            if (this.readOnly && this.images.length > 0) {
                imageArray = null;
            } else {
                Image[] imageArray2 = new Image[1];
                imageArray = imageArray2;
                imageArray2[0] = image;
            }
            Image[] imges = imageArray;
            String[] paths = new String[]{imagePath};
            return new Object[]{imges, paths};
        }
        final ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(imagePath);
        String name = XML.getName(imagePath);
        String extension = "";
        int i = imagePath.lastIndexOf(46);
        if (i > 0 && i < imagePath.length() - 1) {
            extension = imagePath.substring(i).toLowerCase();
            imagePath = imagePath.substring(0, i);
        }
        int len = imagePath.length();
        int digits = 0;
        while (digits <= 4 && --len >= 0 && Character.isDigit(imagePath.charAt(len))) {
            ++digits;
        }
        switch (digits) {
            case 0: {
                Image[] imageArray;
                if (this.readOnly && this.images.length > 0) {
                    imageArray = null;
                } else {
                    Image[] imageArray3 = new Image[1];
                    imageArray = imageArray3;
                    imageArray3[0] = image;
                }
                Image[] imges = imageArray;
                String[] paths = new String[]{String.valueOf(imagePath) + extension};
                Object[] ret = new Object[]{imges, paths};
                if (whenDone != null) {
                    whenDone.apply(ret);
                }
                return ret;
            }
        }
        int limit = (int)Math.pow(10.0, digits);
        final ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(image);
        if (!sequence && whenDone != null) {
            new AsyncDialog().showOptionDialog(null, "\"" + name + "\" " + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Message") + XML.NEW_LINE + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Query"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Title"), 0, 3, null, new String[]{MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.SingleImage"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages")}, MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int sel = ((AsyncDialog)e.getSource()).getOption();
                    switch (sel) {
                        case 0: {
                            Image[] imges = ImageVideo.this.readOnly && ImageVideo.this.images.length > 0 ? null : imageList.toArray(new Image[0]);
                            String[] paths = pathList.toArray(new String[0]);
                            whenDone.apply(new Object[]{imges, paths});
                            return;
                        }
                        case 2: {
                            whenDone.apply(new Object[]{new Image[0], new String[0]});
                            return;
                        }
                        case 1: {
                            try {
                                ImageVideo.this.loadImages(path0, true, (Function<Object[], Void>)whenDone);
                            }
                            catch (IOException e1) {
                                whenDone.apply(null);
                            }
                            return;
                        }
                    }
                }
            });
            return null;
        }
        String root = imagePath.substring(0, ++len);
        int n = Integer.parseInt(imagePath.substring(len));
        try {
            while (++n < limit) {
                boolean precacheImage = !this.readOnly || imageList.isEmpty();
                String num = "000" + n;
                imagePath = String.valueOf(root) + num.substring(num.length() - digits) + extension;
                if (!(!precacheImage ? !ResourceLoader.checkExists(this.getAbsolutePath(imagePath)) : (image = ResourceLoader.getImage(this.getAbsolutePath(imagePath))) == null)) {
                    if (precacheImage) {
                        imageList.add(image);
                    }
                    pathList.add(imagePath);
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        Image[] imges = this.readOnly && this.images.length > 0 ? null : imageList.toArray(new Image[0]);
        String[] paths = pathList.toArray(new String[0]);
        Object[] ret = new Object[]{imges, paths};
        if (whenDone != null) {
            whenDone.apply(ret);
        }
        return ret;
    }

    private Object[] loadImages(String[] imagePaths, boolean sequence, Function<Object[], Void> whenDone) throws IOException {
        String path0 = imagePaths[0];
        Resource res = ResourceLoader.getResource(this.getAbsolutePath(path0));
        if (res == null) {
            throw new IOException("Image " + path0 + " not found");
        }
        Image image = res.getImage();
        if (image == null) {
            throw new IOException("\"" + path0 + "\" is not an image");
        }
        if (this.getProperty("name") == null) {
            int n = path0.indexOf("!/");
            String path = n > 0 ? path0.substring(0, n) : path0;
            this.setProperty("ext", XML.getExtension(path0));
            this.setProperty("name", XML.getName(path));
            this.setProperty("path", path);
            this.setProperty("absolutePath", n > 0 ? path : res.getAbsolutePath());
        }
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(image);
        boolean precacheImage = false;
        if (precacheImage) {
            int i = 0;
            while (i < imagePaths.length) {
                image = ResourceLoader.getImage(this.getAbsolutePath(imagePaths[i]));
                if (image != null) {
                    imageList.add(image);
                }
                ++i;
            }
        }
        Image[] images = imageList.toArray(new Image[imageList.size()]);
        Object[] ret = new Object[]{images, imagePaths};
        if (whenDone != null) {
            whenDone.apply(ret);
        }
        return ret;
    }

    public String[] getValidPaths() {
        ArrayList<String> pathList = new ArrayList<String>();
        int i = 0;
        while (i < this.paths.length) {
            if (!this.paths[i].equals("")) {
                pathList.add(this.paths[i]);
            }
            ++i;
        }
        return pathList.toArray(new String[0]);
    }

    protected String[] getValidPathsRelativeTo(String base) {
        ArrayList<String> pathList = new ArrayList<String>();
        int i = 0;
        while (i < this.paths.length) {
            if (!this.paths[i].equals("")) {
                String absolutePath = this.getAbsolutePath(this.paths[i]);
                pathList.add(XML.getPathRelativeTo(absolutePath, base));
            }
            ++i;
        }
        return pathList.toArray(new String[0]);
    }

    protected void insert(Image[] newImages, int index, String[] imagePaths) {
        int n;
        if (imagePaths == null && (this.readOnly || newImages == null)) {
            return;
        }
        int len = this.length();
        index = Math.min(index, len);
        int n2 = n = this.readOnly ? imagePaths.length : newImages.length;
        if (newImages != null) {
            BufferedImage[] buf = new BufferedImage[n];
            int i = 0;
            while (i < newImages.length) {
                Image im = newImages[i];
                if (im instanceof BufferedImage) {
                    buf[i] = (BufferedImage)im;
                } else {
                    int w = im.getWidth(null);
                    int h = im.getHeight(null);
                    buf[i] = new BufferedImage(w, h, 1);
                    Graphics2D g = buf[i].createGraphics();
                    g.drawImage(im, 0, 0, null);
                    g.dispose();
                }
                this.size.width = Math.max(this.size.width, buf[i].getWidth());
                this.size.height = Math.max(this.size.height, buf[i].getHeight());
                ++i;
            }
            Image[] newArray = new Image[len + n];
            System.arraycopy(this.images, 0, newArray, 0, index);
            System.arraycopy(buf, 0, newArray, index, n);
            System.arraycopy(this.images, index, newArray, index + n, len - index);
            this.images = newArray;
        }
        if (imagePaths == null) {
            imagePaths = new String[newImages.length];
            int i = 0;
            while (i < imagePaths.length) {
                imagePaths[i] = "";
                ++i;
            }
        }
        n = imagePaths.length;
        String[] newPaths = new String[len + n];
        System.arraycopy(this.paths, 0, newPaths, 0, index);
        System.arraycopy(imagePaths, 0, newPaths, index, n);
        System.arraycopy(this.paths, index, newPaths, index + n, len - index);
        this.paths = newPaths;
        this.rawImage = this.getImageAtFrame(index, this.rawImage);
        this.setFrameCount(this.length());
        this.endFrameNumber = this.frameCount - 1;
        if (this.coords == null) {
            this.size.width = this.rawImage.getWidth(this.observer);
            this.size.height = this.rawImage.getHeight(this.observer);
            this.refreshBufferedImage();
            this.coords = new ImageCoordSystem(this.frameCount, this);
            this.aspects = new DoubleArray(this.frameCount, 1.0);
        } else {
            this.size.width = Math.max(this.size.width, this.rawImage.getWidth(this.observer));
            this.size.height = Math.max(this.size.height, this.rawImage.getHeight(this.observer));
            this.coords.setLength(this.frameCount);
            this.aspects.setLength(this.frameCount);
        }
    }

    @Override
    protected void updateBufferedImage() {
        this.refreshBufferedImage();
        if (!this.isValidImage) {
            this.isValidImage = true;
            Graphics2D g = this.bufferedImage.createGraphics();
            if (this.rawImage.getWidth(null) < this.bufferedImage.getWidth() || this.rawImage.getHeight(null) < this.bufferedImage.getHeight()) {
                g.setColor(new Color(255, 255, 255, 255));
                g.fillRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
                this.rgbSize.width = this.rawImage.getWidth(null);
                this.rgbSize.height = this.rawImage.getHeight(null);
            } else {
                this.rgbSize.width = this.bufferedImage.getWidth();
                this.rgbSize.height = this.bufferedImage.getHeight();
            }
            g.drawImage(this.rawImage, 0, 0, null);
            g.dispose();
        }
    }

    @Override
    public BufferedImage getImage() {
        this.updateBufferedImage();
        if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
            return this.bufferedImage;
        }
        if (!this.isValidFilteredImage) {
            this.isValidFilteredImage = true;
            if (this.rgbSize.width == this.bufferedImage.getWidth() && this.rgbSize.height == this.bufferedImage.getHeight()) {
                this.filteredImage = this.filterStack.getFilteredImage(this.bufferedImage);
            } else {
                if (this.rgbImage == null || this.rgbImage.getWidth() != this.rgbSize.width || this.rgbImage.getHeight() != this.rgbSize.height) {
                    this.rgbImage = new BufferedImage(this.rgbSize.width, this.rgbSize.height, 1);
                }
                Graphics2D g = this.rgbImage.createGraphics();
                g.drawImage(this.rawImage, 0, 0, null);
                this.rgbImage = this.filterStack.getFilteredImage(this.rgbImage);
                if (this.filteredImage == null || this.filteredImage.getWidth() != this.bufferedImage.getWidth() || this.filteredImage.getHeight() != this.bufferedImage.getHeight()) {
                    this.filteredImage = new BufferedImage(this.size.width, this.size.height, 1);
                }
                g = this.filteredImage.createGraphics();
                g.setColor(new Color(255, 255, 255, 255));
                g.fillRect(0, 0, this.filteredImage.getWidth(), this.filteredImage.getHeight());
                g.drawImage((Image)this.rgbImage, 0, 0, null);
            }
        }
        return this.filteredImage;
    }

    public static String getNextImagePathInSequence(String imagePath) {
        String ext = XML.getExtension(imagePath);
        ext = ext == null ? "" : "." + ext;
        String raw = XML.stripExtension(imagePath);
        int len = raw.length();
        if (len == 0) {
            return imagePath;
        }
        if (Character.isDigit(raw.charAt(len - 1))) {
            int i = Integer.parseInt(raw.substring(len - 1));
            if (i < 9) {
                return String.valueOf(raw.substring(0, len - 1)) + ++i + ext;
            }
            String sub = ImageVideo.getNextImagePathInSequence(raw.substring(0, len - 1));
            return String.valueOf(sub) + "0" + ext;
        }
        return imagePath;
    }

    public static ArrayList<String> getStackPaths(String imagePath) {
        String extension = "";
        int i = imagePath.lastIndexOf(46);
        if (i > 0 && i < imagePath.length() - 1) {
            extension = imagePath.substring(i).toLowerCase();
            imagePath = imagePath.substring(0, i);
        }
        int len = imagePath.length();
        int digits = 0;
        while (digits <= 4 && --len >= 0 && Character.isDigit(imagePath.charAt(len))) {
            ++digits;
        }
        ArrayList<String> imagePaths = new ArrayList<String>();
        switch (digits) {
            case 0: {
                imagePaths.add(String.valueOf(imagePath) + extension);
                return imagePaths;
            }
        }
        int limit = (int)Math.pow(10.0, digits);
        String root = imagePath.substring(0, ++len);
        int n = Integer.parseInt(imagePath.substring(len));
        try {
            imagePaths.add(String.valueOf(imagePath) + extension);
            while (n++ < limit) {
                String num = "000" + n;
                imagePath = String.valueOf(root) + num.substring(num.length() - digits) + extension;
                imagePaths.add(imagePath);
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        if (imagePaths.size() > 1) {
            imagePaths.remove(imagePaths.size() - 1);
        }
        return imagePaths;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    public String getTypeName() {
        return "Image";
    }

    public String toString() {
        return String.valueOf(this.getTypeName()) + " " + this.frameCount;
    }

    @Override
    protected void setStartTimes() {
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ImageVideo video2 = (ImageVideo)obj;
            String vidBase = video2.baseDir;
            String trkBase = (String)video2.getProperty("base");
            if (trkBase == null) {
                trkBase = vidBase;
            }
            String[] paths = video2.getValidPathsRelativeTo(trkBase);
            String path = null;
            if (vidBase != null && vidBase.endsWith("zip!")) {
                String s = vidBase.substring(0, vidBase.indexOf("!"));
                path = s = XML.getPathRelativeTo(s, trkBase);
            } else if (paths.length > 0) {
                path = paths[0];
            }
            if (paths.length > 0) {
                control.setValue("paths", paths);
                control.setValue("path", path);
                control.setBasepath(trkBase);
            }
            if (!video2.filterStack.isEmpty()) {
                control.setValue("filters", video2.filterStack.getFilters());
            }
            control.setValue("delta_t", video2.deltaT);
        }

        @Override
        public Object createObject(XMLControl control) {
            boolean[] sequences;
            String[] paths = (String[])control.getObject("paths");
            if (paths == null) {
                try {
                    String path = control.getString("path");
                    if (path != null) {
                        String basepath = control.getBasepath();
                        if (OSPRuntime.checkTempDirCache && basepath == null) {
                            path = String.valueOf(OSPRuntime.tempDir) + path;
                        }
                        boolean known = control.getPropertyNamesRaw().contains("sequence");
                        boolean seq = control.getBoolean("sequence") || !known;
                        return new ImageVideo(path, basepath, seq);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if ((sequences = (boolean[])control.getObject("sequences")) != null && paths != null) {
                try {
                    ImageVideo vid = new ImageVideo(paths[0], null, sequences[0]);
                    int i = 1;
                    while (i < paths.length) {
                        vid.append(paths[i], sequences[i]);
                        ++i;
                    }
                    return vid;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if (paths == null || paths.length == 0) {
                return null;
            }
            ImageVideo vid = null;
            boolean sequenceLoaded = false;
            if (control.getPropertyNamesRaw().contains("absolutePath")) {
                try {
                    String path = control.getString("absolutePath");
                    if (VideoIO.zipFileFilter.accept(new File(path))) {
                        String[] imagePaths = VideoIO.getZippedImagePaths(path);
                        if (imagePaths != null && imagePaths.length > 0) {
                            vid = new ImageVideo(imagePaths[0], null, true);
                            sequenceLoaded = true;
                        }
                    } else {
                        vid = new ImageVideo(path, null, false);
                    }
                }
                catch (Exception path) {
                    // empty catch block
                }
            }
            ArrayList<String> badPaths = null;
            int i = 0;
            while (i < paths.length) {
                if (paths[i].toLowerCase().endsWith(".zip") || paths[i].toLowerCase().contains(".zip!")) break;
                try {
                    if (vid == null) {
                        vid = new ImageVideo(paths[i], control.getBasepath(), false);
                    } else if (!sequenceLoaded) {
                        vid.append(paths[i], false);
                    }
                }
                catch (Exception ex) {
                    if (badPaths == null) {
                        badPaths = new ArrayList<String>();
                    }
                    badPaths.add("\"" + paths[i] + "\"");
                }
                ++i;
            }
            if (vid == null) {
                try {
                    String path = control.getString("path");
                    if (path != null && !path.toLowerCase().endsWith(".zip") && !path.toLowerCase().contains(".zip!")) {
                        if (OSPRuntime.checkTempDirCache) {
                            path = String.valueOf(OSPRuntime.tempDir) + path;
                        }
                        return new ImageVideo(path, null, true);
                    }
                }
                catch (IOException path) {
                    // empty catch block
                }
            }
            if (vid == null && badPaths != null) {
                String s = (String)badPaths.get(0);
                int len = s.length();
                int i2 = 1;
                while (i2 < badPaths.size()) {
                    s = String.valueOf(s) + ", " + (String)badPaths.get(i2);
                    ++i2;
                }
                int maxLen = len + 100;
                if (s.length() > maxLen) {
                    s = String.valueOf(s.substring(0, len)) + " ...";
                }
                JOptionPane.showMessageDialog(null, String.valueOf(MediaRes.getString("ImageVideo.Dialog.MissingImages.Message")) + ":\n" + s, MediaRes.getString("ImageVideo.Dialog.MissingImages.Title"), 2);
            }
            if (vid == null) {
                return null;
            }
            vid.rawImage = vid.images[0];
            vid.filterStack.addFilters((Collection)control.getObject("filters"));
            String path = paths[0];
            String ext = XML.getExtension(path);
            VideoType type = VideoIO.getVideoType("Image", ext);
            if (type != null) {
                vid.setProperty("video_type", type);
            }
            vid.deltaT = control.getDouble("delta_t");
            return vid;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            return obj;
        }
    }
}

