/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;

public class ImageVideoType
implements VideoType {
    private VideoFileFilter[] fileFilters;

    public ImageVideoType() {
    }

    public ImageVideoType(VideoFileFilter filter) {
        this();
        if (filter != null) {
            this.fileFilters = new VideoFileFilter[]{filter};
        }
    }

    public Video getVideo(File file) {
        try {
            ImageVideo video2 = new ImageVideo(file.getAbsolutePath(), null, true);
            video2.setProperty("video_type", this);
            return video2;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Video getVideo(String name, String basePath, XMLControl control) {
        boolean baseInvalid;
        ImageVideo video2 = null;
        if (control == null) {
            String xmlName = String.valueOf(XML.stripExtension(basePath == null ? name : String.valueOf(basePath) + File.separator + name)) + ".xml";
            control = new XMLControlElement(new File(xmlName));
        }
        control.setBasepath(basePath == null ? XML.getDirectoryPath(name) : basePath);
        if (!control.failedToRead() && control.getObjectClass() == ImageVideo.class) {
            try {
                video2 = (ImageVideo)control.loadObject(null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (video2 == null) {
            try {
                video2 = new ImageVideo(name, basePath, true);
                video2.setProperty("video_type", this);
            }
            catch (IOException ex) {
                // empty catch block
            }
            return video2;
        }
        String[] paths = video2.getValidPaths();
        String absolutePath = (String)video2.getProperty("absolutePath");
        boolean absInvalid = absolutePath == null || !absolutePath.startsWith("/") && absolutePath.indexOf(":") == -1;
        String theName = (String)video2.getProperty("name");
        if (theName == null) {
            theName = name;
        }
        if (absInvalid) {
            video2.setProperty("absolutePath", XML.getResolvedPath(theName, basePath));
        }
        boolean bl = baseInvalid = video2.baseDir == null || !video2.baseDir.startsWith("/") && video2.baseDir.indexOf(":") == -1;
        if (baseInvalid && basePath != null && paths.length > 0) {
            absolutePath = (String)video2.getProperty("absolutePath");
            int n = absolutePath.indexOf(paths[0]);
            video2.baseDir = n > -1 ? absolutePath.substring(0, n) : basePath;
        }
        return video2;
    }

    @Override
    public VideoRecorder getRecorder() {
        return new ImageVideoRecorder(this);
    }

    @Override
    public boolean canRecord() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.getFileFilters()[0].getDescription();
    }

    @Override
    public String getDefaultExtension() {
        return this.getFileFilters()[0].getDefaultExtension();
    }

    @Override
    public VideoFileFilter[] getFileFilters() {
        if (this.fileFilters == null) {
            ArrayList<VideoType> types = VideoIO.getVideoTypes(true);
            ArrayList<VideoFileFilter> filters = new ArrayList<VideoFileFilter>();
            for (VideoType next : types) {
                if (!(next instanceof ImageVideoType) || next == this) continue;
                ImageVideoType imageType = (ImageVideoType)next;
                filters.add(imageType.getDefaultFileFilter());
            }
            this.fileFilters = filters.toArray(new VideoFileFilter[filters.size()]);
        }
        return this.fileFilters;
    }

    @Override
    public VideoFileFilter getDefaultFileFilter() {
        return this.getFileFilters()[0];
    }

    @Override
    public boolean isType(Video video2) {
        return video2 instanceof ImageVideo;
    }

    @Override
    public String getTypeName() {
        return "Image";
    }

    public String toString() {
        return this._toString();
    }
}

