/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Toolkit;
import org.opensourcephysics.media.core.NumberField;

public class IntegerField
extends NumberField {
    public IntegerField(int columns) {
        super(columns, 4, true);
        super.setParseIntegerOnly();
        this.setIntValue((int)this.prevValue);
    }

    public int getIntValue() {
        int retValue;
        String s = this.getText().trim();
        if (this.units != null && !this.units.equals("")) {
            int n = s.indexOf(this.units);
            while (n > -1) {
                s = s.substring(0, n);
                n = s.indexOf(this.units);
            }
        }
        if (s.equals(this.nf.format(this.prevValue))) {
            return (int)this.prevValue;
        }
        try {
            retValue = Integer.parseInt(s);
            if (this.minValue != null && retValue < this.minValue.intValue()) {
                this.setIntValue(this.minValue.intValue());
                return this.minValue.intValue();
            }
            if (this.maxValue != null && retValue > this.maxValue.intValue()) {
                this.setIntValue(this.maxValue.intValue());
                return this.maxValue.intValue();
            }
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
            this.setIntValue((int)this.prevValue);
            return (int)this.prevValue;
        }
        return retValue;
    }

    public void setIntValue(int value) {
        if (this.minValue != null) {
            value = Math.max(value, this.minValue.intValue());
        }
        if (this.maxValue != null) {
            value = Math.min(value, this.maxValue.intValue());
        }
        String s = this.nf.format(value);
        if (this.units != null) {
            s = String.valueOf(s) + this.units;
        }
        if (!s.equals(this.getText())) {
            this.setText(s);
        }
        this.prevValue = value;
    }
}

