/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;

public class LogFilter
extends Filter {
    private int level = Integer.MAX_VALUE;
    private int[] lookup = new int[256];
    private boolean grayscale;
    private Inspector inspector;
    private JLabel levelLabel;
    private JLabel highlightLabel;
    private JLabel shadowLabel;
    private IntegerField field;
    private JSlider slider;
    private JCheckBox grayCheckbox;
    static final float[] hsb = new float[3];

    public LogFilter() {
        this.hasInspector = true;
        this.setLevel(0);
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.levelLabel.setText(MediaRes.getString("Filter.Log.Label.Level"));
        this.highlightLabel.setText(MediaRes.getString("Filter.Log.Label.Highlights"));
        this.shadowLabel.setText(MediaRes.getString("Filter.Log.Label.Shadows"));
        this.slider.setToolTipText(MediaRes.getString("Filter.Log.ToolTip.Level"));
        this.field.setToolTipText(MediaRes.getString("Filter.Log.ToolTip.Level"));
        this.grayCheckbox.setText(MediaRes.getString("Filter.Log.Checkbox.Grayscale"));
        this.field.setEnabled(this.isEnabled());
        this.slider.setEnabled(this.isEnabled());
        this.grayCheckbox.setEnabled(this.isEnabled());
        this.grayCheckbox.setSelected(this.grayscale);
        this.inspector.setTitle(MediaRes.getString("Filter.Log.Title"));
        this.inspector.pack();
    }

    @Override
    protected void initializeSubclass() {
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int i = 0;
        while (i < this.nPixelsIn) {
            int gray;
            int pixel = this.pixelsIn[i];
            int r = pixel >> 16 & 0xFF;
            int g = pixel >> 8 & 0xFF;
            int b = pixel & 0xFF;
            if (this.grayscale) {
                gray = LogFilter.getGray(r, g, b);
                gray = this.lookup[gray];
                this.pixelsOut[i] = gray << 16 | gray << 8 | gray;
            } else {
                Color.RGBtoHSB(r, g, b, hsb);
                gray = (int)(hsb[2] * 255.0f);
                gray = this.lookup[gray];
                this.pixelsOut[i] = Color.HSBtoRGB(hsb[0], hsb[1], (float)((double)gray / 255.0));
            }
            ++i;
        }
    }

    private static final int getGray(int r, int g, int b) {
        return (r + g + b) / 3;
    }

    private void setLevelOrig(int level) {
        if (level != 0 && this.level == level) {
            return;
        }
        this.level = level;
        double lim = Math.abs(0.01 * (double)level);
        double a = Math.min(1.0, 5.0 * lim);
        lim = a * Math.exp(6.0 * lim);
        double b = lim / Math.log10(lim + 1.0);
        double c = level == 0 ? 1.0 : 255.0 / lim;
        int i = 0;
        while (i < 256) {
            this.lookup[i] = level == 0 ? i : (int)Math.round(c * b * Math.log10(1.0 + (double)i / c));
            ++i;
        }
        if (level < 0) {
            int[] newLookup = new int[256];
            int i2 = 0;
            while (i2 < 256) {
                newLookup[i2] = 255 - this.lookup[255 - i2];
                ++i2;
            }
            this.lookup = newLookup;
        }
        this.firePropertyChange("level", null, null);
    }

    private void setLevel(int level) {
        if (this.level == level) {
            return;
        }
        this.level = level;
        if (level == 0) {
            int i = 0;
            while (i < 256) {
                this.lookup[i] = i;
                ++i;
            }
            return;
        }
        double lim = Math.abs(0.01 * (double)level);
        lim = Math.min(1.0, 5.0 * lim) * Math.exp(6.0 * lim);
        double c = 255.0 / lim;
        double bc = 255.0 / Math.log10(lim + 1.0);
        if (level > 0) {
            int i = 0;
            while (i < 256) {
                this.lookup[i] = (int)Math.round(bc * Math.log10(1.0 + (double)i / c));
                ++i;
            }
        } else {
            int i = 0;
            while (i < 256) {
                this.lookup[i] = 255 - (int)Math.round(bc * Math.log10(1.0 + (double)(255 - i) / c));
                ++i;
            }
        }
        this.firePropertyChange("level", null, null);
    }

    private int getLevel() {
        return this.level;
    }

    private void setGrayscale(boolean gray) {
        if (this.grayscale == gray) {
            return;
        }
        this.grayscale = gray;
        this.firePropertyChange("grayscale", null, null);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public static void main(String[] args) {
        int i = -100;
        while (i <= 100) {
            LogFilter f = new LogFilter();
            f.setLevelOrig(i);
            int[] l = f.lookup;
            f = new LogFilter();
            f.setLevel(i);
            if (!Arrays.equals(l, f.lookup)) {
                System.out.println(Arrays.toString(l));
                System.out.println(Arrays.toString(f.lookup));
                throw new NumberFormatException("oops");
            }
            ++i;
        }
        System.out.println("OK");
    }

    private class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super("Filter.GrayScale.Title");
        }

        @Override
        void createGUI() {
            LogFilter.this.levelLabel = new JLabel();
            LogFilter.this.levelLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            LogFilter.this.highlightLabel = new JLabel();
            LogFilter.this.highlightLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            LogFilter.this.shadowLabel = new JLabel();
            LogFilter.this.shadowLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
            LogFilter.this.field = new IntegerField(3);
            LogFilter.this.field.setMaxValue(100.0);
            LogFilter.this.field.setMinValue(-100.0);
            LogFilter.this.field.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogFilter.this.setLevel(LogFilter.this.field.getIntValue());
                    Inspector.this.updateDisplay();
                    LogFilter.this.field.selectAll();
                }
            });
            LogFilter.this.field.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    LogFilter.this.field.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    LogFilter.this.setLevel(LogFilter.this.field.getIntValue());
                    Inspector.this.updateDisplay();
                }
            });
            LogFilter.this.slider = new JSlider(0, 0, 0);
            LogFilter.this.slider.setMaximum(100);
            LogFilter.this.slider.setMinimum(-100);
            LogFilter.this.slider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            LogFilter.this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = LogFilter.this.slider.getValue();
                    if (i != LogFilter.this.getLevel()) {
                        LogFilter.this.setLevel(i);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            LogFilter.this.grayCheckbox = new JCheckBox();
            LogFilter.this.grayCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogFilter.this.setGrayscale(LogFilter.this.grayCheckbox.isSelected());
                }
            });
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            JPanel panel = new JPanel();
            panel.add(LogFilter.this.highlightLabel);
            panel.add(LogFilter.this.slider);
            panel.add(LogFilter.this.shadowLabel);
            contentPane.add((Component)panel, "North");
            panel = new JPanel();
            panel.add(LogFilter.this.levelLabel);
            panel.add(LogFilter.this.field);
            panel.add(LogFilter.this.grayCheckbox);
            contentPane.add((Component)panel, "Center");
            JPanel buttonbar = new JPanel();
            buttonbar.add(LogFilter.this.ableButton);
            buttonbar.add(LogFilter.this.closeButton);
            contentPane.add((Component)buttonbar, "South");
        }

        void initialize() {
            LogFilter.this.refresh();
            this.updateDisplay();
        }

        void updateDisplay() {
            LogFilter.this.field.setIntValue(LogFilter.this.getLevel());
            LogFilter.this.slider.setValue(LogFilter.this.getLevel());
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            LogFilter filter = (LogFilter)obj;
            control.setValue("level", filter.getLevel());
            control.setValue("grayscale", filter.grayscale);
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new LogFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            LogFilter filter = (LogFilter)obj;
            if (control.getPropertyNamesRaw().contains("level")) {
                filter.setLevel(control.getInt("level"));
            }
            filter.grayscale = control.getBoolean("grayscale");
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

