/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opensourcephysics.display.OSPRuntime;

public class NumberField
extends JTextField {
    public static final Color DISABLED_COLOR = new Color(120, 120, 120);
    public static final String INTEGER_PATTERN = "0";
    public static final String DECIMAL_1_PATTERN = "0.0";
    public static final String DECIMAL_2_PATTERN = "0.00";
    public static final String DECIMAL_3_PATTERN = "0.000";
    protected double prevValue;
    protected Double maxValue;
    protected Double minValue;
    protected String units;
    protected double conversionFactor = 1.0;
    protected NumberFormatter nf;

    public NumberField(int columns) {
        this(columns, 4, false);
    }

    public NumberField(int columns, int sigfigs) {
        this(columns, sigfigs, false);
    }

    public NumberField(int columns, int sigfigs, boolean fixed) {
        super(columns);
        this.nf = new NumberFormatter(fixed);
        this.setBackground(Color.white);
        this.setDisabledTextColor(DISABLED_COLOR);
        this.setText(INTEGER_PATTERN);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!NumberField.this.isEditable()) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    Runnable runner = new Runnable(){

                        @Override
                        public synchronized void run() {
                            NumberField.this.setBackground(Color.white);
                            NumberField.this.setValue(NumberField.this.getValue());
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                } else {
                    NumberField.this.setBackground(Color.yellow);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!NumberField.this.isEditable()) {
                    return;
                }
                Runnable runner = new Runnable(){

                    @Override
                    public synchronized void run() {
                        NumberField.this.setBackground(Color.white);
                        NumberField.this.setValue(NumberField.this.getValue());
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!NumberField.this.isEditable()) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    NumberField.this.selectAll();
                }
            }
        });
        this.nf.setSigFigs(sigfigs);
    }

    public double getValue() {
        double retValue;
        int n;
        String s = this.getText().trim().toUpperCase();
        if (s.length() == 0) {
            return this.prevValue;
        }
        if (this.units != null && !this.units.equals("") && (n = s.indexOf(this.units.toUpperCase())) > 0) {
            s = s.substring(0, n);
        }
        if (s.equals(this.nf.format(this.prevValue * this.conversionFactor))) {
            return this.prevValue;
        }
        try {
            double d = retValue = s.equals(INTEGER_PATTERN) ? 0.0 : this.nf.parse(s).doubleValue() / this.conversionFactor;
            if (this.minValue != null && retValue < this.minValue) {
                this.setValue(this.minValue);
                return this.minValue;
            }
            if (this.maxValue != null && retValue > this.maxValue) {
                this.setValue(this.maxValue);
                return this.maxValue;
            }
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            this.setValue(this.prevValue);
            return this.prevValue;
        }
        return retValue;
    }

    public final String format(double d) {
        return this.nf.format(d);
    }

    public void setValue(double value) {
        if (!this.isVisible()) {
            return;
        }
        if (this.minValue != null) {
            value = Math.max(value, this.minValue);
        }
        if (this.maxValue != null) {
            value = Math.min(value, this.maxValue);
        }
        this.prevValue = value;
        String s = this.nf.getText(this.conversionFactor * value);
        if (this.units != null) {
            s = String.valueOf(s) + this.units;
        }
        if (!s.equals(this.getText())) {
            this.setText(s);
        }
    }

    public void setExpectedRange(double lower, double upper) {
        this.nf.setExpectedRange(lower, upper);
    }

    public void setSigFigs(int sigfigs) {
        this.nf.setSigFigs(sigfigs);
    }

    public void setMinValue(double min) {
        this.minValue = Double.isNaN(min) ? null : Double.valueOf(min);
    }

    public void setMaxValue(double max) {
        this.maxValue = Double.isNaN(max) ? null : Double.valueOf(max);
    }

    public void setUnits(String units) {
        double val = this.getValue();
        this.units = units;
        this.setValue(val);
    }

    public String getUnits() {
        return this.units;
    }

    public void setConversionFactor(double factor) {
        this.conversionFactor = factor;
        this.setValue(this.prevValue);
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public void applyPattern(String p) {
        this.nf.applyPattern(p);
    }

    public void setPatterns(String[] patterns) {
        this.setPatterns(patterns, new double[]{0.1, 10.0, 100.0, 1000.0});
    }

    public void setPatterns(String[] patterns, double[] limits) {
        this.nf.setPatterns(patterns, limits);
    }

    public void setFixedPattern(String pattern) {
        this.nf.setFixedPattern(pattern, this.getValue());
        this.setValue(this.prevValue);
    }

    public String getFixedPattern() {
        return this.nf.userPattern;
    }

    public void setParseIntegerOnly() {
        this.nf.setParseIntegerOnly();
    }

    public void setFormatFor(double d) {
        this.nf.setFormatFor(d);
    }

    public void refreshDecimalSeparators(boolean redraw) {
        if (this.nf.format != null) {
            this.nf.format.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        }
        if (redraw) {
            this.setValue(this.getValue());
        }
    }

    public static class NumberFormatter {
        private DecimalFormat format;
        char decimalSeparator;
        private String[] patterns = new String[5];
        private double[] ranges = new double[]{0.1, 10.0, 100.0, 1000.0};
        protected String currentPattern;
        private final Map<String, DecimalFormat> formatCache = new Hashtable<String, DecimalFormat>();
        private boolean isIntegerOnly;
        private boolean fixedPattern;
        private boolean fixedPatternByDefault;
        int sigfigs;
        String userPattern = "";

        public NumberFormatter(boolean fixed) {
            this.fixedPattern = this.fixedPatternByDefault = fixed;
        }

        public void setSigFigs(int sigfigs) {
            if (this.sigfigs == sigfigs) {
                return;
            }
            this.ranges = new double[]{0.1, 10.0, 100.0, 1000.0};
            sigfigs = Math.max(sigfigs, 2);
            this.sigfigs = Math.min(sigfigs, 6);
            char d = '.';
            if (sigfigs == 2) {
                this.patterns[0] = NumberField.INTEGER_PATTERN + d + "0E0";
                this.patterns[1] = NumberField.INTEGER_PATTERN + d + NumberField.INTEGER_PATTERN;
                this.patterns[2] = NumberField.INTEGER_PATTERN;
                this.patterns[3] = NumberField.INTEGER_PATTERN + d + "0E0";
                this.patterns[4] = NumberField.INTEGER_PATTERN + d + "0E0";
            } else if (sigfigs == 3) {
                this.patterns[0] = NumberField.INTEGER_PATTERN + d + "00E0";
                this.patterns[1] = NumberField.INTEGER_PATTERN + d + "00";
                this.patterns[2] = NumberField.INTEGER_PATTERN + d + NumberField.INTEGER_PATTERN;
                this.patterns[3] = NumberField.INTEGER_PATTERN;
                this.patterns[4] = NumberField.INTEGER_PATTERN + d + "00E0";
            } else if (sigfigs >= 4) {
                this.patterns[0] = NumberField.INTEGER_PATTERN + d + "000E0";
                this.patterns[1] = NumberField.INTEGER_PATTERN + d + "000";
                this.patterns[2] = NumberField.INTEGER_PATTERN + d + "00";
                this.patterns[3] = NumberField.INTEGER_PATTERN + d + NumberField.INTEGER_PATTERN;
                this.patterns[4] = NumberField.INTEGER_PATTERN + d + "000E0";
                int n = sigfigs - 4;
                int i = 0;
                while (i < n) {
                    int j = 0;
                    while (j < this.patterns.length) {
                        this.patterns[j] = NumberField.INTEGER_PATTERN + d + NumberField.INTEGER_PATTERN + this.patterns[j].substring(2);
                        ++j;
                    }
                    ++i;
                }
            }
        }

        public void setFormatFor(double value) {
            if (this.fixedPattern) {
                return;
            }
            value = Math.abs(value);
            String p = null;
            p = value == 0.0 ? (this.sigfigs == 1 ? NumberField.INTEGER_PATTERN : (this.sigfigs == 2 ? NumberField.DECIMAL_1_PATTERN : (this.sigfigs == 3 ? NumberField.DECIMAL_2_PATTERN : NumberField.DECIMAL_3_PATTERN))) : (value < this.ranges[0] ? this.patterns[0] : (value < this.ranges[1] ? this.patterns[1] : (value < this.ranges[2] ? this.patterns[2] : (value < this.ranges[3] ? this.patterns[3] : this.patterns[4]))));
            this.applyPattern(p);
        }

        public String getText(double d) {
            this.setFormatFor(d);
            return this.format(d);
        }

        public String format(double d) {
            String s;
            if (Double.isNaN(d)) {
                return "";
            }
            if (d == 0.0) {
                d = 0.0;
            }
            if (this.decimalSeparator != OSPRuntime.getCurrentDecimalSeparator()) {
                this.decimalSeparator = OSPRuntime.getCurrentDecimalSeparator();
                this.formatCache.clear();
            }
            if (this.currentPattern == null) {
                this.setFormatFor(d);
            }
            int i = 0;
            int f = 0;
            switch (this.currentPattern) {
                case "0": {
                    return "" + (int)d;
                }
                case "0.0": {
                    f = 10;
                    i = 1;
                    break;
                }
                case "0.00": {
                    f = 100;
                    i = 2;
                    break;
                }
                case "0.000": {
                    f = 1000;
                    i = 3;
                }
            }
            if (i == 0) {
                s = this.format.format(d);
            } else if (d == 0.0) {
                s = this.currentPattern;
            } else {
                String neg = d < 0.0 ? "-" : "";
                s = "" + Math.round(Math.abs(d) * (double)f);
                int j = s.length() - i;
                if (j < 1) {
                    i = 1;
                    s = String.valueOf("000".substring(0, 1 - j)) + s;
                } else {
                    i = j;
                }
                s = String.valueOf(neg) + s.substring(0, i) + this.decimalSeparator + s.substring(i);
            }
            s = s.replace(".", String.valueOf(this.decimalSeparator));
            return s;
        }

        Number parse(String s) throws ParseException {
            if (this.format == null) {
                String p = this.currentPattern;
                this.applyPattern("0E0");
                this.applyPattern(p);
            }
            return this.format.parse(s);
        }

        public void applyPattern(String p) {
            block16: {
                if (p == this.currentPattern) break block16;
                if (this.decimalSeparator != OSPRuntime.getCurrentDecimalSeparator()) {
                    this.decimalSeparator = OSPRuntime.getCurrentDecimalSeparator();
                    this.formatCache.clear();
                }
                this.currentPattern = p;
                switch (p) {
                    case "0": 
                    case "0.0": 
                    case "0.00": 
                    case "0.000": {
                        return;
                    }
                }
                this.format = this.formatCache.get(p);
                if (this.format == null) {
                    this.format = (DecimalFormat)NumberFormat.getInstance();
                    this.formatCache.put(p, this.format);
                    this.format.applyPattern(p);
                    this.format.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
                    if (this.isIntegerOnly) {
                        this.format.setParseIntegerOnly(true);
                    }
                }
            }
        }

        public void setExpectedRange(double lower, double upper) {
            this.fixedPatternByDefault = true;
            this.fixedPattern = true;
            double range = Math.max(Math.abs(lower), Math.abs(upper));
            if (range < 0.1 || range >= 1000.0) {
                String s = "";
                int i = 0;
                while (i < this.sigfigs - 1) {
                    s = String.valueOf(s) + NumberField.INTEGER_PATTERN;
                    ++i;
                }
                this.applyPattern("0." + s + "E0");
            } else {
                int n = range < 1.0 ? this.sigfigs : (range < 10.0 ? this.sigfigs - 1 : (range < 100.0 ? this.sigfigs - 2 : this.sigfigs - 3));
                String s = "";
                int i = 0;
                while (i < n) {
                    s = String.valueOf(s) + NumberField.INTEGER_PATTERN;
                    ++i;
                }
                if (s.equals("")) {
                    this.applyPattern(NumberField.INTEGER_PATTERN);
                } else {
                    this.applyPattern("0." + s);
                }
            }
        }

        public void setPatterns(String[] patterns, double[] ranges) {
            if (patterns.length > 4 && ranges.length > 3) {
                this.patterns = patterns;
                this.ranges = ranges;
            }
        }

        public void setFixedPattern(String pattern, double value) {
            if (pattern == null) {
                pattern = "";
            }
            if ((pattern = pattern.trim()).equals(this.userPattern)) {
                return;
            }
            this.userPattern = pattern;
            this.currentPattern = null;
            if (this.userPattern.equals("")) {
                this.fixedPattern = this.fixedPatternByDefault;
                this.setFormatFor(value);
            } else {
                this.fixedPattern = true;
                this.applyPattern(this.userPattern);
            }
        }

        public void setParseIntegerOnly() {
            this.isIntegerOnly = true;
            this.applyPattern(NumberField.INTEGER_PATTERN);
        }
    }
}

