/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

public class PerspectiveFilter
extends Filter
implements PropertyChangeListener {
    public static final String PROPERTY_PERSPECTIVEFILTER_CORNERLOCATION = "cornerlocation";
    public static final String PROPERTY_PERSPECTIVEFILTER_FIXED = "fixed";
    public static final String PROPERTY_PERSPECTIVEFILTER_PERSPECTIVE = "perspective";
    private static Color defaultColor = Color.RED;
    private double[][] matrix = new double[3][3];
    private double[][] temp1 = new double[3][3];
    private double[][] temp2 = new double[3][3];
    private double[] xOut;
    private double[] yOut;
    private double[] xIn;
    private double[] yIn;
    private int interpolation = 2;
    private Quadrilateral quad;
    private QuadEditor inputEditor;
    private QuadEditor outputEditor;
    private Point2D.Double[][] inCornerPoints = new Point2D.Double[10][];
    private Point2D.Double[][] outCornerPoints = new Point2D.Double[10][];
    private TreeSet<Integer> inKeyFrames = new TreeSet();
    private TreeSet<Integer> outKeyFrames = new TreeSet();
    private boolean fixedIn = false;
    private boolean fixedOut = true;
    private int fixedKey = 0;
    private Inspector inspector;
    private boolean disposing = false;
    private int[] rgb = new int[4];
    private int[] values = new int[4];

    public PerspectiveFilter() {
        this.quad = new Quadrilateral();
        this.refresh();
        this.hasInspector = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "nextframe": {
                this.refreshCorners((Integer)e.getNewValue());
            }
        }
    }

    @Override
    public boolean isEnabled() {
        boolean editingInput;
        boolean disabled = !this.superIsEnabled();
        boolean bl = editingInput = this.inspector != null && this.inspector.isVisible() && this.inspector.tabbedPane.getSelectedComponent() == this.inputEditor;
        return !disabled && !editingInput;
    }

    public boolean isSuperEnabled() {
        return super.isEnabled();
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.inspector.setTitle(MediaRes.getString("Filter.Perspective.Title"));
        this.inspector.tabbedPane.setTitleAt(0, MediaRes.getString("PerspectiveFilter.Tab.Input"));
        this.inspector.tabbedPane.setTitleAt(1, MediaRes.getString("PerspectiveFilter.Tab.Output"));
        this.inspector.helpButton.setText(MediaRes.getString("PerspectiveFilter.Button.Help"));
        this.inspector.colorButton.setText(MediaRes.getString("PerspectiveFilter.Button.Color"));
        this.ableButton.setText(super.isEnabled() ? MediaRes.getString("Filter.Button.Disable") : MediaRes.getString("Filter.Button.Enable"));
        this.inputEditor.refreshGUI();
        this.outputEditor.refreshGUI();
        this.inputEditor.refreshFields();
        this.outputEditor.refreshFields();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.vidPanel != null && this.vidPanel.getVideo() != null) {
            this.vidPanel.removePropertyChangeListener("selectedpoint", this.quad);
            Video video2 = this.vidPanel.getVideo();
            video2.removePropertyChangeListener("nextframe", this);
            this.removePropertyChangeListener("filter_visible", this.vidPanel);
        }
    }

    @Override
    public void setVideoPanel(VideoPanel panel) {
        VideoPanel prevPanel = this.vidPanel;
        super.setVideoPanel(panel);
        if (this.vidPanel != null) {
            Video video2 = this.vidPanel.getVideo();
            video2.removePropertyChangeListener("nextframe", this);
            video2.addPropertyChangeListener("nextframe", this);
            this.vidPanel.propertyChange(new PropertyChangeEvent(this, PROPERTY_PERSPECTIVEFILTER_PERSPECTIVE, null, this));
        } else if (prevPanel != null) {
            prevPanel.removeDrawable(this.quad);
            Video video3 = prevPanel.getVideo();
            video3.removePropertyChangeListener("nextframe", this);
            prevPanel.propertyChange(new PropertyChangeEvent(this, PROPERTY_PERSPECTIVEFILTER_PERSPECTIVE, this, null));
        }
    }

    public void setFixed(boolean fix, boolean in) {
        if (this.isFixed(in) != fix) {
            String filterState = new XMLControlElement(this).toXML();
            if (in) {
                this.fixedIn = fix;
            } else {
                this.fixedOut = fix;
            }
            if (this.isFixed(in)) {
                TreeSet<Integer> keyFrames = in ? this.inKeyFrames : this.outKeyFrames;
                keyFrames.clear();
                this.saveCorners(this.fixedKey, in);
            }
            this.firePropertyChange(PROPERTY_PERSPECTIVEFILTER_FIXED, filterState, null);
        }
    }

    public boolean isFixed(boolean in) {
        return in ? this.fixedIn : this.fixedOut;
    }

    public void setCornerLocation(int frameNumber, int cornerIndex, double x, double y) {
        boolean in = cornerIndex < 4;
        Corner[] corners = in ? this.quad.inCorners : this.quad.outCorners;
        corners[cornerIndex].setXY(x, y);
    }

    public Color getColor() {
        return this.quad.color;
    }

    public int getCornerIndex(Corner corner) {
        int i = 0;
        while (i < 4) {
            if (corner == this.quad.inCorners[i]) {
                return i;
            }
            if (corner == this.quad.outCorners[i]) {
                return i + 4;
            }
            ++i;
        }
        return -1;
    }

    public Corner getCorner(int index) {
        Corner[] corners = index < 4 ? this.quad.inCorners : this.quad.outCorners;
        return corners[index % 4];
    }

    public void deleteKeyFrame(int frameNumber, Corner corner) {
        int index = this.getCornerIndex(corner);
        if (index == -1) {
            return;
        }
        boolean isInput = index < 4;
        TreeSet<Integer> keyFrames = isInput ? this.inKeyFrames : this.outKeyFrames;
        int key = this.getKeyFrame(frameNumber, isInput);
        if (key == 0) {
            return;
        }
        keyFrames.remove(key);
        Point2D.Double[][] cornerPoints = index < 4 ? this.inCornerPoints : this.outCornerPoints;
        cornerPoints[key] = null;
        this.refreshCorners(this.vidPanel.getFrameNumber());
    }

    public void setInputEnabled(boolean enable) {
        if (this.inspector == null) {
            return;
        }
        this.inspector.tabbedPane.setSelectedComponent(enable ? this.inputEditor : this.outputEditor);
    }

    public boolean isInputEnabled() {
        if (this.inspector == null) {
            return false;
        }
        return this.inspector.tabbedPane.getSelectedComponent() == this.inputEditor;
    }

    public boolean isActive() {
        if (this.inspector == null) {
            return false;
        }
        return this.inspector.tabbedPane.isEnabled();
    }

    public boolean hasInspector() {
        return this.inspector != null;
    }

    @Override
    protected void initializeSubclass() {
        this.xIn = new double[this.nPixelsIn];
        this.yIn = new double[this.nPixelsIn];
        this.xOut = new double[this.nPixelsIn];
        this.yOut = new double[this.nPixelsIn];
        int j = 0;
        int p = 0;
        while (j < this.h) {
            int i = 0;
            while (i < this.w) {
                this.yOut[p] = j;
                this.xOut[p] = i;
                ++i;
                ++p;
            }
            ++j;
        }
        if (this.inKeyFrames.isEmpty()) {
            this.quad.inCorners[0].setLocation(this.w / 4, this.h / 4);
            this.quad.inCorners[1].setLocation(3 * this.w / 4, this.h / 4);
            this.quad.inCorners[2].setLocation(3 * this.w / 4, 3 * this.h / 4);
            this.quad.inCorners[3].setLocation(this.w / 4, 3 * this.h / 4);
            this.quad.outCorners[0].setLocation(this.w / 4, this.h / 4);
            this.quad.outCorners[1].setLocation(3 * this.w / 4, this.h / 4);
            this.quad.outCorners[2].setLocation(3 * this.w / 4, 3 * this.h / 4);
            this.quad.outCorners[3].setLocation(this.w / 4, 3 * this.h / 4);
            this.saveCorners(0, true);
            this.saveCorners(0, false);
        }
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        this.getQuadToSquare(this.temp1, ((Quadrilateral)this.quad).outCorners[0].x, ((Quadrilateral)this.quad).outCorners[0].y, ((Quadrilateral)this.quad).outCorners[1].x, ((Quadrilateral)this.quad).outCorners[1].y, ((Quadrilateral)this.quad).outCorners[2].x, ((Quadrilateral)this.quad).outCorners[2].y, ((Quadrilateral)this.quad).outCorners[3].x, ((Quadrilateral)this.quad).outCorners[3].y);
        this.getSquareToQuad(this.temp2, ((Quadrilateral)this.quad).inCorners[0].x, ((Quadrilateral)this.quad).inCorners[0].y, ((Quadrilateral)this.quad).inCorners[1].x, ((Quadrilateral)this.quad).inCorners[1].y, ((Quadrilateral)this.quad).inCorners[2].x, ((Quadrilateral)this.quad).inCorners[2].y, ((Quadrilateral)this.quad).inCorners[3].x, ((Quadrilateral)this.quad).inCorners[3].y);
        this.concatenate(this.temp1, this.temp2);
        this.transform(this.xOut, this.yOut, this.xIn, this.yIn);
        int i = 0;
        while (i < this.nPixelsIn) {
            this.pixelsOut[i] = this.getColor(this.xIn[i], this.yIn[i], this.w, this.h, this.pixelsIn);
            ++i;
        }
    }

    private void transform(double[] xSource, double[] ySource, double[] xTrans, double[] yTrans) {
        int n = xSource.length;
        int i = 0;
        while (i < n) {
            double w = this.matrix[2][0] * xSource[i] + this.matrix[2][1] * ySource[i] + this.matrix[2][2];
            if (w == 0.0) {
                xTrans[i] = xSource[i];
                yTrans[i] = ySource[i];
            } else {
                xTrans[i] = (this.matrix[0][0] * xSource[i] + this.matrix[0][1] * ySource[i] + this.matrix[0][2]) / w;
                yTrans[i] = (this.matrix[1][0] * xSource[i] + this.matrix[1][1] * ySource[i] + this.matrix[1][2]) / w;
            }
            ++i;
        }
    }

    private int getColor(double x, double y, int w, int h, int[] pixelValues) {
        double v;
        int col = (int)Math.floor(x);
        int row = (int)Math.floor(y);
        if (col < 0 || col >= w || row < 0 || row >= h) {
            return 0;
        }
        if (col + 1 == w || row + 1 == h) {
            return pixelValues[row * w + col];
        }
        double u = col == 0 ? x : x % (double)col;
        double d = v = row == 0 ? y : y % (double)row;
        if (this.interpolation == 2) {
            this.values[0] = pixelValues[row * w + col];
            this.values[1] = pixelValues[row * w + col + 1];
            this.values[2] = pixelValues[(row + 1) * w + col];
            this.values[3] = pixelValues[(row + 1) * w + col + 1];
            int j = 0;
            while (j < 4) {
                this.rgb[j] = this.values[j] >> 16 & 0xFF;
                ++j;
            }
            int r = this.bilinearInterpolation(u, v, this.rgb);
            int j2 = 0;
            while (j2 < 4) {
                this.rgb[j2] = this.values[j2] >> 8 & 0xFF;
                ++j2;
            }
            int g = this.bilinearInterpolation(u, v, this.rgb);
            int j3 = 0;
            while (j3 < 4) {
                this.rgb[j3] = this.values[j3] & 0xFF;
                ++j3;
            }
            int b = this.bilinearInterpolation(u, v, this.rgb);
            return r << 16 | g << 8 | b;
        }
        return u < 0.5 ? (v < 0.5 ? pixelValues[row * w + col] : pixelValues[(row + 1) * w + col]) : (v < 0.5 ? pixelValues[row * w + col + 1] : pixelValues[(row + 1) * w + col + 1]);
    }

    private int bilinearInterpolation(double x, double y, int[] values) {
        return (int)((1.0 - y) * ((1.0 - x) * (double)values[0] + x * (double)values[2]) + y * ((1.0 - x) * (double)values[1] + x * (double)values[3]));
    }

    private void getSquareToQuad(double[][] matrix, double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double dx3 = x0 - x1 + x2 - x3;
        double dy3 = y0 - y1 + y2 - y3;
        matrix[2][2] = 1.0;
        if (dx3 == 0.0 && dy3 == 0.0) {
            matrix[0][0] = x1 - x0;
            matrix[0][1] = x2 - x1;
            matrix[0][2] = x0;
            matrix[1][0] = y1 - y0;
            matrix[1][1] = y2 - y1;
            matrix[1][2] = y0;
            matrix[2][0] = 0.0;
            matrix[2][1] = 0.0;
        } else {
            double dx1 = x1 - x2;
            double dy1 = y1 - y2;
            double dx2 = x3 - x2;
            double dy2 = y3 - y2;
            double invdet = 1.0 / (dx1 * dy2 - dx2 * dy1);
            matrix[2][0] = (dx3 * dy2 - dx2 * dy3) * invdet;
            matrix[2][1] = (dx1 * dy3 - dx3 * dy1) * invdet;
            matrix[0][0] = x1 - x0 + matrix[2][0] * x1;
            matrix[0][1] = x3 - x0 + matrix[2][1] * x3;
            matrix[0][2] = x0;
            matrix[1][0] = y1 - y0 + matrix[2][0] * y1;
            matrix[1][1] = y3 - y0 + matrix[2][1] * y3;
            matrix[1][2] = y0;
        }
    }

    private void getQuadToSquare(double[][] matrix, double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        this.getSquareToQuad(matrix, x0, y0, x1, y1, x2, y2, x3, y3);
        double m00 = matrix[1][1] * matrix[2][2] - matrix[1][2] * matrix[2][1];
        double m01 = matrix[1][2] * matrix[2][0] - matrix[1][0] * matrix[2][2];
        double m02 = matrix[1][0] * matrix[2][1] - matrix[1][1] * matrix[2][0];
        double m10 = matrix[0][2] * matrix[2][1] - matrix[0][1] * matrix[2][2];
        double m11 = matrix[0][0] * matrix[2][2] - matrix[0][2] * matrix[2][0];
        double m12 = matrix[0][1] * matrix[2][0] - matrix[0][0] * matrix[2][1];
        double m20 = matrix[0][1] * matrix[1][2] - matrix[0][2] * matrix[1][1];
        double m21 = matrix[0][2] * matrix[1][0] - matrix[0][0] * matrix[1][2];
        double m22 = matrix[0][0] * matrix[1][1] - matrix[0][1] * matrix[1][0];
        matrix[0][0] = m00;
        matrix[0][1] = m10;
        matrix[0][2] = m20;
        matrix[1][0] = m01;
        matrix[1][1] = m11;
        matrix[1][2] = m21;
        matrix[2][0] = m02;
        matrix[2][1] = m12;
        matrix[2][2] = m22;
    }

    private void concatenate(double[][] m1, double[][] m2) {
        this.matrix[0][0] = m1[0][0] * m2[0][0] + m1[1][0] * m2[0][1] + m1[2][0] * m2[0][2];
        this.matrix[1][0] = m1[0][0] * m2[1][0] + m1[1][0] * m2[1][1] + m1[2][0] * m2[1][2];
        this.matrix[2][0] = m1[0][0] * m2[2][0] + m1[1][0] * m2[2][1] + m1[2][0] * m2[2][2];
        this.matrix[0][1] = m1[0][1] * m2[0][0] + m1[1][1] * m2[0][1] + m1[2][1] * m2[0][2];
        this.matrix[1][1] = m1[0][1] * m2[1][0] + m1[1][1] * m2[1][1] + m1[2][1] * m2[1][2];
        this.matrix[2][1] = m1[0][1] * m2[2][0] + m1[1][1] * m2[2][1] + m1[2][1] * m2[2][2];
        this.matrix[0][2] = m1[0][2] * m2[0][0] + m1[1][2] * m2[0][1] + m1[2][2] * m2[0][2];
        this.matrix[1][2] = m1[0][2] * m2[1][0] + m1[1][2] * m2[1][1] + m1[2][2] * m2[1][2];
        this.matrix[2][2] = m1[0][2] * m2[2][0] + m1[1][2] * m2[2][1] + m1[2][2] * m2[2][2];
    }

    private double[][] getCornerData(Point2D.Double[] cornerPoints) {
        double[][] data = new double[4][2];
        int i = 0;
        while (i < 4) {
            data[i][0] = cornerPoints[i].x;
            data[i][1] = cornerPoints[i].y;
            ++i;
        }
        return data;
    }

    private void refreshCorners(int frameNumber) {
        int key = this.getKeyFrame(frameNumber, true);
        int i = 0;
        while (i < 4) {
            this.quad.inCorners[i].setLocation(this.inCornerPoints[key][i]);
            ++i;
        }
        key = this.getKeyFrame(frameNumber, false);
        i = 0;
        while (i < 4) {
            this.quad.outCorners[i].setLocation(this.outCornerPoints[key][i]);
            ++i;
        }
    }

    private void saveCorners(int frameNumber, boolean in) {
        int i;
        if (this.isFixed(in)) {
            frameNumber = this.fixedKey;
        }
        this.ensureCornerCapacity(frameNumber);
        TreeSet<Integer> keyFrames = in ? this.inKeyFrames : this.outKeyFrames;
        Point2D.Double[][] cornerPoints = in ? this.inCornerPoints : this.outCornerPoints;
        Corner[] corners = in ? this.quad.inCorners : this.quad.outCorners;
        keyFrames.add(frameNumber);
        if (cornerPoints[frameNumber] == null) {
            cornerPoints[frameNumber] = new Point2D.Double[4];
            i = 0;
            while (i < 4) {
                cornerPoints[frameNumber][i] = new Point2D.Double();
                ++i;
            }
        }
        i = 0;
        while (i < 4) {
            cornerPoints[frameNumber][i].setLocation(corners[i]);
            ++i;
        }
    }

    private void loadCornerData(double[][][] cornerData, boolean in) {
        this.ensureCornerCapacity(cornerData.length);
        TreeSet<Integer> keyFrames = in ? this.inKeyFrames : this.outKeyFrames;
        keyFrames.clear();
        Point2D.Double[][] cornerPoints = in ? this.inCornerPoints : this.outCornerPoints;
        int j = 0;
        while (j < cornerData.length) {
            if (cornerData[j] != null) {
                int i;
                keyFrames.add(j);
                if (cornerPoints[j] == null) {
                    cornerPoints[j] = new Point2D.Double[4];
                    i = 0;
                    while (i < 4) {
                        cornerPoints[j][i] = new Point2D.Double();
                        ++i;
                    }
                }
                i = 0;
                while (i < 4) {
                    cornerPoints[j][i].setLocation(cornerData[j][i][0], cornerData[j][i][1]);
                    ++i;
                }
            }
            ++j;
        }
    }

    private void ensureCornerCapacity(int index) {
        Point2D.Double[][] newArray;
        int length = this.inCornerPoints.length;
        if (length < index + 1) {
            newArray = new Point2D.Double[index + 10][];
            System.arraycopy(this.inCornerPoints, 0, newArray, 0, length);
            this.inCornerPoints = newArray;
        }
        if ((length = this.outCornerPoints.length) < index + 1) {
            newArray = new Point2D.Double[index + 10][];
            System.arraycopy(this.outCornerPoints, 0, newArray, 0, length);
            this.outCornerPoints = newArray;
        }
    }

    private void trimCornerPoints() {
        Point2D.Double[][] newArray;
        int length;
        int i = length = this.inCornerPoints.length;
        while (i > 0) {
            if (this.inCornerPoints[i - 1] != null) {
                newArray = new Point2D.Double[i][];
                System.arraycopy(this.inCornerPoints, 0, newArray, 0, i);
                this.inCornerPoints = newArray;
                break;
            }
            --i;
        }
        i = length = this.outCornerPoints.length;
        while (i > 0) {
            if (this.outCornerPoints[i - 1] != null) {
                newArray = new Point2D.Double[i][];
                System.arraycopy(this.outCornerPoints, 0, newArray, 0, i);
                this.outCornerPoints = newArray;
                break;
            }
            --i;
        }
    }

    private int getKeyFrame(int frameNumber, boolean in) {
        if (this.isFixed(in)) {
            return this.fixedKey;
        }
        TreeSet<Integer> keyFrames = in ? this.inKeyFrames : this.outKeyFrames;
        int key = 0;
        for (int i : keyFrames) {
            if (i > frameNumber) continue;
            key = i;
        }
        return key;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public boolean superIsEnabled() {
        return super.isEnabled();
    }

    public class Corner
    extends TPoint {
        @Override
        public void setXY(double x, double y) {
            QuadEditor editor;
            super.setXY(x, y);
            boolean in = !PerspectiveFilter.this.isEnabled();
            Corner[] corners = in ? PerspectiveFilter.this.quad.inCorners : PerspectiveFilter.this.quad.outCorners;
            QuadEditor quadEditor = editor = in ? PerspectiveFilter.this.inputEditor : PerspectiveFilter.this.outputEditor;
            if (editor.shapes[editor.selectedShapeIndex].equals("Rectangle")) {
                if (this == corners[0]) {
                    corners[3].x = x;
                    corners[1].y = y;
                } else if (this == corners[1]) {
                    corners[2].x = x;
                    corners[0].y = y;
                } else if (this == corners[2]) {
                    corners[1].x = x;
                    corners[3].y = y;
                } else if (this == corners[3]) {
                    corners[0].x = x;
                    corners[2].y = y;
                }
            }
            PerspectiveFilter.this.saveCorners(PerspectiveFilter.this.vidPanel == null ? 0 : PerspectiveFilter.this.vidPanel.getFrameNumber(), in);
            editor.refreshFields();
            if (editor == PerspectiveFilter.this.outputEditor) {
                PerspectiveFilter.this.firePropertyChange("image", null, null);
            }
            PerspectiveFilter.this.firePropertyChange(PerspectiveFilter.PROPERTY_PERSPECTIVEFILTER_CORNERLOCATION, null, this);
            if (PerspectiveFilter.this.vidPanel != null) {
                PerspectiveFilter.this.vidPanel.repaint();
            }
        }
    }

    private class Inspector
    extends Filter.InspectorDlg {
        JButton helpButton;
        JButton colorButton;
        JTabbedPane tabbedPane;
        JPanel contentPane;

        public Inspector() {
            super("Filter.Perspective.Title");
        }

        @Override
        void createGUI() {
            this.tabbedPane = new JTabbedPane();
            PerspectiveFilter.this.inputEditor = new QuadEditor(true);
            PerspectiveFilter.this.outputEditor = new QuadEditor(false);
            ((PerspectiveFilter)PerspectiveFilter.this).outputEditor.selectedShapeIndex = 1;
            this.tabbedPane.addTab("", PerspectiveFilter.this.inputEditor);
            this.tabbedPane.addTab("", PerspectiveFilter.this.outputEditor);
            this.tabbedPane.setSelectedComponent(PerspectiveFilter.this.inputEditor);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (PerspectiveFilter.this.disposing) {
                        return;
                    }
                    PerspectiveFilter.this.refresh();
                    PerspectiveFilter filter = PerspectiveFilter.this;
                    filter.firePropertyChange("image", null, null);
                    filter.firePropertyChange("tab", null, null);
                }
            });
            this.helpButton = new JButton();
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = String.valueOf(MediaRes.getString("PerspectiveFilter.Help.Message1")) + "\n" + MediaRes.getString("PerspectiveFilter.Help.Message2") + "\n" + MediaRes.getString("PerspectiveFilter.Help.Message3") + "\n" + MediaRes.getString("PerspectiveFilter.Help.Message4") + "\n\n" + MediaRes.getString("PerspectiveFilter.Help.Message5") + "\n  " + MediaRes.getString("PerspectiveFilter.Help.Message6") + "\n  " + MediaRes.getString("PerspectiveFilter.Help.Message7") + "\n  " + MediaRes.getString("PerspectiveFilter.Help.Message8") + "\n      " + MediaRes.getString("PerspectiveFilter.Help.Message9");
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(((Inspector)Inspector.this).PerspectiveFilter.this.vidPanel), s, MediaRes.getString("PerspectiveFilter.Help.Title"), 1);
                }
            });
            this.colorButton = new JButton();
            this.colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPRuntime.chooseColor(PerspectiveFilter.this.quad.color, MediaRes.getString("PerspectiveFilter.Dialog.Color.Title"), newColor -> {
                        if (newColor != null) {
                            PerspectiveFilter.this.quad.color = newColor;
                            Inspector.this.firePropertyChange("filter_color", null, newColor);
                        }
                    });
                }
            });
            PerspectiveFilter.this.ableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean enable = !PerspectiveFilter.this.superIsEnabled();
                    Inspector.this.colorButton.setEnabled(enable);
                    Inspector.this.tabbedPane.setEnabled(enable);
                    PerspectiveFilter.this.inputEditor.setEnabled(enable);
                    PerspectiveFilter.this.outputEditor.setEnabled(enable);
                }
            });
            this.contentPane = new JPanel(new BorderLayout());
            this.setContentPane(this.contentPane);
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(this.helpButton);
            buttonbar.add(this.colorButton);
            buttonbar.add(PerspectiveFilter.this.ableButton);
            buttonbar.add(PerspectiveFilter.this.closeButton);
            this.contentPane.add((Component)buttonbar, "South");
            this.contentPane.add((Component)this.tabbedPane, "Center");
        }

        void initialize() {
            PerspectiveFilter.this.refresh();
            this.pack();
        }

        @Override
        public void dispose() {
            PerspectiveFilter.this.disposing = true;
            if (this.tabbedPane != null) {
                this.tabbedPane.removeAll();
                if (this.contentPane != null) {
                    this.contentPane.remove(this.tabbedPane);
                }
            }
            super.dispose();
            PerspectiveFilter.this.disposing = false;
        }

        @Override
        public void setVisible(boolean vis) {
            if (vis == this.isVisible()) {
                return;
            }
            super.setVisible(vis);
            if (PerspectiveFilter.this.vidPanel != null) {
                PerspectiveFilter filter = PerspectiveFilter.this;
                if (vis) {
                    PerspectiveFilter.this.vidPanel.addDrawable(PerspectiveFilter.this.quad);
                    filter.firePropertyChange("filter_visible", null, null);
                    filter.removePropertyChangeListener("filter_visible", PerspectiveFilter.this.vidPanel);
                    filter.addPropertyChangeListener("filter_visible", PerspectiveFilter.this.vidPanel);
                    PerspectiveFilter.this.vidPanel.removePropertyChangeListener("selectedpoint", PerspectiveFilter.this.quad);
                    PerspectiveFilter.this.vidPanel.addPropertyChangeListener("selectedpoint", PerspectiveFilter.this.quad);
                } else {
                    filter.firePropertyChange("filter_visible", null, null);
                    filter.removePropertyChangeListener("filter_visible", PerspectiveFilter.this.vidPanel);
                    PerspectiveFilter.this.vidPanel.removePropertyChangeListener("selectedpoint", PerspectiveFilter.this.quad);
                    PerspectiveFilter.this.vidPanel.removeDrawable(PerspectiveFilter.this.quad);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseEvent(PerspectiveFilter.this.vidPanel, 502, 0L, 16, -100, -100, 1, false));
                }
            }
            boolean enable = PerspectiveFilter.this.superIsEnabled();
            this.colorButton.setEnabled(enable);
            this.tabbedPane.setEnabled(enable);
            PerspectiveFilter.this.inputEditor.setEnabled(enable);
            PerspectiveFilter.this.outputEditor.setEnabled(enable);
            this.firePropertyChange("image", null, null);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            int i;
            PerspectiveFilter filter = (PerspectiveFilter)obj;
            filter.trimCornerPoints();
            double[][][] data = new double[filter.inCornerPoints.length][][];
            Iterator iterator = filter.inKeyFrames.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                filter.refreshCorners(i);
                data[i] = filter.getCornerData(filter.inCornerPoints[i]);
            }
            control.setValue("in_corners", data);
            data = new double[filter.outCornerPoints.length][][];
            iterator = filter.outKeyFrames.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                filter.refreshCorners(i);
                data[i] = filter.getCornerData(filter.outCornerPoints[i]);
            }
            control.setValue("out_corners", data);
            if (filter.vidPanel != null) {
                VideoClip clip = filter.vidPanel.getPlayer().getVideoClip();
                control.setValue("startframe", clip.getStartFrameNumber());
                filter.refreshCorners(filter.vidPanel.getFrameNumber());
            }
            if (!filter.quad.color.equals(defaultColor)) {
                control.setValue("color", filter.quad.color);
            }
            filter.addLocation(control);
            control.setValue("disabled", !filter.isSuperEnabled());
            control.setValue("fixed_in", filter.fixedIn);
            control.setValue("fixed_out", filter.fixedOut);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new PerspectiveFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            int i;
            double[][][] data;
            PerspectiveFilter filter = (PerspectiveFilter)obj;
            if (control.getPropertyNamesRaw().contains("fixed_out")) {
                filter.fixedIn = control.getBoolean("fixed_in");
                filter.fixedOut = control.getBoolean("fixed_out");
            }
            if ((data = (double[][][])control.getObject("in_corners")) != null) {
                filter.loadCornerData(data, true);
            }
            if ((data = (double[][][])control.getObject("out_corners")) != null) {
                filter.loadCornerData(data, false);
            }
            Iterator iterator = filter.inKeyFrames.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                filter.refreshCorners(i);
            }
            iterator = filter.outKeyFrames.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                filter.refreshCorners(i);
            }
            int frame = control.getInt("startframe");
            if (frame != Integer.MIN_VALUE) {
                filter.refreshCorners(frame);
            }
            if (filter.vidPanel != null) {
                filter.refreshCorners(filter.vidPanel.getFrameNumber());
            }
            if (control.getPropertyNamesRaw().contains("color")) {
                filter.quad.color = (Color)control.getObject("color");
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            boolean disable = control.getBoolean("disabled");
            if (disable && filter.isSuperEnabled() || !disable && !filter.isSuperEnabled()) {
                filter.ableButton.doClick(0);
            }
            filter.refresh();
            return obj;
        }
    }

    private class QuadEditor
    extends JPanel {
        DecimalField[][] fields;
        boolean isInput;
        String[] shapes;
        int selectedShapeIndex;
        JComboBox<String> shapeDropdown;
        JLabel shapeLabel;
        JCheckBox fixedCheckbox;
        boolean refreshing;
        Box[] boxes;
        TitledBorder cornersBorder;

        QuadEditor(boolean input) {
            super(new BorderLayout());
            this.fields = new DecimalField[4][2];
            this.shapes = new String[]{"Any", "Rectangle"};
            this.shapeDropdown = new JComboBox();
            this.shapeLabel = new JLabel();
            this.boxes = new Box[4];
            this.cornersBorder = BorderFactory.createTitledBorder("");
            this.isInput = input;
            AbstractAction cornerSetter = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Corner[] corners = QuadEditor.this.isInput ? PerspectiveFilter.this.quad.inCorners : PerspectiveFilter.this.quad.outCorners;
                    int i = 0;
                    while (i < QuadEditor.this.fields.length) {
                        if (e.getSource() == QuadEditor.this.fields[i][0] || e.getSource() == QuadEditor.this.fields[i][1]) {
                            ((TPoint)corners[i]).setXY(QuadEditor.this.fields[i][0].getValue(), QuadEditor.this.fields[i][1].getValue());
                        }
                        ++i;
                    }
                    QuadEditor.this.refreshFields();
                    PerspectiveFilter.this.firePropertyChange("image", null, null);
                }
            };
            JPanel fieldPanel = new JPanel(new GridLayout(2, 2));
            fieldPanel.setBorder(this.cornersBorder);
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i][0] = new DecimalField(4, 1);
                this.fields[i][0].addActionListener(cornerSetter);
                this.fields[i][1] = new DecimalField(4, 1);
                this.fields[i][1].addActionListener(cornerSetter);
                this.boxes[i] = Box.createHorizontalBox();
                JLabel label = new JLabel(String.valueOf(i) + ":  x");
                label.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
                this.boxes[i].add(label);
                this.boxes[i].add(this.fields[i][0]);
                label = new JLabel("y");
                label.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
                this.boxes[i].add(label);
                this.boxes[i].add(this.fields[i][1]);
                this.boxes[i].setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                ++i;
            }
            fieldPanel.add(this.boxes[0]);
            fieldPanel.add(this.boxes[1]);
            fieldPanel.add(this.boxes[3]);
            fieldPanel.add(this.boxes[2]);
            this.shapeLabel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 4));
            this.shapeDropdown.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 8));
            this.shapeDropdown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QuadEditor.this.refreshing) {
                        return;
                    }
                    QuadEditor.this.selectedShapeIndex = QuadEditor.this.shapeDropdown.getSelectedIndex();
                    if (QuadEditor.this.shapes[QuadEditor.this.selectedShapeIndex].equals("Rectangle")) {
                        Corner[] corners = QuadEditor.this.isInput ? PerspectiveFilter.this.quad.inCorners : PerspectiveFilter.this.quad.outCorners;
                        int i = 0;
                        while (i < 4) {
                            ((TPoint)corners[i]).setXY(corners[i].x, corners[i].y);
                            ++i;
                        }
                        if (((QuadEditor)QuadEditor.this).PerspectiveFilter.this.vidPanel != null) {
                            ((QuadEditor)QuadEditor.this).PerspectiveFilter.this.vidPanel.repaint();
                        }
                    }
                }
            });
            this.fixedCheckbox = new JCheckBox();
            this.fixedCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QuadEditor.this.refreshing || PerspectiveFilter.this.isFixed(QuadEditor.this.isInput) == QuadEditor.this.fixedCheckbox.isSelected()) {
                        return;
                    }
                    PerspectiveFilter.this.setFixed(QuadEditor.this.fixedCheckbox.isSelected(), QuadEditor.this.isInput);
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(this.shapeLabel);
            box.add(this.shapeDropdown);
            box.add(this.fixedCheckbox);
            this.add((Component)box, "North");
            this.add((Component)fieldPanel, "Center");
            this.refreshGUI();
            this.refreshFields();
        }

        void refreshGUI() {
            this.refreshing = true;
            this.shapeLabel.setText(MediaRes.getString("PerspectiveFilter.Label.Shape"));
            this.cornersBorder.setTitle(MediaRes.getString("PerspectiveFilter.Corners.Title"));
            this.fixedCheckbox.setText(MediaRes.getString("PerspectiveFilter.Checkbox.Fixed"));
            this.shapeDropdown.removeAllItems();
            if (this == PerspectiveFilter.this.inputEditor) {
                this.shapeDropdown.addItem(MediaRes.getString("PerspectiveFilter.Shape.Any"));
            } else {
                int i = 0;
                while (i < this.shapes.length) {
                    this.shapeDropdown.addItem(MediaRes.getString("PerspectiveFilter.Shape." + this.shapes[i]));
                    ++i;
                }
            }
            this.shapeDropdown.setSelectedIndex(this.selectedShapeIndex);
            this.fixedCheckbox.setSelected(PerspectiveFilter.this.isFixed(this.isInput));
            this.refreshing = false;
        }

        void refreshFields() {
            Corner[] corners = this == PerspectiveFilter.this.outputEditor ? PerspectiveFilter.this.quad.outCorners : PerspectiveFilter.this.quad.inCorners;
            int i = 0;
            while (i < 4) {
                this.fields[i][0].setValue(corners[i].x);
                this.fields[i][1].setValue(corners[i].y);
                ++i;
            }
        }

        @Override
        public void setEnabled(boolean b) {
            this.shapeDropdown.setEnabled(b);
            this.shapeLabel.setEnabled(b);
            this.fixedCheckbox.setEnabled(b);
            int i = 0;
            while (i < this.boxes.length) {
                Component[] componentArray = this.boxes[i].getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    c.setEnabled(b);
                    ++n2;
                }
                ++i;
            }
            this.cornersBorder.setTitleColor(b ? this.shapeLabel.getForeground() : GUIUtils.getDisabledTextColor());
        }
    }

    private class Quadrilateral
    implements Trackable,
    Interactive,
    PropertyChangeListener {
        private Corner[] inCorners = new Corner[4];
        private Corner[] outCorners = new Corner[4];
        private Point2D.Double[] screenPts = new Point2D.Double[4];
        private GeneralPath path = new GeneralPath();
        private Stroke stroke = new BasicStroke(2.0f);
        private Stroke cornerStroke = new BasicStroke();
        private Shape selectionShape = new Rectangle(-4, -4, 8, 8);
        private Shape cornerShape = new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0);
        private Shape[] hitShapes = new Shape[4];
        private Shape[] drawShapes = new Shape[5];
        private Corner selectedCorner;
        private AffineTransform transform = new AffineTransform();
        private OSPRuntime.TextLayout[] textLayouts = new OSPRuntime.TextLayout[4];
        private Font font = new JTextField().getFont();
        private Point p = new Point();
        private Color color = PerspectiveFilter.access$8();

        public Quadrilateral() {
            int i = 0;
            while (i < this.inCorners.length) {
                this.inCorners[i] = new Corner();
                this.outCorners[i] = new Corner();
                this.textLayouts[i] = new OSPRuntime.TextLayout(String.valueOf(i), this.font);
                this.screenPts[i] = new Point2D.Double();
                ++i;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Corner prev = this.selectedCorner;
            this.selectedCorner = null;
            int i = 0;
            while (i < 4) {
                if (e.getNewValue() == this.inCorners[i]) {
                    this.selectedCorner = this.inCorners[i];
                } else if (e.getNewValue() == this.outCorners[i]) {
                    this.selectedCorner = this.outCorners[i];
                }
                ++i;
            }
            if (this.selectedCorner != prev && PerspectiveFilter.this.vidPanel != null) {
                PerspectiveFilter.this.vidPanel.repaint();
            }
        }

        @Override
        public void draw(DrawingPanel panel, Graphics g) {
            if (!PerspectiveFilter.this.superIsEnabled()) {
                return;
            }
            VideoPanel vidPanel = (VideoPanel)panel;
            Corner[] corners = PerspectiveFilter.this.isEnabled() ? this.outCorners : this.inCorners;
            int i = 0;
            while (i < 4) {
                Point pt = corners[i].getScreenPosition(vidPanel);
                this.screenPts[i].setLocation(pt.x, pt.y);
                this.transform.setToTranslation(this.screenPts[i].x, this.screenPts[i].y);
                Shape s = corners[i] == this.selectedCorner ? this.selectionShape : this.cornerShape;
                Stroke sk = corners[i] == this.selectedCorner ? this.stroke : this.cornerStroke;
                this.hitShapes[i] = this.transform.createTransformedShape(s);
                this.drawShapes[i] = sk.createStrokedShape(this.hitShapes[i]);
                ++i;
            }
            this.path.reset();
            this.path.moveTo((float)this.screenPts[0].x, (float)this.screenPts[0].y);
            this.path.lineTo((float)this.screenPts[1].x, (float)this.screenPts[1].y);
            this.path.lineTo((float)this.screenPts[2].x, (float)this.screenPts[2].y);
            this.path.lineTo((float)this.screenPts[3].x, (float)this.screenPts[3].y);
            this.path.closePath();
            this.drawShapes[4] = this.stroke.createStrokedShape(this.path);
            Graphics2D g2 = (Graphics2D)g;
            Color gcolor = g2.getColor();
            g2.setColor(this.color);
            Font gfont = g.getFont();
            g2.setFont(this.font);
            if (OSPRuntime.setRenderingHints) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int i2 = 0;
            while (i2 < this.drawShapes.length) {
                g2.fill(this.drawShapes[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.textLayouts.length) {
                this.p.setLocation(this.screenPts[i2].x - 4.0 - (double)this.font.getSize(), this.screenPts[i2].y - 6.0);
                this.textLayouts[i2].draw(g2, this.p.x, this.p.y);
                ++i2;
            }
            g2.setFont(gfont);
            g2.setColor(gcolor);
        }

        @Override
        public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
            if (!PerspectiveFilter.this.superIsEnabled()) {
                return null;
            }
            if (!(panel instanceof VideoPanel) || !this.isEnabled()) {
                return null;
            }
            int i = 0;
            while (i < this.hitShapes.length) {
                if (this.hitShapes[i] != null && this.hitShapes[i].contains(xpix, ypix)) {
                    if (!PerspectiveFilter.this.isEnabled()) {
                        return this.inCorners[i];
                    }
                    return this.outCorners[i];
                }
                ++i;
            }
            return null;
        }

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }

        @Override
        public void setX(double x) {
        }

        @Override
        public void setY(double y) {
        }

        @Override
        public void setXY(double x, double y) {
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isMeasured() {
            return false;
        }

        @Override
        public double getXMin() {
            return this.getX();
        }

        @Override
        public double getXMax() {
            return this.getX();
        }

        @Override
        public double getYMin() {
            return this.getY();
        }

        @Override
        public double getYMax() {
            return this.getY();
        }
    }
}

