/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoPanel;

public class RadialDistortionFilter
extends Filter {
    public static final String RECTILINEAR = "Rectilinear";
    public static final String EQUIDISTANT = "Equidistant";
    public static final String EQUISOLID = "Equisolid";
    public static final String STEREOGRAPHIC = "Stereographic";
    public static final String ORTHOGRAPHIC = "Orthographic";
    protected static final ArrayList<String> PROJECTION_TYPES = new ArrayList();
    protected static double minRadius = 0.2;
    protected static double maxRadius = 1.0;
    protected static double minFOV = 0.17453292519943295;
    protected static double maxFOV = 3.1405926535897932;
    private double[] xOut;
    private double[] yOut;
    private double[] xIn;
    private double[] yIn;
    private double pixelsToCorner;
    private boolean isValidTransform = false;
    private boolean updatingDisplay = false;
    private boolean dimensionsChanged = false;
    private double outputFOV;
    private boolean hasLowerLimit;
    private int lowerRadiusLimit = (int)(100.0 * minRadius);
    private int interpolation = 1;
    private double fixedRadius = 0.75;
    private double sourceFOV = 1.5707963267948966;
    private String sourceProjectionType = "Rectilinear";
    private String outputProjectionType = "Rectilinear";
    private Color color = Color.GREEN;
    private Inspector inspector;
    private Circle circle = new Circle();

    static {
        PROJECTION_TYPES.add(RECTILINEAR);
        PROJECTION_TYPES.add(EQUISOLID);
        PROJECTION_TYPES.add(EQUIDISTANT);
        PROJECTION_TYPES.add(STEREOGRAPHIC);
        PROJECTION_TYPES.add(ORTHOGRAPHIC);
    }

    public RadialDistortionFilter() {
        this.refresh();
        this.hasInspector = true;
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.ableButton.setText(this.isEnabled() ? MediaRes.getString("Filter.Button.Disable") : MediaRes.getString("Filter.Button.Enable"));
        this.inspector.refreshGUI();
    }

    public void setFixedRadius(double fraction) {
        if (Double.isNaN(fraction)) {
            return;
        }
        fraction = Math.abs(fraction);
        fraction = Math.min(fraction, maxRadius);
        if (this.fixedRadius != (fraction = Math.max(fraction, minRadius))) {
            this.fixedRadius = fraction;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.isValidTransform = false;
            this.firePropertyChange("image", null, null);
        }
    }

    public double getFixedRadius() {
        return this.fixedRadius;
    }

    public void setSourceFOV(double fov) {
        if (Double.isNaN(fov)) {
            return;
        }
        fov = Math.abs(fov);
        fov = Math.min(fov, 3.141092653589793);
        if (this.sourceFOV != (fov = Math.max(fov, minFOV))) {
            this.sourceFOV = fov;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.isValidTransform = false;
            this.firePropertyChange("image", null, null);
        }
    }

    public double getSourceFOV() {
        return this.sourceFOV;
    }

    public void setSourceProjectionType(String type) {
        if (!this.sourceProjectionType.equals(type) && PROJECTION_TYPES.contains(type)) {
            this.sourceProjectionType = type;
            this.hasLowerLimit = this.getAngleAtRadius(0.5, this.outputProjectionType, 1.5707963267948966) < this.getAngleAtRadius(0.5, this.sourceProjectionType, 1.5707963267948966);
            this.isValidTransform = false;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.firePropertyChange("image", null, null);
        }
    }

    public String getSourceProjectionType() {
        return this.sourceProjectionType;
    }

    public void setOutputProjectionType(String type) {
        if (!this.outputProjectionType.equals(type) && PROJECTION_TYPES.contains(type)) {
            this.outputProjectionType = type;
            this.hasLowerLimit = this.getAngleAtRadius(0.5, this.outputProjectionType, 1.5707963267948966) < this.getAngleAtRadius(0.5, this.sourceProjectionType, 1.5707963267948966);
            this.isValidTransform = false;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.firePropertyChange("image", null, null);
        }
    }

    public String getOutputProjectionType() {
        return this.outputProjectionType;
    }

    private String[] getProjectionTypeDescriptions() {
        String[] types = new String[PROJECTION_TYPES.size()];
        int i = 0;
        while (i < types.length) {
            String next = PROJECTION_TYPES.get(i);
            types[i] = MediaRes.getString("RadialDistortionFilter.ProjectionType." + next);
            ++i;
        }
        return types;
    }

    @Override
    protected void initializeSubclass() {
        this.pixelsToCorner = Math.sqrt(this.w * this.w + this.h * this.h) / 2.0;
        this.isValidTransform = false;
    }

    @Override
    protected void initializeSource(BufferedImage image) {
        int prevW = this.w;
        int prevH = this.h;
        super.initializeSource(image);
        this.dimensionsChanged = this.w != prevW || this.h != prevH;
    }

    @Override
    protected void setOutputPixels() {
        int i;
        this.getPixelsIn();
        this.getPixelsOut();
        if (this.dimensionsChanged) {
            this.xOut = new double[this.w * this.h];
            this.yOut = new double[this.w * this.h];
            i = 0;
            while (i < this.w) {
                int j = 0;
                while (j < this.h) {
                    this.xOut[j * this.w + i] = i;
                    this.yOut[j * this.w + i] = j;
                    ++j;
                }
                ++i;
            }
        }
        if (!this.isValidTransform || this.xIn == null || this.dimensionsChanged) {
            this.xIn = new double[this.w * this.h];
            this.yIn = new double[this.w * this.h];
            this.transform(this.xOut, this.yOut, this.xIn, this.yIn);
        }
        i = 0;
        while (i < this.nPixelsIn) {
            this.pixelsOut[i] = this.getColor(this.xIn[i], this.yIn[i], this.w, this.h, this.pixelsIn);
            ++i;
        }
        this.dimensionsChanged = false;
    }

    private void transform(double[] xSource, double[] ySource, double[] xTrans, double[] yTrans) {
        this.refreshScale();
        double xCenter = (double)this.w / 2.0;
        double yCenter = (double)this.h / 2.0;
        int n = xSource.length;
        int i = 0;
        while (i < n) {
            double dx = xSource[i] - xCenter;
            double dy = ySource[i] - yCenter;
            double r = Math.sqrt(dx * dx + dy * dy);
            double stretch = this.getStretchFactor(r);
            double extra = 1.0E-4;
            xTrans[i] = xCenter + stretch * dx + extra;
            yTrans[i] = yCenter + stretch * dy + extra;
            ++i;
        }
        this.isValidTransform = true;
    }

    private double findRadiusLimit() {
        double tolerance = 1.0E-6;
        int maxInterations = 10;
        double rLimit = 0.8;
        double f = this.getAngleAtRadius(rLimit, this.sourceProjectionType, this.sourceFOV) - this.getAngleAtRadius(rLimit, this.outputProjectionType, Math.PI);
        double dfdr = this.getDerivativeAtRadius(rLimit, this.sourceProjectionType, this.sourceFOV) - this.getDerivativeAtRadius(rLimit, this.outputProjectionType, Math.PI);
        int i = 0;
        while (Math.abs(f) > tolerance && i < maxInterations) {
            f = this.getAngleAtRadius(rLimit -= f / dfdr, this.sourceProjectionType, this.sourceFOV) - this.getAngleAtRadius(rLimit, this.outputProjectionType, Math.PI);
            dfdr = this.getDerivativeAtRadius(rLimit, this.sourceProjectionType, this.sourceFOV) - this.getDerivativeAtRadius(rLimit, this.outputProjectionType, Math.PI);
            ++i;
        }
        return i < maxInterations ? rLimit : Double.NaN;
    }

    private double getAngleAtRadius(double r, String projectionType, double fov) {
        if (RECTILINEAR.equals(projectionType)) {
            return Math.atan(r * Math.tan(fov / 2.0));
        }
        if (EQUIDISTANT.equals(projectionType)) {
            return r * fov / 2.0;
        }
        if (EQUISOLID.equals(projectionType)) {
            return 2.0 * Math.asin(r * Math.sin(fov / 4.0));
        }
        if (STEREOGRAPHIC.equals(projectionType)) {
            return 2.0 * Math.atan(r * Math.tan(fov / 4.0));
        }
        if (ORTHOGRAPHIC.equals(projectionType)) {
            return Math.asin(r * Math.sin(fov / 2.0));
        }
        return r * fov / 2.0;
    }

    private double getDerivativeAtRadius(double r, String projectionType, double fov) {
        if (RECTILINEAR.equals(projectionType)) {
            double tan = Math.tan(fov / 2.0);
            return tan / (1.0 + r * r * tan * tan);
        }
        if (EQUIDISTANT.equals(projectionType)) {
            return fov / 2.0;
        }
        if (EQUISOLID.equals(projectionType)) {
            double sin = Math.sin(fov / 4.0);
            return 2.0 * sin / Math.sqrt(1.0 - r * r * sin * sin);
        }
        if (STEREOGRAPHIC.equals(projectionType)) {
            double tan = Math.tan(fov / 4.0);
            return 2.0 * tan / (1.0 + r * r * tan * tan);
        }
        if (ORTHOGRAPHIC.equals(projectionType)) {
            double sin = Math.sin(fov / 2.0);
            return sin / Math.sqrt(1.0 - r * r * sin * sin);
        }
        return fov / 2.0;
    }

    private void refreshScale() {
        if (this.sourceFOV == 0.0) {
            return;
        }
        double theta = this.getAngleAtRadius(this.fixedRadius, this.sourceProjectionType, this.sourceFOV);
        if (RECTILINEAR.equals(this.outputProjectionType)) {
            this.outputFOV = 2.0 * Math.atan(Math.tan(theta) / this.fixedRadius);
        } else if (EQUIDISTANT.equals(this.outputProjectionType)) {
            this.outputFOV = 2.0 * theta / this.fixedRadius;
        } else if (EQUISOLID.equals(this.outputProjectionType)) {
            this.outputFOV = 4.0 * Math.asin(Math.sin(theta / 2.0) / this.fixedRadius);
        } else if (STEREOGRAPHIC.equals(this.outputProjectionType)) {
            this.outputFOV = 4.0 * Math.atan(Math.tan(theta / 2.0) / this.fixedRadius);
        } else if (ORTHOGRAPHIC.equals(this.outputProjectionType)) {
            this.outputFOV = 2.0 * Math.asin(Math.sin(theta) / this.fixedRadius);
        }
        if (Double.isNaN(this.outputFOV)) {
            this.outputFOV = maxFOV;
        }
        if (this.hasLowerLimit) {
            double limit = this.findRadiusLimit();
            if (!Double.isNaN(limit) && limit > 0.005 && limit < 1.01) {
                this.lowerRadiusLimit = Math.max((int)Math.floor(100.0 * limit), (int)(100.0 * minRadius));
            }
            if (this.outputFOV > maxFOV && this.fixedRadius != (double)this.lowerRadiusLimit / 100.0) {
                this.fixedRadius = (double)this.lowerRadiusLimit / 100.0;
                this.refreshScale();
            }
        } else {
            this.lowerRadiusLimit = (int)(100.0 * minRadius);
        }
    }

    private double getStretchFactor(double rOut) {
        if (rOut == 0.0 || this.sourceFOV == 0.0) {
            return 1.0;
        }
        double radius = rOut / this.pixelsToCorner;
        double theta = this.getAngleAtRadius(radius, this.outputProjectionType, this.outputFOV);
        double rSource = rOut;
        if (RECTILINEAR.equals(this.sourceProjectionType)) {
            double L = this.pixelsToCorner / Math.tan(this.sourceFOV / 2.0);
            rSource = L * Math.tan(theta);
        } else if (EQUIDISTANT.equals(this.sourceProjectionType)) {
            double L = 2.0 * this.pixelsToCorner / this.sourceFOV;
            rSource = L * theta;
        } else if (EQUISOLID.equals(this.sourceProjectionType)) {
            double twoL = this.pixelsToCorner / Math.sin(this.sourceFOV / 4.0);
            rSource = twoL * Math.sin(theta / 2.0);
        } else if (STEREOGRAPHIC.equals(this.sourceProjectionType)) {
            double twoL = this.pixelsToCorner / Math.tan(this.sourceFOV / 4.0);
            rSource = twoL * Math.tan(theta / 2.0);
        } else if (ORTHOGRAPHIC.equals(this.sourceProjectionType)) {
            double L = this.pixelsToCorner / Math.sin(this.sourceFOV / 2.0);
            rSource = L * Math.sin(theta);
        }
        return rSource / rOut;
    }

    private int getColor(double x, double y, int w, int h, int[] pixelValues) {
        double v;
        int col = (int)Math.floor(x);
        int row = (int)Math.floor(y);
        if (col < 0 || col >= w || row < 0 || row >= h) {
            return 0;
        }
        if (col + 1 == w || row + 1 == h) {
            return pixelValues[row * w + col];
        }
        double u = col == 0 ? x : x % (double)col;
        double d = v = row == 0 ? y : y % (double)row;
        if (this.interpolation == 2) {
            int[] values = new int[]{pixelValues[row * w + col], pixelValues[row * w + col + 1], pixelValues[(row + 1) * w + col], pixelValues[(row + 1) * w + col + 1]};
            int[] rgb = new int[4];
            int j = 0;
            while (j < 4) {
                rgb[j] = values[j] >> 16 & 0xFF;
                ++j;
            }
            int r = this.bilinearInterpolation(u, v, rgb);
            int j2 = 0;
            while (j2 < 4) {
                rgb[j2] = values[j2] >> 8 & 0xFF;
                ++j2;
            }
            int g = this.bilinearInterpolation(u, v, rgb);
            int j3 = 0;
            while (j3 < 4) {
                rgb[j3] = values[j3] & 0xFF;
                ++j3;
            }
            int b = this.bilinearInterpolation(u, v, rgb);
            return r << 16 | g << 8 | b;
        }
        return u < 0.5 ? (v < 0.5 ? pixelValues[row * w + col] : pixelValues[(row + 1) * w + col]) : (v < 0.5 ? pixelValues[row * w + col + 1] : pixelValues[(row + 1) * w + col + 1]);
    }

    private int bilinearInterpolation(double x, double y, int[] values) {
        return (int)((1.0 - y) * ((1.0 - x) * (double)values[0] + x * (double)values[2]) + y * ((1.0 - x) * (double)values[1] + x * (double)values[3]));
    }

    public boolean superIsEnabled() {
        return super.isEnabled();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Circle
    implements Trackable {
        TPoint center = new TPoint();
        TPoint corner = new TPoint();
        Ellipse2D ellipse = new Ellipse2D.Double();
        Stroke stroke = new BasicStroke(2.0f);

        private Circle() {
        }

        @Override
        public void draw(DrawingPanel panel, Graphics g) {
            if (!RadialDistortionFilter.this.superIsEnabled()) {
                return;
            }
            VideoPanel vidPanel = (VideoPanel)panel;
            Dimension d = vidPanel.getVideo().getImageSize(true);
            double x = d.width / 2;
            double y = d.height / 2;
            double r = RadialDistortionFilter.this.fixedRadius * RadialDistortionFilter.this.pixelsToCorner;
            this.center.setLocation(x, y);
            this.corner.setLocation(x - r, y - r);
            Point centerScreen = this.center.getScreenPosition(vidPanel);
            Point cornerScreen = this.corner.getScreenPosition(vidPanel);
            this.ellipse.setFrameFromCenter(centerScreen, cornerScreen);
            Shape shape = this.stroke.createStrokedShape(this.ellipse);
            Graphics2D g2 = (Graphics2D)g;
            Color gcolor = g2.getColor();
            g2.setColor(RadialDistortionFilter.this.color);
            if (OSPRuntime.setRenderingHints) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2.fill(shape);
            g2.setColor(gcolor);
        }
    }

    private class Inspector
    extends Filter.InspectorDlg {
        JButton helpButton;
        JButton colorButton;
        JPanel contentPane;
        JSlider radiusSlider;
        JSlider sourceAngleSlider;
        JComboBox<String> sourceTypeDropdown;
        JComboBox<String> outputTypeDropdown;
        JLabel radiusLabel;
        JLabel sourceAngleLabel;
        JLabel outputAngleLabel;
        JLabel sourceTypeLabel;
        JLabel outputTypeLabel;
        IntegerField radiusField;
        IntegerField sourceAngleField;
        IntegerField outputAngleField;
        TitledBorder sourceBorder;
        TitledBorder outputBorder;
        TitledBorder circleBorder;

        public Inspector() {
            super("RadialDistortionFilter.Inspector.Title");
        }

        @Override
        void createGUI() {
            this.helpButton = new JButton();
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = String.valueOf(MediaRes.getString("RadialDistortionFilter.Help.Message1")) + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message2") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message3") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message4") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message5") + "\n\n" + MediaRes.getString("RadialDistortionFilter.Help.Message6") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message7");
                    int i = 0;
                    while (i < PROJECTION_TYPES.size()) {
                        String type = PROJECTION_TYPES.get(i);
                        s = String.valueOf(s) + "\n    " + (i + 1) + ". " + MediaRes.getString("RadialDistortionFilter.Help.Message." + type);
                        ++i;
                    }
                    s = String.valueOf(s) + "\n\n" + MediaRes.getString("RadialDistortionFilter.Help.Message8") + "\n    " + MediaRes.getString("RadialDistortionFilter.Help.Message9") + "\n    " + MediaRes.getString("RadialDistortionFilter.Help.Message10") + "\n    " + MediaRes.getString("RadialDistortionFilter.Help.Message11");
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(((Inspector)Inspector.this).RadialDistortionFilter.this.vidPanel), s, MediaRes.getString("RadialDistortionFilter.Help.Title"), 1);
                }
            });
            this.colorButton = new JButton();
            this.colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPRuntime.chooseColor(RadialDistortionFilter.this.color, MediaRes.getString("PerspectiveFilter.Dialog.Color.Title"), newColor -> {
                        if (newColor != null) {
                            RadialDistortionFilter.this.color = newColor;
                            Inspector.this.firePropertyChange("filter_color", null, newColor);
                        }
                    });
                }
            });
            Border space = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            String[] types = RadialDistortionFilter.this.getProjectionTypeDescriptions();
            this.sourceTypeDropdown = new JComboBox<String>(types);
            this.sourceTypeDropdown.setSelectedItem(MediaRes.getString("RadialDistortionFilter.ProjectionType." + RadialDistortionFilter.this.sourceProjectionType));
            this.sourceTypeDropdown.setBorder(space);
            this.sourceTypeDropdown.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String desired = Inspector.this.sourceTypeDropdown.getSelectedItem().toString();
                    String[] types = RadialDistortionFilter.this.getProjectionTypeDescriptions();
                    int i = 0;
                    while (i < types.length) {
                        if (types[i].equals(desired)) {
                            RadialDistortionFilter.this.setSourceProjectionType(PROJECTION_TYPES.get(i));
                        }
                        ++i;
                    }
                }
            });
            this.outputTypeDropdown = new JComboBox<String>(types);
            this.outputTypeDropdown.setSelectedItem(MediaRes.getString("RadialDistortionFilter.ProjectionType." + RadialDistortionFilter.this.outputProjectionType));
            this.outputTypeDropdown.setBorder(space);
            this.outputTypeDropdown.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String desired = Inspector.this.outputTypeDropdown.getSelectedItem().toString();
                    String[] types = RadialDistortionFilter.this.getProjectionTypeDescriptions();
                    int i = 0;
                    while (i < types.length) {
                        if (types[i].equals(desired)) {
                            RadialDistortionFilter.this.setOutputProjectionType(PROJECTION_TYPES.get(i));
                        }
                        ++i;
                    }
                }
            });
            space = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            this.sourceAngleSlider = new JSlider(5, 180, 90);
            this.sourceAngleSlider.setBorder(space);
            this.sourceAngleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int n = Inspector.this.sourceAngleSlider.getValue();
                    RadialDistortionFilter.this.setSourceFOV((double)n * Math.PI / 180.0);
                }
            });
            int rMax = (int)(100.0 * maxRadius);
            int rMin = (int)(100.0 * minRadius);
            int rFixed = (int)(100.0 * RadialDistortionFilter.this.fixedRadius);
            this.radiusSlider = new JSlider(rMin, rMax, rFixed);
            this.radiusSlider.setBorder(space);
            this.radiusSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = Inspector.this.radiusSlider.getValue();
                    i = Math.max(i, RadialDistortionFilter.this.lowerRadiusLimit);
                    RadialDistortionFilter.this.setFixedRadius((double)i / 100.0);
                }
            });
            this.radiusSlider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Inspector.this.updateDisplay();
                }
            });
            space = BorderFactory.createEmptyBorder(2, 4, 2, 2);
            this.sourceTypeLabel = new JLabel();
            this.sourceTypeLabel.setBorder(space);
            this.outputTypeLabel = new JLabel();
            this.outputTypeLabel.setBorder(space);
            this.sourceAngleLabel = new JLabel();
            this.sourceAngleLabel.setBorder(space);
            this.outputAngleLabel = new JLabel();
            this.outputAngleLabel.setBorder(space);
            this.radiusLabel = new JLabel();
            this.radiusLabel.setBorder(space);
            this.sourceAngleField = new IntegerField(3);
            this.sourceAngleField.setMaxValue(180.0);
            this.sourceAngleField.setMinValue(5.0);
            this.sourceAngleField.setUnits("\u00b0");
            this.sourceAngleField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int n = Inspector.this.sourceAngleField.getIntValue();
                    RadialDistortionFilter.this.setSourceFOV((double)n * Math.PI / 180.0);
                    Inspector.this.updateDisplay();
                    Inspector.this.sourceAngleField.selectAll();
                }
            });
            this.sourceAngleField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Inspector.this.sourceAngleField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    int n = Inspector.this.sourceAngleField.getIntValue();
                    RadialDistortionFilter.this.setSourceFOV((double)n * Math.PI / 180.0);
                    Inspector.this.updateDisplay();
                }
            });
            this.outputAngleField = new IntegerField(3);
            this.outputAngleField.setMaxValue(180.0);
            this.outputAngleField.setMinValue(0.0);
            this.outputAngleField.setEditable(false);
            this.outputAngleField.setUnits("\u00b0");
            this.radiusField = new IntegerField(3);
            this.radiusField.setMaxValue(rMax);
            this.radiusField.setMinValue(rMin);
            this.radiusField.setUnits("%");
            this.radiusField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int n = Inspector.this.radiusField.getIntValue();
                    RadialDistortionFilter.this.setFixedRadius((double)n / 100.0);
                    Inspector.this.updateDisplay();
                    Inspector.this.radiusField.selectAll();
                }
            });
            this.radiusField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Inspector.this.radiusField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    int n = Inspector.this.radiusField.getIntValue();
                    RadialDistortionFilter.this.setFixedRadius((double)n / 100.0);
                    Inspector.this.updateDisplay();
                }
            });
            this.contentPane = new JPanel(new BorderLayout());
            this.setContentPane(this.contentPane);
            JPanel buttonbar = new JPanel(new FlowLayout());
            this.contentPane.add((Component)buttonbar, "South");
            buttonbar.add(this.helpButton);
            buttonbar.add(this.colorButton);
            buttonbar.add(RadialDistortionFilter.this.ableButton);
            buttonbar.add(RadialDistortionFilter.this.closeButton);
            space = BorderFactory.createEmptyBorder(2, 2, 2, 4);
            Box controlPanel = Box.createVerticalBox();
            this.contentPane.add((Component)controlPanel, "Center");
            Box sourceStack = Box.createVerticalBox();
            this.sourceBorder = BorderFactory.createTitledBorder("");
            sourceStack.setBorder(this.sourceBorder);
            controlPanel.add(sourceStack);
            Box box = Box.createHorizontalBox();
            box.setBorder(space);
            box.add(this.sourceTypeLabel);
            box.add(this.sourceTypeDropdown);
            box.add(this.sourceAngleLabel);
            box.add(this.sourceAngleField);
            sourceStack.add(box);
            box = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            box.add(this.sourceAngleSlider);
            sourceStack.add(box);
            Box outputStack = Box.createVerticalBox();
            this.outputBorder = BorderFactory.createTitledBorder("");
            outputStack.setBorder(this.outputBorder);
            controlPanel.add(outputStack);
            box = Box.createHorizontalBox();
            box.setBorder(space);
            box.add(this.outputTypeLabel);
            box.add(this.outputTypeDropdown);
            box.add(this.outputAngleLabel);
            box.add(this.outputAngleField);
            outputStack.add(box);
            Box circleBox = Box.createVerticalBox();
            this.circleBorder = BorderFactory.createTitledBorder("");
            circleBox.setBorder(this.circleBorder);
            controlPanel.add(circleBox);
            box = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            box.add(this.radiusLabel);
            box.add(this.radiusField);
            box.add(this.radiusSlider);
            circleBox.add(box);
        }

        void refreshGUI() {
            this.setTitle(MediaRes.getString("RadialDistortionFilter.Inspector.Title"));
            this.sourceTypeLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.ProjectionType")) + ":");
            this.outputTypeLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.ProjectionType")) + ":");
            this.sourceAngleLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.Angle")) + ":");
            this.outputAngleLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.Angle")) + ":");
            this.radiusLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.Diameter")) + ":");
            this.helpButton.setText(MediaRes.getString("PerspectiveFilter.Button.Help"));
            this.colorButton.setText(MediaRes.getString("PerspectiveFilter.Button.Color"));
            this.sourceBorder.setTitle(MediaRes.getString("RadialDistortionFilter.BorderTitle.Source"));
            this.outputBorder.setTitle(MediaRes.getString("RadialDistortionFilter.BorderTitle.Output"));
            this.circleBorder.setTitle(MediaRes.getString("RadialDistortionFilter.BorderTitle.Circle"));
            boolean enabled = RadialDistortionFilter.this.isEnabled();
            this.sourceTypeLabel.setEnabled(enabled);
            this.outputTypeLabel.setEnabled(enabled);
            this.radiusLabel.setEnabled(enabled);
            this.sourceAngleLabel.setEnabled(enabled);
            this.outputAngleLabel.setEnabled(enabled);
            this.radiusField.setEnabled(enabled);
            this.sourceAngleField.setEnabled(enabled);
            this.outputAngleField.setEnabled(enabled);
            this.radiusSlider.setEnabled(enabled);
            this.sourceAngleSlider.setEnabled(enabled);
            this.sourceTypeDropdown.setEnabled(enabled);
            this.outputTypeDropdown.setEnabled(enabled);
            this.colorButton.setEnabled(enabled);
            Color color = enabled ? GUIUtils.getEnabledTextColor() : GUIUtils.getDisabledTextColor();
            this.sourceBorder.setTitleColor(color);
            this.outputBorder.setTitleColor(color);
            this.circleBorder.setTitleColor(color);
            this.repaint();
        }

        void initialize() {
            this.updateDisplay();
        }

        void updateDisplay() {
            if (RadialDistortionFilter.this.updatingDisplay) {
                return;
            }
            RadialDistortionFilter.this.updatingDisplay = true;
            RadialDistortionFilter.this.refreshScale();
            int n = (int)Math.round(180.0 * RadialDistortionFilter.this.sourceFOV / Math.PI);
            this.sourceAngleField.setIntValue(n);
            this.sourceAngleSlider.setValue(n);
            n = (int)Math.round(180.0 * RadialDistortionFilter.this.outputFOV / Math.PI);
            this.outputAngleField.setIntValue(n);
            n = (int)Math.round(100.0 * RadialDistortionFilter.this.fixedRadius);
            this.radiusSlider.setValue(n);
            this.radiusField.setIntValue(n);
            RadialDistortionFilter.this.updatingDisplay = false;
        }

        @Override
        public void setVisible(boolean vis) {
            super.setVisible(vis);
            if (vis) {
                this.refreshGUI();
            }
            if (RadialDistortionFilter.this.vidPanel != null) {
                if (vis) {
                    RadialDistortionFilter.this.vidPanel.addDrawable(RadialDistortionFilter.this.circle);
                    this.firePropertyChange("filter_visible", null, null);
                    RadialDistortionFilter.this.addPropertyChangeListener("filter_visible", RadialDistortionFilter.this.vidPanel);
                } else {
                    RadialDistortionFilter.this.vidPanel.removeDrawable(RadialDistortionFilter.this.circle);
                    this.firePropertyChange("filter_visible", null, null);
                    RadialDistortionFilter.this.removePropertyChangeListener("filter_visible", RadialDistortionFilter.this.vidPanel);
                }
            }
            this.firePropertyChange("image", null, null);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            RadialDistortionFilter filter = (RadialDistortionFilter)obj;
            control.setValue("fixed_radius", filter.fixedRadius);
            control.setValue("input_type", filter.sourceProjectionType);
            control.setValue("input_fov", filter.sourceFOV);
            control.setValue("output_type", filter.outputProjectionType);
            control.setValue("color", filter.color);
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new RadialDistortionFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            RadialDistortionFilter filter = (RadialDistortionFilter)obj;
            filter.setFixedRadius(control.getDouble("fixed_radius"));
            filter.setSourceFOV(control.getDouble("input_fov"));
            filter.setSourceProjectionType(control.getString("input_type"));
            filter.setOutputProjectionType(control.getString("output_type"));
            Color color = (Color)control.getObject("color");
            if (color != null) {
                filter.color = color;
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

