/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;

public class ResizeFilter
extends Filter {
    private Graphics2D gOut;
    private Inspector inspector;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JLabel inputLabel;
    private JLabel outputLabel;
    private IntegerField widthInField;
    private IntegerField heightInField;
    private IntegerField widthOutField;
    private IntegerField heightOutField;

    public ResizeFilter() {
        this.hasInspector = true;
        this.autoScale720x480 = true;
    }

    public void setWidthFactor(double factor) {
        this.source = null;
        Double prev = this.widthFactor;
        this.widthFactor = Math.min(Math.abs(factor), 10.0);
        this.widthFactor = Math.max(this.widthFactor, 0.01);
        this.firePropertyChange("width", prev, this.widthFactor);
    }

    public void setHeightFactor(double factor) {
        this.source = null;
        Double prev = this.heightFactor;
        this.heightFactor = Math.min(Math.abs(factor), 10.0);
        this.heightFactor = Math.max(this.heightFactor, 0.01);
        this.firePropertyChange("height", prev, this.heightFactor);
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public double getHeightFactor() {
        return this.heightFactor;
    }

    @Override
    protected void initializeSubclass() {
    }

    @Override
    protected void setOutputPixels() {
        AffineTransform transform = AffineTransform.getScaleInstance(this.widthFactor, this.heightFactor);
        this.gOut = this.output.createGraphics();
        this.gOut.setTransform(transform);
        this.gOut.drawImage((Image)this.input, 0, 0, null);
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        return this.inspector;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.widthLabel.setText(MediaRes.getString("Filter.Resize.Label.Width"));
        this.heightLabel.setText(MediaRes.getString("Filter.Resize.Label.Height"));
        this.inputLabel.setText(MediaRes.getString("Filter.Resize.Label.Input"));
        this.outputLabel.setText(MediaRes.getString("Filter.Resize.Label.Output"));
        boolean enabled = this.isEnabled();
        this.inputLabel.setEnabled(enabled);
        this.outputLabel.setEnabled(enabled);
        this.heightLabel.setEnabled(enabled);
        this.widthLabel.setEnabled(enabled);
        this.widthInField.setEnabled(enabled);
        this.heightInField.setEnabled(enabled);
        this.widthOutField.setEnabled(enabled);
        this.heightOutField.setEnabled(enabled);
        int wOut = (int)((double)this.w * this.widthFactor);
        int hOut = (int)((double)this.h * this.heightFactor);
        this.widthInField.setIntValue(this.w);
        this.widthOutField.setIntValue(wOut);
        this.heightInField.setIntValue(this.h);
        this.heightOutField.setIntValue(hOut);
        this.inspector.setTitle(MediaRes.getString("Filter.Resize.Title"));
        this.inspector.pack();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super("Filter.Resize.Title");
        }

        @Override
        void createGUI() {
            ResizeFilter.this.inputLabel = new JLabel();
            ResizeFilter.this.outputLabel = new JLabel();
            ResizeFilter.this.widthLabel = new JLabel();
            ResizeFilter.this.widthInField = new IntegerField(4);
            ResizeFilter.this.widthInField.setEditable(false);
            ResizeFilter.this.widthInField.applyPattern("0");
            ResizeFilter.this.widthOutField = new IntegerField(4);
            ResizeFilter.this.widthOutField.applyPattern("0");
            ResizeFilter.this.widthOutField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResizeFilter.this.setWidthFactor(1.0 * (double)ResizeFilter.this.widthOutField.getIntValue() / (double)((Inspector)Inspector.this).ResizeFilter.this.w);
                    ResizeFilter.this.refresh();
                    ResizeFilter.this.widthOutField.selectAll();
                }
            });
            ResizeFilter.this.widthOutField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ResizeFilter.this.widthOutField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ResizeFilter.this.setWidthFactor(1.0 * (double)ResizeFilter.this.widthOutField.getIntValue() / (double)((Inspector)Inspector.this).ResizeFilter.this.w);
                    ResizeFilter.this.refresh();
                }
            });
            ResizeFilter.this.heightLabel = new JLabel();
            ResizeFilter.this.heightInField = new IntegerField(4);
            ResizeFilter.this.heightInField.setEditable(false);
            ResizeFilter.this.heightInField.applyPattern("0");
            ResizeFilter.this.heightOutField = new IntegerField(4);
            ResizeFilter.this.heightOutField.applyPattern("0");
            ResizeFilter.this.heightOutField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResizeFilter.this.setHeightFactor(1.0 * (double)ResizeFilter.this.heightOutField.getIntValue() / (double)((Inspector)Inspector.this).ResizeFilter.this.h);
                    ResizeFilter.this.refresh();
                    ResizeFilter.this.heightOutField.selectAll();
                }
            });
            ResizeFilter.this.heightOutField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ResizeFilter.this.heightOutField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ResizeFilter.this.setHeightFactor(1.0 * (double)ResizeFilter.this.heightOutField.getIntValue() / (double)((Inspector)Inspector.this).ResizeFilter.this.h);
                    ResizeFilter.this.refresh();
                }
            });
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            GridBagLayout gridbag = new GridBagLayout();
            JPanel panel = new JPanel(gridbag);
            contentPane.add((Component)panel, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            c.fill = 0;
            c.weightx = 0.5;
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(4, 2, 0, 2);
            gridbag.setConstraints(ResizeFilter.this.widthLabel, c);
            panel.add(ResizeFilter.this.widthLabel);
            c.gridx = 2;
            c.insets = new Insets(4, 0, 0, 8);
            gridbag.setConstraints(ResizeFilter.this.heightLabel, c);
            panel.add(ResizeFilter.this.heightLabel);
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 13;
            c.insets = new Insets(0, 4, 0, 2);
            c.weightx = 0.2;
            gridbag.setConstraints(ResizeFilter.this.inputLabel, c);
            panel.add(ResizeFilter.this.inputLabel);
            c.gridy = 2;
            gridbag.setConstraints(ResizeFilter.this.outputLabel, c);
            panel.add(ResizeFilter.this.outputLabel);
            c.gridy = 1;
            c.gridx = 1;
            c.anchor = 10;
            c.insets = new Insets(4, 2, 0, 2);
            gridbag.setConstraints(ResizeFilter.this.widthInField, c);
            panel.add(ResizeFilter.this.widthInField);
            c.gridx = 2;
            c.insets = new Insets(4, 0, 0, 8);
            gridbag.setConstraints(ResizeFilter.this.heightInField, c);
            panel.add(ResizeFilter.this.heightInField);
            c.gridy = 2;
            c.gridx = 1;
            c.insets = new Insets(4, 2, 0, 2);
            gridbag.setConstraints(ResizeFilter.this.widthOutField, c);
            panel.add(ResizeFilter.this.widthOutField);
            c.gridx = 2;
            c.insets = new Insets(4, 0, 0, 8);
            gridbag.setConstraints(ResizeFilter.this.heightOutField, c);
            panel.add(ResizeFilter.this.heightOutField);
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(ResizeFilter.this.ableButton);
            buttonbar.add(ResizeFilter.this.closeButton);
            contentPane.add((Component)buttonbar, "South");
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ResizeFilter filter = (ResizeFilter)obj;
            control.setValue("width_factor", filter.widthFactor);
            control.setValue("height_factor", filter.heightFactor);
            if (filter.getFrame() != null && filter.inspector != null && filter.inspector.isVisible()) {
                int x = ((ResizeFilter)filter).inspector.getLocation().x - filter.frame.getLocation().x;
                int y = ((ResizeFilter)filter).inspector.getLocation().y - filter.frame.getLocation().y;
                control.setValue("inspector_x", x);
                control.setValue("inspector_y", y);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new ResizeFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ResizeFilter filter = (ResizeFilter)obj;
            if (control.getPropertyNamesRaw().contains("width_factor")) {
                filter.setWidthFactor(control.getDouble("width_factor"));
            }
            if (control.getPropertyNamesRaw().contains("height_factor")) {
                filter.setHeightFactor(control.getDouble("height_factor"));
            }
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

