/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.tools.ResourceLoader;

public class RotateFilter
extends Filter {
    private static final int[] types;
    private static final String[] typeNames;
    private static Icon cwIcon;
    private static Icon ccwIcon;
    private Inspector inspector;
    private JRadioButtonMenuItem[] buttons = new JRadioButtonMenuItem[4];
    private ButtonGroup buttonGroup;
    private JCheckBox reverseCheckbox;
    private JComponent rotationPanel;
    private JComponent reversePanel;
    private boolean reverse;

    static {
        int[] nArray = new int[4];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 2;
        types = nArray;
        typeNames = new String[]{"None", "CCW", "CW", "180"};
        String path = "/org/opensourcephysics/resources/media/images/cw.gif";
        cwIcon = ResourceLoader.getImageIcon(path);
        path = "/org/opensourcephysics/resources/media/images/ccw.gif";
        ccwIcon = ResourceLoader.getImageIcon(path);
    }

    public RotateFilter() {
        this.refresh();
        this.hasInspector = true;
    }

    private void setRotationType(int type) {
        if (type != this.rotationType) {
            this.rotationType = type;
            this.source = null;
            this.firePropertyChange("rotate", null, null);
        }
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.rotationPanel.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("Filter.Rotate.Label.Rotate")));
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setEnabled(this.isEnabled());
            this.buttons[i].setText(MediaRes.getString("Filter.Rotate.Button." + typeNames[i]));
            ++i;
        }
        this.reverseCheckbox.setText(MediaRes.getString("Filter.Rotate.Checkbox.Reverse"));
        this.reverseCheckbox.setSelected(this.reverse);
        this.inspector.setTitle(MediaRes.getString("Filter.Rotate.Title"));
    }

    @Override
    protected void initializeSubclass() {
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int[] pixels = this.pixelsIn == this.pixelsOut ? new int[this.nPixelsIn] : this.pixelsOut;
        int last = this.w * this.h - 1;
        if (this.rotationType == -1 && !this.reverse) {
            if (this.pixelsOut == this.pixelsIn) {
                return;
            }
            System.arraycopy(this.pixelsIn, 0, pixels, 0, this.nPixelsIn);
        } else {
            if (this.rotationType == -1) {
                int i = 0;
                while (i < this.nPixelsIn) {
                    int row = i / this.w;
                    int col = this.w - i % this.w - 1;
                    pixels[this.w * row + col] = this.pixelsIn[i];
                    ++i;
                }
            } else if (this.rotationType == 1) {
                if (this.reverse) {
                    int i = 0;
                    while (i < this.nPixelsIn) {
                        int col = this.h - i / this.w - 1;
                        int row = this.w - i % this.w - 1;
                        pixels[this.h * row + col] = this.pixelsIn[i];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.nPixelsIn) {
                        int col = this.h - i / this.w - 1;
                        int row = i % this.w;
                        pixels[this.h * row + col] = this.pixelsIn[i];
                        ++i;
                    }
                }
            } else if (this.rotationType == 0) {
                if (this.reverse) {
                    int i = 0;
                    while (i < this.nPixelsIn) {
                        int col = i / this.w;
                        int row = i % this.w;
                        pixels[this.h * row + col] = this.pixelsIn[i];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.nPixelsIn) {
                        int col = i / this.w;
                        int row = this.w - i % this.w - 1;
                        pixels[this.h * row + col] = this.pixelsIn[i];
                        ++i;
                    }
                }
            } else if (this.reverse) {
                int i = 0;
                while (i < this.nPixelsIn) {
                    int row = this.h - i / this.w - 1;
                    int col = i % this.w;
                    pixels[this.w * row + col] = this.pixelsIn[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.nPixelsIn) {
                    pixels[last - i] = this.pixelsIn[i];
                    ++i;
                }
            }
            if (this.pixelsOut == this.pixelsIn) {
                System.arraycopy(pixels, 0, this.pixelsIn, 0, this.nPixelsIn);
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super("Filter.Rotate.Title");
        }

        @Override
        void createGUI() {
            int leftBorder = 40;
            RotateFilter.this.rotationPanel = Box.createVerticalBox();
            RotateFilter.this.buttonGroup = new ButtonGroup();
            ActionListener selector = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < RotateFilter.this.buttons.length) {
                        if (RotateFilter.this.buttons[i].isSelected()) {
                            RotateFilter.this.setRotationType(types[i]);
                            break;
                        }
                        ++i;
                    }
                }
            };
            int i = 0;
            while (i < RotateFilter.this.buttons.length) {
                ((RotateFilter)RotateFilter.this).buttons[i] = new JRadioButtonMenuItem();
                RotateFilter.this.buttons[i].setSelected(RotateFilter.this.rotationType == types[i]);
                RotateFilter.this.buttons[i].addActionListener(selector);
                RotateFilter.this.buttons[i].setBorder(BorderFactory.createEmptyBorder(2, leftBorder, 2, 2));
                RotateFilter.this.buttons[i].setHorizontalTextPosition(2);
                if (types[i] == 1) {
                    RotateFilter.this.buttons[i].setIcon(cwIcon);
                } else if (types[i] == 0) {
                    RotateFilter.this.buttons[i].setIcon(ccwIcon);
                }
                RotateFilter.this.buttonGroup.add(RotateFilter.this.buttons[i]);
                RotateFilter.this.rotationPanel.add(RotateFilter.this.buttons[i]);
                ++i;
            }
            RotateFilter.this.reversePanel = Box.createVerticalBox();
            RotateFilter.this.reverseCheckbox = new JCheckBox();
            RotateFilter.this.reverseCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RotateFilter.this.reverse = RotateFilter.this.reverseCheckbox.isSelected();
                    RotateFilter.this.firePropertyChange("rotate", null, null);
                }
            });
            RotateFilter.this.reversePanel.add(RotateFilter.this.reverseCheckbox);
            RotateFilter.this.reverseCheckbox.setBorder(BorderFactory.createEmptyBorder(2, leftBorder + 7, 2, 2));
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            contentPane.add((Component)RotateFilter.this.rotationPanel, "North");
            contentPane.add((Component)RotateFilter.this.reversePanel, "Center");
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(RotateFilter.this.ableButton);
            buttonbar.add(RotateFilter.this.closeButton);
            contentPane.add((Component)buttonbar, "South");
        }

        void initialize() {
            RotateFilter.this.refresh();
            this.updateDisplay();
        }

        void updateDisplay() {
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            RotateFilter filter = (RotateFilter)obj;
            if (filter.rotationType > -1) {
                control.setValue("rotation", typeNames[filter.rotationType + 1]);
            }
            control.setValue("reverse", filter.reverse);
            if (filter.getFrame() != null && filter.inspector != null && filter.inspector.isVisible()) {
                int x = ((RotateFilter)filter).inspector.getLocation().x - filter.frame.getLocation().x;
                int y = ((RotateFilter)filter).inspector.getLocation().y - filter.frame.getLocation().y;
                control.setValue("inspector_x", x);
                control.setValue("inspector_y", y);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new RotateFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            RotateFilter filter = (RotateFilter)obj;
            String typeName = control.getString("rotation");
            int i = 0;
            while (i < typeNames.length) {
                if (typeNames[i].equals(typeName)) {
                    filter.rotationType = types[i];
                }
                ++i;
            }
            filter.reverse = control.getBoolean("reverse");
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

