/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;

public abstract class ScratchVideoRecorder
implements VideoRecorder {
    protected static JFileChooser chooser;
    protected static JTextComponent chooserField;
    protected static String ext;
    protected static boolean ignoreChooser;
    protected static String tempDirectory;
    protected static String tempFilePrefix;
    protected VideoType videoType;
    protected Dimension dim;
    protected Image frameImage;
    protected double frameDuration = 100.0;
    protected int frameCount;
    protected String scratchName;
    protected int scratchNumber = 0;
    protected File scratchFile;
    protected boolean canRecord;
    protected boolean hasContent;
    protected boolean isSaved;
    protected File saveFile = null;
    protected boolean saveChanges = false;
    protected String tempFileBasePath;
    protected String tempFileType = "png";
    protected ArrayList<File> tempFiles = new ArrayList();
    protected String suggestedFileName;
    protected String chosenExtension;
    protected String baseDir;

    static {
        tempFilePrefix = "osp_";
    }

    public ScratchVideoRecorder(VideoType vidType) {
        this.videoType = vidType;
        ext = this.videoType.getDefaultExtension();
        SimpleDateFormat formatter = new SimpleDateFormat("ssSSS");
        this.scratchName = String.valueOf(tempFilePrefix) + formatter.format(new Date());
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            this.createScratch();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
            chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    VideoFileFilter vidFilter;
                    String ext;
                    FileFilter filter;
                    if (!ignoreChooser && (filter = (FileFilter)e.getNewValue()) instanceof VideoFileFilter && (ext = (vidFilter = (VideoFileFilter)filter).getDefaultExtension()) != null) {
                        ScratchVideoRecorder.setChooserExtension(ext);
                    }
                }
            });
            String temp = "untitled.tmp";
            chooser.setSelectedFile(new File(temp));
            chooserField = this.getTextComponent(chooser, temp);
        }
    }

    @Override
    public void createVideo() throws IOException {
        if (this.scratchFile == null) {
            this.createScratch();
            if (this.scratchFile == null) {
                OSPLog.severe("No scratch file");
                return;
            }
        }
        if (this.scratchFile != null && this.hasContent) {
            String query;
            int n;
            if (this.saveChanges && !this.isSaved && (n = JOptionPane.showConfirmDialog(null, query = MediaRes.getString("ScratchVideoRecorder.Dialog.SaveVideo.Message"), MediaRes.getString("ScratchVideoRecorder.Dialog.SaveVideo.Title"), 0)) == 0) {
                this.saveVideo();
            }
            this.createScratch();
            this.saveFile = null;
            this.dim = null;
        }
    }

    @Override
    public void createVideo(String fileName) throws IOException {
        this.createVideo(fileName, null);
    }

    @Override
    public void createVideo(String fileName, String trkPath) throws IOException {
        File file = null;
        if (fileName == null) {
            file = this.selectFile();
            if (file == null) {
                return;
            }
            fileName = file.getAbsolutePath();
        } else {
            file = new File(fileName);
        }
        this.baseDir = XML.getDirectoryPath(fileName);
        this.createVideo();
        this.saveFile = file;
    }

    @Override
    public void setSize(Dimension dimension) {
        this.dim = dimension;
    }

    @Override
    public void setFrameDuration(double millis) {
        this.frameDuration = millis;
    }

    @Override
    public void addFrame(Image image) throws IOException {
        if (image == null) {
            return;
        }
        this.frameImage = image;
        if (this.scratchFile == null || this.hasContent && this.isSaved) {
            this.createVideo();
        }
        if (this.scratchFile == null) {
            return;
        }
        if (!this.canRecord) {
            this.canRecord = this.startRecording();
            this.isSaved = false;
            this.hasContent = false;
        }
        if (this.canRecord && this.append(image)) {
            this.hasContent = true;
            ++this.frameCount;
        }
    }

    public VideoType getVideoType() {
        return this.videoType;
    }

    @Override
    public Video getVideo() throws IOException {
        if (this.isSaved && this.saveFile != null) {
            return this.videoType.getVideo(this.saveFile.getAbsolutePath());
        }
        this.saveScratch();
        return this.videoType.getVideo(this.scratchFile.getAbsolutePath());
    }

    @Override
    public String saveVideo() throws IOException {
        if (this.saveFile != null) {
            return this.saveVideo(this.saveFile.getAbsolutePath());
        }
        return this.saveVideoAs();
    }

    @Override
    public String saveVideo(String fileName) throws IOException {
        if (this.scratchFile == null) {
            return null;
        }
        if (fileName == null) {
            return this.saveVideoAs();
        }
        this.setFileName(fileName);
        if (this.saveFile == null) {
            throw new IOException("could not write to read-only file");
        }
        this.saveScratch();
        int buffer = 8192;
        byte[] data = new byte[buffer];
        int count = 0;
        int total = 0;
        FileInputStream fin = new FileInputStream(this.scratchFile);
        BufferedInputStream in = new BufferedInputStream(fin);
        FileOutputStream fout = new FileOutputStream(this.saveFile);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        while ((count = ((InputStream)in).read(data, 0, buffer)) != -1) {
            ((OutputStream)out).write(data, 0, count);
            total += count;
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
        this.isSaved = true;
        OSPLog.fine("copied " + total + " bytes from " + this.scratchFile.getName() + " to " + this.saveFile.getAbsolutePath());
        this.scratchFile.delete();
        return this.saveFile.getAbsolutePath();
    }

    @Override
    public String saveVideoAs() throws IOException {
        File file = this.selectFile();
        if (file != null) {
            return this.saveVideo(file.getAbsolutePath());
        }
        return null;
    }

    @Override
    public String getFileName() {
        return this.saveFile == null ? null : this.saveFile.getAbsolutePath();
    }

    @Override
    public void setFileName(String path) {
        if (this.saveFile != null && this.saveFile.getAbsolutePath().equals(path)) {
            return;
        }
        File file = new File(path);
        this.saveFile = file.exists() && !file.canWrite() ? null : file;
    }

    public void suggestFileName(String name) {
        this.suggestedFileName = name;
    }

    @Override
    public void reset() {
        if (this.scratchFile != null) {
            try {
                this.saveScratch();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scratchFile.delete();
        }
        this.hasContent = false;
    }

    public static void setChooserExtension(String extension) {
        if (extension != null) {
            ext = extension;
        }
        if (ext != null && chooser != null && chooser.isVisible()) {
            final String name = chooserField == null ? "*." + ext : String.valueOf(XML.stripExtension(chooserField.getText())) + "." + ext;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    File dir = chooser.getCurrentDirectory();
                    String path = XML.getResolvedPath(name, dir.getAbsolutePath());
                    chooser.setSelectedFile(new File(path));
                    if (chooserField != null) {
                        chooserField.setText(name);
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    protected void createScratch() throws IOException {
        if (this.hasContent || this.scratchFile == null) {
            String fileName = this.scratchName;
            if (this.hasContent) {
                fileName = String.valueOf(fileName) + "-" + this.scratchNumber++;
            }
            this.reset();
            fileName = String.valueOf(OSPRuntime.tempDir) + "/" + fileName + this.getScratchExtension();
            this.scratchFile = new File(fileName);
            this.hasContent = false;
            this.canRecord = false;
            OSPLog.finest(this.scratchFile.getAbsolutePath());
        }
    }

    protected String getScratchExtension() {
        return ".tmp";
    }

    protected File selectFile() {
        ignoreChooser = true;
        File file = null;
        String chooserExt = null;
        chooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveVideoAs.Title"));
        chooser.resetChoosableFileFilters();
        VideoFileFilter[] filters = this.videoType.getFileFilters();
        boolean isZipType = this.videoType instanceof VideoIO.ZipImageVideoType;
        if (filters != null && filters.length > 0) {
            VideoFileFilter preferred = this.videoType.getDefaultFileFilter();
            if (preferred == null) {
                preferred = filters[0];
            }
            chooserExt = ext = preferred.getDefaultExtension();
            if (isZipType) {
                VideoIO.ZipImageVideoType z = (VideoIO.ZipImageVideoType)this.videoType;
                ext = z.getImageExtension();
                VideoIO.ZipImageVideoType.checkZipContents = false;
            }
            chooser.setAcceptAllFileFilterUsed(false);
            int i = 0;
            while (i < filters.length) {
                chooser.addChoosableFileFilter(filters[i]);
                ++i;
            }
            chooser.setFileFilter(preferred);
        } else {
            chooser.setAcceptAllFileFilterUsed(true);
        }
        String filename = this.suggestedFileName;
        if (filename == null) {
            filename = MediaRes.getString("VideoIO.FileName.Untitled");
        }
        if (chooserExt != null) {
            filename = String.valueOf(filename) + "." + chooserExt;
        }
        chooser.setSelectedFile(new File(filename));
        if (chooserField != null) {
            chooserField.setText(filename);
        }
        ignoreChooser = false;
        int result = chooser.showSaveDialog(null);
        VideoIO.ZipImageVideoType.checkZipContents = true;
        if (result == 0) {
            file = chooser.getSelectedFile();
            file = this.getFileToBeSaved(file);
            this.chosenExtension = XML.getExtension(file.getName());
            if (file.exists()) {
                if (file.canWrite()) {
                    int selected = JOptionPane.showConfirmDialog(null, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 1);
                    if (selected != 0) {
                        file = null;
                    } else {
                        VideoIO.requiresReload(file.getPath());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
                    file = null;
                }
            }
        }
        return file;
    }

    protected File getFileToBeSaved(File file) {
        return file;
    }

    protected void finalize() {
        this.deleteTempFiles();
    }

    protected void deleteTempFiles() {
        this.deleteFiles(this.tempFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFiles(ArrayList<File> files) {
        if (files == null) {
            return;
        }
        ArrayList<File> arrayList = files;
        synchronized (arrayList) {
            for (File next : files) {
                next.delete();
            }
            files.clear();
        }
    }

    private JTextComponent getTextComponent(Container c, String toMatch) {
        Component[] comps = c.getComponents();
        int i = 0;
        while (i < comps.length) {
            JTextComponent tc;
            if (comps[i] instanceof JTextComponent && toMatch.equals(((JTextComponent)comps[i]).getText())) {
                return (JTextComponent)comps[i];
            }
            if (comps[i] instanceof Container && (tc = this.getTextComponent((Container)comps[i], toMatch)) != null) {
                return tc;
            }
            ++i;
        }
        return null;
    }

    protected abstract void saveScratch() throws IOException;

    protected abstract boolean startRecording();

    protected abstract boolean append(Image var1);

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            if (ScratchVideoRecorder.this.scratchFile != null) {
                try {
                    ScratchVideoRecorder.this.saveScratch();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ScratchVideoRecorder.this.scratchFile.delete();
            }
            ScratchVideoRecorder.this.deleteTempFiles();
        }
    }
}

