/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.VideoClip;

public class StepperClipControl
extends ClipControl {
    private static final double DELAY_STABILITY = 5.0;
    private Timer timer;
    private double frameDuration = 100.0;
    private double stepDuration;
    private boolean playing = false;
    private boolean readyToStep = true;
    private boolean stepDisplayed = true;
    private int minDelay = 0;
    private int maxDelay = 2000;
    private long startTime;
    private int timerDelay;
    private double processingTime = 10.0;
    private int playStepCount;
    private double playDuration;

    protected StepperClipControl(VideoClip videoClip) {
        super(videoClip);
        videoClip.addPropertyChangeListener(this);
        if (this.video != null) {
            if (this.video.getFrameCount() > 1 && this.video.isValid()) {
                this.frameDuration = this.video.getAverageFrameDuration(true);
            } else if (this.video instanceof ImageVideo) {
                this.frameDuration = ((ImageVideo)this.video).getFrameDuration(0);
            }
        }
        this.timer = new Timer(this.getTimerDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StepperClipControl.this.readyToStep = true;
                StepperClipControl.this.step();
            }
        });
        this.timer.setRepeats(false);
        this.timer.setCoalesce(false);
    }

    @Override
    public void play() {
        if (this.clip.getStepCount() == 1) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.playDuration = 0.0;
        this.playStepCount = 0;
        this.playing = true;
        this.readyToStep = true;
        if (this.stepNumber == this.clip.getStepCount() - 1) {
            this.setStepNumber(0);
        } else {
            this.timer.restart();
        }
        SwingUtilities.invokeLater(() -> this.firePropertyChange("playing", null, Boolean.TRUE));
    }

    @Override
    public void stop() {
        this.timer.stop();
        this.readyToStep = true;
        this.stepDisplayed = true;
        this.playing = false;
        this.firePropertyChange("playing", null, Boolean.FALSE);
    }

    @Override
    public void step() {
        if (this.stepNumber >= this.clip.getStepCount() - 1 && !this.looping) {
            this.stop();
        } else if (this.stepDisplayed && (!this.playing || this.readyToStep)) {
            this.stepDisplayed = false;
            if (this.stepNumber < this.clip.getStepCount() - 1) {
                this.setStepNumber(this.stepNumber + 1);
            } else if (this.looping) {
                this.setStepNumber(0);
            }
            if (this.playing) {
                long dt = System.currentTimeMillis() - this.startTime;
                this.playDuration += (double)dt;
                ++this.playStepCount;
                this.startTime += dt;
                this.timerDelay -= Math.round(Math.round(((double)dt - this.stepDuration) / 5.0));
                this.timerDelay = Math.min(this.maxDelay, Math.max(this.minDelay, this.timerDelay));
                this.timer.setInitialDelay(this.timerDelay);
                this.processingTime = this.stepDuration - (double)this.timerDelay;
                this.readyToStep = false;
                this.timer.restart();
            }
        }
    }

    @Override
    public void back() {
        if (this.stepDisplayed && this.stepNumber > 0) {
            this.stepDisplayed = false;
            this.setStepNumber(this.stepNumber - 1);
        }
    }

    @Override
    public void setStepNumber(int n0) {
        int step = Math.min(Math.max(0, n0), this.clip.getStepCount() - 1);
        if (step == this.stepNumber && this.clip.stepToFrame(step) == this.getFrameNumber()) {
            return;
        }
        if (this.video == null) {
            super.setStepNumber(step);
            this.stepDisplayed = true;
            this.firePropertyChange("stepnumber", null, step);
        } else {
            int frame = this.clip.stepToFrame(step);
            if (frame > this.video.getEndFrameNumber()) {
                super.setStepNumber(step);
                this.video.setVisible(false);
                this.stepDisplayed = true;
                this.firePropertyChange("stepnumber", null, step);
            } else {
                this.video.setVisible(this.videoVisible);
                SwingUtilities.invokeLater(() -> this.setStepNumberLater(frame, step));
            }
        }
    }

    protected void setStepNumberLater(int frame, int step) {
        if (this.videoFrameNumber == frame) {
            this.stepDisplayed = true;
        } else if (this.video.getFrameNumber() == frame) {
            super.setStepNumber(step);
            this.stepDisplayed = true;
            this.firePropertyChange("stepnumber", null, step);
        } else {
            this.video.setFrameNumber(frame);
        }
    }

    @Override
    public void setRate(double newRate) {
        if (newRate == 0.0 || newRate == this.rate) {
            return;
        }
        this.rate = Math.abs(newRate);
        this.timer.setInitialDelay(this.getTimerDelay());
        this.playDuration = 0.0;
        this.playStepCount = 0;
        this.firePropertyChange("rate", null, this.rate);
    }

    @Override
    public double getMeanFrameDuration() {
        if (this.video != null && this.video.isValid()) {
            return this.timeStretch * this.video.getAverageFrameDuration(true);
        }
        return this.frameDuration;
    }

    @Override
    public void setFrameDuration(double duration) {
        if ((duration = Math.abs(duration)) == 0.0 || duration == this.getMeanFrameDuration()) {
            return;
        }
        if (this.video instanceof ImageVideo) {
            ImageVideo iVideo = (ImageVideo)this.video;
            iVideo.setFrameDuration(duration);
            this.frameDuration = duration;
            this.timer.setInitialDelay(this.getTimerDelay());
        } else if (this.video != null && this.video.isValid()) {
            double ave = this.video.getAverageFrameDuration(false);
            if (ave > 0.0) {
                this.timeStretch = duration / ave;
            }
        } else {
            this.frameDuration = duration;
            this.timer.setInitialDelay(this.getTimerDelay());
        }
        this.firePropertyChange("frameduration", null, duration);
    }

    @Override
    public void setLooping(boolean loops) {
        if (loops == this.looping) {
            return;
        }
        this.looping = loops;
        this.firePropertyChange("looping", null, loops);
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public double getTime() {
        if (this.video != null && this.video.isValid()) {
            int n = this.video.getFrameNumber();
            double videoTime = this.video.getFrameTime(n);
            int m = this.clip.stepToFrame(this.getStepNumber());
            if (m > this.video.getFrameCount() - 1) {
                int extra = m - this.video.getFrameCount() + 1;
                videoTime = this.video.getFrameTime(this.video.getFrameCount() - 1) + (double)extra * this.frameDuration;
            }
            return (videoTime - this.video.getStartTime()) * this.timeStretch;
        }
        return (double)this.stepNumber * this.frameDuration * (double)this.clip.getStepSize();
    }

    @Override
    public double getStepTime(int stepNumber) {
        if (this.video != null && this.video.isValid()) {
            int n = this.clip.stepToFrame(stepNumber);
            double videoTime = this.video.getFrameTime(n);
            int nframes = this.video.getFrameCount();
            if (n > nframes - 1) {
                int extra = n - nframes + 1;
                videoTime = this.video.getFrameTime(nframes - 1) + (double)extra * this.frameDuration;
            }
            return (videoTime - this.video.getStartTime()) * this.timeStretch;
        }
        return (double)stepNumber * this.frameDuration * (double)this.clip.getStepSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name;
        switch (name = e.getPropertyName()) {
            case "stepsize": {
                this.timer.setInitialDelay(this.getTimerDelay());
                return;
            }
            case "framenumber": {
                this.stepDisplayed = true;
                super.propertyChange(e);
                if (this.playing) {
                    this.step();
                }
                return;
            }
        }
        super.propertyChange(e);
    }

    private int getTimerDelay() {
        double duration = this.frameDuration;
        if (this.video != null && this.video.isValid()) {
            duration = this.video.getAverageFrameDuration(true);
        }
        this.stepDuration = duration * (double)this.clip.getStepSize() / this.rate;
        int delay = Math.round(Math.round(this.stepDuration - this.processingTime));
        this.timerDelay = delay = Math.max(this.minDelay, Math.min(delay, this.maxDelay));
        return this.timerDelay;
    }

    @Override
    public double getMeasuredRate() {
        if (this.playStepCount > 0) {
            double measuredStepDuration = this.playDuration / (double)this.playStepCount;
            return this.rate * this.stepDuration / measuredStepDuration;
        }
        return this.rate;
    }

    public static XML.ObjectLoader getLoader() {
        return new ClipControl.Loader();
    }

    @Override
    public void dispose() {
        if (this.clip != null) {
            this.clip.removePropertyChangeListener(this);
            this.clip.dispose();
        }
        super.dispose();
    }
}

