/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class StrobeFilter
extends Filter {
    protected int[] prevPixels;
    private double fade;
    private double defaultFade = 0.0;
    private boolean brightTrails = false;
    private Inspector inspector;
    private JLabel fadeLabel;
    private NumberField fadeField;
    private JSlider fadeSlider;
    private JRadioButton darkButton;
    private JRadioButton brightButton;

    public StrobeFilter() {
        this.setFade(this.defaultFade);
        this.hasInspector = true;
    }

    public void setFade(double fade) {
        Double prev = this.fade;
        this.fade = Math.min(Math.abs(fade), 1.0);
        this.firePropertyChange("fade", prev, fade);
    }

    public double getFade() {
        return this.fade;
    }

    public void setBrightTrails(boolean bright) {
        this.brightTrails = bright;
        this.clear();
    }

    public boolean isBrightTrails() {
        return this.brightTrails;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        this.source = null;
        super.setEnabled(enabled);
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void clear() {
        this.source = null;
        this.firePropertyChange("image", null, null);
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.fadeLabel.setText(MediaRes.getString("Filter.Ghost.Label.Fade"));
        this.fadeSlider.setToolTipText(MediaRes.getString("Filter.Ghost.ToolTip.Fade"));
        this.brightButton.setText(MediaRes.getString("Filter.Strobe.RadioButton.Bright"));
        this.brightButton.setToolTipText(MediaRes.getString("Filter.Strobe.RadioButton.Bright.Tooltip"));
        this.darkButton.setText(MediaRes.getString("Filter.Strobe.RadioButton.Dark"));
        this.darkButton.setToolTipText(MediaRes.getString("Filter.Strobe.RadioButton.Dark.Tooltip"));
        boolean enabled = this.isEnabled();
        this.brightButton.setEnabled(enabled);
        this.darkButton.setEnabled(enabled);
        this.fadeLabel.setEnabled(enabled);
        this.fadeSlider.setEnabled(enabled);
        this.fadeField.setEnabled(enabled);
        this.inspector.setTitle(MediaRes.getString("Filter.Strobe.Title"));
        this.inspector.pack();
    }

    @Override
    protected void initializeSubclass() {
        if (this.prevPixels == null || this.prevPixels.length != this.nPixelsIn) {
            this.prevPixels = new int[this.nPixelsIn];
        }
        this.getPixelsIn();
        System.arraycopy(this.pixelsIn, 0, this.prevPixels, 0, this.nPixelsIn);
    }

    @Override
    protected void setOutputPixels() {
        this.getPixelsIn();
        this.getPixelsOut();
        int i = 0;
        while (i < this.pixelsIn.length) {
            int pixel = this.pixelsIn[i];
            int r = pixel >> 16 & 0xFF;
            int g = pixel >> 8 & 0xFF;
            int b = pixel & 0xFF;
            int val = (r + g + b) / 3;
            int rprev = this.prevPixels[i] >> 16 & 0xFF;
            int gprev = this.prevPixels[i] >> 8 & 0xFF;
            int bprev = this.prevPixels[i] & 0xFF;
            int valprev = (rprev + gprev + bprev) / 3;
            if (this.brightTrails) {
                if ((valprev = (int)((1.0 - this.fade) * (double)valprev)) > val) {
                    rprev = (int)((1.0 - this.fade) * (double)rprev);
                    gprev = (int)((1.0 - this.fade) * (double)gprev);
                    bprev = (int)((1.0 - this.fade) * (double)bprev);
                    this.pixelsOut[i] = rprev << 16 | gprev << 8 | bprev;
                } else {
                    this.pixelsOut[i] = pixel;
                }
            } else if (val > (valprev = (int)(255.0 - (1.0 - this.fade) * (double)(255 - valprev)))) {
                rprev = (int)(255.0 - (1.0 - this.fade) * (double)(255 - rprev));
                gprev = (int)(255.0 - (1.0 - this.fade) * (double)(255 - gprev));
                bprev = (int)(255.0 - (1.0 - this.fade) * (double)(255 - bprev));
                this.pixelsOut[i] = rprev << 16 | gprev << 8 | bprev;
            } else {
                this.pixelsOut[i] = pixel;
            }
            this.prevPixels[i] = this.pixelsOut[i];
            ++i;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super("Filter.Strobe.Title");
        }

        @Override
        void createGUI() {
            StrobeFilter.this.fadeLabel = new JLabel();
            StrobeFilter.this.fadeLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            StrobeFilter.this.fadeField = new DecimalField(4, 2);
            StrobeFilter.this.fadeField.setMaxValue(0.5);
            StrobeFilter.this.fadeField.setMinValue(0.0);
            StrobeFilter.this.fadeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StrobeFilter.this.setFade(StrobeFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                    StrobeFilter.this.fadeField.selectAll();
                }
            });
            StrobeFilter.this.fadeField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    StrobeFilter.this.fadeField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    StrobeFilter.this.setFade(StrobeFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            StrobeFilter.this.fadeSlider = new JSlider(0, 0, 0);
            StrobeFilter.this.fadeSlider.setMaximum(50);
            StrobeFilter.this.fadeSlider.setMinimum(0);
            StrobeFilter.this.fadeSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            StrobeFilter.this.fadeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = StrobeFilter.this.fadeSlider.getValue();
                    if (i != (int)(StrobeFilter.this.getFade() * 100.0)) {
                        StrobeFilter.this.setFade((double)i / 100.0);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            ButtonGroup group = new ButtonGroup();
            ActionListener brightDarkAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StrobeFilter.this.setBrightTrails(StrobeFilter.this.brightButton.isSelected());
                }
            };
            StrobeFilter.this.brightButton = new JRadioButton();
            StrobeFilter.this.darkButton = new JRadioButton();
            group.add(StrobeFilter.this.brightButton);
            group.add(StrobeFilter.this.darkButton);
            StrobeFilter.this.darkButton.setSelected(!StrobeFilter.this.brightTrails);
            StrobeFilter.this.brightButton.addActionListener(brightDarkAction);
            StrobeFilter.this.darkButton.addActionListener(brightDarkAction);
            JPanel panel = new JPanel(new BorderLayout());
            this.setContentPane(panel);
            JPanel fadePanel = new JPanel(new FlowLayout());
            fadePanel.add(StrobeFilter.this.fadeLabel);
            fadePanel.add(StrobeFilter.this.fadeField);
            fadePanel.add(StrobeFilter.this.fadeSlider);
            panel.add((Component)fadePanel, "North");
            JPanel brightDarkBar = new JPanel(new FlowLayout());
            brightDarkBar.add(StrobeFilter.this.brightButton);
            brightDarkBar.add(StrobeFilter.this.darkButton);
            panel.add((Component)brightDarkBar, "Center");
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(StrobeFilter.this.ableButton);
            buttonbar.add(StrobeFilter.this.clearButton);
            buttonbar.add(StrobeFilter.this.closeButton);
            panel.add((Component)buttonbar, "South");
        }

        void initialize() {
            this.updateDisplay();
            StrobeFilter.this.refresh();
        }

        void updateDisplay() {
            StrobeFilter.this.fadeField.setValue(StrobeFilter.this.getFade());
            StrobeFilter.this.fadeSlider.setValue((int)(100.0 * StrobeFilter.this.getFade()));
            if (StrobeFilter.this.isBrightTrails()) {
                StrobeFilter.this.brightButton.setSelected(true);
            } else {
                StrobeFilter.this.darkButton.setSelected(true);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            StrobeFilter filter = (StrobeFilter)obj;
            control.setValue("fade", filter.getFade());
            if (filter.isBrightTrails()) {
                control.setValue("bright_trails", filter.isBrightTrails());
            }
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new StrobeFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            StrobeFilter filter = (StrobeFilter)obj;
            if (control.getPropertyNamesRaw().contains("fade")) {
                filter.setFade(control.getDouble("fade"));
            }
            filter.setBrightTrails(control.getBoolean("bright_trails"));
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

