/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;

public class SumFilter
extends Filter {
    protected int[] rsums;
    protected int[] gsums;
    protected int[] bsums;
    private int imageCount = 1;
    private double brightness = 1.0;
    private boolean mean;
    private boolean skipSum = true;
    private Inspector inspector;
    private JLabel percentLabel;
    private DecimalField percentField;
    private JSlider percentSlider;
    private JCheckBox showMeanCheckBox;
    private JLabel frameCountLabel;
    private IntegerField frameCountField;

    public SumFilter() {
        this.hasInspector = true;
    }

    public void setBrightness(double fraction) {
        if (fraction != this.brightness) {
            this.brightness = Math.abs(fraction);
            this.firePropertyChange("brightness", null, null);
        }
    }

    public void setMean(boolean mean) {
        if (this.mean != mean) {
            this.mean = mean;
            this.refresh();
            this.firePropertyChange("mean", null, null);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.refresh();
    }

    @Override
    protected Filter.InspectorDlg newInspector() {
        this.inspector = new Inspector();
        return this.inspector;
    }

    @Override
    protected Filter.InspectorDlg initInspector() {
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void clear() {
        if (this.source != null) {
            this.initializeSubclass();
            this.brightness = 1.0;
            this.skipSum = true;
            this.firePropertyChange("reset", null, null);
        }
    }

    @Override
    public void refresh() {
        if (this.inspector == null || !this.haveGUI) {
            return;
        }
        super.refresh();
        this.percentLabel.setText(MediaRes.getString("Filter.Sum.Label.Percent"));
        this.percentField.setToolTipText(MediaRes.getString("Filter.Sum.ToolTip.Percent"));
        this.percentSlider.setToolTipText(MediaRes.getString("Filter.Sum.ToolTip.Percent"));
        this.showMeanCheckBox.setText(MediaRes.getString("Filter.Sum.CheckBox.ShowMean"));
        this.frameCountLabel.setText(MediaRes.getString("Filter.Sum.Label.FrameCount"));
        boolean enabled = this.isEnabled();
        this.showMeanCheckBox.setEnabled(enabled);
        this.frameCountLabel.setEnabled(enabled);
        this.frameCountField.setEnabled(enabled);
        this.percentLabel.setEnabled(enabled && !this.mean);
        this.percentField.setEnabled(enabled && !this.mean);
        this.percentSlider.setEnabled(enabled && !this.mean);
        this.frameCountField.setIntValue(this.imageCount);
        if (this.mean) {
            this.percentField.setValue(100.0 / (double)this.imageCount);
            this.percentSlider.setValue(Math.round(100.0f / (float)this.imageCount));
        } else {
            this.percentField.setValue(this.brightness * 100.0);
            this.percentSlider.setValue(Math.round((float)this.brightness * 100.0f));
        }
        this.inspector.setTitle(MediaRes.getString("Filter.Sum.Title"));
        this.inspector.pack();
    }

    public void addNextImage() {
        this.skipSum = false;
    }

    @Override
    protected void initializeSubclass() {
        this.rsums = new int[this.nPixelsIn];
        this.gsums = new int[this.nPixelsIn];
        this.bsums = new int[this.nPixelsIn];
        this.getPixelsIn();
        this.getPixelsOut();
        System.arraycopy(this.pixelsIn, 0, this.pixelsOut, 0, this.nPixelsIn);
        this.imageCount = 0;
        this.addPixels();
    }

    private void addPixels() {
        ++this.imageCount;
        this.getPixelsIn();
        int i = 0;
        while (i < this.nPixelsIn) {
            int pixel = this.pixelsIn[i];
            int n = i;
            this.rsums[n] = this.rsums[n] + (pixel >> 16 & 0xFF);
            int n2 = i;
            this.gsums[n2] = this.gsums[n2] + (pixel >> 8 & 0xFF);
            int n3 = i++;
            this.bsums[n3] = this.bsums[n3] + (pixel & 0xFF);
        }
        if (this.inspector != null && this.inspector.isVisible()) {
            this.refresh();
        }
    }

    @Override
    protected void setOutputPixels() {
        if (!this.skipSum) {
            this.addPixels();
            this.skipSum = true;
        }
        this.getPixelsOut();
        double f = this.mean ? 1.0 / (double)this.imageCount : this.brightness;
        int i = 0;
        while (i < this.nPixelsIn) {
            this.pixelsOut[i] = (int)Math.min((double)this.rsums[i] * f, 255.0) << 16 | (int)Math.min((double)this.gsums[i] * f, 255.0) << 8 | (int)Math.min((double)this.bsums[i] * f, 255.0);
            ++i;
        }
        if (this.mean && this.inspector != null) {
            this.refresh();
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends Filter.InspectorDlg {
        public Inspector() {
            super("Filter.Sum.Title");
        }

        @Override
        void createGUI() {
            SumFilter.this.percentLabel = new JLabel();
            SumFilter.this.percentLabel.setHorizontalAlignment(11);
            SumFilter.this.percentField = new DecimalField(3, 1);
            SumFilter.this.percentField.setMaxValue(100.0);
            SumFilter.this.percentField.setMinValue(0.0);
            SumFilter.this.percentField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SumFilter.this.setBrightness(SumFilter.this.percentField.getValue() / 100.0);
                    SumFilter.this.refresh();
                    SumFilter.this.percentField.selectAll();
                }
            });
            SumFilter.this.percentField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    SumFilter.this.percentField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    SumFilter.this.setBrightness(SumFilter.this.percentField.getValue() / 100.0);
                    SumFilter.this.refresh();
                }
            });
            SumFilter.this.percentSlider = new JSlider(0, 100, 100);
            SumFilter.this.percentSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (SumFilter.this.percentSlider.isEnabled() && SumFilter.this.percentSlider.getValue() != Math.round((float)SumFilter.this.brightness * 100.0f)) {
                        SumFilter.this.setBrightness((double)SumFilter.this.percentSlider.getValue() / 100.0);
                        SumFilter.this.refresh();
                    }
                }
            });
            SumFilter.this.showMeanCheckBox = new JCheckBox();
            SumFilter.this.showMeanCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SumFilter.this.setMean(SumFilter.this.showMeanCheckBox.isSelected());
                    SumFilter.this.refresh();
                }
            });
            SumFilter.this.frameCountLabel = new JLabel();
            SumFilter.this.frameCountLabel.setHorizontalAlignment(11);
            SumFilter.this.frameCountField = new IntegerField(3);
            SumFilter.this.frameCountField.setEditable(false);
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            GridBagLayout gridbag = new GridBagLayout();
            JPanel panel = new JPanel(gridbag);
            contentPane.add((Component)panel, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.insets = new Insets(5, 5, 0, 2);
            gridbag.setConstraints(SumFilter.this.percentLabel, c);
            panel.add(SumFilter.this.percentLabel);
            c.anchor = 13;
            c.fill = 2;
            c.gridx = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(SumFilter.this.percentField, c);
            panel.add(SumFilter.this.percentField);
            c.gridx = 2;
            c.weightx = 1.0;
            c.insets = new Insets(5, 0, 0, 5);
            gridbag.setConstraints(SumFilter.this.percentSlider, c);
            panel.add(SumFilter.this.percentSlider);
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 1;
            c.insets = new Insets(5, 5, 0, 2);
            c.anchor = 17;
            gridbag.setConstraints(SumFilter.this.frameCountLabel, c);
            panel.add(SumFilter.this.frameCountLabel);
            c.gridx = 1;
            c.insets = new Insets(5, 0, 0, 0);
            c.anchor = 13;
            gridbag.setConstraints(SumFilter.this.frameCountField, c);
            panel.add(SumFilter.this.frameCountField);
            c.gridx = 2;
            c.insets = new Insets(8, 0, 0, 0);
            gridbag.setConstraints(SumFilter.this.showMeanCheckBox, c);
            panel.add(SumFilter.this.showMeanCheckBox);
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(SumFilter.this.ableButton);
            buttonbar.add(SumFilter.this.clearButton);
            buttonbar.add(SumFilter.this.closeButton);
            contentPane.add((Component)buttonbar, "South");
        }

        void initialize() {
            SumFilter.this.showMeanCheckBox.setSelected(SumFilter.this.mean);
            SumFilter.this.refresh();
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            SumFilter filter = (SumFilter)obj;
            filter.addLocation(control);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new SumFilter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            SumFilter filter = (SumFilter)obj;
            filter.inspectorX = control.getInt("inspector_x");
            filter.inspectorY = control.getInt("inspector_y");
            return obj;
        }
    }
}

