/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TCircle
extends TShape {
    protected Ellipse2D circle = new Ellipse2D.Double();
    protected int radius = 5;
    protected int n;

    public TCircle(int n) {
        this(n, 0.0, 0.0);
    }

    public TCircle(int n, double x, double y) {
        super(x, y);
        this.n = n;
        this.setColor(Color.red);
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getFrameNumber(VideoPanel vidPanel) {
        return this.n;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof VideoPanel)) {
            return null;
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        if (this.getBounds(vidPanel).contains(xpix, ypix)) {
            return this;
        }
        return null;
    }

    @Override
    protected Shape getShape(VideoPanel vidPanel) {
        Point p = this.getScreenPosition(vidPanel);
        double xpix = p.x - this.radius;
        double ypix = p.y - this.radius;
        if (this.stroke == null) {
            this.circle.setFrame(xpix, ypix, 2 * this.radius, 2 * this.radius);
            return this.circle;
        }
        double w = this.stroke.getLineWidth();
        this.circle.setFrame(xpix + w / 2.0, ypix + w / 2.0, (double)(2 * this.radius) - w, (double)(2 * this.radius) - w);
        return this.stroke.createStrokedShape(this.circle);
    }
}

