/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TCoordAxes
extends TShape {
    protected VideoPanel vidPanel;
    protected GeneralPath axes = new GeneralPath();
    protected Origin origin = new Origin();
    protected boolean originEnabled = true;
    protected boolean xaxisEnabled = true;
    protected GeneralPath originShape = new GeneralPath();
    protected GeneralPath xaxis = new GeneralPath();

    public TCoordAxes(VideoPanel panel) {
        this.vidPanel = panel;
        this.setStroke(new BasicStroke(2.0f));
        this.setColor(new Color(153, 0, 0));
    }

    public TPoint getOrigin() {
        return this.origin;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (panel == this.vidPanel) {
            super.draw(panel, g);
        }
    }

    @Override
    public void setXY(double x, double y) {
        super.setXY(x, y);
        double cos = this.origin.cos(this);
        double sin = this.origin.sin(this);
        int n = this.vidPanel.getFrameNumber();
        this.vidPanel.getCoords().setCosineSine(n, cos, sin);
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke != null) {
            this.stroke = stroke;
        }
    }

    public void setOriginEnabled(boolean enabled) {
        this.originEnabled = enabled;
    }

    public boolean isOriginEnabled() {
        return this.originEnabled;
    }

    public void setXAxisEnabled(boolean enabled) {
        this.xaxisEnabled = enabled;
    }

    public boolean isXAxisEnabled() {
        return this.xaxisEnabled;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (panel != this.vidPanel) {
            return null;
        }
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        this.setHitRectCenter(xpix, ypix);
        if (this.originEnabled && this.originShape.intersects(hitRect)) {
            return this.origin;
        }
        if (this.xaxisEnabled && this.xaxis.intersects(hitRect)) {
            return this;
        }
        return null;
    }

    @Override
    public String toString() {
        return "Coordinate axes";
    }

    @Override
    protected Shape getShape(VideoPanel vidPanel) {
        float bsin;
        float bcos;
        float dsin;
        float dcos;
        float wy;
        float wx;
        ImageCoordSystem coords = vidPanel.getCoords();
        int n = this.getFrameNumber(vidPanel);
        int w = vidPanel.getWidth();
        int h = vidPanel.getHeight();
        double d = Math.max(2 * w, 2 * h);
        double x = coords.getOriginX(n);
        double y = coords.getOriginY(n);
        this.origin.setLocation(x, y);
        double sin = coords.getSine(n);
        double cos = coords.getCosine(n);
        if (vidPanel.isDrawingInImageSpace()) {
            wx = vidPanel.xToPix(x);
            wy = vidPanel.yToPix(y);
            dcos = (float)(d * cos);
            dsin = (float)(d * sin);
            bcos = (float)(3.0 * cos);
            bsin = (float)(3.0 * sin);
        } else {
            wx = vidPanel.xToPix(coords.imageToWorldX(n, x, y));
            wy = vidPanel.yToPix(coords.imageToWorldY(n, x, y));
            dcos = (float)d;
            dsin = 0.0f;
            bcos = 3.0f;
            bsin = 0.0f;
        }
        this.axes.reset();
        this.axes.moveTo(wx - dcos, wy + dsin);
        this.axes.lineTo(wx + dcos, wy - dsin);
        this.axes.moveTo(wx - dsin, wy - dcos);
        this.axes.lineTo(wx + dsin, wy + dcos);
        this.axes.moveTo(wx + 5.0f * bcos - bsin, wy - 5.0f * bsin - bcos);
        this.axes.lineTo(wx + 5.0f * bcos + bsin, wy - 5.0f * bsin + bcos);
        this.originShape.reset();
        this.originShape.moveTo(wx - 3.0f * bcos, wy + 3.0f * bsin);
        this.originShape.lineTo(wx + 3.0f * bcos, wy - 3.0f * bsin);
        this.originShape.moveTo(wx - 3.0f * bsin, wy - 3.0f * bcos);
        this.originShape.lineTo(wx + 3.0f * bsin, wy + 3.0f * bcos);
        this.xaxis.reset();
        this.xaxis.moveTo(wx + 5.0f * bcos, wy - 5.0f * bsin);
        this.xaxis.lineTo(wx + dcos, wy - dsin);
        return this.stroke.createStrokedShape(this.axes);
    }

    private class Origin
    extends TPoint {
        private Origin() {
        }

        @Override
        public void setXY(double x, double y) {
            super.setXY(x, y);
            int n = this.getFrameNumber(TCoordAxes.this.vidPanel);
            TCoordAxes.this.vidPanel.getCoords().setOriginXY(n, x, y);
        }
    }
}

