/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TLine
extends TShape {
    protected Line2D line = new Line2D.Double();
    protected TPoint end1 = new LineEnd();
    protected TPoint end2 = new LineEnd();
    protected Rectangle end1Rect = new Rectangle(0, 0, 8, 8);
    protected Rectangle end2Rect = new Rectangle(0, 0, 8, 8);

    public TLine() {
    }

    public TLine(double x1, double y1, double x2, double y2) {
        this.end1.setXY(x1, y1);
        this.end2.setXY(x2, y2);
    }

    public TPoint getEnd1() {
        return this.end1;
    }

    public TPoint getEnd2() {
        return this.end2;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke != null) {
            this.stroke = stroke;
        }
    }

    @Override
    public void setXY(double x, double y) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        this.end1.translate(dx, dy);
        this.end2.translate(dx, dy);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (this.end1Rect.contains(xpix, ypix)) {
            return this.end1;
        }
        if (this.end2Rect.contains(xpix, ypix)) {
            return this.end2;
        }
        this.setHitRectCenter(xpix, ypix);
        if (this.line.intersects(hitRect)) {
            return this;
        }
        return null;
    }

    @Override
    protected Shape getShape(VideoPanel vidPanel) {
        this.center(this.end1, this.end2);
        Point p1 = this.end1.getScreenPosition(vidPanel);
        Point p2 = this.end2.getScreenPosition(vidPanel);
        this.line.setLine(p1, p2);
        this.end1Rect.setLocation(p1.x - 4, p1.y - 4);
        this.end2Rect.setLocation(p2.x - 4, p2.y - 4);
        return this.stroke.createStrokedShape(this.line);
    }

    class LineEnd
    extends TPoint {
        LineEnd() {
        }

        @Override
        public Rectangle getBounds(VideoPanel vidPanel) {
            return TLine.this.getBounds(vidPanel);
        }
    }
}

