/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.TLine;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;

public class TLineProfile
extends TLine {
    protected int[] pixels = new int[0];
    protected int[] values = new int[0];

    public TLineProfile(double x1, double y1, double x2, double y2) {
        this.end1 = new LineEnd(x1, y1);
        this.end2 = new LineEnd(x2, y2);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!(panel instanceof VideoPanel)) {
            return;
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        if (!this.isVisible()) {
            return;
        }
        super.draw(vidPanel, g);
        this.getProfileData(vidPanel);
    }

    public int[] getProfile() {
        return this.values;
    }

    protected void getProfileData(VideoPanel vidPanel) {
        BufferedImage image;
        if (vidPanel.getVideo() == null) {
            return;
        }
        int length = (int)this.end1.distance(this.end2);
        if (length != this.pixels.length) {
            this.pixels = new int[length];
            this.values = new int[length];
        }
        if ((image = vidPanel.getVideo().getImage()).getType() == 1) {
            try {
                int x = Math.min((int)this.end1.getX(), (int)this.end2.getX());
                int y = (int)this.end1.getY();
                image.getRaster().getDataElements(x, y, length, 1, this.pixels);
                int i = 0;
                while (i < this.pixels.length) {
                    int pixel = this.pixels[i];
                    int r = pixel >> 16 & 0xFF;
                    int g = pixel >> 8 & 0xFF;
                    int b = pixel & 0xFF;
                    this.values[i] = (r + g + b) / 3;
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class LineEnd
    extends TPoint {
        public LineEnd(double x, double y) {
            super(x, y);
        }

        @Override
        public void setXY(double x, double y) {
            this.setLocation(x, this.getY());
        }

        @Override
        public void translate(double dx, double dy) {
            this.setLocation(this.getX() + dx, this.getY() + dy);
        }

        @Override
        public Rectangle getBounds(VideoPanel vidPanel) {
            return TLineProfile.this.getBounds(vidPanel);
        }
    }
}

