/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VidCartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.XYCoordinateStringBuilder;

public class TPoint
extends Point2D.Double
implements Interactive,
Trackable {
    protected static boolean coordsVisibleInMouseBox = true;
    protected static XYCoordinateStringBuilder xyStringBuilder = new VidCartesianCoordinateStringBuilder();
    protected boolean enabled = true;
    protected boolean trackEditTrigger = false;
    protected boolean coordsEditTrigger = false;
    protected boolean stepEditTrigger = false;
    protected boolean isAdjusting = false;
    protected Point screenPt;
    protected Point2D.Double worldPt;
    protected PropertyChangeSupport support;
    protected TPoint attachedTo;
    protected double prevX = Double.NaN;
    protected double prevY = Double.NaN;
    protected AffineTransform toScreen;

    public TPoint() {
        this(0.0, 0.0);
    }

    public TPoint(double x, double y) {
        super(x, y);
    }

    public TPoint(Point2D.Double point) {
        this(point.x, point.y);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        return null;
    }

    @Override
    public void setX(double x) {
        this.setXY(x, this.y);
    }

    @Override
    public void setY(double y) {
        this.setXY(this.x, y);
    }

    @Override
    public void setXY(double x, double y) {
        this.setLocation(x, y);
    }

    @Override
    public void setLocation(double x, double y) {
        if (this.getX() == x && this.getY() == y) {
            return;
        }
        super.setLocation(x, y);
        if (this.support != null) {
            this.support.firePropertyChange("location", null, this);
        }
    }

    public int getFrameNumber(VideoPanel vidPanel) {
        return vidPanel.getFrameNumber();
    }

    public Point getScreenPosition(VideoPanel vidPanel) {
        if (this.screenPt == null) {
            this.toScreen = new AffineTransform();
            this.screenPt = new Point();
        }
        this.toScreen.setTransform(vidPanel.getPixelTransform());
        if (!vidPanel.isDrawingInImageSpace()) {
            int n = this.getFrameNumber(vidPanel);
            this.toScreen.concatenate(vidPanel.getCoords().getToWorldTransform(n));
        }
        this.toScreen.transform(this, this.screenPt);
        return this.screenPt;
    }

    public void setScreenPosition(int x, int y, VideoPanel vidPanel) {
        if (this.screenPt == null) {
            this.screenPt = new Point();
            this.toScreen = new AffineTransform();
        }
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.screenPt.setLocation(x, y);
        this.toScreen.setTransform(vidPanel.getPixelTransform());
        if (!vidPanel.isDrawingInImageSpace()) {
            int n = this.getFrameNumber(vidPanel);
            this.toScreen.concatenate(vidPanel.getCoords().getToWorldTransform(n));
        }
        try {
            this.toScreen.inverseTransform(this.screenPt, this.worldPt);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.setXY(this.worldPt.x, this.worldPt.y);
    }

    public void setScreenPosition(int x, int y, VideoPanel vidPanel, InputEvent e) {
        this.setScreenPosition(x, y, vidPanel);
    }

    public Point2D getWorldPosition(VideoPanel vidPanel) {
        AffineTransform at = vidPanel.getCoords().getToWorldTransform(this.getFrameNumber(vidPanel));
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        return at.transform(this, this.worldPt);
    }

    public void setWorldPosition(double x, double y, VideoPanel vidPanel) {
        int n = this.getFrameNumber(vidPanel);
        AffineTransform at = vidPanel.getCoords().getToWorldTransform(n);
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.worldPt.setLocation(x, y);
        try {
            at.inverseTransform(this.worldPt, this.worldPt);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.setXY(this.worldPt.x, this.worldPt.y);
    }

    public void showCoordinates(VideoPanel vidPanel) {
        if (coordsVisibleInMouseBox) {
            this.getWorldPosition(vidPanel);
            XYCoordinateStringBuilder builder = vidPanel.getXYCoordinateStringBuilder(this);
            String s = builder.getCoordinateString(vidPanel, this.worldPt.x, this.worldPt.y);
            vidPanel.setMessage(s, 0);
        }
    }

    public boolean attachTo(TPoint p) {
        if (p == null || p == this) {
            return false;
        }
        if (p == this.attachedTo && p.x == this.x && p.y == this.y) {
            return false;
        }
        this.detach();
        this.attachedTo = p;
        p.addPropertyChangeListener("location", new Follower());
        this.setXY(p.x, p.y);
        return true;
    }

    public void detach() {
        if (this.attachedTo != null) {
            PropertyChangeListener[] listeners;
            PropertyChangeListener[] propertyChangeListenerArray = listeners = this.attachedTo.support.getPropertyChangeListeners("location");
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Follower follower;
                PropertyChangeListener next = propertyChangeListenerArray[n2];
                if (next instanceof Follower && (follower = (Follower)next).getTarget() == this) {
                    this.attachedTo.removePropertyChangeListener("location", next);
                }
                ++n2;
            }
            this.attachedTo = null;
        }
    }

    public boolean isAttached() {
        return this.attachedTo != null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setTrackEditTrigger(boolean edit) {
        this.trackEditTrigger = edit;
    }

    public boolean isTrackEditTrigger() {
        return this.trackEditTrigger;
    }

    public void setCoordsEditTrigger(boolean edit) {
        this.coordsEditTrigger = edit;
    }

    public boolean isCoordsEditTrigger() {
        return this.coordsEditTrigger;
    }

    public void setStepEditTrigger(boolean stepEditTrigger) {
        this.stepEditTrigger = stepEditTrigger;
    }

    public boolean isStepEditTrigger() {
        return this.stepEditTrigger;
    }

    public Rectangle getBounds(VideoPanel vidPanel) {
        return null;
    }

    @Override
    public boolean isMeasured() {
        return false;
    }

    @Override
    public double getXMin() {
        return this.x;
    }

    @Override
    public double getXMax() {
        return this.x;
    }

    @Override
    public double getYMin() {
        return this.y;
    }

    @Override
    public double getYMax() {
        return this.y;
    }

    public double angle(double x, double y) {
        return Math.atan2(y - this.getY(), x - this.getX());
    }

    public double angle(Point2D.Double pt) {
        return Math.atan2(pt.y - this.y, pt.x - this.x);
    }

    public double sin(double x, double y) {
        return (this.getY() - y) / this.distance(x, y);
    }

    public double sin(Point2D.Double pt) {
        return (this.y - pt.y) / this.distance(pt);
    }

    public double cos(double x, double y) {
        return (x - this.getX()) / this.distance(x, y);
    }

    public double cos(Point2D.Double pt) {
        return (pt.x - this.x) / this.distance(pt);
    }

    public void center(Point2D.Double pt1, Point2D.Double pt2) {
        double x = (pt1.x + pt2.x) / 2.0;
        double y = (pt1.y + pt2.y) / 2.0;
        this.setLocation(x, y);
    }

    public void translate(double dx, double dy) {
        this.setXY(this.x + dx, this.y + dy);
    }

    public void setAdjusting(boolean adjusting, MouseEvent e) {
        if (!this.isAdjusting && adjusting) {
            this.prevX = this.x;
            this.prevY = this.y;
        }
        this.isAdjusting = adjusting;
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new SwingPropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new SwingPropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(property, listener);
    }

    @Override
    public String toString() {
        return "TPoint [" + this.x + ", " + this.y + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TPoint p = (TPoint)obj;
        return p.x == this.x && p.y == this.y && p.screenPt == this.screenPt && p.worldPt == this.worldPt;
    }

    public void setPositionOnLine(int xScreen, int yScreen, VideoPanel vidPanel, TPoint end1, TPoint end2) {
        if (this.screenPt == null) {
            this.screenPt = new Point();
            this.toScreen = new AffineTransform();
        }
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.screenPt.setLocation(xScreen, yScreen);
        this.toScreen.setTransform(vidPanel.getPixelTransform());
        if (!vidPanel.isDrawingInImageSpace()) {
            int n = this.getFrameNumber(vidPanel);
            this.toScreen.concatenate(vidPanel.getCoords().getToWorldTransform(n));
        }
        try {
            this.toScreen.inverseTransform(this.screenPt, this.worldPt);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        double dx = end2.x - end1.x;
        double dy = end2.y - end1.y;
        double u = ((this.worldPt.x - end1.x) * dx + (this.worldPt.y - end1.y) * dy) / end1.distanceSq(end2);
        if (Double.isNaN(u)) {
            u = 0.0;
        }
        double xLine = end1.x + u * dx;
        double yLine = end1.y + u * dy;
        this.setLocation(xLine, yLine);
    }

    private class Follower
    implements PropertyChangeListener {
        private Follower() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            TPoint p = (TPoint)e.getSource();
            TPoint.this.setXY(p.x, p.y);
        }

        public TPoint getTarget() {
            return TPoint.this;
        }
    }
}

