/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;

public class TShape
extends TPoint {
    protected static Rectangle hitRect = new Rectangle(0, 0, 8, 8);
    protected Color color = Color.black;
    protected boolean visible = true;
    protected Shape fillShape = hitRect;
    protected BasicStroke stroke = new BasicStroke();

    public TShape() {
    }

    public TShape(double x, double y) {
        super(x, y);
    }

    public TShape(Point2D.Double point) {
        super(point);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public Rectangle getBounds(VideoPanel vidPanel) {
        return this.getShape(vidPanel).getBounds();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        if (!(panel instanceof VideoPanel) || !this.isVisible()) {
            return;
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        this.fillShape = this.getShape(vidPanel);
        Graphics2D g = (Graphics2D)_g;
        Paint gpaint = g.getPaint();
        g.setPaint(this.color);
        g.fill(this.fillShape);
        g.setPaint(gpaint);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof VideoPanel)) {
            return null;
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        this.setHitRectCenter(xpix, ypix);
        if (hitRect.contains(this.getScreenPosition(vidPanel))) {
            return this;
        }
        return null;
    }

    @Override
    public String toString() {
        return "TShape [" + this.x + ", " + this.y + "]";
    }

    protected Shape getShape(VideoPanel vidPanel) {
        Point p = this.getScreenPosition(vidPanel);
        this.setHitRectCenter(p.x, p.y);
        if (this.stroke == null) {
            return (Rectangle)hitRect.clone();
        }
        return this.stroke.createStrokedShape(hitRect);
    }

    protected void setHitRectCenter(int xpix, int ypix) {
        hitRect.setLocation(xpix - TShape.hitRect.width / 2, ypix - TShape.hitRect.height / 2);
    }
}

