/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TVector
extends TShape {
    protected GeneralPath path = new GeneralPath();
    protected Line2D line = new Line2D.Double();
    protected Shape head;
    protected Shape shaft;
    protected int length = 16;
    protected int width = 4;
    protected AffineTransform rotation = new AffineTransform();
    protected TPoint tail = new LineEnd();
    protected TPoint tip = new LineEnd();
    protected Rectangle tipRect = new Rectangle(0, 0, 8, 8);
    protected boolean tipEnabled = true;

    public TVector() {
        this.setStroke(new BasicStroke(1.0f));
    }

    public TVector(double xt, double yt, double xc, double yc) {
        this.tail.setXY(xt, yt);
        this.tip.setXY(xt + xc, yt + yc);
        this.setStroke(new BasicStroke(1.0f));
    }

    public TPoint getTip() {
        return this.tip;
    }

    public TPoint getTail() {
        return this.tail;
    }

    public void setXComponent(double x) {
        this.tip.setX(this.tail.getX() + x);
    }

    public void setYComponent(double y) {
        this.tip.setY(this.tail.getY() + y);
    }

    public void setXYComponents(double x, double y) {
        this.tip.setXY(this.tail.getX() + x, this.tail.getY() + y);
    }

    public double getXComponent() {
        return this.tip.getX() - this.tail.getX();
    }

    public double getYComponent() {
        return this.tip.getY() - this.tail.getY();
    }

    @Override
    public void setXY(double x, double y) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        this.tip.translate(dx, dy);
        this.tail.translate(dx, dy);
    }

    public void setTipEnabled(boolean enabled) {
        this.tipEnabled = enabled;
    }

    public boolean isTipEnabled() {
        return this.tipEnabled;
    }

    public void setTipLength(int tipLength) {
        tipLength = Math.max(8, tipLength);
        this.width = tipLength / 4;
        this.length = 4 * this.width;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke == null) {
            return;
        }
        this.stroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, stroke.getDashArray(), stroke.getDashPhase());
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof VideoPanel)) {
            return null;
        }
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        this.setHitRectCenter(xpix, ypix);
        if (this.shaft != null && this.shaft.intersects(hitRect)) {
            return this;
        }
        if (this.tipEnabled && this.head != null && this.head.intersects(hitRect)) {
            return this.tip;
        }
        return null;
    }

    @Override
    protected Shape getShape(VideoPanel vidPanel) {
        this.center(this.tip, this.tail);
        Point p1 = this.tail.getScreenPosition(vidPanel);
        Point p2 = this.tip.getScreenPosition(vidPanel);
        double theta = Math.atan2(p2.y - p1.y, p2.x - p1.x);
        this.rotation.setToRotation(theta, p1.x, p1.y);
        this.rotation.translate(p1.x, p1.y);
        float d = (float)p1.distance(p2);
        this.path.reset();
        this.path.moveTo(d - 4.0f, 0.0f);
        this.path.lineTo(d - 6.0f, -2.0f);
        this.path.lineTo(d, 0.0f);
        this.path.lineTo(d - 6.0f, 2.0f);
        this.path.closePath();
        this.head = this.rotation.createTransformedShape(this.path);
        float w = this.stroke.getLineWidth();
        this.line.setLine(0.0, 0.0, (d -= 1.58f * w) - (float)this.length, 0.0);
        this.shaft = this.rotation.createTransformedShape(this.line);
        this.path.reset();
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo(d - (float)this.length + (float)this.width, 0.0f);
        this.path.lineTo(d - (float)this.length, -this.width);
        this.path.lineTo(d, 0.0f);
        this.path.lineTo(d - (float)this.length, this.width);
        this.path.lineTo(d - (float)this.length + (float)this.width, 0.0f);
        Shape vector = this.rotation.createTransformedShape(this.path);
        return this.stroke.createStrokedShape(vector);
    }

    class LineEnd
    extends TPoint {
        LineEnd() {
        }

        @Override
        public Rectangle getBounds(VideoPanel vidPanel) {
            return TVector.this.getBounds(vidPanel);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return TVector.this.getFrameNumber(vidPanel);
        }
    }
}

