/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.BitSet;
import java.util.TreeMap;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.KnownPolynomial;

public class TemplateMatcher {
    private static final double LARGE_NUMBER = 1.0E10;
    private BufferedImage original;
    private BufferedImage template;
    private BufferedImage working;
    private BufferedImage match;
    private Shape mask;
    private int[] pixels;
    private int[] templateR;
    private int[] templateG;
    private int[] templateB;
    private boolean[] isPixelTransparent;
    private int[] targetPixels;
    private int wTemplate;
    private int hTemplate;
    private int wTarget;
    private int hTarget;
    private int wTest;
    private int hTest;
    private double largeNumber = 1.0E20;
    private double[] xValues = new double[3];
    private double[] yValues = new double[3];
    private double peakHeight;
    private double peakWidth;
    private int trimLeft;
    private int trimTop;
    private int[] alphas = new int[2];
    private int index;
    private KnownPolynomial parabola;

    public TemplateMatcher(BufferedImage image, Shape maskShape) {
        this.mask = maskShape;
        this.setTemplate(image);
        this.parabola = new KnownPolynomial(new double[3]);
    }

    public void setTemplate(BufferedImage image) {
        boolean isOK;
        boolean isARGB = image.getType() == 2;
        boolean bl = isOK = this.template != null && this.wTemplate == image.getWidth() && this.hTemplate == image.getHeight();
        if (!isARGB || !isOK) {
            this.original = TemplateMatcher.ensureType(image, image.getWidth(), image.getHeight(), 2);
            image = this.buildTemplate(this.original, 255, 0);
        }
        this.template = image;
        this.pixels = TemplateMatcher.getPixels(this.template);
        int i = this.pixels.length;
        while (--i >= 0) {
            int val = this.pixels[i];
            this.templateR[i] = TemplateMatcher.getRed(val);
            this.templateG[i] = TemplateMatcher.getGreen(val);
            this.templateB[i] = TemplateMatcher.getBlue(val);
            boolean bl2 = this.isPixelTransparent[i] = TemplateMatcher.getAlpha(val) == 0;
        }
    }

    public int[] getWorkingPixels() {
        return TemplateMatcher.getPixels(this.working);
    }

    public BufferedImage getTemplate() {
        if (this.template == null) {
            this.template = this.buildTemplate(this.original, 255, 0);
            this.setTemplate(this.template);
        }
        return this.template;
    }

    public BufferedImage buildTemplate(BufferedImage image, int alphaInput, int alphaOriginal) {
        int i;
        int wT;
        int line;
        int w = image.getWidth();
        int h = image.getHeight();
        int nPixels = w * h;
        if (this.original.getWidth() != w || this.original.getHeight() != h) {
            return null;
        }
        if (alphaInput == 0 && alphaOriginal == 0) {
            return this.template != null ? this.template : this.original;
        }
        this.alphas[0] = alphaInput;
        this.alphas[1] = alphaOriginal;
        BufferedImage input = TemplateMatcher.ensureType(image, w, h, 2);
        this.working = TemplateMatcher.ensureType(this.working, w, h, 2);
        Graphics2D gWorking = this.working.createGraphics();
        if ((alphaInput = Math.max(0, Math.min(255, alphaInput))) > 0) {
            gWorking.setComposite(TemplateMatcher.getComposite(alphaInput));
            gWorking.drawImage((Image)input, 0, 0, null);
        }
        if ((alphaOriginal = Math.max(0, Math.min(255, alphaOriginal))) > 0) {
            gWorking.setComposite(TemplateMatcher.getComposite(alphaOriginal));
            gWorking.drawImage((Image)this.original, 0, 0, null);
        }
        this.pixels = this.getWorkingPixels();
        if (this.template == null || w != this.wTemplate || h != this.hTemplate) {
            this.wTemplate = w;
            this.hTemplate = h;
            this.template = new BufferedImage(w, h, 2);
            this.templateR = new int[nPixels];
            this.templateG = new int[nPixels];
            this.templateB = new int[nPixels];
            this.isPixelTransparent = new boolean[nPixels];
        }
        if (this.mask != null) {
            int i2 = nPixels;
            while (--i2 >= 0) {
                boolean inside = true;
                int x = i2 % this.wTemplate;
                int y = i2 / this.wTemplate;
                int j = 0;
                while (j < 2) {
                    int k = 0;
                    while (k < 2) {
                        inside = inside && this.mask.contains(x + j, y + k);
                        ++k;
                    }
                    ++j;
                }
                if (inside) continue;
                this.pixels[i2] = 0;
            }
        }
        BitSet bsOpaque = TemplateMatcher.getOpaqueBS(this.pixels, this.wTemplate, this.hTemplate);
        this.trimTop = bsOpaque.nextSetBit(0) / this.wTemplate;
        int trimBottom = this.hTemplate - 1 - (bsOpaque.length() - 1) / this.wTemplate;
        this.trimLeft = 0;
        int trimRight = 0;
        block3: while (this.trimLeft < this.wTemplate) {
            line = this.trimTop;
            wT = this.wTemplate;
            i = this.trimTop * wT + this.trimLeft;
            while (line < this.hTemplate) {
                if (bsOpaque.get(i)) break block3;
                ++line;
                i += wT;
            }
            ++this.trimLeft;
        }
        block5: while (this.trimLeft + trimRight < this.wTemplate) {
            line = 0;
            wT = this.wTemplate;
            i = wT - 1 - trimRight;
            while (line < this.hTemplate) {
                if (bsOpaque.get(i)) break block5;
                ++line;
                i += wT;
            }
            ++trimRight;
        }
        if (this.trimLeft + trimRight + this.trimTop + trimBottom == 0) {
            System.arraycopy(this.pixels, 0, TemplateMatcher.getPixels(this.template), 0, nPixels);
        } else {
            int w0 = this.wTemplate;
            this.wTemplate -= this.trimLeft + trimRight;
            this.hTemplate -= this.trimTop + trimBottom;
            this.wTemplate = Math.max(this.wTemplate, 1);
            this.hTemplate = Math.max(this.hTemplate, 1);
            int len = this.wTemplate * this.hTemplate;
            this.templateR = new int[len];
            this.templateG = new int[len];
            this.templateB = new int[len];
            this.isPixelTransparent = new boolean[len];
            this.template = new BufferedImage(this.wTemplate, this.hTemplate, 2);
            TemplateMatcher.transferPixels(this.pixels, this.trimLeft, this.trimTop, w0, TemplateMatcher.getPixels(this.template), this.wTemplate);
            this.pixels = new int[len];
        }
        return this.template;
    }

    public int[] getAlphas() {
        return this.alphas;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setWorkingPixels(int[] pixels) {
        int[] p;
        if (pixels != null && pixels.length == this.wTemplate * this.hTemplate && (p = this.getWorkingPixels()) != pixels) {
            System.arraycopy(pixels, 0, p, 0, p.length);
        }
    }

    public TPoint getMatchLocation(BufferedImage target, Rectangle searchRect, int[][] searchPts, double x0, double y0, double theta) {
        boolean isLinear = searchPts != null;
        this.wTarget = target.getWidth();
        this.hTarget = target.getHeight();
        int left = this.wTemplate / 2;
        int top = this.hTemplate / 2;
        int right = left + this.wTemplate % 2;
        int bottom = top + this.hTemplate % 2;
        int sx = searchRect.x = Math.max(left, Math.min(this.wTarget - right, searchRect.x));
        int sy = searchRect.y = Math.max(top, Math.min(this.hTarget - bottom, searchRect.y));
        int sw = searchRect.width = Math.min(this.wTarget - sx - right, searchRect.width);
        int sh = searchRect.height = Math.min(this.hTarget - sy - bottom, searchRect.height);
        if (sw <= 0 || sh <= 0) {
            this.peakHeight = Double.NaN;
            this.peakWidth = Double.NaN;
            return null;
        }
        int xMin = Math.max(0, sx - left);
        int xMax = Math.min(this.wTarget, sx + sw + right);
        int yMin = Math.max(0, sy - top);
        int yMax = Math.min(this.hTarget, sy + sh + bottom);
        this.wTest = xMax - xMin;
        this.hTest = yMax - yMin;
        target = TemplateMatcher.ensureType(target, this.wTarget, this.hTarget, 1);
        this.targetPixels = new int[this.wTest * this.hTest];
        TemplateMatcher.transferPixels(TemplateMatcher.getPixels(target), xMin, yMin, this.wTarget, this.targetPixels, this.wTest);
        if (searchPts == null) {
            searchPts = new int[sw * sh][2];
            int index = 0;
            int x = 0;
            while (x < sw) {
                int y = 0;
                while (y < sh) {
                    searchPts[index][0] = x;
                    searchPts[index][1] = y++;
                    ++index;
                }
                ++x;
            }
        }
        double minDiffSq = this.largeNumber;
        int matchIndex = -1;
        double avgDiffSq = 0.0;
        int n = 0;
        int i = 0;
        while (i < searchPts.length) {
            if (searchPts[i][0] < sw && searchPts[i][1] < sh && searchPts[i][0] >= 0 && searchPts[i][1] >= 0) {
                double diffSq = this.getRGBDiffSquaredAtTestPoint(searchPts[i][0], searchPts[i][1]);
                avgDiffSq += diffSq;
                ++n;
                if (diffSq < minDiffSq) {
                    minDiffSq = diffSq;
                    matchIndex = i;
                }
            }
            ++i;
        }
        this.peakHeight = (avgDiffSq /= (double)n) / minDiffSq - 1.0;
        this.peakWidth = Double.NaN;
        int xMatch = searchPts[matchIndex][0];
        int yMatch = searchPts[matchIndex][1];
        double dx = 0.0;
        double dy = 0.0;
        if (!Double.isInfinite(this.peakHeight)) {
            double[] pixels = new double[]{-1.0, 0.0, 1.0};
            if (isLinear && matchIndex > 0 && matchIndex < searchPts.length - 1) {
                int x = searchPts[matchIndex - 1][0];
                int y = searchPts[matchIndex - 1][1];
                this.xValues[0] = this.getRGBDiffSquaredAtTestPoint(x, y);
                this.xValues[1] = minDiffSq;
                x = searchPts[matchIndex + 1][0];
                y = searchPts[matchIndex + 1][1];
                this.xValues[2] = this.getRGBDiffSquaredAtTestPoint(x, y);
                this.parabola.fitData(pixels, this.xValues);
                double[] c = this.parabola.getCoefficients();
                double dl = -c[1] / (2.0 * c[2]);
                this.peakWidth = Math.sqrt(2.0 * c[0] / c[2]);
                dx = dl * Math.cos(theta);
                dy = dl * Math.sin(theta);
            } else {
                this.xValues[1] = this.yValues[1] = minDiffSq;
                int i2 = -1;
                while (i2 < 2) {
                    if (i2 != 0) {
                        double diffSq;
                        this.xValues[i2 + 1] = diffSq = this.getRGBDiffSquaredAtTestPoint(xMatch + i2, yMatch);
                        this.yValues[i2 + 1] = diffSq = this.getRGBDiffSquaredAtTestPoint(xMatch, yMatch + i2);
                    }
                    ++i2;
                }
                this.parabola.fitData(pixels, this.xValues);
                double[] c = this.parabola.getCoefficients();
                dx = -c[1] / (2.0 * c[2]);
                this.peakWidth = Math.sqrt(2.0 * c[0] / c[2]);
                this.parabola.fitData(pixels, this.yValues);
                c = this.parabola.getCoefficients();
                dy = -c[1] / (2.0 * c[2]);
                this.peakWidth = 0.5 * (this.peakWidth + Math.sqrt(2.0 * c[0] / c[2]));
                if (Double.isNaN(dx)) {
                    dx = 0.0;
                }
                if (Double.isNaN(dy)) {
                    dy = 0.0;
                }
            }
        }
        if (!Double.isNaN(this.peakWidth) && this.peakWidth > 1.0) {
            this.peakHeight /= this.peakWidth;
        }
        this.refreshMatchImage(target, xMatch += sx - left - this.trimLeft, yMatch += sy - top - this.trimTop);
        TPoint p = new TPoint((double)xMatch + dx, (double)yMatch + dy);
        return p;
    }

    public BufferedImage getMatchImage() {
        return this.match;
    }

    public double[] getMatchWidthAndHeight() {
        return new double[]{this.peakWidth, this.peakHeight};
    }

    public static int getValue(int a, int argb) {
        return argb & 0xFFFFFF | a << 24;
    }

    public static int getValue(int a, int r, int g, int b) {
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static int getAlpha(int value) {
        int alpha = value >> 24 & 0xFF;
        return alpha;
    }

    public static int getRed(int value) {
        int red = value >> 16 & 0xFF;
        return red;
    }

    public static int getGreen(int value) {
        int green = value >> 8 & 0xFF;
        return green;
    }

    public static int getBlue(int value) {
        int blue = value & 0xFF;
        return blue;
    }

    private void refreshMatchImage(BufferedImage target, int x, int y) {
        if (this.match == null || this.match.getWidth() != this.wTemplate || this.match.getHeight() != this.hTemplate) {
            this.match = new BufferedImage(this.wTemplate, this.hTemplate, 2);
        }
        int[] matchPixels = TemplateMatcher.getPixels(this.match);
        TemplateMatcher.transferPixels(TemplateMatcher.getPixels(target), x + 1, y + 1, this.wTarget, matchPixels, this.wTemplate);
        int i = matchPixels.length;
        while (--i >= 0) {
            matchPixels[i] = TemplateMatcher.getValue(this.isPixelTransparent[i] ? 0 : 255, matchPixels[i]);
        }
    }

    private double getRGBDiffSquaredAtTestPoint(int x, int y) {
        double diff = 0.0;
        int xyoff = y * this.wTest + x;
        int pmax = xyoff + (this.hTemplate - 1) * this.wTest + this.wTemplate;
        if (xyoff < 0 || pmax >= this.targetPixels.length) {
            return Double.NaN;
        }
        int j = 0;
        int tpt = 0;
        int targetIndex = xyoff;
        int dw = this.wTest - this.wTemplate;
        while (j < this.hTemplate) {
            int i = 0;
            while (i < this.wTemplate) {
                if (targetIndex >= this.targetPixels.length) {
                    return Double.NaN;
                }
                if (!this.isPixelTransparent[tpt]) {
                    int pixel = this.targetPixels[targetIndex];
                    diff += TemplateMatcher.getRGBDiffSquared(pixel, this.templateR[tpt], this.templateG[tpt], this.templateB[tpt]);
                }
                ++i;
                ++tpt;
                ++targetIndex;
            }
            ++j;
            targetIndex += dw;
        }
        return diff;
    }

    public int[][] getSearchPoints(Rectangle searchRect, double x0, double y0, double theta, int lineSpread) {
        int sx = searchRect.x;
        int sy = searchRect.y;
        int sh = searchRect.height;
        int sw = searchRect.width;
        double slope = -Math.tan(theta);
        Line2D.Double line = new Line2D.Double();
        if (Math.abs(slope) > 1.0E10) {
            line.setLine(x0, y0, x0, y0 + 1.0);
        } else if (Math.abs(slope) < 1.0E-10) {
            line.setLine(x0, y0, x0 + 1.0, y0);
        } else {
            line.setLine(x0, y0, x0 + 1.0, y0 + slope);
        }
        double[] uxy = new double[3];
        double[] p1 = new double[2];
        double[] p2 = new double[]{Double.NaN, Double.NaN};
        Object p = p1;
        if (TemplateMatcher.getDistanceAndPointAtX(line, sx, uxy)) {
            p[0] = uxy[1];
            p[1] = uxy[2];
            if (p[1] >= (double)sy && p[1] <= (double)(sy + sh)) {
                p = p2;
            }
        }
        if (TemplateMatcher.getDistanceAndPointAtX(line, sx + sw, uxy)) {
            p[0] = uxy[1];
            p[1] = uxy[2];
            if (p[1] >= (double)sy && p[1] <= (double)(sy + sh)) {
                p = p == p1 ? p2 : null;
            }
        }
        if (p != null) {
            if (TemplateMatcher.getDistanceAndPointAtY(line, sy, uxy)) {
                p[0] = uxy[1];
                p[1] = uxy[2];
                if (p[0] >= (double)sx && p[0] <= (double)(sx + sw)) {
                    if (p == p1) {
                        p = p2;
                    } else if (p1[0] != p2[0] || p1[1] != p2[1]) {
                        p = null;
                    }
                }
            }
            if (p == p2 && TemplateMatcher.getDistanceAndPointAtY(line, sy + sh, uxy)) {
                p[0] = uxy[1];
                p[1] = uxy[2];
                if (p[0] >= (double)sx && p[0] <= (double)(sx + sw) && p == p2 && (p1[0] != p2[0] || p1[1] != p2[1])) {
                    p = null;
                }
            }
        }
        if (p != null) {
            return null;
        }
        if (p1[0] <= p2[0]) {
            line.setLine(p1[0], p1[1], p2[0], p2[1]);
        } else {
            line.setLine(p2[0], p2[1], p1[0], p1[1]);
        }
        int xMin = (int)Math.ceil(Math.min(p1[0], p2[0]));
        int xMax = (int)Math.floor(Math.max(p1[0], p2[0]));
        int yMin = (int)Math.ceil(Math.min(p1[1], p2[1]));
        int yMax = (int)Math.floor(Math.max(p1[1], p2[1]));
        TreeMap<Double, double[]> intersections = new TreeMap<Double, double[]>();
        int x = xMin;
        while (x <= xMax) {
            if (TemplateMatcher.getDistanceAndPointAtX(line, x, uxy)) {
                intersections.put(uxy[0], new double[]{uxy[1], uxy[2]});
            }
            ++x;
        }
        int y = yMin;
        while (y <= yMax) {
            if (TemplateMatcher.getDistanceAndPointAtY(line, y, uxy)) {
                intersections.put(uxy[0], new double[]{uxy[1], uxy[2]});
            }
            ++y;
        }
        int[][] pts = new int[intersections.size() - 1][2];
        int i = -1;
        double[] pxy = null;
        for (double[] next : intersections.values()) {
            if (pxy != null) {
                pts[i][0] = (int)((pxy[0] + next[0]) / 2.0) - sx;
                pts[i][1] = (int)((pxy[1] + next[1]) / 2.0) - sy;
            }
            pxy = next;
            ++i;
        }
        return pts;
    }

    private static boolean getDistanceAndPointAtX(Line2D.Double line, double x, double[] uxy) {
        double dx = line.x2 - line.x1;
        if (dx == 0.0) {
            return false;
        }
        uxy[0] = (x - line.x1) / dx;
        uxy[1] = x;
        uxy[2] = line.y1 + uxy[0] * (line.y2 - line.y1);
        return true;
    }

    private static boolean getDistanceAndPointAtY(Line2D.Double line, double y, double[] uxy) {
        double dy = line.y2 - line.y1;
        if (dy == 0.0) {
            return false;
        }
        uxy[0] = (y - line.y1) / dy;
        uxy[1] = line.x1 + uxy[0] * (line.x2 - line.x1);
        uxy[2] = y;
        return true;
    }

    private static double getRGBDiffSquared(int pixel, int r, int g, int b) {
        int dr = r - (pixel >> 16 & 0xFF);
        int dg = g - (pixel >> 8 & 0xFF);
        int db = b - (pixel & 0xFF);
        return dr * dr + dg * dg + db * db;
    }

    private static AlphaComposite getComposite(int alpha) {
        float a = 1.0f * (float)alpha / 255.0f;
        return AlphaComposite.getInstance(3, a);
    }

    private static BufferedImage ensureType(BufferedImage image, int w, int h, int type) {
        if (image != null && image.getType() == type) {
            return image;
        }
        BufferedImage bi = new BufferedImage(w, h, type);
        if (image != null) {
            Graphics2D g = bi.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
        }
        return bi;
    }

    private static int[] getPixels(BufferedImage img) {
        return ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
    }

    private static void transferPixels(int[] p0, int x, int y, int w0, int[] p1, int w1) {
        int tpt = 0;
        int len = p1.length;
        int dw = w0 - w1;
        int pt = y * w0 + x;
        while (tpt < len) {
            int j = 0;
            while (j < w1) {
                p1[tpt] = p0[pt];
                ++j;
                ++pt;
                ++tpt;
            }
            pt += dw;
        }
    }

    private static BitSet getOpaqueBS(int[] pixels, int w, int h) {
        int nPixels = w * h;
        BitSet bs = new BitSet(nPixels);
        int i = nPixels;
        while (--i >= 0) {
            if ((pixels[i] & 0xFF000000) != -16777216) continue;
            bs.set(i);
        }
        return bs;
    }
}

