/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Circle;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoPanel;

public class TrackableCircle
extends Circle
implements Trackable {
    protected int n;

    public TrackableCircle(int n, double imageX, double imageY) {
        super(imageX, imageY);
        this.n = n;
        this.color = Color.green;
    }

    public int getFrameNumber() {
        return this.n;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!(panel instanceof VideoPanel)) {
            return;
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        double x = this.getX();
        double y = this.getY();
        if (!vidPanel.isDrawingInImageSpace()) {
            x = vidPanel.getCoords().imageToWorldX(this.n, this.getX(), this.getY());
            y = vidPanel.getCoords().imageToWorldY(this.n, this.getX(), this.getY());
        }
        int xpix = panel.xToPix(x) - this.pixRadius;
        int ypix = panel.yToPix(y) - this.pixRadius;
        g.setColor(this.color);
        g.fillOval(xpix, ypix, 2 * this.pixRadius, 2 * this.pixRadius);
    }
}

