/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.geom.AffineTransform;

public class TransformArray {
    private AffineTransform[] array;

    public TransformArray(int initialLength) {
        initialLength = Math.max(initialLength, 1);
        this.array = new AffineTransform[initialLength];
        this.array[0] = new AffineTransform();
        this.fill(this.array, this.array[0]);
    }

    public AffineTransform get(int n) {
        if (n >= this.array.length) {
            this.setLength(n + 1);
        }
        return this.array[n];
    }

    public void setLength(int newLength) {
        if (newLength == this.array.length || newLength < 1) {
            return;
        }
        AffineTransform[] newArray = new AffineTransform[newLength];
        System.arraycopy(this.array, 0, newArray, 0, Math.min(newLength, this.array.length));
        if (newLength > this.array.length) {
            AffineTransform at = this.array[this.array.length - 1];
            this.fill(newArray, at);
        }
        this.array = newArray;
    }

    private void fill(AffineTransform[] array, AffineTransform at) {
        int n = 0;
        while (n < array.length) {
            if (array[n] == null) {
                array[n] = new AffineTransform(at);
            }
            ++n;
        }
    }
}

