/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.axes.CartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.XYCoordinateStringBuilder;

public class VidCartesianCoordinateStringBuilder
extends CartesianCoordinateStringBuilder
implements XYCoordinateStringBuilder {
    protected VidCartesianCoordinateStringBuilder() {
    }

    protected VidCartesianCoordinateStringBuilder(String xLabel, String yLabel) {
        super(xLabel, yLabel);
    }

    @Override
    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        if (!(panel instanceof VideoPanel)) {
            return super.getCoordinateString(panel, e);
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        Point2D pt = vidPanel.getWorldMousePoint();
        return this.getCoordinateString(vidPanel, pt.getX(), pt.getY());
    }

    @Override
    public String getCoordinateString(VideoPanel panel, double x, double y) {
        String msg;
        if (Math.abs(x) > 100.0 || Math.abs(x) < 0.01 || Math.abs(y) > 100.0 || Math.abs(y) < 0.01) {
            this.scientificFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
            msg = String.valueOf(this.xLabel) + this.scientificFormat.format((float)x) + this.yLabel + this.scientificFormat.format((float)y);
        } else {
            this.decimalFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
            msg = String.valueOf(this.xLabel) + this.decimalFormat.format((float)x) + this.yLabel + this.decimalFormat.format((float)y);
        }
        return msg;
    }
}

