/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.BitSet;
import org.opensourcephysics.media.core.InteractiveImage;
import org.opensourcephysics.media.core.Trackable;

public interface Video
extends InteractiveImage,
Trackable,
PropertyChangeListener {
    public static final String PROPERTY_VIDEO_COORDS = "coords";
    public static final String PROPERTY_VIDEO_FILTERCHANGED = "filterChanged";
    public static final String PROPERTY_VIDEO_IMAGE = "image";
    public static final String PROPERTY_VIDEO_SIZE = "size";
    public static final String PROPERTY_VIDEO_VIDEOVISIBLE = "videoVisible";
    public static final String PROPERTY_VIDEO_FRAMENUMBER = "framenumber";
    public static final String PROPERTY_VIDEO_NEXTFRAME = "nextframe";
    public static final String PROPERTY_VIDEO_ENDFRAME = "endframe";
    public static final String PROPERTY_VIDEO_LOOPING = "looping";
    public static final String PROPERTY_VIDEO_PLAYING = "playing";
    public static final String PROPERTY_VIDEO_RATE = "rate";

    default public void removeListener(PropertyChangeListener c) {
        this.removePropertyChangeListener(PROPERTY_VIDEO_COORDS, c);
        this.removePropertyChangeListener(PROPERTY_VIDEO_FILTERCHANGED, c);
        this.removePropertyChangeListener(PROPERTY_VIDEO_IMAGE, c);
        this.removePropertyChangeListener(PROPERTY_VIDEO_SIZE, c);
        this.removePropertyChangeListener(PROPERTY_VIDEO_VIDEOVISIBLE, c);
    }

    default public void addListener(PropertyChangeListener c) {
        this.addPropertyChangeListener(PROPERTY_VIDEO_COORDS, c);
        this.addPropertyChangeListener(PROPERTY_VIDEO_FILTERCHANGED, c);
        this.addPropertyChangeListener(PROPERTY_VIDEO_IMAGE, c);
        this.addPropertyChangeListener(PROPERTY_VIDEO_SIZE, c);
        this.addPropertyChangeListener(PROPERTY_VIDEO_VIDEOVISIBLE, c);
    }

    public Dimension getImageSize(boolean var1);

    public void step();

    public void back();

    public int getFrameCount();

    public int getFrameNumber();

    public void setFrameNumber(int var1);

    public int getStartFrameNumber();

    public void setStartFrameNumber(int var1);

    public int getEndFrameNumber();

    public void setEndFrameNumber(int var1);

    public double getFrameTime(int var1);

    public double getFrameDuration(int var1);

    public void setFrameX(int var1, double var2);

    public void setFrameY(int var1, double var2);

    public void setFrameXY(int var1, double var2, double var4);

    public void setFrameRelativeAspect(int var1, double var2);

    public void setFrameWidth(int var1, double var2);

    public void setFrameHeight(int var1, double var2);

    public void setFrameAngle(int var1, double var2);

    public void dispose();

    public String getTypeName();

    default public boolean isValid() {
        return this.getFrameCountDurationMS() > 0.0;
    }

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public void play();

    public void stop();

    public void reset();

    public double getStartTime();

    public void setStartTime(double var1);

    public double getEndTime();

    public void setEndTime(double var1);

    public void goToStart();

    public void goToEnd();

    public double getFrameCountDurationMS();

    default public double getAverageFrameDuration(boolean allowOneFrame) {
        int firstFrame;
        int lastFrame = this.getEndFrameNumber();
        int count = lastFrame - (firstFrame = this.getStartFrameNumber());
        if (count == 0) {
            return allowOneFrame ? 1.0 / this.getAverageFrameRate() : 0.0;
        }
        double ti = this.getFrameTime(firstFrame);
        double tf = this.getFrameTime(lastFrame);
        return (tf - ti) / (double)count;
    }

    public double getRate();

    public void setRate(double var1);

    @Deprecated
    public void setPlaying(boolean var1);

    public boolean isPlaying();

    public void setLooping(boolean var1);

    public boolean isLooping();

    public void invalidateVideoAndFilter();

    default public double getAverageFrameRate() {
        return (double)this.getFrameCount() / this.getFrameCountDurationMS();
    }

    default public BitSet getOutliers(double tolerance) {
        BitSet outliers = new BitSet();
        double videoDurMS = this.getFrameCountDurationMS();
        double frameDur = 0.0;
        int nFrames = this.getFrameCount();
        int i = 0;
        while (i < nFrames) {
            double durMS;
            double err;
            if (i == 0) {
                frameDur = videoDurMS / (double)(nFrames - outliers.cardinality());
            }
            if (!outliers.get(i) && (err = Math.abs(frameDur - (durMS = this.getFrameDuration(i))) / frameDur) > tolerance) {
                videoDurMS -= durMS;
                outliers.set(i);
                i = -1;
            }
            ++i;
        }
        outliers.clear(nFrames - 1);
        return outliers;
    }
}

