/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.ResourceLoader;

public abstract class VideoAdapter
extends OSPRuntime.Supported
implements Video {
    protected Image rawImage;
    protected Dimension size = new Dimension();
    protected Dimension displayedSize = new Dimension();
    protected BufferedImage bufferedImage;
    protected BufferedImage filteredImage;
    protected String baseDir;
    protected int frameCount = 0;
    protected int frameNumber = 0;
    protected int startFrameNumber;
    protected int endFrameNumber;
    protected double rate = 1.0;
    protected boolean playing = false;
    protected boolean looping = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean mouseEnabled = false;
    protected boolean visible = true;
    protected boolean isMeasured = false;
    protected boolean isValidMeasure = false;
    protected boolean widthDominates = true;
    protected boolean isValidImage = false;
    protected boolean isValidFilteredImage = false;
    protected ImageCoordSystem coords;
    protected DoubleArray aspects;
    protected HashMap<String, Object> properties = new HashMap();
    protected FilterStack filterStack = new FilterStack();
    protected DataBufferInt clearRaster;
    protected double[] startTimesMS;
    private boolean doNotify = true;
    private static final Point2D.Double corner = new Point2D.Double(0.0, 0.0);
    static int ntest = 0;
    static int ntest1 = 0;
    static int ntest2 = 0;

    public void setNotify(boolean b) {
        this.doNotify = b;
    }

    protected VideoAdapter() {
        this.initialize();
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (this.rawImage == null || !this.visible || this.filterStack == null) {
            return;
        }
        int xoffset = 0;
        int yoffset = 0;
        Graphics2D g2 = null;
        if (panel instanceof VideoPanel && ((VideoPanel)panel).isDrawingInImageSpace() || this.isMeasured) {
            g2 = (Graphics2D)g.create();
            AffineTransform at = panel.getPixelTransform();
            g2.transform(at);
            ImageCoordSystem coords = null;
            if (panel instanceof VideoPanel) {
                VideoPanel vidPanel = (VideoPanel)panel;
                if (!vidPanel.isDrawingInImageSpace()) {
                    coords = vidPanel.getCoords();
                }
            } else {
                coords = this.coords;
            }
            if (coords != null) {
                at = coords.getToWorldTransform(this.frameNumber);
                g2.transform(at);
            }
            g2.drawImage(this.filterStack.isEmpty() || !this.filterStack.isEnabled() ? this.rawImage : this.getImage(), xoffset, yoffset, panel);
            g2.dispose();
        } else {
            double centerX = (panel.getXMax() + panel.getXMin()) / 2.0;
            double centerY = (panel.getYMax() + panel.getYMin()) / 2.0;
            xoffset = panel.xToPix(centerX) - this.size.width / 2;
            yoffset = panel.yToPix(centerY) - this.size.height / 2;
            g.drawImage(this.filterStack.isEmpty() || !this.filterStack.isEnabled() ? this.rawImage : this.getImage(), xoffset, yoffset, panel);
        }
    }

    @Override
    public final void invalidateVideoAndFilter() {
        this.isValidFilteredImage = false;
        this.isValidImage = false;
    }

    protected final void notifyFrame(final int n, boolean isAsync) {
        if (!this.doNotify) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                VideoAdapter.this.firePropertyChange("framenumber", null, n);
            }
        };
        if (isAsync) {
            SwingUtilities.invokeLater(r);
        } else {
            r.run();
        }
    }

    @Override
    public final int getStartFrameNumber() {
        return this.startFrameNumber;
    }

    @Override
    public final void setStartFrameNumber(int n) {
        if (n == this.startFrameNumber) {
            return;
        }
        n = Math.max(0, n);
        this.startFrameNumber = Math.min(this.endFrameNumber, n);
        this.firePropertyChange("startframe", null, this.startFrameNumber);
    }

    @Override
    public final int getEndFrameNumber() {
        return this.endFrameNumber;
    }

    @Override
    public final void setEndFrameNumber(int n) {
        if (n == this.endFrameNumber) {
            return;
        }
        if (this.frameCount > 1) {
            n = Math.min(this.frameCount - 1, n);
        }
        this.endFrameNumber = Math.max(this.startFrameNumber, n);
        this.firePropertyChange("endframe", null, this.endFrameNumber);
    }

    @Override
    public final void reset() {
        this.stop();
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public final void goToStart() {
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public final void goToEnd() {
        this.setFrameNumber(this.endFrameNumber);
    }

    @Override
    @Deprecated
    public final void setPlaying(boolean playing) {
        if (playing) {
            this.play();
        } else {
            this.stop();
        }
    }

    @Override
    public final boolean isPlaying() {
        return this.playing;
    }

    @Override
    public final void setLooping(boolean loops) {
        if (this.looping == loops) {
            return;
        }
        this.looping = loops;
        this.firePropertyChange("looping", null, this.looping);
    }

    @Override
    public final boolean isLooping() {
        return this.looping;
    }

    @Override
    public final double getRate() {
        return this.rate;
    }

    @Override
    public final void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange("videoVisible", null, visible);
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    @Override
    public final double getXMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minX;
    }

    @Override
    public final double getXMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxX;
    }

    @Override
    public final double getYMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minY;
    }

    @Override
    public final double getYMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxY;
    }

    @Override
    public final boolean isMeasured() {
        return this.isMeasured;
    }

    public final BufferedImage getRawBufferedImage() {
        this.updateBufferedImage();
        return this.bufferedImage;
    }

    @Override
    public final Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        return this.mouseEnabled ? this : null;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.mouseEnabled = enabled;
    }

    @Override
    public final boolean isEnabled() {
        return this.mouseEnabled;
    }

    @Override
    public final void setFrameX(int n, double x) {
        this.setFrameXY(n, x, this.coords.imageToWorldY(n, 0.0, 0.0));
    }

    @Override
    public final void setX(double x) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameX(n, x);
            ++n;
        }
    }

    @Override
    public final void setFrameY(int n, double y) {
        this.setFrameXY(n, this.coords.imageToWorldX(n, 0.0, 0.0), y);
    }

    @Override
    public final void setY(double y) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameY(n, y);
            ++n;
        }
    }

    @Override
    public final double getX() {
        return this.coords.imageToWorldX(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public final double getY() {
        return this.coords.imageToWorldY(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public final void setFrameXY(int n, double x, double y) {
        double sin = this.coords.getSine(n);
        double cos = this.coords.getCosine(n);
        double tx = this.coords.getScaleX(n) * (y * sin - x * cos);
        double ty = this.coords.getScaleY(n) * (y * cos + x * sin);
        this.coords.setOriginXY(n, tx, ty);
    }

    @Override
    public final void setXY(double x, double y) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameXY(n, x, y);
            ++n;
        }
    }

    @Override
    public final void setFrameRelativeAspect(int n, double relativeAspect) {
        if (relativeAspect < 0.001 || relativeAspect > 1000.0) {
            return;
        }
        this.aspects.set(n, Math.abs(relativeAspect));
        if (this.isMeasured) {
            if (this.widthDominates) {
                this.setFrameWidth(n, (double)this.size.width / this.coords.getScaleX(n));
            } else {
                this.setFrameHeight(n, (double)this.size.height / this.coords.getScaleY(n));
            }
        }
    }

    @Override
    public final void setRelativeAspect(double relativeAspect) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameRelativeAspect(n, relativeAspect);
            ++n;
        }
    }

    @Override
    public final double getRelativeAspect() {
        return this.aspects.get(this.frameNumber);
    }

    @Override
    public final void setFrameWidth(int n, double width) {
        if (width == 0.0) {
            return;
        }
        width = Math.abs(width);
        double x = this.coords.imageToWorldX(n, 0.0, 0.0);
        double y = this.coords.imageToWorldY(n, 0.0, 0.0);
        double scaleX = (double)this.size.width / width;
        this.coords.setScaleX(n, scaleX);
        this.coords.setScaleY(n, scaleX * this.aspects.get(n));
        this.widthDominates = true;
        this.setFrameXY(n, x, y);
    }

    @Override
    public final void setWidth(double width) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameWidth(n, width);
            ++n;
        }
    }

    @Override
    public final double getWidth() {
        return (double)this.size.width / this.coords.getScaleX(this.frameNumber);
    }

    @Override
    public final void setFrameHeight(int n, double height) {
        if (height == 0.0) {
            return;
        }
        height = Math.abs(height);
        double x = this.coords.imageToWorldX(n, 0.0, 0.0);
        double y = this.coords.imageToWorldY(n, 0.0, 0.0);
        double scaleY = (double)this.size.height / height;
        this.coords.setScaleY(n, scaleY);
        this.coords.setScaleX(n, scaleY / this.aspects.get(n));
        this.widthDominates = false;
        this.setFrameXY(n, x, y);
    }

    @Override
    public final void setHeight(double height) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameHeight(n, height);
            ++n;
        }
    }

    @Override
    public final double getHeight() {
        return (double)this.size.height / this.coords.getScaleY(this.frameNumber);
    }

    @Override
    public final Dimension getImageSize(boolean withFilters) {
        BufferedImage img;
        if (withFilters && (img = this.getImage()) != null) {
            this.displayedSize.setSize(img.getWidth(), img.getHeight());
            return this.displayedSize;
        }
        return this.size;
    }

    @Override
    public final void setFrameAngle(int n, double theta) {
        double x = this.coords.imageToWorldX(n, 0.0, 0.0);
        double y = this.coords.imageToWorldY(n, 0.0, 0.0);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        this.coords.setCosineSine(n, cos, -sin);
        this.setFrameXY(n, x, y);
    }

    @Override
    public final void setAngle(double theta) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameAngle(n, theta);
            ++n;
        }
    }

    @Override
    public final double getAngle() {
        return -this.coords.getAngle(this.frameNumber);
    }

    @Override
    public final void step() {
        this.stop();
        this.setFrameNumber(this.frameNumber + 1);
    }

    @Override
    public final void back() {
        this.stop();
        this.setFrameNumber(this.frameNumber - 1);
    }

    @Override
    public final int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public final int getFrameNumber() {
        return this.frameNumber;
    }

    protected final void finalize() {
        OSPLog.finalized(this);
    }

    protected final void initialize() {
        this.filterStack.addPropertyChangeListener("image", this);
        this.filterStack.addPropertyChangeListener("tab", this);
    }

    protected final void refreshBufferedImage() {
        if (this.bufferedImage != null && this.bufferedImage.getWidth() == this.size.width && this.bufferedImage.getHeight() == this.size.height) {
            return;
        }
        this.bufferedImage = new BufferedImage(this.size.width, this.size.height, 1);
        this.isValidImage = false;
    }

    protected final void findMinMaxValues() {
        VideoClip clip = (VideoClip)this.getProperty("videoclip");
        AffineTransform at = this.coords.getToWorldTransform(clip == null ? 0 : clip.getStartFrameNumber());
        this.minY = Double.MAX_VALUE;
        this.minX = Double.MAX_VALUE;
        this.maxY = -1.7976931348623157E308;
        this.maxX = -1.7976931348623157E308;
        this.addMinMax(at, 0, 0);
        int w = this.size.width;
        int h = this.size.height;
        int i = clip == null ? this.frameCount : clip.getStepCount();
        while (--i >= 0) {
            at = this.coords.getToWorldTransform(clip == null ? i : clip.stepToFrame(i));
            this.addMinMax(at, 0, 0);
            this.addMinMax(at, w, 0);
            this.addMinMax(at, w, h);
            this.addMinMax(at, 0, h);
        }
        this.isValidMeasure = true;
    }

    private final void addMinMax(AffineTransform at, int x, int y) {
        corner.setLocation(x, y);
        at.transform(corner, corner);
        this.minX = Math.min(VideoAdapter.corner.x, this.minX);
        this.maxX = Math.max(VideoAdapter.corner.x, this.maxX);
        this.minY = Math.min(VideoAdapter.corner.y, this.minY);
        this.maxY = Math.max(VideoAdapter.corner.y, this.maxY);
    }

    protected final String getAbsolutePath(String path) {
        String base;
        int n;
        if (this.baseDir == null) {
            this.baseDir = XML.getDirectoryPath((String)this.getProperty("absolutePath"));
        }
        if ((n = (base = this.baseDir).indexOf("file:")) > -1) {
            base = base.substring(n + 5, base.length());
            if (OSPRuntime.isWindows() && base.startsWith("/")) {
                base = base.substring(1, base.length());
            }
        }
        if (base != "" && !path.replace('\\', '/').startsWith(base)) {
            path = String.valueOf(base) + "/" + path;
            if (!ResourceLoader.isHTTP(base)) {
                path = XML.getAbsolutePath(new File(path));
            }
        }
        return path;
    }

    protected final void notifySize(Dimension newDim) {
        if (!this.doNotify) {
            return;
        }
        if (newDim.height != this.size.height || newDim.width != this.size.width) {
            Dimension oldSize = new Dimension(this.size);
            this.size.width = newDim.width;
            this.size.height = newDim.height;
            this.refreshBufferedImage();
            this.firePropertyChange("size", oldSize, this.size);
        }
    }

    @Override
    public void setFrameNumber(int n) {
        if (n == this.frameNumber) {
            return;
        }
        this.frameNumber = Math.min(Math.max(n, this.startFrameNumber), this.endFrameNumber);
        if (this.doNotify) {
            this.firePropertyChange("nextframe", null, this.frameNumber);
        }
    }

    @Override
    public double getFrameTime(int i) {
        if (i >= this.startTimesMS.length || i < 0) {
            return -1.0;
        }
        return this.startTimesMS[i];
    }

    @Override
    public final double getFrameDuration(int n) {
        if (this.frameCount == 1) {
            return this.getFrameCountDurationMS();
        }
        if (n == this.frameCount - 1) {
            return this.getFrameCountDurationMS() - this.getFrameTime(n);
        }
        return this.getFrameTime(n + 1) - this.getFrameTime(n);
    }

    @Override
    public double getStartTime() {
        return this.getFrameTime(this.getStartFrameNumber());
    }

    protected abstract void setStartTimes();

    @Override
    @Deprecated
    public void setStartTime(double millis) {
        millis = Math.abs(millis);
        int i = 0;
        while (i < this.startTimesMS.length) {
            double t = this.startTimesMS[i];
            if (millis < t) {
                this.setStartFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public double getEndTime() {
        int n = this.getEndFrameNumber();
        if (n < this.getFrameCount() - 1) {
            return this.getFrameTime(n + 1);
        }
        return this.getFrameCountDurationMS();
    }

    @Override
    public void setEndTime(double millis) {
        millis = Math.abs(millis);
        millis = Math.min(this.getFrameCountDurationMS(), millis);
        int i = 0;
        while (i < this.startTimesMS.length) {
            double t = this.startTimesMS[i];
            if (millis < t) {
                this.setEndFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public void setRate(double rate) {
        if ((rate = Math.abs(rate)) == this.rate || rate == 0.0) {
            return;
        }
        this.rate = rate;
    }

    @Override
    public BufferedImage getImage() {
        this.updateBufferedImage();
        if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
            return this.bufferedImage;
        }
        if (!this.isValidFilteredImage) {
            this.isValidFilteredImage = true;
            this.filteredImage = this.filterStack.getFilteredImage(this.bufferedImage);
        }
        return this.filteredImage;
    }

    protected void updateBufferedImage() {
        this.refreshBufferedImage();
        if (!this.isValidImage) {
            this.isValidImage = true;
            Graphics2D g = this.bufferedImage.createGraphics();
            g.drawImage(this.rawImage, 0, 0, null);
            g.dispose();
        }
    }

    protected void setFrameCount(int n) {
        this.frameCount = n;
    }

    @Override
    public void setCoords(ImageCoordSystem newCoords) {
        if (newCoords == this.coords) {
            return;
        }
        if (this.coords != null) {
            this.coords.removePropertyChangeListener("transform", this);
        }
        this.coords = newCoords;
        this.coords.addPropertyChangeListener("transform", this);
        this.isMeasured = true;
        this.isValidMeasure = false;
        this.firePropertyChange("coords", null, newCoords);
    }

    @Override
    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    @Override
    public void setFilterStack(FilterStack stack) {
        if (stack == this.filterStack) {
            return;
        }
        if (this.filterStack != null) {
            this.filterStack.removePropertyChangeListener("image", this);
            this.filterStack.removePropertyChangeListener("tab", this);
        }
        this.filterStack = stack;
        this.filterStack.addPropertyChangeListener("image", this);
        this.filterStack.addPropertyChangeListener("tab", this);
    }

    @Override
    public FilterStack getFilterStack() {
        return this.filterStack;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name.equals("measure")) {
            this.isValidMeasure = false;
        } else {
            this.properties.put(name, value);
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public void dispose() {
        if (this.coords != null) {
            this.coords.removePropertyChangeListener("transform", this);
        }
        this.coords = null;
        if (this.filterStack != null) {
            this.filterStack.removePropertyChangeListener("image", this);
            this.filterStack.removePropertyChangeListener("tab", this);
            this.filterStack.setInspectorsVisible(false);
            this.filterStack = null;
        }
        this.filteredImage = null;
        this.bufferedImage = null;
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "transform": {
                this.isMeasured = true;
                this.isValidMeasure = false;
                break;
            }
            case "tab": 
            case "image": {
                this.isValidFilteredImage = false;
                this.firePropertyChange(e);
            }
        }
    }

    public static abstract class Loader
    implements XML.ObjectLoader {
        protected Loader() {
        }

        protected abstract Video createVideo(String var1) throws IOException;

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Video video2 = (Video)obj;
            String base = (String)video2.getProperty("base");
            String absPath = (String)video2.getProperty("absolutePath");
            if (base != null && absPath != null) {
                control.setValue("path", XML.getPathRelativeTo(absPath, base));
            } else {
                String path = (String)video2.getProperty("path");
                control.setValue("path", path);
            }
            if (!video2.getFilterStack().isEmpty()) {
                control.setValue("filters", video2.getFilterStack().getFilters());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            try {
                String fullpath = control.getString("absolutePath");
                if (fullpath != null) {
                    return this.createVideo(fullpath);
                }
                String path = control.getString("path");
                if (OSPRuntime.checkTempDirCache) {
                    path = String.valueOf(OSPRuntime.tempDir) + path;
                }
                return this.createVideo(path);
            }
            catch (IOException ex) {
                OSPLog.fine(ex.getMessage());
                return null;
            }
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Video video2 = (Video)obj;
            Collection filters = (Collection)control.getObject("filters");
            if (filters != null) {
                video2.getFilterStack().clear();
                for (Filter filter : filters) {
                    video2.getFilterStack().addFilter(filter);
                }
            }
            return obj;
        }
    }
}

