/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javajs.async.AsyncDialog;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.AsyncVideoI;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.IncrementallyLoadable;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoClip
extends OSPRuntime.Supported
implements PropertyChangeListener {
    public static final String PROPERTY_VIDEOCLIP_FRAMECOUNT = "framecount";
    public static final String PROPERTY_VIDEOCLIP_STARTFRAME = "startframe";
    public static final String PROPERTY_VIDEOCLIP_STARTTIME = "starttime";
    public static final String PROPERTY_VIDEOCLIP_STEPCOUNT = "stepcount";
    public static final String PROPERTY_VIDEOCLIP_STEPSIZE = "stepsize";
    public boolean changeEngine;
    protected boolean invalid;
    Video video = null;
    ClipInspector inspector;
    private int startFrame = 0;
    private int stepSize = 1;
    private int stepCount;
    private int nullVideoFrameCount = this.stepCount = 10;
    private int maxFrameCount = 500001;
    private double startTime = 0.0;
    protected boolean isDefaultStartTime = true;
    private int[] stepFrames;
    private boolean playAllSteps = true;
    private boolean isDefaultState;
    private boolean isAdjusting = false;
    private int endFrame;
    protected String readoutType;
    protected String videoPath;
    protected double savedStartTime;
    protected boolean startTimeIsSaved = false;
    protected int extraFrames = 0;
    public VideoIO.FinalizableLoader loader;
    public int frameShift;

    public void addListener(PropertyChangeListener c) {
        this.addPropertyChangeListener("adjusting", c);
        this.addPropertyChangeListener(PROPERTY_VIDEOCLIP_FRAMECOUNT, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOCLIP_STARTFRAME, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOCLIP_STARTTIME, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOCLIP_STEPCOUNT, c);
        this.addPropertyChangeListener(PROPERTY_VIDEOCLIP_STEPSIZE, c);
    }

    public void removeListener(PropertyChangeListener c) {
        this.removePropertyChangeListener("adjusting", c);
        this.removePropertyChangeListener(PROPERTY_VIDEOCLIP_FRAMECOUNT, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOCLIP_STARTFRAME, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOCLIP_STARTTIME, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOCLIP_STEPCOUNT, c);
        this.removePropertyChangeListener(PROPERTY_VIDEOCLIP_STEPSIZE, c);
    }

    public boolean isValid() {
        return !this.invalid;
    }

    public VideoClip(Video video2) {
        this.video = video2;
        if (video2 != null) {
            video2.setProperty("videoclip", this);
            if (video2.getFrameCount() == 0 && video2 instanceof AsyncVideoI) {
                video2.addPropertyChangeListener("asyncVideoHaveFrames", this);
                return;
            }
            this.initVideo();
        }
        this.updateArray();
        this.isDefaultState = true;
    }

    private void initVideo() {
        this.setStartFrameNumber(this.video.getStartFrameNumber());
        if (this.video.getFrameCount() > 1) {
            this.setStepCount(this.video.getEndFrameNumber() - this.startFrame + 1);
        }
        if (this.video instanceof ImageVideo) {
            this.video.addPropertyChangeListener("endframe", this);
        }
    }

    public Video getVideo() {
        return this.video;
    }

    public String getVideoPath() {
        if (this.video != null) {
            return (String)this.video.getProperty("absolutePath");
        }
        return this.videoPath;
    }

    public boolean setStartFrameNumber(int start) {
        return this.setStartFrameNumber(start, this.getLastFrameNumber());
    }

    public boolean setStartFrameNumber(int start, int maxStart) {
        int prevStart = this.getStartFrameNumber();
        int prevEnd = this.getEndFrameNumber();
        start = Math.max(start, this.getFirstFrameNumber());
        start = Math.min(start, maxStart);
        if (this.video != null && this.video.getFrameCount() > 1) {
            this.video.setEndFrameNumber(this.video.getFrameCount() - 1);
            int vidStart = Math.max(0, start);
            this.video.setStartFrameNumber(vidStart);
            this.startFrame = Math.max(0, this.video.getStartFrameNumber());
        } else {
            this.startFrame = start;
            this.updateArray();
        }
        start = this.getStartFrameNumber();
        this.setEndFrameNumber(prevEnd);
        if (prevStart != start) {
            this.isDefaultState = false;
            this.firePropertyChange(PROPERTY_VIDEOCLIP_STARTFRAME, null, start);
        }
        return prevStart != start;
    }

    public int getStartFrameNumber() {
        return this.startFrame;
    }

    public boolean setStepSize(int size) {
        this.isDefaultState = false;
        if (size == 0) {
            return false;
        }
        size = Math.abs(size);
        if (this.video != null && this.video.getFrameCount() > 1) {
            int maxSize = Math.max(this.video.getFrameCount() - this.startFrame - 1 + this.extraFrames, 1);
            size = Math.min(size, maxSize);
        }
        if (this.stepSize == size) {
            return false;
        }
        int endFrame = this.getEndFrameNumber();
        this.stepSize = size;
        this.stepCount = 1 + (endFrame - this.getStartFrameNumber()) / this.stepSize;
        this.updateArray();
        this.firePropertyChange(PROPERTY_VIDEOCLIP_STEPSIZE, null, size);
        this.setEndFrameNumber(endFrame);
        return true;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepCount(int count) {
        if (count == 0) {
            return;
        }
        count = Math.abs(count);
        if (this.video != null) {
            int end;
            if (this.video.getFrameCount() > 1) {
                end = this.video.getFrameCount() - 1 + this.extraFrames;
                int maxCount = 1 + (int)((double)(end - this.startFrame) / (1.0 * (double)this.stepSize));
                count = Math.min(count, maxCount);
            }
            if ((end = this.startFrame + (count - 1) * this.stepSize) != this.video.getEndFrameNumber()) {
                this.video.setEndFrameNumber(end);
            }
        } else {
            count = Math.min(count, this.frameToStep(this.maxFrameCount - 1) + 1);
        }
        if (this.stepCount == (count = Math.max(count, 1))) {
            this.updateArray();
            return;
        }
        Integer prev = this.stepCount;
        this.stepCount = count;
        this.updateArray();
        this.firePropertyChange(PROPERTY_VIDEOCLIP_STEPCOUNT, prev, this.stepCount);
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setExtraFrames(int extras) {
        int prev = this.extraFrames;
        this.extraFrames = Math.max(extras, 0);
        if (prev != this.extraFrames) {
            OSPLog.finest("set extra frames to " + this.extraFrames);
            this.setStepCount(this.stepCount);
        }
    }

    public int getExtraFrames() {
        return this.extraFrames;
    }

    public int getFrameCount() {
        if (this.video != null && this.video.getFrameCount() > 1) {
            return Math.max(1, this.video.getFrameCount() + this.extraFrames);
        }
        int frames = this.getEndFrameNumber() - this.getStartFrameNumber() + 1;
        this.nullVideoFrameCount = Math.min(Math.max(this.nullVideoFrameCount, frames), this.maxFrameCount - 1);
        return this.nullVideoFrameCount;
    }

    public void setStartTime(double t0) {
        this.isDefaultState = false;
        if (this.startTime == t0 || this.isDefaultStartTime && Double.isNaN(t0)) {
            return;
        }
        this.isDefaultStartTime = Double.isNaN(t0);
        this.startTime = Double.isNaN(t0) ? 0.0 : t0;
        this.firePropertyChange(PROPERTY_VIDEOCLIP_STARTTIME, null, this.startTime);
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getEndFrameNumber() {
        this.endFrame = Math.max(this.startFrame, this.startFrame + this.stepSize * (this.stepCount - 1));
        return this.endFrame;
    }

    public boolean setEndFrameNumber(int end) {
        return this.setEndFrameNumber(end, this.maxFrameCount - 1, true);
    }

    public boolean extendEndFrameNumber(int end) {
        if (this.video != null && this.getFrameCount() <= end) {
            this.setExtraFrames(end + 1 - this.getFrameCount() + this.extraFrames);
        }
        return this.setEndFrameNumber(end);
    }

    private boolean setEndFrameNumber(int end, int max, boolean onlyIfChanged) {
        int maxStepSize;
        int prev = this.getEndFrameNumber();
        if (prev == end && onlyIfChanged) {
            return false;
        }
        this.isDefaultState = false;
        end = Math.max(end, this.startFrame);
        int rem = (end - this.startFrame) % this.stepSize;
        int count = (end - this.startFrame) / this.stepSize;
        if ((double)rem * 1.0 / (double)this.stepSize > 0.5) {
            ++count;
        }
        while (this.stepToFrame(count) > max) {
            --count;
        }
        this.setStepCount(count + 1);
        end = this.getEndFrameNumber();
        if (end != this.startFrame && (maxStepSize = Math.max(end - this.startFrame, 1)) < this.stepSize) {
            this.stepSize = maxStepSize;
        }
        return prev != end;
    }

    public int stepToFrame(int stepNumber) {
        return Math.max(0, this.startFrame + stepNumber * this.stepSize);
    }

    public int frameToStep(int n) {
        return (int)((double)(n - this.startFrame) / (1.0 * (double)this.stepSize));
    }

    public boolean includesFrame(int n) {
        int i = 0;
        while (i < this.stepCount) {
            if (this.stepFrames[i] == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ClipInspector getClipInspector() {
        return this.inspector;
    }

    public ClipInspector getClipInspector(ClipControl control, Frame frame) {
        if (this.inspector == null) {
            this.inspector = new ClipInspector(frame, this, control);
        }
        return this.inspector;
    }

    public void hideClipInspector() {
        if (this.inspector != null) {
            this.inspector.setVisible(false);
        }
    }

    public boolean isDefaultState() {
        return this.isDefaultState && this.inspector == null;
    }

    public void setAdjusting(boolean adjusting) {
        if (this.isAdjusting == adjusting) {
            return;
        }
        this.isAdjusting = adjusting;
        this.firePropertyChange("adjusting", this, adjusting);
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void setPlayAllSteps(boolean all) {
        this.playAllSteps = all;
    }

    public boolean isPlayAllSteps() {
        return this.playAllSteps;
    }

    protected void trimFrameCount() {
        if (this.video == null || this.video.getFrameCount() == 1) {
            this.nullVideoFrameCount = this.getEndFrameNumber() + 1;
            this.firePropertyChange(PROPERTY_VIDEOCLIP_FRAMECOUNT, null, this.nullVideoFrameCount);
        }
    }

    private void updateArray() {
        if (this.stepFrames == null || this.stepFrames.length < this.stepCount) {
            this.stepFrames = new int[this.stepCount];
        }
        int i = 0;
        while (i < this.stepCount) {
            this.stepFrames[i] = this.stepToFrame(i);
            ++i;
        }
    }

    public int getFirstFrameNumber() {
        return 0;
    }

    public int getLastFrameNumber() {
        return this.video == null || this.video.getFrameCount() == 1 ? this.getEndFrameNumber() : Math.max(0, this.video.getFrameCount() - 1 + this.extraFrames);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "asyncVideoHaveFrames": {
                this.initVideo();
                this.updateArray();
                break;
            }
            case "endframe": {
                this.setEndFrameNumber(this.video.getEndFrameNumber());
            }
        }
    }

    @Override
    public void dispose() {
        if (this.inspector != null) {
            this.inspector.dispose();
            this.inspector = null;
        }
        super.dispose();
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    static class Loader
    implements XML.ObjectLoader,
    VideoIO.FinalizableLoader {
        private Video loadedVideo;
        private VideoClip loadedClip;
        private Collection<?> loadedFilters;
        private int start;
        private int stepSize;
        private int stepCount;
        private int frameCount;
        private String base;
        private String path;
        private String readoutType;
        private double dt;
        private double startTime;
        private boolean playAllSteps;
        private boolean initialized;
        private boolean finalized;

        Loader() {
        }

        public void finalize() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            VideoClip clip = (VideoClip)obj;
            Video video2 = clip.getVideo();
            if (video2 != null) {
                if (video2 instanceof ImageVideo) {
                    ImageVideo vid = (ImageVideo)video2;
                    if (vid.isFileBased()) {
                        control.setValue("video", video2);
                    }
                    control.setValue("video_framecount", clip.getFrameCount());
                } else {
                    control.setValue("video", video2);
                    control.setValue("video_framecount", video2.getFrameCount());
                }
            }
            control.setValue(VideoClip.PROPERTY_VIDEOCLIP_STARTFRAME, clip.getStartFrameNumber());
            control.setValue(VideoClip.PROPERTY_VIDEOCLIP_STEPSIZE, clip.getStepSize());
            control.setValue(VideoClip.PROPERTY_VIDEOCLIP_STEPCOUNT, clip.getStepCount());
            control.setValue(VideoClip.PROPERTY_VIDEOCLIP_STARTTIME, clip.startTimeIsSaved ? clip.savedStartTime : clip.getStartTime());
            control.setValue("readout", clip.readoutType);
            control.setValue("playallsteps", clip.playAllSteps);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new VideoClip(null);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            boolean getVideo;
            IncrementallyLoadable ivideo;
            this.base = control.getString("basepath");
            this.loadedClip = (VideoClip)obj;
            this.loadedVideo = this.loadedClip.getVideo();
            IncrementallyLoadable incrementallyLoadable = ivideo = this.loadedVideo == null || !(this.loadedVideo instanceof IncrementallyLoadable) ? null : (IncrementallyLoadable)((Object)this.loadedVideo);
            if (ivideo != null && !ivideo.isFullyLoaded()) {
                return this.loadedClip;
            }
            if (!this.initialized) {
                this.initialized = true;
                this.start = control.getInt(VideoClip.PROPERTY_VIDEOCLIP_STARTFRAME);
                this.stepSize = control.getInt(VideoClip.PROPERTY_VIDEOCLIP_STEPSIZE);
                this.stepCount = control.getInt(VideoClip.PROPERTY_VIDEOCLIP_STEPCOUNT);
                this.startTime = control.getDouble(VideoClip.PROPERTY_VIDEOCLIP_STARTTIME);
                this.readoutType = control.getString("readout");
                this.playAllSteps = true;
                if (control.getPropertyNamesRaw().contains("playallsteps")) {
                    this.playAllSteps = control.getBoolean("playallsteps");
                }
                this.frameCount = -1;
                if (control.getPropertyNamesRaw().contains("video_framecount")) {
                    this.frameCount = control.getInt("video_framecount");
                } else if (this.start != Integer.MIN_VALUE && this.stepSize != Integer.MIN_VALUE && this.stepCount != Integer.MIN_VALUE) {
                    this.frameCount = this.start + this.stepCount * this.stepSize;
                }
                int frameShift = control.getInt("frameshift");
                if (frameShift != Integer.MIN_VALUE) {
                    this.loadedClip.frameShift = frameShift;
                    this.start -= frameShift;
                    this.frameCount -= frameShift;
                }
            }
            boolean bl = getVideo = ivideo == null && control.getPropertyNamesRaw().contains("video");
            if (!getVideo) {
                this.finalizeLoading();
                ((XMLControlElement)control).dispose();
                return obj;
            }
            ResourceLoader.addSearchPath(this.base);
            XMLControl child = control.getChildControl("video");
            this.loadedFilters = (Collection)child.getObject("filters");
            this.dt = child.getDouble("delta_t");
            String childPath = child.getString("path");
            if (childPath == null) {
                String[] paths = (String[])child.getObject("paths");
                if (paths != null) {
                    childPath = paths[0];
                } else {
                    this.path = "";
                }
            }
            if (child.getPropertyNamesRaw().contains("absolutePath")) {
                this.path = child.getString("absolutePath");
                this.base = null;
            } else {
                this.path = XML.getResolvedPath(childPath, this.base);
            }
            String fullPath = this.path;
            if (this.base != null && this.base.endsWith("!")) {
                this.path = childPath;
            } else if (fullPath.equals(XML.getResolvedPath(childPath, this.base))) {
                this.path = childPath;
            } else {
                this.base = XML.getDirectoryPath(this.path);
                this.path = XML.getName(this.path);
            }
            ArrayList<VideoType> types = VideoIO.getVideoTypesForPath(this.path);
            switch (types.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.loadedVideo = VideoIO.getVideo(this.path, this.base, types.get(0), child);
                    break;
                }
                default: {
                    this.loadedVideo = VideoIO.getVideo(this.path, this.base, null, child);
                }
            }
            if (this.loadedVideo == null && !VideoIO.isCanceled()) {
                Resource res = ResourceLoader.getResource(XML.getResolvedPath(this.path, this.base));
                boolean exists = res != null;
                boolean supported = types.size() > 0;
                OSPLog.info("\"" + fullPath + "\" could not be opened. Found? " + exists + " Supported? " + supported);
                if (!supported || exists) {
                    String codec = res == null ? null : VideoIO.getVideoCodec(res.getAbsolutePath());
                    String reason = exists ? "VideoClip null video" : "VideoClip not supported";
                    VideoIO.handleUnsupportedVideo(String.valueOf(this.base) + "/" + this.path, XML.getExtension(this.path), codec, null, reason);
                } else {
                    File[] files;
                    String message = "\"" + fullPath + "\" " + MediaRes.getString("VideoClip.Dialog.VideoNotFound.Message");
                    if (OSPRuntime.isJS) {
                        new AsyncDialog().showMessageDialog(null, message, MediaRes.getString("VideoClip.Dialog.VideoNotFound.Title"), 2, ev -> {});
                    } else if (JOptionPane.showConfirmDialog(null, message, MediaRes.getString("VideoClip.Dialog.VideoNotFound.Title"), 0, 2) == 0 && (files = VideoIO.getChooserFilesAsync("open", null)) != null && files.length > 0) {
                        this.loadedVideo = VideoIO.getVideo(XML.getAbsolutePath(files[0]), null);
                    }
                }
            }
            if (this.loadedVideo != null) {
                if (this.loadedFilters != null) {
                    this.loadedVideo.getFilterStack().clear();
                    for (Filter filter : this.loadedFilters) {
                        this.loadedVideo.getFilterStack().addFilter(filter);
                    }
                }
                if (this.loadedVideo instanceof ImageVideo && !Double.isNaN(this.dt)) {
                    ((ImageVideo)this.loadedVideo).setFrameDuration(this.dt);
                }
            }
            int frameShift = this.loadedClip.frameShift;
            this.loadedClip = new VideoClip(this.loadedVideo);
            this.loadedClip.frameShift = frameShift;
            if (this.path != null) {
                if (!this.path.startsWith("/") && this.path.indexOf(":") == -1) {
                    this.path = XML.getResolvedPath(this.path, this.base);
                }
                this.loadedClip.videoPath = this.path;
            }
            if (this.loadedVideo instanceof AsyncVideoI) {
                this.loadedClip.loader = this;
                return this.loadedClip;
            }
            if (this.loadedVideo instanceof IncrementallyLoadable) {
                return this.loadedClip;
            }
            VideoClip c = this.loadedClip;
            this.finalizeLoading();
            return c;
        }

        @Override
        public void finalizeLoading() {
            this.loadedClip.loader = null;
            if (this.frameCount == -1) {
                this.frameCount = this.loadedClip.getFrameCount();
            }
            this.loadedClip.setStepCount(this.frameCount);
            if (this.start != Integer.MIN_VALUE) {
                this.loadedClip.setStartFrameNumber(this.start);
            }
            if (this.stepSize != Integer.MIN_VALUE) {
                this.loadedClip.setStepSize(this.stepSize);
            }
            if (this.stepCount != Integer.MIN_VALUE) {
                this.loadedClip.setStepCount(this.stepCount);
            }
            if (!Double.isNaN(this.startTime)) {
                this.loadedClip.startTime = this.startTime;
            }
            this.loadedClip.readoutType = this.readoutType;
            this.loadedClip.playAllSteps = this.playAllSteps;
            this.dispose();
        }

        private void dispose() {
            this.loadedClip = null;
            this.loadedVideo = null;
            this.loadedFilters = null;
            this.finalized = true;
        }

        @Override
        public boolean isFinalized() {
            return this.finalized;
        }
    }
}

