/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.VideoClip;

public class VideoClipControl
extends ClipControl {
    protected VideoClipControl(VideoClip videoClip) {
        super(videoClip);
    }

    @Override
    public void play() {
        this.video.play();
    }

    @Override
    public void stop() {
        this.video.stop();
    }

    @Override
    public void step() {
        this.video.stop();
        this.setStepNumber(this.stepNumber + 1);
    }

    @Override
    public void back() {
        this.video.stop();
        this.setStepNumber(this.stepNumber - 1);
    }

    @Override
    public void setStepNumber(int n) {
        if (n == this.stepNumber && this.clip.stepToFrame(n) == this.getFrameNumber()) {
            return;
        }
        n = Math.max(0, n);
        int stepNum = Math.min(this.clip.getStepCount() - 1, n);
        SwingUtilities.invokeLater(() -> this.video.setFrameNumber(this.clip.stepToFrame(stepNum)));
    }

    @Override
    public int getStepNumber() {
        return this.clip.frameToStep(this.video.getFrameNumber());
    }

    @Override
    public void setRate(double newRate) {
        if (newRate == 0.0 || newRate == this.rate) {
            return;
        }
        this.rate = Math.abs(newRate);
        this.video.setRate(this.rate);
    }

    @Override
    public double getRate() {
        return this.video.getRate();
    }

    @Override
    public void setLooping(boolean loops) {
        if (loops == this.isLooping()) {
            return;
        }
        this.video.setLooping(loops);
    }

    @Override
    public boolean isLooping() {
        return this.video.isLooping();
    }

    @Override
    public int getFrameNumber() {
        int n = this.video.getFrameNumber();
        n = Math.max(0, n);
        return n;
    }

    @Override
    public boolean isPlaying() {
        return this.video.isPlaying();
    }

    @Override
    public double getTime() {
        int n = this.video.getFrameNumber();
        return (this.video.getFrameTime(n) - this.video.getStartTime()) * this.timeStretch;
    }

    @Override
    public double getStepTime(int stepNumber) {
        int n = this.clip.stepToFrame(stepNumber);
        return (this.video.getFrameTime(n) - this.video.getStartTime()) * this.timeStretch;
    }

    @Override
    public void setFrameDuration(double duration) {
        if (duration == 0.0) {
            return;
        }
        duration = Math.abs(duration);
        double t = this.video.getAverageFrameDuration(false);
        if (t != 0.0) {
            this.timeStretch = duration / t;
            this.firePropertyChange("frameduration", null, duration);
        }
    }

    @Override
    public double getMeanFrameDuration() {
        return this.timeStretch * this.video.getAverageFrameDuration(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "playing": 
            case "rate": 
            case "looping": {
                this.firePropertyChange(e);
                break;
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    public void dispose() {
        this.video.removePropertyChangeListener(this);
        super.dispose();
    }

    public static XML.ObjectLoader getLoader() {
        return new ClipControl.Loader();
    }
}

