/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import java.util.Arrays;
import java.util.TreeSet;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoIO;

public class VideoFileFilter
extends VideoIO.SingleExtFileFilter
implements Comparable<VideoFileFilter> {
    String[] extensions;
    String type = "Video";

    public VideoFileFilter() {
        super(null, null);
    }

    public VideoFileFilter(String containerType, String[] extensions) {
        this();
        if (containerType != null && extensions != null && extensions.length > 0) {
            this.type = containerType;
            this.extensions = extensions;
        }
    }

    @Override
    public boolean accept(File f, boolean checkIfDir) {
        block5: {
            block4: {
                if (checkIfDir && f.isDirectory()) {
                    return true;
                }
                if (this.extensions == null) break block4;
                String extension = VideoIO.getExtension(f);
                if (extension == null) break block5;
                int i = 0;
                int n = this.extensions.length;
                while (i < n) {
                    String next = this.extensions[i];
                    if (extension.equalsIgnoreCase(next)) {
                        return true;
                    }
                    ++i;
                }
                break block5;
            }
            for (VideoFileFilter next : VideoIO.singleVideoTypeFilters) {
                if (!next.accept(f, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.desc != null) {
            return this.desc;
        }
        String desc = MediaRes.getString(String.valueOf(this.type.toUpperCase()) + "FileFilter.Description");
        String[] exts = this.getExtensions();
        if (exts != null) {
            desc = String.valueOf(desc) + " (";
            int i = 0;
            while (i < exts.length) {
                if (i > 0) {
                    desc = String.valueOf(desc) + ", ";
                }
                desc = String.valueOf(desc) + "." + exts[i];
                ++i;
            }
            desc = String.valueOf(desc) + ")";
        }
        this.desc = desc;
        return this.desc;
    }

    public String getDefaultExtension() {
        String[] exts = this.getExtensions();
        if (exts != null) {
            return exts[0];
        }
        for (VideoFileFilter next : VideoIO.singleVideoTypeFilters) {
            String ext = next.getDefaultExtension();
            if (ext == null) continue;
            return ext;
        }
        return null;
    }

    public String[] getExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (VideoFileFilter next : VideoIO.singleVideoTypeFilters) {
            String[] exts;
            String[] stringArray = exts = next.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                set.add(ext);
                ++n2;
            }
        }
        return set.toArray(new String[set.size()]);
    }

    public String getContainerType() {
        return this.type;
    }

    @Override
    public int compareTo(VideoFileFilter filter) {
        return this.getDescription().compareTo(filter.getDescription());
    }

    public String toString() {
        String s = Arrays.toString(this.extensions);
        return s.substring(1, s.length() - 1);
    }
}

