/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFrame;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifVideoRecorder;
import org.opensourcephysics.tools.VideoCaptureTool;

public class VideoGrabber
extends VideoCaptureTool {
    public static VideoGrabber VIDEO_CAPTURE_TOOL = null;
    static Dimension defaultSize = new Dimension(320, 240);
    BufferedImage scratch;
    VideoRecorder recorder;
    VideoType videoType;
    VideoPanel recorderPanel;
    VideoPanel playerPanel;
    String playerFileName;
    JFrame recorderFrame;
    JFrame playerFrame;
    Action clearAction;
    Action saveAsAction;
    Action recordAction;
    Action vidTypeAction;
    Action fpsAction;
    JButton clearButton;
    JButton saveAsButton;
    JCheckBox recordCheckBox;
    JCheckBox loopCheckBox;
    JComboBox<String> vidTypeDropDown;
    JLabel fpsLabel;
    JComboBox<String> fpsDropDown;
    boolean recording = true;
    boolean saved = false;
    int frameCount = 0;
    Dimension imageSize;
    int[] pixels = new int[1];
    Map<String, VideoType> vidTypes = new HashMap<String, VideoType>();
    boolean previewAll = false;

    public VideoGrabber() {
        this(defaultSize);
    }

    public VideoGrabber(Dimension dim) {
        super(false);
        this.imageSize = dim;
        this.createGUI();
        this.vidTypeAction.actionPerformed(null);
        this.setRecording(false);
    }

    public static VideoGrabber getTool() {
        if (VIDEO_CAPTURE_TOOL == null) {
            VIDEO_CAPTURE_TOOL = new VideoGrabber();
        }
        return VIDEO_CAPTURE_TOOL;
    }

    public static VideoGrabber getTool(Dimension dim) {
        if (VIDEO_CAPTURE_TOOL == null) {
            VIDEO_CAPTURE_TOOL = new VideoGrabber(dim);
        } else {
            VideoGrabber.VIDEO_CAPTURE_TOOL.imageSize = dim;
            VideoGrabber.VIDEO_CAPTURE_TOOL.recorderPanel.setPreferredSize(dim);
            VideoGrabber.VIDEO_CAPTURE_TOOL.recorderFrame.pack();
        }
        return VIDEO_CAPTURE_TOOL;
    }

    @Override
    public void clear() {
        this.clearAction.actionPerformed(null);
    }

    @Override
    public boolean addFrame(BufferedImage image) {
        if (this.isRecording()) {
            try {
                int w = image.getWidth();
                int h = image.getHeight();
                int remainderW = w % 16;
                int remainderH = h % 16;
                if (remainderW != 0 || remainderH != 0) {
                    image = image.getSubimage(remainderW / 2, remainderH / 2, w - remainderW, h - remainderH);
                    w = image.getWidth();
                    h = image.getHeight();
                }
                if (this.pixels.length != w * h) {
                    this.pixels = new int[w * h];
                }
                boolean newScratch = false;
                if (this.previewAll) {
                    this.scratch = null;
                } else if (this.scratch == null || this.scratch.getWidth() != w || this.scratch.getHeight() != h) {
                    this.scratch = new BufferedImage(w, h, 1);
                    newScratch = true;
                }
                BufferedImage copy = this.previewAll ? new BufferedImage(w, h, 1) : this.scratch;
                image.getRaster().getDataElements(0, 0, w, h, this.pixels);
                copy.getRaster().setDataElements(0, 0, w, h, this.pixels);
                Video video2 = this.recorderPanel.getVideo();
                if (video2 == null) {
                    this.recorderPanel.setVideo(new ImageVideo(copy));
                    this.recorderPanel.getPlayer().setReadoutTypes("frame", null);
                    if (this.recorder instanceof GifVideoRecorder) {
                        int i = this.loopCheckBox.isSelected() ? 0 : 1;
                        ((GifVideoRecorder)this.recorder).getGifEncoder().setRepeat(i);
                    }
                } else if (this.previewAll) {
                    ImageVideo imageVid = (ImageVideo)video2;
                    imageVid.insert(new Image[]{copy}, imageVid.getFrameCount(), null);
                } else if (newScratch) {
                    this.recorderPanel.setVideo(new ImageVideo(copy));
                    this.recorderPanel.getPlayer().setReadoutTypes("frame", null);
                }
                this.recorder.addFrame(copy);
                ++this.frameCount;
                String item = (String)this.fpsDropDown.getSelectedItem();
                double dt = 1000.0 / Double.parseDouble(item);
                this.recorderPanel.getPlayer().getClipControl().setFrameDuration(dt);
                this.recorderPanel.getPlayer().getVideoClip().setStepCount(this.frameCount);
                this.recorderPanel.getPlayer().setStepNumber(this.frameCount - 1);
                if (video2 == null) {
                    this.imageSize = new Dimension(image.getWidth(), image.getHeight());
                    final Dimension dim = new Dimension(image.getWidth() + 4, image.getHeight() + 4);
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            VideoGrabber.this.recorderPanel.setPreferredSize(dim);
                            VideoGrabber.this.recorderFrame.pack();
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                    this.refreshGUI();
                }
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.recorderFrame.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.recorderFrame.isVisible();
    }

    @Override
    public void setRecording(boolean record) {
        this.recording = record;
        this.refreshGUI();
    }

    @Override
    public boolean isRecording() {
        return this.recording && this.recorder != null;
    }

    @Override
    public void setVideoType(VideoType type) {
        if (type == null || type == this.videoType) {
            return;
        }
        this.videoType = type;
        this.recorder = type.getRecorder();
        this.clearAction.actionPerformed(null);
    }

    @Override
    public void setFrameRate(double fps) {
        fps = Math.max(fps, 1.0);
        fps = Math.min(fps, 60.0);
        fps = Math.round(100.0 * fps) / 100L;
        int n = this.fpsDropDown.getItemCount();
        int i = 0;
        while (i < n) {
            String item = this.fpsDropDown.getItemAt(i);
            double dropdownValue = Double.parseDouble(item);
            if (fps == dropdownValue) {
                this.fpsDropDown.setSelectedIndex(i);
                return;
            }
            if (fps > dropdownValue) {
                String s = String.valueOf(fps);
                this.fpsDropDown.insertItemAt(s, i);
                this.fpsDropDown.setSelectedItem(s);
                return;
            }
            ++i;
        }
    }

    public String saveVideoAs() {
        if (this.recorder != null) {
            try {
                return this.recorder.saveVideoAs();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "File Not Saved", 2);
            }
        }
        return null;
    }

    public VideoRecorder getRecorder() {
        return this.recorder;
    }

    protected void createGUI() {
        this.createActions();
        this.clearButton = new JButton(this.clearAction);
        this.saveAsButton = new JButton(this.saveAsAction);
        this.recordCheckBox = new JCheckBox(this.recordAction);
        this.recordCheckBox.setOpaque(false);
        this.loopCheckBox = new JCheckBox();
        this.loopCheckBox.setOpaque(false);
        this.fpsLabel = new JLabel();
        String[] rates = new String[]{"30", "29.97", "25", "20", "15", "12", "10", "8", "6", "5", "4", "3", "2", "1"};
        this.fpsDropDown = new JComboBox<String>(rates){

            @Override
            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        this.fpsDropDown.addActionListener(this.fpsAction);
        this.vidTypeDropDown = new JComboBox<String>(){

            @Override
            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        for (VideoType next : VideoIO.getVideoTypes(true)) {
            String desc = next.getDescription();
            this.vidTypes.put(desc, next);
            this.vidTypeDropDown.addItem(desc);
        }
        this.vidTypeDropDown.addActionListener(this.vidTypeAction);
        this.recorderFrame = new JFrame();
        this.recorderFrame.setDefaultCloseOperation(1);
        this.recorderFrame.setName("VideoCaptureTool");
        this.recorderFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (VideoGrabber.this.recorder instanceof ScratchVideoRecorder) {
                    ScratchVideoRecorder svr = (ScratchVideoRecorder)VideoGrabber.this.recorder;
                    if (svr.scratchFile != null) {
                        try {
                            svr.saveScratch();
                            svr.scratchFile.delete();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        JPanel contentPane = new JPanel(new BorderLayout());
        this.recorderFrame.setContentPane(contentPane);
        this.recorderPanel = new FixedSizeVideoPanel();
        this.recorderPanel.setPreferredSize(this.imageSize);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)bottomPanel, "South");
        JToolBar playerBar = new JToolBar();
        playerBar.setFloatable(false);
        this.recorderPanel.getPlayer().setBorder(null);
        this.recorderPanel.setPlayerVisible(false);
        this.recorderPanel.getPlayer().setLoopingButtonVisible(false);
        contentPane.add((Component)this.recorderPanel, "Center");
        JToolBar buttonBar = new JToolBar();
        buttonBar.setFloatable(false);
        if (this.previewAll) {
            playerBar.add(this.recorderPanel.getPlayer());
            bottomPanel.add((Component)playerBar, "Center");
        } else {
            buttonBar.add(this.recorderPanel.getPlayer().readout);
        }
        bottomPanel.add((Component)buttonBar, "South");
        buttonBar.add(this.recordCheckBox);
        buttonBar.add(Box.createHorizontalGlue());
        buttonBar.add(this.clearButton);
        buttonBar.add(this.saveAsButton);
        JToolBar topBar = new JToolBar();
        topBar.setFloatable(false);
        contentPane.add((Component)topBar, "North");
        topBar.add(this.vidTypeDropDown);
        topBar.addSeparator();
        topBar.add(this.fpsLabel);
        topBar.add(this.fpsDropDown);
        topBar.addSeparator();
        topBar.add(this.loopCheckBox);
        topBar.add(Box.createHorizontalGlue());
        this.recorderFrame.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.recorderFrame.getBounds().width) / 2;
        this.recorderFrame.setLocation(x, 0);
    }

    protected void createActions() {
        this.clearAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoGrabber.this.recorderPanel.setVideo(null);
                VideoGrabber.this.recorderPanel.getPlayer().getVideoClip().setStepCount(1);
                if (VideoGrabber.this.recorder != null) {
                    String item = (String)VideoGrabber.this.fpsDropDown.getSelectedItem();
                    double dt = 1000.0 / Double.parseDouble(item);
                    VideoGrabber.this.recorder.setFrameDuration(dt);
                    try {
                        VideoGrabber.this.recorder.createVideo();
                        VideoGrabber.this.frameCount = 0;
                        VideoGrabber.this.saved = false;
                        VideoGrabber.this.recorderPanel.setVideo(null);
                        VideoGrabber.this.recorderPanel.getPlayer().setReadoutTypes("frame", null);
                        VideoGrabber.this.recorderPanel.getPlayer().getVideoClip().setStepCount(1);
                        VideoGrabber.this.refreshGUI();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                System.gc();
            }
        };
        this.saveAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoGrabber.this.recorder != null) {
                    try {
                        String name = VideoGrabber.this.recorder.saveVideoAs();
                        if (name != null) {
                            Video video2 = VideoGrabber.this.videoType.getVideo(name);
                            if (VideoGrabber.this.playerPanel == null) {
                                VideoGrabber.this.playerPanel = new FixedSizeVideoPanel();
                                VideoGrabber.this.playerFrame = new VideoFrame(VideoGrabber.this.playerPanel);
                                int w = VideoGrabber.this.imageSize.width + 4;
                                int h = VideoGrabber.this.imageSize.height + VideoGrabber.this.recorderPanel.getPlayer().height + 4;
                                VideoGrabber.this.playerPanel.setPreferredSize(new Dimension(w, h));
                                VideoGrabber.this.playerFrame.pack();
                            }
                            VideoGrabber.this.playerPanel.setVideo(video2);
                            if (VideoGrabber.this.loopCheckBox.isVisible() && VideoGrabber.this.loopCheckBox.isSelected()) {
                                VideoGrabber.this.playerPanel.getPlayer().setLooping(true);
                                VideoGrabber.this.playerPanel.getPlayer().play();
                            }
                            VideoGrabber.this.playerFrame.setVisible(true);
                            VideoGrabber.this.saved = true;
                            VideoGrabber.this.playerFileName = name;
                            VideoGrabber.this.clearAction.actionPerformed(null);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this.recordAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoGrabber.this.recording = !VideoGrabber.this.recording;
                VideoGrabber.this.refreshGUI();
            }
        };
        this.vidTypeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object desc = VideoGrabber.this.vidTypeDropDown.getSelectedItem();
                VideoType vidType = VideoGrabber.this.vidTypes.get(desc);
                if (vidType != null) {
                    VideoGrabber.this.setVideoType(vidType);
                }
            }
        };
        this.fpsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoGrabber.this.clearAction.actionPerformed(null);
            }
        };
    }

    protected void refreshGUI() {
        this.recordCheckBox.setSelected(this.isRecording());
        this.clearButton.setEnabled(this.frameCount != 0);
        this.saveAsButton.setEnabled(this.frameCount != 0);
        this.vidTypeDropDown.setEnabled(this.frameCount == 0);
        this.vidTypeDropDown.setSelectedItem(this.videoType.getDescription());
        this.fpsDropDown.setEnabled(this.frameCount == 0);
        this.fpsDropDown.setVisible(!(this.videoType instanceof ImageVideoType));
        this.fpsLabel.setVisible(!(this.videoType instanceof ImageVideoType));
        this.loopCheckBox.setEnabled(this.frameCount == 0);
        this.recorderPanel.getPlayer().readout.setEnabled(this.frameCount != 0);
        this.recordCheckBox.setText(MediaRes.getString("VideoGrabber.Action.Capture"));
        this.loopCheckBox.setText(MediaRes.getString("VideoGrabber.Action.Loop"));
        this.loopCheckBox.setVisible(this.videoType.getClass().getSimpleName().equals("GifVideoType"));
        this.fpsLabel.setText(String.valueOf(MediaRes.getString("VideoGrabber.Label.PlayRate")) + " ");
        this.clearButton.setText(MediaRes.getString("VideoGrabber.Action.Clear"));
        this.saveAsButton.setText(MediaRes.getString("VideoGrabber.Action.SaveAs"));
        if (this.recordCheckBox.isSelected()) {
            this.recorderFrame.setTitle(String.valueOf(MediaRes.getString("VideoGrabber.Title.Capturing")) + this.videoType.getDescription());
        } else {
            this.recorderFrame.setTitle(this.videoType.getDescription());
        }
        if (this.playerFrame != null && this.playerFrame.isVisible()) {
            this.playerFrame.setTitle(String.valueOf(MediaRes.getString("VideoGrabber.Title.Saved")) + XML.getName(this.playerFileName));
        }
    }

    private class FixedSizeVideoPanel
    extends VideoPanel {
        FixedSizeVideoPanel() {
            this.setBackground(Color.black);
            this.setDrawingInImageSpace(true);
            this.setShowCoordinates(false);
        }

        @Override
        protected void scale(ArrayList<Drawable> drawables) {
            double w = this.imageWidth;
            double wBorder = ((double)this.getWidth() - w - 1.0) * 0.5 / w;
            double h = this.imageHeight;
            double hBorder = ((double)this.getHeight() - h - 1.0) * 0.5 / h;
            double border = Math.min(wBorder, hBorder);
            super.setImageBorder(border);
            super.scale(drawables);
        }
    }
}

