/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import javajs.async.AsyncDialog;
import javajs.async.AsyncFileChooser;
import javajs.async.AsyncSwingWorker;
import javajs.util.VideoReader;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifVideoType;
import org.opensourcephysics.media.mov.MovieFactory;
import org.opensourcephysics.media.mov.MovieVideo;
import org.opensourcephysics.media.mov.MovieVideoType;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoIO {
    public static final int PROGRESS_LOAD_INIT = 0;
    public static final int PROGRESS_VIDEO_LOADING = 10;
    public static final int PROGRESS_VIDEO_PROCESSING = 20;
    public static final int PROGRESS_VIDEO_READY = 80;
    public static final int PROGRESS_COMPLETE = 100;
    public static final int PROGRESS_VIDEO_CANCELED = -999;
    public static final String DEFAULT_PREFERRED_EXPORT_EXTENSION = "mp4";
    public static final String DEFAULT_VIDEO_EXTENSION = "jpg";
    public static final String[] KNOWN_VIDEO_EXTENSIONS = new String[]{"mov", "flv", "mp4", "wmv", "avi", "mts", "m2ts", "mpg", "mod", "ogg", "dv"};
    public static final String VIDEO_CONVERSION_HELP_PATH = "https://opensourcephysics.github.io/tracker-website/converting_videos.html";
    public static final String TAB = "\t";
    public static final String SPACE = " ";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    protected static String defaultDelimiter = "\t";
    public static Map<String, String> delimiters = new TreeMap<String, String>();
    protected static String delimiter = defaultDelimiter;
    public static Map<String, String> customDelimiters = new TreeMap<String, String>();
    public static SingleExtFileFilter zipFileFilter;
    public static SingleExtFileFilter trkFileFilter;
    public static SingleExtFileFilter trzFileFilter;
    public static SingleExtFileFilter videoAndTrkFileFilter;
    public static SingleExtFileFilter txtFileFilter;
    public static SingleExtFileFilter jarFileFilter;
    public static SingleExtFileFilter delimitedTextFileFilter;
    protected static boolean dataCopiedToClipboard;
    private static ArrayList<String> filenamesToReload;
    protected static AsyncFileChooser chooser;
    protected static SingleExtFileFilter imageFileFilter;
    protected static SingleExtFileFilter jpgFileFilter;
    protected static ArrayList<VideoType> videoTypes;
    protected static VideoFileFilter videoFileFilter;
    protected static Collection<VideoFileFilter> singleVideoTypeFilters;
    protected static String defaultXMLExt;
    private static boolean canceled;
    protected static String preferredExportExtension;
    public static boolean loadIncrementally;
    public static int incrementToLoad;
    public static AsyncSwingWorker loader;
    private static HashSet<String> unsupportedPaths;
    private static Map<String, String> codecMap;

    static {
        filenamesToReload = new ArrayList();
        singleVideoTypeFilters = new TreeSet<VideoFileFilter>();
        defaultXMLExt = "xml";
        preferredExportExtension = DEFAULT_PREFERRED_EXPORT_EXTENSION;
        incrementToLoad = 10;
        videoTypes = new ArrayList();
        videoFileFilter = new VideoFileFilter();
        MovieFactory.hasVideoEngine();
        VideoIO.addVideoType(new GifVideoType());
        VideoFileFilter filter = new VideoFileFilter(DEFAULT_VIDEO_EXTENSION, new String[]{DEFAULT_VIDEO_EXTENSION, "jpeg"});
        ImageVideoType vidType = new ImageVideoType(filter);
        VideoIO.addVideoType(vidType);
        VideoIO.addVideoType(new ZipImageVideoType(vidType));
        filter = new VideoFileFilter("png", new String[]{"png"});
        vidType = new ImageVideoType(filter);
        VideoIO.addVideoType(vidType);
        VideoIO.addVideoType(new ZipImageVideoType(vidType));
        imageFileFilter = new SingleExtFileFilter(null, MediaRes.getString("VideoIO.ImageFileFilter.Description")){

            @Override
            public boolean accept(File f, boolean checkDir) {
                String ext = VideoIO.getExtension(f);
                return checkDir && f.isDirectory() || VideoIO.DEFAULT_VIDEO_EXTENSION.equalsIgnoreCase(ext) || "jpeg".equalsIgnoreCase(ext) || "png".equalsIgnoreCase(ext) || "gif".equalsIgnoreCase(ext);
            }
        };
        jpgFileFilter = new SingleExtFileFilter(null, MediaRes.getString("ImageVideoType.JPGFileFilter.Description")){

            @Override
            public boolean accept(File f, boolean checkDir) {
                String ext = VideoIO.getExtension(f);
                return checkDir && f.isDirectory() || "jpeg".equalsIgnoreCase(ext) || VideoIO.DEFAULT_VIDEO_EXTENSION.equalsIgnoreCase(ext);
            }
        };
        unsupportedPaths = new HashSet();
        codecMap = new HashMap<String, String>();
    }

    private static VideoType checkVideoFilter(VideoType mtype, String extension) {
        VideoFileFilter[] filters;
        VideoFileFilter[] videoFileFilterArray = filters = mtype.getFileFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            VideoFileFilter filter = videoFileFilterArray[n2];
            if (filter.extensions != null) {
                String[] stringArray = filter.extensions;
                int n3 = filter.extensions.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray[n4];
                    if (s.indexOf(extension) > -1) {
                        return mtype;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    protected VideoIO() {
    }

    public static String getExtension(File file) {
        return XML.getExtension(file.getName());
    }

    public static String[] getZippedImagePaths(String zipPath) {
        if (zipPath == null) {
            return null;
        }
        int n = zipPath.indexOf("!");
        if (n > 0 && (zipPath = zipPath.substring(0, n)).startsWith("jar:")) {
            zipPath = zipPath.substring(4, zipPath.length());
        }
        if (zipFileFilter != null && !zipFileFilter.accept(new File(zipPath))) {
            return null;
        }
        String name = XML.getName(zipPath);
        boolean useCache = !filenamesToReload.remove(name);
        Map<String, ZipEntry> map = ResourceLoader.getZipContents(zipPath, useCache);
        if (map == null) {
            return null;
        }
        String[] imagePaths = null;
        for (String next : map.keySet()) {
            String imagePath;
            if (!next.contains("/") && !next.contains("\\") && imageFileFilter.accept(new File(next)) && (imagePaths = VideoIO.getImageSequencePaths(imagePath = String.valueOf(zipPath) + "!/" + next, map.keySet())) != null && imagePaths.length > 1) break;
        }
        boolean ret = imagePaths != null && imagePaths.length > 1;
        return ret ? imagePaths : null;
    }

    public static String getDelimiter() {
        return delimiter;
    }

    public static void setDelimiter(String d) {
        if (d != null) {
            delimiter = d;
        }
    }

    public static Map<String, String> getDelimiters() {
        if (delimiters.isEmpty()) {
            delimiters.put(MediaRes.getString("VideoIO.Delimiter.Tab"), TAB);
            delimiters.put(MediaRes.getString("VideoIO.Delimiter.Space"), SPACE);
            delimiters.put(MediaRes.getString("VideoIO.Delimiter.Comma"), COMMA);
            delimiters.put(MediaRes.getString("VideoIO.Delimiter.Semicolon"), SEMICOLON);
        }
        return delimiters;
    }

    public static AsyncFileChooser getChooser() {
        if (chooser == null) {
            File dir = OSPRuntime.chooserDir == null ? new File(OSPRuntime.getUserHome()) : new File(OSPRuntime.chooserDir);
            chooser = new AsyncFileChooser(dir);
        }
        FontSizer.setFonts(chooser);
        return chooser;
    }

    public static void setDefaultXMLExtension(String ext) {
        defaultXMLExt = ext;
    }

    public static String getRelativePath(String absolutePath) {
        if (absolutePath.indexOf("/") == -1 && absolutePath.indexOf("\\") == -1) {
            return absolutePath;
        }
        if (ResourceLoader.isHTTP(absolutePath)) {
            return absolutePath;
        }
        String path = absolutePath;
        String relativePath = "";
        boolean validPath = false;
        String base = System.getProperty("user.dir");
        if (base == null) {
            return path;
        }
        int j = 0;
        while (j < 3) {
            if (j > 0) {
                int k = base.lastIndexOf("\\");
                if (k == -1) {
                    k = base.lastIndexOf("/");
                }
                if (k == -1) break;
                base = base.substring(0, k);
                relativePath = String.valueOf(relativePath) + "../";
            }
            if (path.startsWith(base)) {
                path = path.substring(base.length() + 1);
                int i = path.indexOf("\\");
                while (i != -1) {
                    path = String.valueOf(path.substring(0, i)) + "/" + path.substring(i + 1);
                    i = path.indexOf("\\");
                }
                relativePath = String.valueOf(relativePath) + path;
                validPath = true;
                break;
            }
            ++j;
        }
        if (validPath) {
            return relativePath;
        }
        return path;
    }

    public static void testExec() {
    }

    public static String[] getVideoExtensions() {
        return videoFileFilter.getExtensions();
    }

    public static String getPreferredExportExtension() {
        return preferredExportExtension;
    }

    public static void setPreferredExportExtension(String extension) {
        if (extension != null && extension.length() > 1) {
            preferredExportExtension = extension;
        }
    }

    public static void addVideoType(VideoType type) {
        if (type == null) {
            return;
        }
        boolean hasType = false;
        for (VideoType next : videoTypes) {
            if (!next.getDescription().equals(type.getDescription()) || next.getClass() != type.getClass()) continue;
            hasType = true;
        }
        if (!hasType) {
            videoTypes.add(type);
            VideoFileFilter filter = type.getDefaultFileFilter();
            if (filter != null && filter.extensions != null) {
                singleVideoTypeFilters.add(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovieVideoType getMovieType(String extension) {
        if (!MovieFactory.hasVideoEngine()) {
            return null;
        }
        MovieVideoType mtype = null;
        ArrayList<VideoType> arrayList = videoTypes;
        synchronized (arrayList) {
            for (VideoType next : videoTypes) {
                if (!(next instanceof MovieVideo)) continue;
                mtype = (MovieVideoType)next;
                break;
            }
            if (extension == null || mtype == null) {
                return mtype;
            }
            String id = mtype.getDefaultExtension();
            if (id != null && id.indexOf(extension) > -1) {
                return mtype;
            }
            return (MovieVideoType)VideoIO.checkVideoFilter(mtype, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VideoType getVideoType(String typeName, String extension) {
        if (typeName == null && extension == null) {
            return null;
        }
        if ("JS" == typeName) {
            return VideoIO.getMovieType(extension);
        }
        ArrayList<VideoType> candidates = new ArrayList<VideoType>();
        ArrayList<VideoType> arrayList = videoTypes;
        synchronized (arrayList) {
            if (typeName == null) {
                candidates.addAll(videoTypes);
            } else {
                for (VideoType next : videoTypes) {
                    if (next.getTypeName() != typeName) continue;
                    candidates.add(next);
                }
            }
            if (extension == null) {
                if (!candidates.isEmpty()) return (VideoType)candidates.get(0);
                return null;
            }
            extension = extension.toLowerCase();
            for (VideoType next : candidates) {
                String id = next.getDefaultExtension();
                if (id == null || id.indexOf(extension) <= -1) continue;
                return next;
            }
            for (VideoType next : candidates) {
                if (VideoIO.checkVideoFilter(next, extension) == null) continue;
                return next;
            }
            return null;
        }
    }

    public static ArrayList<VideoType> getVideoTypesForPath(String path) {
        String ext = (path.indexOf(".") >= 0 ? XML.getExtension(path) : path).toLowerCase();
        ArrayList<VideoType> found = new ArrayList<VideoType>();
        ArrayList<VideoType> vidTypes = VideoIO.getVideoTypes(false);
        for (VideoType next : vidTypes) {
            String id = next.getDefaultExtension();
            if (id == null || id.indexOf(ext) <= -1) continue;
            found.add(next);
        }
        for (VideoType next : vidTypes) {
            VideoFileFilter[] filters;
            VideoFileFilter[] videoFileFilterArray = filters = next.getFileFilters();
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                VideoFileFilter filter = videoFileFilterArray[n2];
                if (filter.extensions != null) {
                    String[] stringArray = filter.extensions;
                    int n3 = filter.extensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        if (s.indexOf(ext) > -1 && !found.contains(next)) {
                            found.add(next);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return found;
    }

    public static ArrayList<VideoType> getVideoTypes(boolean mustBeWritable) {
        ArrayList<VideoType> available = new ArrayList<VideoType>();
        for (VideoType next : videoTypes) {
            if (mustBeWritable && !next.canRecord()) continue;
            available.add(next);
        }
        return available;
    }

    public static void requiresReload(String zipPath) {
        filenamesToReload.add(XML.getName(zipPath));
    }

    public static void setCanceled(boolean cancel) {
        if (canceled == cancel) {
            return;
        }
        canceled = cancel;
        if (loader != null && cancel) {
            loader.cancelAsync();
            loader = null;
        }
    }

    public static boolean isCanceled() {
        return canceled;
    }

    public static boolean isKnownVideoExtension(String path) {
        String ext = XML.getExtension(path.toLowerCase());
        if (ext == null) {
            return false;
        }
        int i = 0;
        while (i < KNOWN_VIDEO_EXTENSIONS.length) {
            if (ext.equals(KNOWN_VIDEO_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getVideoCodec(String path0) {
        if (codecMap.containsKey(path0)) {
            return codecMap.get(path0);
        }
        String path = path0;
        String codec = null;
        File localFile = ResourceLoader.download(path, null, false);
        if (localFile != null) {
            path = localFile.getAbsolutePath();
        }
        if (codecMap.containsKey(path)) {
            return codecMap.get(path);
        }
        try {
            VideoReader vr = new VideoReader(path);
            List<Map<String, Object>> contents = vr.getContents(false);
            codec = vr.getCodec() == null ? "unknown" : vr.getCodec();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        codecMap.put(path, codec);
        codecMap.put(path0, codec);
        return codec;
    }

    public static void handleUnsupportedVideo(String path0, String ext, String codec, VideoPanel vidPanel, String why) {
        String message;
        String path;
        String string = path = path0.startsWith("jar:file:/") ? path0.substring(9) : path0;
        if (unsupportedPaths.contains(path)) {
            return;
        }
        unsupportedPaths.add(path);
        OSPLog.warning("VideoIO.handleUnsupportedVideo " + path + " from " + why);
        String string2 = message = codec != null ? String.valueOf(MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.VideoCodec1")) + SPACE + ext.toUpperCase() + SPACE + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.VideoCodec2") + " \"" + codec + "\"." : String.valueOf(MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.VideoType")) + " \"" + ext + "\".";
        if (codec == null && MovieFactory.xuggleNeeds32bitVM && vidPanel != null) {
            vidPanel.offerReloadVM(ext, message);
            return;
        }
        String helpLink = String.valueOf(MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.MoreInfo")) + "<br>" + "<a href=\"" + VIDEO_CONVERSION_HELP_PATH + "\">" + VIDEO_CONVERSION_HELP_PATH + "</a>";
        message = String.valueOf(message) + "<br><br>" + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.Fix") + ":";
        message = String.valueOf(message) + "<ol>";
        if (ResourceLoader.isHTTP(path) || OSPRuntime.isJSTemp(path)) {
            message = String.valueOf(message) + "<li>" + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.Download") + "</li>";
            message = String.valueOf(message) + "<li>" + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.ConvertDownload") + "</li>";
            message = String.valueOf(message) + "<li>" + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.Import") + "</li></ol>";
            message = String.valueOf(message) + helpLink;
            message = String.valueOf(message) + "<br><br>" + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.DownloadNow");
            new AsyncDialog().showConfirmDialog(null, new EditorPaneMessage(message), MediaRes.getString("VideoIO.Dialog.UnsupportedVideo.Title"), 0, ev -> {
                int sel = ev.getID();
                switch (sel) {
                    case 0: {
                        String name = XML.getName(path);
                        VideoIO.getChooserFilesAsync("save video " + name, files -> {
                            if (VideoIO.getChooser().getSelectedOption() == 0 && files != null) {
                                ResourceLoader.downloadResourceFromDialog(path, files[0]);
                            }
                            return null;
                        });
                    }
                }
            });
        } else {
            message = String.valueOf(message) + "<li>" + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.Convert") + "</li>";
            message = String.valueOf(message) + "<li>" + MediaRes.getString("VideoIO.Dialog.ConvertVideo.Message.Import") + "</li></ol>";
            message = String.valueOf(message) + helpLink;
            new AsyncDialog().showMessageDialog(null, new EditorPaneMessage(message), MediaRes.getString("VideoIO.Dialog.UnsupportedVideo.Title"), 1, ev -> {});
        }
    }

    public static Video getVideo(String path, VideoType vidType) {
        return VideoIO.getVideo(path, null, vidType, null);
    }

    public static Video getVideo(String path, String basePath, VideoType vidType, XMLControl control) {
        File localFile;
        path = VideoIO.fixVideoPath(path);
        String fullPath = XML.getResolvedPath(path, basePath);
        OSPLog.fine("Path: " + fullPath + "    Type: " + (vidType == null ? null : vidType.getTypeName()));
        if (vidType != null && "Xuggle".equals(vidType.getTypeName()) && ResourceLoader.isHTTP(fullPath) && (localFile = ResourceLoader.download(fullPath, null, false)) != null) {
            fullPath = localFile.getAbsolutePath();
            path = XML.getName(fullPath);
            basePath = XML.getDirectoryPath(fullPath);
        }
        Video video2 = null;
        VideoIO.setCanceled(false);
        if (vidType != null) {
            OSPLog.finest("preferred type " + vidType.getClass().getSimpleName() + SPACE + vidType.getDescription());
            video2 = vidType.getVideo(path, basePath, control);
            if (video2 != null) {
                return video2;
            }
        }
        if (VideoIO.isCanceled()) {
            return null;
        }
        ArrayList<VideoType> allTypes = VideoIO.getVideoTypesForPath(path);
        for (VideoType next : allTypes) {
            video2 = next.getVideo(path, basePath, control);
            if (VideoIO.isCanceled()) {
                return null;
            }
            if (video2 == null) continue;
            int n = fullPath.indexOf("zip!");
            int n2 = n = n > 0 ? n : fullPath.indexOf("trz!");
            if (n > 0) {
                fullPath = fullPath.substring(0, n + 3);
            }
            if ((fullPath.endsWith(".zip") || fullPath.endsWith(".trz")) && !(next instanceof ZipImageVideoType)) {
                ArrayList<VideoType> types = VideoIO.getVideoTypesForPath(fullPath);
                int i = 0;
                while (i < types.size()) {
                    ZipImageVideoType zipType;
                    if (types.get(i) instanceof ZipImageVideoType && (zipType = (ZipImageVideoType)types.get(i)).getImageVideoType().getDefaultExtension().equals(next.getDefaultExtension())) {
                        video2.setProperty("video_type", types.get(i));
                        break;
                    }
                    ++i;
                }
            }
            return video2;
        }
        return null;
    }

    private static String fixVideoPath(String path) {
        return path.startsWith("file:") ? ResourceLoader.getNonURIPath(path) : path;
    }

    public static Video clone(Video video2) {
        if (video2 == null) {
            return null;
        }
        if (video2 instanceof ImageVideo) {
            return new ImageVideo((ImageVideo)video2);
        }
        XMLControlElement control = new XMLControlElement(video2);
        return (Video)new XMLControlElement(control).loadObject(null);
    }

    public static boolean canWrite(File file) {
        int selected;
        if (OSPRuntime.isJS) {
            return true;
        }
        if (file.getName().contains("&")) {
            new AsyncDialog().showMessageDialog(null, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadFileName.Message")) + " \n\"&\"", MediaRes.getString("VideoIO.Dialog.BadFileName.Title"), 2, ev -> {});
            return false;
        }
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
            return false;
        }
        return !file.exists() || (selected = JOptionPane.showConfirmDialog(null, "\"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 0)) == 0;
    }

    public static File[] getChooserFilesAsync(String type, Function<File[], Void> processFiles) {
        File[] fileArray;
        String saveResource;
        AsyncFileChooser chooser = VideoIO.getChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setAccessory(null);
        Runnable resetChooser = () -> {
            chooser.resetChoosableFileFilters();
            if (processFiles != null) {
                chooser.setSelectedFile(null);
            }
        };
        Runnable okOpen = () -> {
            File file = chooser.getSelectedFile();
            resetChooser.run();
            if (chooser.getSelectedOption() != 0) {
                return;
            }
            if (processFiles != null) {
                processFiles.apply(new File[]{file});
            }
        };
        Runnable okSave = () -> {
            File file = chooser.getSelectedFile();
            resetChooser.run();
            if (chooser.getSelectedOption() != 0) {
                return;
            }
            if (processFiles != null && VideoIO.canWrite(file)) {
                processFiles.apply(new File[]{file});
            }
        };
        String originalFileName = "";
        String saveVideo = "save video";
        if (type.startsWith(String.valueOf(saveVideo) + SPACE)) {
            originalFileName = type.substring(saveVideo.length() + 1);
            type = saveVideo;
        }
        if (type.startsWith(String.valueOf(saveResource = "save resource") + SPACE)) {
            originalFileName = type.substring(saveResource.length() + 1);
            type = saveResource;
        }
        switch (type.toLowerCase()) {
            case "open": {
                chooser.addChoosableFileFilter(videoFileFilter);
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "open image": {
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.resetChoosableFileFilters();
                chooser.addChoosableFileFilter(imageFileFilter);
                chooser.setFileFilter(imageFileFilter);
                chooser.showOpenDialog(null, okOpen, resetChooser);
                break;
            }
            case "save video": {
                chooser.resetChoosableFileFilters();
                chooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveVideoAs.Title"));
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
                chooser.setSelectedFile(new File(originalFileName));
                chooser.showSaveDialog(null, okSave, resetChooser);
                break;
            }
            case "save image": {
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.resetChoosableFileFilters();
                chooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
                chooser.addChoosableFileFilter(jpgFileFilter);
                chooser.setFileFilter(jpgFileFilter);
                chooser.setSelectedFile(new File(originalFileName));
                chooser.showSaveDialog(null, okSave, resetChooser);
                break;
            }
            case "save resource": {
                chooser.resetChoosableFileFilters();
                chooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
                chooser.setSelectedFile(new File(originalFileName));
                chooser.showSaveDialog(null, okSave, resetChooser);
                break;
            }
            default: {
                return null;
            }
        }
        File ret = VideoIO.processChoose(chooser, null, processFiles != null);
        if (ret == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = ret;
        }
        return fileArray;
    }

    protected static File processChoose(AsyncFileChooser chooser, File ret, boolean isAsync) {
        if (isAsync) {
            return null;
        }
        if (ret == null && chooser.getSelectedOption() == 0) {
            ret = chooser.getSelectedFile();
        }
        chooser.setSelectedFile(null);
        return ret;
    }

    public static void openVideoPanelFileAsync(File file, final VideoPanel vidPanel) {
        if (file != null) {
            VideoIO.openVideoPanelFileSync(file, vidPanel);
            return;
        }
        VideoIO.getChooserFilesAsync("open", new Function<File[], Void>(){

            @Override
            public Void apply(File[] files) {
                File file;
                File file2 = file = files == null ? null : files[0];
                if (file != null) {
                    VideoIO.openVideoPanelFileSync(file, vidPanel);
                }
                return null;
            }
        });
    }

    private static void openVideoPanelFileSync(File file, VideoPanel vidPanel) {
        String p;
        String path = file.getAbsolutePath();
        if (ResourceLoader.isJarZipTrz(path, false) && (p = VideoIO.getEmbeddedMovie(path)) != null) {
            path = p;
            file = new File(path);
        }
        if (videoFileFilter.accept(file, true)) {
            ArrayList<VideoType> types = VideoIO.getVideoTypes(false);
            Video video2 = null;
            int i = 0;
            while (i < types.size()) {
                VideoType type = types.get(i);
                if (type.accepts(file)) {
                    video2 = type.getVideo(path);
                    if (video2 != null) {
                        OSPLog.info(String.valueOf(file.getName()) + " opened as type " + type.getDescription());
                        break;
                    }
                    OSPLog.info(String.valueOf(file.getName()) + " failed as type " + type.getDescription());
                }
                ++i;
            }
            if (video2 == null) {
                JOptionPane.showMessageDialog(vidPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + ResourceLoader.getNonURIPath(XML.getAbsolutePath(file)));
                return;
            }
            vidPanel.setVideo(video2);
            vidPanel.repaint();
        } else {
            XMLControlElement control = new XMLControlElement();
            control.read(path);
            Class<?> type = control.getObjectClass();
            if (VideoPanel.class.isAssignableFrom(type)) {
                vidPanel.setDataFile(file);
                control.loadObject(vidPanel);
            } else if (control.failedToRead()) {
                JOptionPane.showMessageDialog(vidPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadFile.Message")) + ResourceLoader.getNonURIPath(XML.getAbsolutePath(file)));
            } else {
                JOptionPane.showMessageDialog(vidPanel, "\"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.XMLMismatch.Message"), MediaRes.getString("VideoIO.Dialog.XMLMismatch.Title"), 2);
                return;
            }
            vidPanel.changed = false;
        }
    }

    private static String getEmbeddedMovie(String path) {
        Map<String, ZipEntry> map = ResourceLoader.getZipContents(path, true);
        for (String key : map.keySet()) {
            if (!videoFileFilter.accept(new File(key), true)) continue;
            return String.valueOf(path) + "!/" + key;
        }
        return null;
    }

    public static File save(File file, VideoPanel vidPanel) {
        return VideoIO.save(file, vidPanel, MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
    }

    public static File save(File file, VideoPanel vidPanel, String chooserTitle) {
        Video video2;
        if (file == null) {
            int i;
            video2 = vidPanel.getVideo();
            AsyncFileChooser chooser = VideoIO.getChooser();
            chooser.removeChoosableFileFilter(videoFileFilter);
            chooser.removeChoosableFileFilter(imageFileFilter);
            chooser.setDialogTitle(chooserTitle);
            String filename = MediaRes.getString("VideoIO.FileName.Untitled");
            if (vidPanel.getFilePath() != null) {
                filename = XML.stripExtension(vidPanel.getFilePath());
            } else if (video2 != null && video2.getProperty("name") != null && (i = (filename = (String)video2.getProperty("name")).lastIndexOf(".")) > 0) {
                filename = filename.substring(0, i);
            }
            file = new File(String.valueOf(filename) + "." + defaultXMLExt);
            String parent = XML.getDirectoryPath(filename);
            if (!parent.equals("")) {
                XML.createFolders(parent);
                chooser.setCurrentDirectory(new File(parent));
            }
            chooser.setSelectedFile(file);
            int result = ((JFileChooser)chooser).showSaveDialog(vidPanel);
            if (result == 0) {
                file = chooser.getSelectedFile();
                if (!defaultXMLExt.equals(VideoIO.getExtension(file))) {
                    filename = XML.stripExtension(file.getPath());
                    file = new File(String.valueOf(filename) + "." + defaultXMLExt);
                }
                if (!VideoIO.canWrite(file)) {
                    return null;
                }
                vidPanel.setDataFile(file);
            } else {
                return null;
            }
        }
        if ((video2 = vidPanel.getVideo()) != null) {
            video2.setProperty("base", XML.getDirectoryPath(XML.getAbsolutePath(file)));
            if (video2 instanceof ImageVideo) {
                ((ImageVideo)video2).saveInvalidImages();
            }
        }
        XMLControlElement xmlControl = new XMLControlElement(vidPanel);
        xmlControl.write(file.getAbsolutePath());
        vidPanel.changed = false;
        return file;
    }

    public static File writeImageFile(BufferedImage image, String filePath) {
        if (image == null) {
            return null;
        }
        File file = new File(filePath);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String ext = XML.getExtension(filePath);
        try {
            if (ImageIO.write((RenderedImage)image, ext, file)) {
                return file;
            }
        }
        catch (IOException ex) {
            OSPLog.finer(ex.toString());
        }
        return null;
    }

    public static String[] getImageSequencePaths(String imagePath, Set<String> names) {
        ArrayList<String> imagePaths = new ArrayList<String>();
        String originalPath = imagePath;
        String extension = "";
        int i = imagePath.lastIndexOf(46);
        if (i > 0 && i < imagePath.length() - 1) {
            extension = imagePath.substring(i).toLowerCase();
            imagePath = imagePath.substring(0, i);
        }
        int len = imagePath.length();
        int digits = 0;
        while (digits <= 4 && --len >= 0 && Character.isDigit(imagePath.charAt(len))) {
            ++digits;
        }
        if (digits == 0) {
            return new String[]{originalPath};
        }
        int limit = (int)Math.pow(10.0, digits);
        String root = imagePath.substring(0, ++len);
        String name = XML.getName(root);
        root = String.valueOf(XML.getDirectoryPath(root)) + "/";
        String startNumber = imagePath.substring(len);
        int n = Integer.parseInt(startNumber) - 1;
        try {
            while (++n < limit) {
                String num = "000" + n;
                String imageName = String.valueOf(name) + num.substring(num.length() - digits) + extension;
                if (names.contains(imageName)) {
                    imagePaths.add(String.valueOf(root) + imageName);
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        return imagePaths.toArray(new String[imagePaths.size()]);
    }

    public static boolean checkMP4(String path, LibraryBrowser libraryBrowser, VideoPanel panel) {
        String ext = XML.getExtension(path);
        if (!DEFAULT_PREFERRED_EXPORT_EXTENSION.equals(ext) && !"mov".equals(ext)) {
            return true;
        }
        String codec = VideoIO.getVideoCodec(path);
        OSPLog.fine("VideoIO: " + ext + " codec = " + codec);
        if (!OSPRuntime.isJS || codec != null && codec.contains("avc1")) {
            return true;
        }
        VideoIO.handleUnsupportedVideo(path, ext, codec, panel, "VideoIO");
        return false;
    }

    public static int progressForFraction(double iFrame, double nFrames) {
        return (int)Math.min(20.0 + iFrame / nFrames % 1.00001 * 60.0, 79.0);
    }

    public static class EditorPaneMessage
    extends JEditorPane {
        public EditorPaneMessage(String htmlBody) {
            super("text/html", "<html><body style=\"" + EditorPaneMessage.getLabelStyle() + "\">" + htmlBody + "</body></html>");
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        OSPDesktop.displayURL(e.getURL().toString());
                    }
                }
            });
            this.setEditable(false);
            this.setBorder(null);
        }

        static StringBuffer getLabelStyle() {
            JLabel label = new JLabel();
            Font font = label.getFont();
            Color color = label.getBackground();
            StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + VideoIO.SEMICOLON);
            style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + VideoIO.SEMICOLON);
            style.append("font-size:" + font.getSize() + "pt;");
            style.append("background-color: rgb(" + color.getRed() + VideoIO.COMMA + color.getGreen() + VideoIO.COMMA + color.getBlue() + ");");
            return style;
        }
    }

    public static interface FinalizableLoader
    extends XML.NonStaticLoader {
        public void finalizeLoading();

        public boolean isFinalized();
    }

    public static class SingleExtFileFilter
    extends FileFilter {
        private String ext;
        protected String desc;

        public SingleExtFileFilter(String ext, String desc) {
            this.ext = ext;
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            return f != null && this.accept(f, true);
        }

        public boolean accept(File f, boolean checkIfDir) {
            return checkIfDir && f.isDirectory() || this.ext != null && this.ext.equalsIgnoreCase(VideoIO.getExtension(f));
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static class StreamPiper
    implements Runnable {
        private final InputStream input;
        private final OutputStream output;

        public StreamPiper(InputStream in, OutputStream out) {
            this.input = in;
            this.output = out;
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[1024];
                int count = 0;
                while ((count = this.input.read(buffer)) >= 0) {
                    this.output.write(buffer, 0, count);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class ZipImageVideoType
    extends ImageVideoType {
        private ImageVideoType imageVideoType;
        private static final String ZIP = "zip";
        public static boolean checkZipContents = true;

        public ZipImageVideoType(ImageVideoType type) {
            super(new VideoFileFilter(ZIP, new String[]{ZIP}){

                @Override
                public boolean accept(File f, boolean checkIfDir) {
                    if (!super.accept(f, checkIfDir)) {
                        return false;
                    }
                    if (f.isDirectory() || !checkZipContents) {
                        return true;
                    }
                    String[] imagePaths = VideoIO.getZippedImagePaths(f.getAbsolutePath());
                    return imagePaths != null;
                }
            });
            this.imageVideoType = type;
        }

        @Override
        public String getDescription() {
            String zipped = MediaRes.getString("ZipImageVideoType.Description.Zipped");
            String desc = String.valueOf(zipped) + VideoIO.SPACE + this.imageVideoType.getDescription();
            desc = String.valueOf(desc.substring(0, desc.indexOf("(") + 1)) + "." + ZIP + ")";
            return desc;
        }

        @Override
        public Video getVideo(String name, String basePath, XMLControl control) {
            String fullPath;
            String string = fullPath = basePath == null ? name : String.valueOf(basePath) + "/" + name;
            if (zipFileFilter.accept(new File(fullPath))) {
                String[] imagePaths = VideoIO.getZippedImagePaths(fullPath);
                if (imagePaths == null) {
                    return null;
                }
                name = imagePaths[0];
                if (!this.getImageVideoType().accepts(new File(XML.getName(name)))) {
                    return null;
                }
                basePath = null;
                Video video2 = super.getVideo(name, basePath, control);
                if (video2 != null) {
                    video2.setProperty("video_type", this);
                }
                return video2;
            }
            return null;
        }

        public String getImageExtension() {
            return this.imageVideoType.getDefaultExtension();
        }

        public ImageVideoType getImageVideoType() {
            return this.imageVideoType;
        }
    }
}

