/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;

public class VideoMouseHandler
implements InteractiveMouseHandler {
    Interactive iad = null;
    TPoint p = null;
    Rectangle bounds;

    @Override
    public void handleMouseAction(InteractivePanel panel, MouseEvent e) {
        if (!(panel instanceof VideoPanel)) {
            return;
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        switch (vidPanel.getMouseAction()) {
            case 1: {
                if (this.iad == null || !(this.iad instanceof TPoint)) break;
                this.p = (TPoint)this.iad;
                this.bounds = this.p.getBounds(vidPanel);
                this.p.setXY(vidPanel.getMouseX(), vidPanel.getMouseY());
                if (this.bounds != null) {
                    this.bounds.add(this.p.getBounds(vidPanel));
                    vidPanel.repaint(this.bounds);
                    break;
                }
                vidPanel.repaint();
                break;
            }
            case 2: {
                this.p = null;
                this.iad = null;
                break;
            }
            case 3: {
                if (this.p == null) break;
                this.bounds = this.p.getBounds(vidPanel);
                this.p.setXY(vidPanel.getMouseX(), vidPanel.getMouseY());
                if (this.bounds != null) {
                    this.bounds.add(this.p.getBounds(vidPanel));
                    vidPanel.repaint(this.bounds);
                    break;
                }
                vidPanel.repaint();
                break;
            }
            case 7: {
                if (vidPanel.isDrawingInImageSpace()) {
                    this.iad = vidPanel.getInteractive();
                }
                if (this.iad != null && this.iad instanceof TPoint) {
                    vidPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                vidPanel.setMouseCursor(Cursor.getDefaultCursor());
            }
        }
        if (this.p == null) {
            vidPanel.hideMouseBox();
        } else {
            this.p.showCoordinates(vidPanel);
        }
    }
}

